<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Dashboard
 *
 * @author test
 */
class Index extends MY_Controller{

    public  $appdata;

    public function __construct() {
        parent::__construct();

        ( $this->require_min_level(1));
        $this->appdata['title']= 'Expense Manager';
        $this->load->model(array(
            'expenses/ExpensesModel'=>'expensesModel',
            'expenses/ExpensesBudgetsModel'=>'expensesBudgetsModel',
            'expenses/ExpensesTypesModel'=>'expensesTypesModel',
            'accounting/Accounting'=>'accountingModel',
            'accounting/GlModel'=>'glModel',
            'expenses/ExpensesCategoriesModel'=>'expensesCategoriesModel'
        ));
        $this->load->helper('expenses/helper');
    }

    public function index() {
        $this->load->helper('form');
        $this->appdata['link']= 'managers';
        $this->load->vars($this->appdata);
        $this->load->view('expenses/overview');
    }

    function delete_expense($key=''){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if($this->expensesModel->delete($key)){
            $results['message'] = 'Expense deleted successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to delete Expense';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }

    function restore_expense($key=''){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if($this->expensesModel->update($key,['expense_deleted' => 0])){
            $results['message'] = 'Expense restored successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to restore Expense';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();
    }



    function deletefile($file){
        $this->load->helper('file');
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
         $filename= $this->db->where('doc_id',$file)->get('expense_docs')->row()->doc_name;
        $this->db->where('doc_id',$file)->delete('expense_docs');
        if($this->db->affected_rows()>0){
            if(file_exists(dirname(APPPATH).'/uploads/expenses/'.$filename)){
                unlink(dirname(APPPATH).'/uploads/expenses/'.$filename);
            }
            $results['message'] = 'File deleted';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to delete file';
            $results['status'] = false;
        }
        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    public function newexpense() {
        $this->load->helper('form');
        $this->load->vars($this->appdata);
        $this->load->view('expenses/newexpense');
    }

    function setexpenseHiddenStatus($expense,$status){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        $data['expense_status'] = urldecode($status);
        $this->db->where('expense_key',$expense);
        $this->db->update('expenses',$data);

        if($this->db->affected_rows()>0){
            $results['message'] = 'Changes applied successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to save changes';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function setexpensestatus($password='',$expense='',$status=''){
        $details = $this->expensesModel->details($expense);
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        if (empty($password)) {
            $results['status'] = false;
            $results['message'] = 'You must provide password';
            echo json_encode($results, JSON_PRETTY_PRINT);
            return;
        }

        if (!checkAccessPassword($password)) {
            $results['status'] = false;
            $results['message'] = 'You provided wrong password';
            echo json_encode($results, JSON_PRETTY_PRINT);
            return;
        }

        $gl_debit['gl_business'] = $details->expense_business;
        $gl_debit['gl_branch'] = $details->expense_branch;
        $gl_debit['gl_user'] = $this->auth_user_id;
        $gl_debit['gl_status'] = urldecode($status);
        $gl_debit['gl_debit'] = $details->expense_paid;
        $gl_debit['gl_credit'] = 0;
        $gl_debit['gl_is_journal'] = $details->expense_is_journal;
        $gl_debit['gl_journal'] = $details->expense_journal;
        $gl_debit['gl_account'] = $this->expensesCategoriesModel->details($details->expense_category)->category_expense_account;
        $gl_debit['gl_activity'] = $expense;
        $gl_debit['gl_category'] = "expenses";
        $gl_debit['gl_date'] = $details->expense_date_posted;
        $gl_debit['gl_key'] = $this->glModel->glKey();

        $gl_credit['gl_business'] = $details->expense_business;
        $gl_credit['gl_branch'] = $details->expense_branch;
        $gl_credit['gl_user'] = $this->auth_user_id;
        $gl_credit['gl_status'] = urldecode($status);
        $gl_credit['gl_debit'] = 0;
        $gl_credit['gl_is_journal'] = $details->expense_is_journal;
        $gl_credit['gl_journal'] = $details->expense_journal;
        $gl_credit['gl_credit'] = $details->expense_paid;
        $gl_credit['gl_account'] = $details->expense_withdraw_account;
        $gl_credit['gl_activity'] = $expense;
        $gl_credit['gl_category'] = "expenses";
        $gl_credit['gl_date'] = $details->expense_date_posted;
        $gl_credit['gl_key'] = $this->glModel->glKey();

        $this->db->trans_start();

        $this->db->where('gl_activity',$expense);
        $this->db->where('gl_category',"expenses");
        $this->db->delete("accounting_general_ledger");
        $this->db->insert('accounting_general_ledger', $gl_credit);
        $this->db->insert('accounting_general_ledger', $gl_debit);

        $expenses['expense_status'] = urldecode($status);
        $this->db->where('expense_key',$expense);
        $this->db->update('expenses',$expenses);

        $this->db->trans_complete();
        if($this->db->trans_status() === TRUE){
            publishEventFlash("expenses_updated");
            $results['message'] = 'Changes applied successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to save changes';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

     function ajaxdetailscancelrequest($expense=''){
         $this->load->helper('form');
         $this->appdata['link']= 'managers';
         $this->appdata['expense']= $this->expensesModel->expenseDetails($expense);
         $this->load->vars($this->appdata);
         $this->load->view('managers/expenses/detailscancelrequest');
     }

    public function details($expense='') {
        $this->load->helper('form');
        $this->appdata['expense']= $this->expensesModel->find($expense);
        $this->load->vars($this->appdata);
        $this->load->view('expenses/expenseDetails');
    }

    function saveexpense($expense)
    {
        $expenseDetails = $this->expensesModel->details($expense);
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $password = $this->input->get('passwd',TRUE);

        if (empty($password)) {
            $results['status'] = false;
            $results['message'] = 'You must provide password';
            echo json_encode($results, JSON_PRETTY_PRINT);
            return;
        }

//        if (!checkAccessPassword($password)) {
//            $results['status'] = false;
//            $results['message'] = 'You provided wrong password';
//            echo json_encode($results, JSON_PRETTY_PRINT);
//            return;
//        }

        $data['expense_modifier'] = $this->auth_user_id;
        $data['expense_withdraw_account'] = $this->input->get('expense_withdraw_account', TRUE);
        $data['expense_modified_at'] = date('Y-m-d H:i:s');
        $data['expense_date_posted'] = date('Y-m-d H:i:s',strtotime($this->input->get('expense_date_posted', TRUE)));
        $data['expense_payee'] = $this->input->get('expense_payee',TRUE);
        $data['expense_status'] = $this->input->get('expense_status',TRUE);
        $data['expense_category'] = $this->input->get('expense_category',TRUE);
        $data['expense_type'] = $this->input->get('expense_type',TRUE);
        $data['expense_budget'] = $this->input->get('expense_budget',TRUE);
        $data['expense_details'] = $this->input->get('expense_details',TRUE);
        $data['expense_amount'] = to_dollar(str_ireplace(',','',$this->input->get('expense_amount',TRUE)));
        $data['expense_paid'] = to_dollar(str_ireplace(',','',$this->input->get('expense_paid',TRUE)));

        $gl_debit['gl_business'] = runningBusiness()->business_key;
        $gl_debit['gl_branch'] = runningBranch()->branch_key;
        $gl_debit['gl_user'] = $this->auth_user_id;
        $gl_debit['gl_status'] = $data['expense_status'];
        $gl_debit['gl_debit'] = $data['expense_paid'];
        $gl_debit['gl_credit'] = 0;
        $gl_debit['gl_account'] = $this->expensesCategoriesModel->details($data['expense_category'])->category_expense_account;
        $gl_debit['gl_activity'] = $expense;
        $gl_debit['gl_category'] = "expenses";
        $gl_debit['gl_is_journal'] = $expenseDetails->expense_is_journal;
        $gl_debit['gl_journal'] = $expenseDetails->expense_journal;
        $gl_debit['gl_date'] = $data['expense_date_posted'];
        $gl_debit['gl_key'] = $this->glModel->glKey();

        $gl_credit['gl_business'] = runningBusiness()->business_key;
        $gl_credit['gl_branch'] = runningBranch()->branch_key;
        $gl_credit['gl_user'] = $this->auth_user_id;
        $gl_credit['gl_status'] = $data['expense_status'];
        $gl_credit['gl_debit'] = 0;
        $gl_credit['gl_is_journal'] = $expenseDetails->expense_is_journal;
        $gl_credit['gl_journal'] = $expenseDetails->expense_journal;
        $gl_credit['gl_credit'] = $data['expense_paid'];
        $gl_credit['gl_account'] = $data['expense_withdraw_account'];
        $gl_credit['gl_activity'] = $expense;
        $gl_credit['gl_category'] = "expenses";
        $gl_credit['gl_date'] = $data['expense_date_posted'];
        $gl_credit['gl_key'] = $this->glModel->glKey();


        if($data['expense_paid'] >= $data['expense_amount']){
            $data['expense_paid_full'] = 1;
        }

        if($data['expense_paid'] > $data['expense_amount']){
            $results['message'] = 'You can not pay more than '.number_format(to_money($data['expense_amount']));
            $results['status'] = false;
            echo json_encode($results, JSON_PRETTY_PRINT);
            return;
        }

        if($data['expense_status'] == 'Approved'){
            $budgetbalance = $this->expensesBudgetsModel->getBalance($data['expense_budget']);
            if($budgetbalance < $data['expense_paid']){
                $results['message'] = 'You can not spend more than budget, Budget balance is '.number_format(to_money($budgetbalance));
                $results['status'] = false;
                echo json_encode($results, JSON_PRETTY_PRINT);
                return;
            }
        }

        $this->db->trans_start();

        $this->db->where('gl_activity',$expense);
        $this->db->where('gl_category',"expenses");
        $this->db->delete("accounting_general_ledger");
        $this->db->insert('accounting_general_ledger', $gl_credit);
        $this->db->insert('accounting_general_ledger', $gl_debit);

        $this->db->where('expense_key',$expense);
        $this->db->update('expenses',$data);
        if (!empty($this->input->get('uploadedfiles'))) {
            $raw = explode('LM-55', $_GET['uploadedfiles']);
            foreach ($raw as $key => $file) {
                $file = unserialize($file);
                if (is_array($file)) {
                    foreach ($file as $dt) {
                        if (!empty($dt)) {
                            $filedata['doc_expense'] = $expense;
                            $filedata['doc_name'] = $dt['doc_name'];
                            $filedata['doc_type'] = $dt['doc_type'];
                            $filedata['doc_ext'] = $dt['doc_ext'];
                            $this->db->insert('expense_docs', $filedata);
                        }
                    }
                }
            }
        }

        $this->db->trans_complete();
        if($this->db->trans_status() == TRUE){
            publishEventFlash("expenses_updated");
            $results['message'] = 'Expense changed successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to change expense';
            $results['status'] = false;
        }
        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function saveexpenserequest($expense)
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $password = $this->input->get('kelly',TRUE);

        if (empty($password)) {
            $results['status'] = false;
            $results['message'] = 'You must provide password '.$this->input->get('kelly',TRUE);
            echo json_encode($results, JSON_PRETTY_PRINT);
            return;
        }

        if (!checkAccessPassword($password)) {
            $results['status'] = false;
            $results['message'] = 'You provided wrong password';
            echo json_encode($results, JSON_PRETTY_PRINT);
            return;
        }

        $data['expense_modifier'] = $this->auth_user_id;
        $data['expense_modified_at'] = date('Y-m-d H:i:s');
        $data['expense_admin_remark'] = $this->input->get('expense_admin_remark',TRUE);
        $data['expense_status'] = $this->input->get('expense_status',TRUE);
        $data['expense_cancel_request'] = 0;
        $this->db->where('expense_id',$expense);
        $this->db->update('expenses',$data);
        if($this->db->affected_rows()>0){
            $results['message'] = 'Expense changed successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to change expense';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function registerexpense()
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $data['expense_category'] = $this->input->get('expense_category', TRUE);
        $data['expense_date'] = date('Y-m-d H:i:s',strtotime($this->input->get('expense_date', TRUE)));
        $data['expense_debit_account'] = $this->expensesCategoriesModel->details($data['expense_category'])->category_debit_account;
        $data['expense_credit_account'] = $this->expensesCategoriesModel->details($data['expense_category'])->category_credit_account;
        $data['expense_status'] = $this->input->get('expense_status', TRUE);
        $data['expense_payee'] = $this->input->get('expense_payee', TRUE);
        $data['expense_type'] = $this->input->get('expense_type', TRUE);
        $data['expense_budget'] = $this->input->get('expense_budget', TRUE);
        $data['expense_details'] = $this->input->get('expense_details', TRUE);
        $data['expense_amount'] = to_dollar(str_ireplace(',', '', $this->input->get('expense_amount', TRUE)));

        if($id = $this->expensesModel->insert($data)){

            $temData = $this->expensesModel->find_by(['expense_id' => $id]);

                if (!empty($this->input->get('uploadedfiles'))) {
                    $raw = explode('LM-55', $_GET['uploadedfiles']);
                    foreach ($raw as $key => $file) {
                        $file = unserialize($file);
                        if (is_array($file)) {
                            foreach ($file as $dt) {
                                if (!empty($dt)) {
                                    $filedata['doc_expense'] = $temData['expense_key'] ;
                                    $filedata['doc_name'] = $dt['doc_name'];
                                    $filedata['doc_type'] = $dt['doc_type'];
                                    $filedata['doc_ext'] = $dt['doc_ext'];
                                    $this->db->insert('expense_docs', $filedata);
                                }
                            }
                        }
                    }
                }

            $results['message'] = 'Expense registered successfully ';
            $results['status'] = true;

            }else{
            $results['message'] = 'Failed to register expense';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);

        }

    function getselecttypes($category=''){
        $types = $this->expensesCategoriesModel->types($category);?>
        <select name="expense_type" class="form-control" style="width: 100%;">
            <option value="">Select Type</option>
            <?php if(!empty($types)){
                foreach ($types as $t => $tap){
                    if(strtolower($tap['type_status']) == "active"){ ?>
                        <option value="<?php echo $tap['type_key'];?>"><?php echo $tap['type_title'];?></option>
                   <?php }?>
               <?php }
            }?>
        </select>
        <script>$('select').select2();</script>
    <?php }

    function edit_expense($key)
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $data['expense_category'] = $this->input->get('expense_category', TRUE);
        $data['expense_date'] = date('Y-m-d H:i:s',strtotime($this->input->get('expense_date', TRUE)));
        $data['expense_debit_account'] = $this->expensesCategoriesModel->details($data['expense_category'])->category_debit_account;
        $data['expense_credit_account'] = $this->expensesCategoriesModel->details($data['expense_category'])->category_credit_account;
        $data['expense_status'] = $this->input->get('expense_status', TRUE);
        $data['expense_payee'] = $this->input->get('expense_payee', TRUE);
        $data['expense_type'] = $this->input->get('expense_type', TRUE);
        $data['expense_budget'] = $this->input->get('expense_budget', TRUE);
        $data['expense_details'] = $this->input->get('expense_details', TRUE);
        $data['expense_amount'] = to_dollar(str_ireplace(',', '', $this->input->get('expense_amount', TRUE)));

        if($this->expensesModel->update($key,$data)){
            $results['message'] = 'Expense updated successfully ';
            $results['status'] = true;

        }else{
            $results['message'] = 'Failed to update expense';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);

    }

    function datasource(){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->expensesModel->find_all();
        $columns = array();
        foreach ($this->expensesModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($data,$columns);
    }

    function datasourcebin(){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $this->expensesModel->where("expense_deleted",1);
        $data = $this->expensesModel->with_deleted()->find_all();
        $columns = array();
        foreach ($this->expensesModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($data,$columns);
    }

    function uploadexpensedocs(){
                header('Content-Type: application/json');
                header('Access-Control-Allow-Origin: ' . base_url());
                header('Access-Control-Allow-Methods: GET, POST');
                header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

                $uploadPath = uploadPath('expenses/');
                $config['upload_path'] = $uploadPath;
                $config['file_ext_tolower']     = TRUE;
                $config['encrypt_name']         = TRUE;
                $config['allowed_types'] = 'jpg|jpeg|png|docx|doc|pdf|xls|xlsx';

                // Load and initialize upload library
                $this->load->library('upload', $config);
                $this->upload->initialize($config);
                $i  = 0;
                if($this->upload->do_upload('file')){
                    // Uploaded file data
                    $fileData = $this->upload->data();
                    $uploadData[$i]['doc_name'] = $fileData['file_name'];
                    $uploadData[$i]['doc_type'] = $fileData['file_type'];
                    $uploadData[$i]['doc_ext'] = str_ireplace('.', '',$fileData['file_ext']);
                }

            if(!empty($uploadData)){
                $files = array();
                $result['status'] = true;
                foreach ($uploadData as $key => $file){
                    $files[$key]['doc_name'] = $file['doc_name'];
                    $files[$key]['doc_type'] = $file['doc_type'];
                    $files[$key]['doc_ext'] = str_ireplace('.', '',$fileData['file_ext']);
                }
                $result['files'] = serialize($files);
            }else{
                $result['status'] = false;
                $result['files'] = '';
            }

        echo json_encode($result, JSON_PRETTY_PRINT);
    }

    function check($check){
        $files = unserialize(explode('LM-55',$check));
        var_dump($files);
    }

    function expenseApprove($key){
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
        $status= $this->expensesModel->update($key,['expense_status'=>'Approved']);
        if($status === true){
            $expense = $this->expensesModel->find($key);
            $this->postPaymentLedger($expense);
            $results['message'] = 'Expense restored successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to approve Expense';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
        exit();

    }

    function expensePending($expense){
        if($this->expensesModel->update($expense,['expense_status'=>'Pending'])){
            $result['status'] = 'ok';
            $result['message'] = 'Expense on Pending successfully';
        }else{
            $result['status'] = 'no';
            //$result['message'] = 'Failed to approve request, Try again later';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function expenseRejected($expense){
        if($this->expensesModel->update($expense,['expense_status'=>'Rejected'])){
            $result['status'] = 'ok';
            $result['message'] = 'Expense rejected successfully';
        }else{
            $result['status'] = 'no';
            //$result['message'] = 'Failed to approve request, Try again later';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function expensePendingReject($expense){
        if($this->expensesModel->update($expense,['expense_status'=>'Pending Reject'])){
            $result['status'] = 'ok';
            $result['message'] = 'Expense pending rejected successfully';
        }else{
            $result['status'] = 'no';
            //$result['message'] = 'Failed to approve request, Try again later';
            $result['message'] = checkError($this->dbexeption());
        }
        print json_encode($result);
    }

    function postPaymentLedger($expense){
        $this->load->helper('reports/accounting/helper');
        $this->load->model(array('accounting/GeneralLedgerModel'=>'generalLedgerModel'));

        $ledgerDebit['gl_account'] = $expense['expense_debit_account'];
        $ledgerDebit['gl_debit'] = $expense['expense_amount'];
        $ledgerDebit['gl_amount'] = $expense['expense_amount'];
        $ledgerDebit['gl_date'] = $expense['expense_date'];
        $ledgerDebit['gl_status'] = "PENDING";
        $ledgerDebit['gl_category'] = "EXPENSES";
        $ledgerDebit['gl_type'] = "EXPENSE";
        $ledgerDebit['gl_reference'] = $expense['expense_key'];
        $ledgerDebit['gl_details'] = $expense['expense_details'];
        $ledgerDebit['gl_activity'] = $expense['expense_key'];
        $id = $this->generalLedgerModel->insert($ledgerDebit);
        $balance['gl_balance'] = accountBalance($ledgerDebit['gl_account']);
        $this->generalLedgerModel->update_by(['gl_id'=> $id],$balance);

        $ledgerCredit['gl_account'] = $expense['expense_credit_account'];
        $ledgerCredit['gl_credit'] = $expense['expense_amount'];
        $ledgerCredit['gl_date'] = $expense['expense_date'];
        $ledgerCredit['gl_status'] = "PENDING";
        $ledgerCredit['gl_category'] = "EXPENSES";
        $ledgerCredit['gl_type'] = "EXPENSE";
        $ledgerCredit['gl_reference'] = $expense['expense_key'];
        $ledgerCredit['gl_details'] = $expense['expense_details'];
        $ledgerCredit['gl_activity'] = $expense['expense_key'];
        $ledgerCredit['gl_amount'] = $expense['expense_amount'];
        $id = $this->generalLedgerModel->insert($ledgerCredit);
        $balance['gl_balance'] = accountBalance($ledgerCredit['gl_account']);
        $this->generalLedgerModel->update_by(['gl_id'=> $id],$balance);

    }



//
//$gl_credit['gl_business'] = runningBusiness()->business_key;
//$gl_credit['gl_branch'] = runningBranch()->branch_key;
//$gl_credit['gl_user'] = $this->auth_user_id;
//$gl_credit['gl_status'] = $data['expense_status'];
//$gl_credit['gl_debit'] = 0;
//$gl_credit['gl_credit'] = $data['expense_paid'];
//$gl_credit['gl_account'] = $data['expense_withdraw_account'];
//$gl_credit['gl_activity'] = $data['expense_key'];
//$gl_credit['gl_category'] = "expenses";
//$gl_credit['gl_date'] = $data['expense_date_posted'];
//$gl_credit['gl_key'] = $this->glModel->glKey();

//$this->db->insert('accounting_general_ledger', $gl_credit);
//$this->db->insert('accounting_general_ledger', $gl_debit);
}
