<?php include VIEWPATH . 'includes/css/base_style.php'; ?>
<?php include VIEWPATH . 'includes/header.php'; ?>
<div class="m-content">
    <div class="m-portlet">
        <div class="m-portlet__body  m-portlet__body--no-padding">
            <div class="row m-row--no-padding m-row--col-separator-xl">
                <div class="col-md-12 col-lg-6 col-xl-3">
                    <?php
                    $today = $this->expensesModel->expenseTotal(datesWhenCustom('today'));
                    $yesterday = $this->expensesModel->expenseTotal(datesWhenCustom('yesterday'));
                    $todayChange = $today - $yesterday;
                    $todayChangePer = $yesterday > 0 ? round($todayChange / $yesterday * 100) : 100;
                    $todayClass = $todayChangePer > 0 ? 'danger' : 'success';
                    $todayShowArrow = $todayChangePer > 0 ? '<i class="fa fa-angle-up font-danger" style="color: #9f191f; font-size: 14px; font-weight: 700"></i>' : '<i class="fa fa-angle-down font-success" style="color: #3a945b; font-size: 14px; font-weight: 700"></i>';
                    ?>
                    <!--begin::Total Profit-->
                    <div class="m-widget24">
                        <div class="m-widget24__item">
                            <h4 class="m-widget24__title">
                                Daily Expenses
                            </h4><br>
                            <span class="m-widget24__desc">
                                    All Expenses Value
                                </span>
                            <span class="m-widget24__stats m--font-<?php echo $todayClass; ?>">
                                    <?php echo moneyUnit($today); ?>
                                </span>
                            <div class="m--space-10"></div>
                            <div class="progress m-progress--sm">
                                <div class="progress-bar m--bg-<?php echo $todayClass; ?>" role="progressbar"
                                     style="width: <?php echo abs($todayChangePer); ?>%;" aria-valuenow="50"
                                     aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                            <span class="m-widget24__change">
                                    Change
                                </span>
                            <span class="m-widget24__number">
                                    <?php echo '<b>' . abs($todayChangePer) . '% ' . moneyUnit(abs($todayChange)) . $todayShowArrow . '</b>'; ?>
                                </span>
                        </div>
                    </div>

                    <!--end::Total Profit-->
                </div>
                <div class="col-md-12 col-lg-6 col-xl-3">
                    <?php
                    $today = $this->expensesModel->expenseTotal(datesWhenCustom('week'));
                    $yesterday = $this->expensesModel->expenseTotal(datesWhenCustom('lastweek'));
                    $todayChange = $today - $yesterday;
                    $todayChangePer = $yesterday > 0 ? round($todayChange / $yesterday * 100) : 100;
                    $todayClass = $todayChangePer > 0 ? 'danger' : 'success';
                    $todayShowArrow = $todayChangePer > 0 ? '<i class="fa fa-angle-up font-danger" style="color: #9f191f; font-size: 14px; font-weight: 700"></i>' : '<i class="fa fa-angle-down font-success" style="color: #3a945b; font-size: 14px; font-weight: 700"></i>';
                    ?>
                    <!--begin::Total Profit-->
                    <div class="m-widget24">
                        <div class="m-widget24__item">
                            <h4 class="m-widget24__title">
                                Weekly Expenses
                            </h4><br>
                            <span class="m-widget24__desc">
                                    All Expenses Value
                                </span>
                            <span class="m-widget24__stats m--font-<?php echo $todayClass; ?>">
                                    <?php echo moneyUnit($today); ?>
                                </span>
                            <div class="m--space-10"></div>
                            <div class="progress m-progress--sm">
                                <div class="progress-bar m--bg-<?php echo $todayClass; ?>" role="progressbar"
                                     style="width: <?php echo abs($todayChangePer); ?>%;" aria-valuenow="50"
                                     aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                            <span class="m-widget24__change">
                                    Change
                                </span>
                            <span class="m-widget24__number">
                                    <?php echo '<b>' . abs($todayChangePer) . '% ' . moneyUnit(abs($todayChange)) . $todayShowArrow . '</b>'; ?>
                                </span>
                        </div>
                    </div>

                    <!--end::Total Profit-->
                </div>
                <div class="col-md-12 col-lg-6 col-xl-3">
                    <?php
                    $today = $this->expensesModel->expenseTotal(datesWhenCustom('month'));
                    $yesterday = $this->expensesModel->expenseTotal(datesWhenCustom('lastmonth'));
                    $todayChange = $today - $yesterday;
                    $todayChangePer = $yesterday > 0 ? round($todayChange / $yesterday * 100) : 100;
                    $todayClass = $todayChangePer > 0 ? 'danger' : 'success';
                    $todayShowArrow = $todayChangePer > 0 ? '<i class="fa fa-angle-up font-danger" style="color: #9f191f; font-size: 14px; font-weight: 700"></i>' : '<i class="fa fa-angle-down font-success" style="color: #3a945b; font-size: 14px; font-weight: 700"></i>';
                    ?>
                    <!--begin::Total Profit-->
                    <div class="m-widget24">
                        <div class="m-widget24__item">
                            <h4 class="m-widget24__title">
                                Monthly Expenses
                            </h4><br>
                            <span class="m-widget24__desc">
                                    All Expenses Value
                                </span>
                            <span class="m-widget24__stats m--font-<?php echo $todayClass; ?>">
                                    <?php echo moneyUnit($today); ?>
                                </span>
                            <div class="m--space-10"></div>
                            <div class="progress m-progress--sm">
                                <div class="progress-bar m--bg-<?php echo $todayClass; ?>" role="progressbar"
                                     style="width: <?php echo abs($todayChangePer); ?>%;" aria-valuenow="50"
                                     aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                            <span class="m-widget24__change">
                                    Change
                                </span>
                            <span class="m-widget24__number">
                                    <?php echo '<b>' . abs($todayChangePer) . '% ' . moneyUnit(abs($todayChange)) . $todayShowArrow . '</b>'; ?>
                                </span>
                        </div>
                    </div>

                    <!--end::Total Profit-->
                </div>
                <div class="col-md-12 col-lg-6 col-xl-3">
                    <?php
                    $today = $this->expensesModel->expenseTotal(datesWhenCustom('year'));
                    $yesterday = $this->expensesModel->expenseTotal(datesWhenCustom('lastyear'));
                    $todayChange = $today - $yesterday;
                    $todayChangePer = $yesterday > 0 ? round($todayChange / $yesterday * 100) : 100;
                    $todayClass = $todayChangePer > 0 ? 'danger' : 'success';
                    $todayShowArrow = $todayChangePer > 0 ? '<i class="fa fa-angle-up font-danger" style="color: #9f191f; font-size: 14px; font-weight: 700"></i>' : '<i class="fa fa-angle-down font-success" style="color: #3a945b; font-size: 14px; font-weight: 700"></i>';
                    ?>
                    <!--begin::Total Profit-->
                    <div class="m-widget24">
                        <div class="m-widget24__item">
                            <h4 class="m-widget24__title">
                                Annual Expenses
                            </h4><br>
                            <span class="m-widget24__desc">
                                    All Expenses Value
                                </span>
                            <span class="m-widget24__stats m--font-<?php echo $todayClass; ?>">
                                    <?php echo moneyUnit($today); ?>
                                </span>
                            <div class="m--space-10"></div>
                            <div class="progress m-progress--sm">
                                <div class="progress-bar m--bg-<?php echo $todayClass; ?>" role="progressbar"
                                     style="width: <?php echo abs($todayChangePer); ?>%;" aria-valuenow="50"
                                     aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                            <span class="m-widget24__change">
                                    Change
                                </span>
                            <span class="m-widget24__number">
                                    <?php echo '<b>' . abs($todayChangePer) . '% ' . moneyUnit(abs($todayChange)) . $todayShowArrow . '</b>'; ?>
                                </span>
                        </div>
                    </div>

                    <!--end::Total Profit-->
                </div>
            </div>
        </div>
    </div>
    <div class="m-portlet">
        <div class="m-portlet__body">
            <?php if (!empty($this->input->get('when'))) { ?>
                <h3 style="color:#2a62bc;">Showing report
                    for <?php echo strtoupper(htmlspecialchars(strtolower(urldecode(trim($this->input->get('when')))))); ?></h3>
                <hr/>
            <?php } ?>
            <!--begin: Search Form -->
            <form class="m-form m-form--fit m--margin-bottom-20">
                <div class="row m--margin-bottom-20">
                    <div hidden class="col-lg-3 m--margin-bottom-10-tablet-and-mobile">
                        <label>RecordID:</label>
                        <input type="text" class="form-control m-input" placeholder="E.g: 4590" data-col-index="0">
                    </div>
                    <div hidden class="col-lg-3 m--margin-bottom-10-tablet-and-mobile">
                        <label>Employee:</label>
                        <select class="form-control m-input" data-col-index="2">
                            <option value="">Select</option>
                        </select>
                    </div>
                    <div class="col-lg-3 m--margin-bottom-10-tablet-and-mobile">
                        <label>Type:</label>
                        <select class="form-control m-input" data-col-index="4">
                            <option value="">Select</option>
                        </select>
                    </div>
                    <div class="col-lg-3 m--margin-bottom-10-tablet-and-mobile">
                        <label>Actions:</label><br/>
                        <button class="btn btn-brand m-btn m-btn--icon" id="m_search">
                            <span>
                                    <i class="la la-search"></i>
                                    <span>Search</span>
                            </span>
                        </button>
                        &nbsp;&nbsp;
                        <button class="btn btn-secondary m-btn m-btn--icon" id="m_reset">
                            <span>
                                    <i class="la la-close"></i>
                                    <span>Reset</span>
                            </span>
                        </button>
                    </div>
                    <div class="col-lg-3 m--margin-bottom-10-tablet-and-mobile"><br/>
                        <a class="btn btn-success text-uppercase " href="#expenseModal" data-toggle="modal"
                           style="vertical-align: middle;">New Expense</a>
                    </div>
                    <div hidden class="col-lg-3 m--margin-bottom-10-tablet-and-mobile">
                        <label>Category:</label>
                        <select class="form-control m-input" data-col-index="3">
                            <option value="">Select</option>
                        </select>
                    </div>
                </div>
                <div class="row m--margin-bottom-20">
                    <div hidden class="col-lg-3 m--margin-bottom-10-tablet-and-mobile">
                        <label>Expense Date:</label>
                        <div class="input-daterange input-group" id="m_datepicker">
                            <input type="text" class="form-control m-input" name="start" placeholder="From"
                                   data-col-index="1"/>
                            <div class="input-group-append">
                                <span class="input-group-text"><i class="la la-ellipsis-h"></i></span>
                            </div>
                            <input type="text" class="form-control m-input" name="end" placeholder="To"
                                   data-col-index="1"/>
                        </div>
                    </div>
                    <div hidden class="col-lg-3 m--margin-bottom-10-tablet-and-mobile">
                        <label>Status:</label>
                        <select class="form-control m-input" data-col-index="6">
                            <option value="">Select</option>
                        </select>
                    </div>

                </div>
            </form>

            <table class="table table-bordered table-succee table-striped" id="lm_table">
                <thead>
                <tr>
                    <th>#</th>
                    <th>Date</th>
                    <th>Employee</th>
                    <th>Category</th>
                    <th>Type</th>
                    <th>Amount</th>
                    <th>Status</th>
                    <th>Payee</th>
                    <th>Description</th>
                    <th>Budget</th>
                </tr>
                </thead>
                <tfoot>
                <tr>
                    <th>#</th>
                    <th>Date</th>
                    <th>Employee</th>
                    <th>Category</th>
                    <th>Type</th>
                    <th>Amount</th>
                    <th>Status</th>
                    <th>Payee</th>
                    <th>Description</th>
                    <th>Budget</th>
                </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>
</div>
<!-- end:: Body -->
<?php include VIEWPATH . 'includes/footer.php'; ?>
<?php include VIEWPATH . 'includes/js/base_scripts.php'; ?>
<?php include VIEWPATH . '/admin/managers/expenses/scripts.php'; ?>
<?php include VIEWPATH . 'admin/managers/expenses/common.php'; ?>s
</body>
<!-- end::Body -->
</html>
