
<script type="text/javascript">

//== Class definition
$.fn.dataTable.Api.register('column().title()', function() {
  return $(this.header()).text().trim();
});

var Datatable = function() {

var initTable = function() {

    // begin first table
    var tableList = $('#budget-list-table');
    if(tableList != undefined){
        // begin first table
        tableList.DataTable({
            responsive: true,
            buttons: [
                'print',
                'copyHtml5',
                'excelHtml5',
                'csvHtml5',
                'pdfHtml5',
            ],
            dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
			<'row'<'col-sm-12'tr>>
			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
            searchDelay: 500,
            processing: false,
            serverSide: false,
            ajax: '<?php echo base_url('/expenses/budgets/index/datasource');?>',
            columns: [
                {data: 'budget_title'},
                {data: 'budget_date'},
                {data: 'budget_deposit'},
                {data: 'budget_withdraw'},
                {data: 'budget_status'},
            ],
            columnDefs: [
                {
                    targets: 0,
                    "width": "10%",
                    render: function(data, type, full, meta) {
                        return '<a href="#budget-details" data-toggle="modal" data-key="'+ full.budget_key +'">'  + full.budget_title+ ' </a>';
                        return  '<a  href="<?php echo base_url('expenses/budgets/detailsr/');?>' + full.budget_key + '">' + full.budget_title+ '</a>';
                    },
                },
                {
                    targets: 1,
                    "width": "10%",
                },
                {
                    targets: 2,
                    "width": "10%",
                    render: function(data, type, full, meta) {
                        return  numeral(to_money(full.total_deposit)).format('0,0') ;
                    },
                },{
                    targets: 3,
                    "width": "5%",
                    render: function(data, type, full, meta) {
                        return  numeral(to_money(full.total_withdraw)).format('0,0') ;
                    },
                },
                {
                    targets:4,
                    "width": "5%",
                    render: function(data, type, full, meta) {
                        var status = {
                            "Active": {'budget_status': 'Active', 'class': 'kt-badge--success'},
                            "Pending": {'budget_status': 'Pending', 'class': ' kt-badge--warning'},
                        };
                        if (typeof status[data] === 'undefined') {
                            return data;
                        }
                        return '<a href="#budget-details" data-toggle="modal" data-backdrop="false" data-key="'+ full.budget_key +'"><span class="kt-badge ' + status[data].class + ' kt-badge--wide kt-badge--inline">' + status[data].budget_status + '</span></a> ' +
                            '<div class="dropdown dropdown-inline">\n' +
                            '                            <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                            '                                <i class="flaticon-more"></i>\n' +
                            '                            </span>\n' +
                            '                            <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                            '                                <a class="dropdown-item" data-backdrop="false" data-toggle="modal" data-key="'+ full.budget_key +'" href="#deposit-details"><i class="la la-plus kt-font-success"></i> Deposit</a>\n' +
                            '                                <a class="dropdown-item" data-backdrop="false" data-toggle="modal" data-key="'+ full.budget_key +'" href="#withdraw-details"><i class="la la-minus kt-font-warning"></i> Withdraw</a>\n' +
                            '                                <a class="dropdown-item" data-backdrop="false" data-toggle="modal" data-key="'+ full.budget_key +'" href="#transactions-details"><i class="la la-dollar kt-font-brand"></i> Transactions</a>\n' +
                            '                                <a class="dropdown-item" data-backdrop="false" data-toggle="modal" data-key="'+ full.budget_key +'" href="#expenditure-details"><i class="la la-money kt-font-danger"></i> Expenditure</a>\n' +
                            '                                <div class="dropdown-divider"></div>' +
                            '                                <a class="dropdown-item" href="javascript:showbalance('+ full.budget_key +');"><i class="la la-balance-scale kt-font-success"></i> Show balance</a>\n' +
                            '                                <a class="dropdown-item" href="javascript:showtotalexpenditure('+ full.budget_key +');"><i class="la la-balance-scale kt-font-success"></i> Show Total Expenditure</a>\n' +
                            '                                <a class="dropdown-item" class="kt-font-danger kt-font-bolder"  href="javascript:deleteBudget('+ full.budget_key +');"><i class="la la-trash kt-font-danger kt-font-bolder"></i> Delete</a>\n' +
                            '                                <a class="dropdown-item" data-backdrop="false" data-toggle="modal" data-key="'+ full.budget_key +'" href="#budget-details"><i class="la la-cog kt-font-dark"></i> Details</a>\n' +
                            '                            </div>\n' +
                            '                        </div>';
                    },
                }
            ],
        });

    }

    var tableListBin = $('#budget-list-bin-table');
    if(tableListBin != undefined){
        // begin first table
        tableListBin.DataTable({
            responsive: true,
            buttons: [
                'print',
                'copyHtml5',
                'excelHtml5',
                'csvHtml5',
                'pdfHtml5',
            ],
            dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
			<'row'<'col-sm-12'tr>>
			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
            searchDelay: 500,
            processing: false,
            serverSide: false,
            ajax: '<?php echo base_url('expenses/budgets/index/datasourcebin');?>',
            columns: [
                {data: 'budget_title'},
                {data: 'budget_date'},
                {data: 'budget_deposit'},
                {data: 'budget_withdraw'},
                {data: 'budget_status'},
            ],
            columnDefs: [
                {
                    targets: 1,
                    "width": "10%",
                },
                {
                    targets: 2,
                    "width": "10%",
                    render: function(data, type, full, meta) {
                        return  numeral(to_money(full.total_deposit)).format('0,0') ;
                    },
                },{
                    targets: 3,
                    "width": "5%",
                    render: function(data, type, full, meta) {
                        return  numeral(to_money(full.total_withdraw)).format('0,0') ;
                    },
                },
                {
                    targets: 4,
                    "width": "10%",
                    render: function (data, type, full, meta) {
                        var status = {
                            "Active": {'budget_status': 'Active', 'class': 'kt-badge--success'},
                            "Pending": {'budget_status': 'Approved', 'class': ' kt-badge--warning'},
                        };
                        if (typeof status[data] === 'undefined') {
                            return data;
                        }
                        return '<a href="javascript:restoreBudget('+ full.budget_key +');"><i class="la la-reply-all kt-font-success"></i> Restore</a>';
                    },
                }
            ],
        });

    }
};

return {

    //main function to initiate the module
    init: function() {
        initTable();
    },

};

}();

jQuery(document).ready(function() {
Datatable.init();
});
</script>
