
<table class="table table-bordered" id="lm_transactions">
    <thead>
    <tr>
        <th>Date</th>
        <th>Deposit</th>
        <th>Withdraw</th>
        <th>Poster</th>
    </tr>
    </thead>
</table>


<script  type="text/javascript">
    $( function(){
        $("select").select2();
    })


    //== Class definition
    $.fn.dataTable.Api.register('column().title()', function() {
        return $(this.header()).text().trim();
    });

    var Datatable = function() {

        var transctions = function() {
            var transction = $('#lm_transactions');

            // begin first table
            transction.DataTable({
                responsive: true,
                buttons: [
                    'print',
                    'copyHtml5',
                    'excelHtml5',
                    'csvHtml5',
                    'pdfHtml5',
                ],
                dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
        <'row'<'col-sm-12'tr>>
        <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                searchDelay: 500,
                processing: true,
                serverSide: true,
                ajax: '<?php echo base_url('expenses/budgets/index/datasourcetransactions/'.$budget['budget_key']);?>',
                columns: [
                    {data: 'bg_date'},
                    {data: 'bg_deposit'},
                    {data: 'bg_withdraw'},
                    {data: 'bg_user'},
                ],
                columnDefs: [
                    {
                        targets: 0,
                        "width": "10%",
                    },
                    {
                        targets: 1,
                        "width": "10%",
                        render: function(data, type, full, meta) {
                            return  numeral(to_money(full.bg_deposit)).format('0,0') ;
                        },
                    },{
                        targets: 2,
                        "width": "5%",
                        render: function(data, type, full, meta) {
                            return  numeral(to_money(full.bg_withdraw)).format('0,0') ;
                        },
                    },
                ],
            });
        };

        return {

            //main function to initiate the module
            init: function() {
                transctions();
            },

        };

    }();

    jQuery(document).ready(function() {
        Datatable.init();
    });

</script>
