<?php echo form_open('#', ['id' => 'formCategory', 'onsubmit' => 'savecategory(); return false;']); ?>
<input required type="hidden" value="<?php echo $category['category_key']; ?>" name="key">
<div class="form-group row">
    <div class="col-12">
        <textarea class="form-control" name="category_details"
                  placeholder="Category Description"><?php echo $category['category_details']; ?></textarea>
    </div>
</div>
<div class="form-group row">
    <div class="col-12">
        <input required type="text" value="<?php echo $category['category_title']; ?>" name="category_title"
               placeholder="Enter category name" class="form-control">
    </div>
</div>
<div class="form-group row">
    <div class="col-6">
        <select required name="category_debit_account" class="form-control">
            <option value="">Select Debit Account</option>
            <?php if (!empty($accounts = $this->accountingModel->accounts())) {
                foreach ($accounts as $ac) {  ?>
                    <option <?php if ($ac['account_key'] == $category['category_debit_account']) echo 'selected'; ?>  value="<?php echo $ac['account_key']; ?>"><?php echo $ac['account_name']; ?></option>
                <?php }
            } ?>
        </select>
    </div>
    <div class="col-6">
        <select required name="category_credit_account" class="form-control">
            <option value="">Select Credit Account</option>
            <?php if (!empty($accounts = $this->accountingModel->accounts())) {
                foreach ($accounts as $ac) {
                    ?>
                    <option <?php if ($ac['account_key'] == $category['category_credit_account']) echo 'selected'; ?> value="<?php echo $ac['account_key']; ?>"><?php echo $ac['account_name']; ?></option>
                <?php }
            } ?>
        </select>
    </div>
</div>
<div class="form-group row">
    <div class="col-6">
        <select required name="category_status" class="form-control">
            <option value="">Select Status</option>
            <option <?php if ("Active" == $category['category_status']) echo 'selected'; ?> value="Active">Active</option>
            <option <?php if ("Pending" == $category['category_status']) echo 'selected'; ?> value="Pending">Pending </option>
            <option <?php if ("Rejected" == $category['category_status']) echo 'selected'; ?> value="Rejected">Rejected</option>
        </select>
    </div>
    <div class="col-6">
        <button type="submit" class="btn btn-block btn-elevate-air btn-brand text-uppercase pull-right kt-font-bolder">
            Save Changes
        </button>
    </div>
</div>
<?php echo form_close(); ?>

<script type="text/javascript">
    $(function () {
        $("select").select2();
    })

    function savecategory() {
        let form = $("form#formCategory");
        let formdata = form.serialize();
        $.ajax({
            url: "<?php echo base_url('/expenses/categories/index/save');?>",
            data: formdata,
            type: "post",
            beforeSend: function () {
                KTApp.block(form, {
                    overlayColor: "#000000",
                    type: "loader",
                    state: "brand",
                    message: "Sending data ..."
                });
            },
            success: function (response) {
                KTApp.unblock(form);
                if (response.status == true) {
                    $("div#category-details").modal("hide");
                    notifySuccess(response.message);
                    var table = $.fn.dataTable.tables({api: true});
                    table.ajax.reload();
                } else {
                    Swal.fire("Server response", response.message, "warning");
                }
            },
            error: function (xhr) {
                KTApp.unblock(form);
                Swal.fire("Server response", "Server issue occured please try again later or contact support: <?php echo config_item("server_level_support");?>", "warning");
            }
        })
    }
</script>