<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<form class="kt-form" id="modifyExpenseForm" action="#" onsubmit="return false;">
    <div class="kt-portlet__body">
        <div class="form-group validated">
            <label class="form-control-label" for="inputSuccess1">Expense payee</label>
            <input name="expense_payee" value="<?php echo $expense->expense_payee; ?>"
                   data-suggestions="<?php if (!empty($usernames = usernames())) {
                       foreach ($usernames as $username) {
                           echo $username['username'] . ',';
                       }
                   }
                   if (!empty($users = users())) {
                       foreach ($users as $user) {
                           echo $user['firstname'] . ' ' . $user['lastname'] . ',';
                       }
                   } ?>" data-validation-help="Enter maximum characters of 30" data-suggestions="Electricity, Payroll"
                   data-validation="length required" data-validation-length="max30" type="text" class="form-control"
                   placeholder="Enter expense payee" maxlength="30">
        </div>
        <div class="form-group validated">
            <label class="form-control-label" for="inputSuccess1">Expense Type</label>
            <select data-validation="required" class="form-control" name="expense_type_type" style="width:100%;">
                <option value="">Select Expense Type</option>
                <?php if (!empty($types = $this->expensesModel->expenseTypes())) {
                    foreach ($types as $type) { ?>
                        <option <?php if ($expense->expense_type_type == $type['expense_type_key']) echo 'selected'; ?>
                                value="<?php echo $type['expense_type_key']; ?>"><?php echo $type['expense_type']; ?></option>
                    <?php }
                } ?>
            </select>
        </div>
        <div class="form-group validated">
            <label class="form-control-label" for="inputSuccess1">Withdarw From</label>
            <select data-validation="required" class="form-control" name="expense_credit_account" style="width:100%;">
                <option value="">Select Account</option>
                <?php if (!empty($accounts = $this->accountingModel->accounts())) {
                    foreach ($accounts as $account) {
                        ?>
                        <option <?php if ($expense->expense_credit_account == $account['account_id']) echo 'selected'; ?>
                                value="<?php echo $account['account_id']; ?>"><?php echo $account['account_name']; ?></option>
                    <?php }
                } ?>
            </select>
        </div>
        <div class="form-group validated">
            <label class="form-control-label" for="inputSuccess1">Amount </label>
            <input name="expense_amount" value="<?php echo number_format(to_money($expense->expense_amount)); ?>"
                   data-validation="required" type="text" class="form-control number" placeholder="Enter expense amount"
                   maxlength="30">
        </div>
        <div class="form-group validated">
            <label class="form-control-label" for="inputSuccess1">Expense Deatils</label>
            <textarea name="expense_details" class="form-control" rows="2"
                      cols="80"><?php echo $expense->expense_details; ?></textarea>
        </div>
        <div class="kt-portlet__foot pull-right">
            <div class="kt-form__actions">
                <button type="submit" class="btn btn-success">Save Changes</button>
                <button type="button" data-dismiss="modal" class="btn btn-warning">Cancel</button>
            </div>
        </div>
    </div>
</form>
<script type="text/javascript">
    (function ($, undefined) {
        "use strict";
        // When ready.
        $(function () {
            var $input = $("input.number");
            $input.on("keyup", function (event) {
                // When user select text in the document, also abort.
                var selection = window.getSelection().toString();
                if (selection !== '') {
                    return;
                }
                // When the arrow keys are pressed, abort.
                if ($.inArray(event.keyCode, [38, 40, 37, 39]) !== -1) {
                    return;
                }
                var $this = $(this);
                // Get the value.
                var input = $this.val();
                var input = input.replace(/[\D\s\._\-]+/g, "");
                input = input ? parseInt(input, 10) : 0;
                $this.val(function () {
                    return (input === 0) ? "" : input.toLocaleString("en-US");
                });
            });
        });
    })(jQuery);
    $('select').select2({placeholder: 'Select Option'});

    $('form#modifyExpenseForm').submit(function (event) {
        let form = $(this);
        event.preventDefault();
        let formdata = form.serialize();
        $.ajax({
            url: '<?php echo base_url($auth_role . '/expenses/expenses/expenseModifyAction/' . $expense->expense_key);?>',
            type: 'get',
            data: formdata,
            beforeSend: function () {
                KTApp.block(form, {
                    overlayColor: "#000000",
                    type: "loader",
                    state: "success",
                    message: "Updating Expense ...."
                });
            },
            success: function (r) {
                var obj = JSON.parse(r);
                if (obj.status == 'ok') {
                    $('.kt-datatable').KTDatatable('reload');
                    $('div#expenseDetails').modal('hide');
                    Swal.fire('', obj.message, 'success');
                } else {
                    Swal.fire('', obj.message, 'warning');
                }
                KTApp.unblock(form);
            },
            error: function () {
                $('div#expenseDetails').modal('hide');
                KTApp.unblock(form);
            }
        });
    })
</script>
