<?php
if (!empty($_GET['when'])) {
    $when = htmlspecialchars(strtolower(urldecode(trim($_GET['when']))));
} else {
    $when = '';
}
?>

<script type="text/javascript">

    $(function () {

        $('select').select2();

        $('#expense-details').on('show.bs.modal', function (event) {
            let modal = $(this);
            let body = modal.find('.expense-details-body');
            body.html('<h1>Please wait ...</h1>');
            let button = $(event.relatedTarget)
            let key = button.data('key')
            body.load('<?php echo base_url('/expenses/index/details/');?>' + key);
        })
    });

    function setExpenseStatusApproved(expense) {
        $.fn.modal.Constructor.prototype._enforceFocus = function () {
        };
        $(document).off('focusin.modal');
        Swal.fire({
            title: 'Submit access password',
            input: 'password',
            inputPlaceholder: "Enter password",
            inputAttributes: {
                autocapitalize: 'off'
            },
            showCancelButton: true,
            confirmButtonText: 'Approve',
            showLoaderOnConfirm: true,
            preConfirm: (login) => {
                return fetch(`<?php echo base_url('/expenses/index/setexpensestatus')?>/${login}/${expense}/Approved`)
                    .then(response => {
                        if (!response.ok) {
                            throw new Error(response.statusText)
                        }
                        return response.json()
                    })
                    .catch(error => {
                        Swal.showValidationMessage(
                            `Request failed: ${error}`
                        )
                    })
            },
            allowOutsideClick: () => !Swal.isLoading()
        }).then((responses) => {
            if (responses.value) {
                if (responses.value.status == true) {
                    notifySuccess(responses.value.message);
                    let table = $.fn.dataTable.tables({api: true});
                    table.clear().draw();
                } else {
                    Swal.fire("Server response", responses.value.message, "warning");
                }
            }
        })
    }

    function setExpenseStatusPending(expense) {
        $.fn.modal.Constructor.prototype._enforceFocus = function () {
        };
        $(document).off('focusin.modal');
        Swal.fire({
            title: 'Submit access password',
            input: 'password',
            inputPlaceholder: "Enter password",
            inputAttributes: {
                autocapitalize: 'off'
            },
            showCancelButton: true,
            confirmButtonText: 'Pending',
            showLoaderOnConfirm: true,
            preConfirm: (login) => {
                return fetch(`<?php echo base_url('/expenses/index/setexpensestatus')?>/${login}/${expense}/Pending`)
                    .then(response => {
                        if (!response.ok) {
                            throw new Error(response.statusText)
                        }
                        return response.json()
                    })
                    .catch(error => {
                        Swal.showValidationMessage(
                            `Request failed: ${error}`
                        )
                    })
            },
            allowOutsideClick: () => !Swal.isLoading()
        }).then((responses) => {
            if (responses.value) {
                if (responses.value.status == true) {
                    notifySuccess(responses.value.message);
                    let table = $.fn.dataTable.tables({api: true});
                    table.clear().draw();
                } else {
                    Swal.fire("Server response", responses.value.message, "warning");
                }
            }
        })
    }

    function setExpenseStatusRejected(expense) {
        $.fn.modal.Constructor.prototype._enforceFocus = function () {
        };
        $(document).off('focusin.modal');
        Swal.fire({
            title: 'Submit access password',
            input: 'password',
            inputPlaceholder: "Enter password",
            inputAttributes: {
                autocapitalize: 'off'
            },
            showCancelButton: true,
            confirmButtonText: 'Reject',
            showLoaderOnConfirm: true,
            preConfirm: (login) => {
                return fetch(`<?php echo base_url('/expenses/index/setexpensestatus')?>/${login}/${expense}/Rejected`)
                    .then(response => {
                        if (!response.ok) {
                            throw new Error(response.statusText)
                        }
                        return response.json()
                    })
                    .catch(error => {
                        Swal.showValidationMessage(
                            `Request failed: ${error}`
                        )
                    })
            },
            allowOutsideClick: () => !Swal.isLoading()
        }).then((responses) => {
            if (responses.value) {
                if (responses.value.status == true) {
                    notifySuccess(responses.value.message);
                    let table = $.fn.dataTable.tables({api: true});
                    table.clear().draw();
                } else {
                    Swal.fire("Server response", responses.value.message, "warning");
                }
            }
        })
    }

    function setExpenseStatusPendingReject(expense) {
        let status = encodeURI("Pending Reject");
        $.fn.modal.Constructor.prototype._enforceFocus = function () {
        };
        $(document).off('focusin.modal');
        Swal.fire({
            title: 'Submit access password',
            input: 'password',
            inputPlaceholder: "Enter password",
            inputAttributes: {
                autocapitalize: 'off'
            },
            showCancelButton: true,
            confirmButtonText: 'Pending Reject',
            showLoaderOnConfirm: true,
            preConfirm: (login) => {
                return fetch(`<?php echo base_url('/expenses/index/setexpensestatus')?>/${login}/${expense}/${status}`)
                    .then(response => {
                        if (!response.ok) {
                            throw new Error(response.statusText)
                        }
                        return response.json()
                    })
                    .catch(error => {
                        Swal.showValidationMessage(
                            `Request failed: ${error}`
                        )
                    })
            },
            allowOutsideClick: () => !Swal.isLoading()
        }).then((responses) => {
            if (responses.value) {
                if (responses.value.status == true) {
                    notifySuccess(responses.value.message);
                    let table = $.fn.dataTable.tables({api: true});
                    table.clear().draw();
                } else {
                    Swal.fire("Server response", responses.value.message, "warning");
                }
            }
        })
    }

</script>