<?php include VIEWPATH . 'includes/css/base_style.php'; ?>
<?php include VIEWPATH . 'includes/header.php'; ?>
<div class="m-content">
    <div class="m-portlet">
        <div class="m-portlet__body  m-portlet__body--no-padding">
            <div class="row m-row--no-padding m-row--col-separator-xl">
                <div class="col-md-12 col-lg-6 col-xl-3">
                    <?php
                    $today = $this->expensesModel->expenseTotal('today');
                    $yesterday = $this->expensesModel->expenseTotal('yesterday');
                    $todayChange = $today - $yesterday;
                    $todayChangePer = $yesterday > 0 ? round($todayChange / $yesterday * 100) : 100;
                    $todayClass = $todayChangePer > 0 ? 'danger' : 'success';
                    $todayShowArrow = $todayChangePer > 0 ? '<i class="fa fa-angle-up font-danger" style="color: #9f191f; font-size: 14px; font-weight: 700"></i>' : '<i class="fa fa-angle-down font-success" style="color: #3a945b; font-size: 14px; font-weight: 700"></i>';
                    ?>
                    <!--begin::Total Profit-->
                    <div class="m-widget24">
                        <div class="m-widget24__item">
                            <h4 class="m-widget24__title">
                                Daily Expenses
                            </h4><br>
                            <span class="m-widget24__desc">
                                    All Expenses Value
                                </span>
                            <span class="m-widget24__stats m--font-<?php echo $todayClass; ?>">
                                    <?php echo moneyUnit($today); ?>
                                </span>
                            <div class="m--space-10"></div>
                            <div class="progress m-progress--sm">
                                <div class="progress-bar m--bg-<?php echo $todayClass; ?>" role="progressbar"
                                     style="width: <?php echo abs($todayChangePer); ?>%;" aria-valuenow="50"
                                     aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                            <span class="m-widget24__change">
                                    Change
                                </span>
                            <span class="m-widget24__number">
                                    <?php echo '<b>' . abs($todayChangePer) . '% ' . moneyUnit(abs($todayChange)) . $todayShowArrow . '</b>'; ?>
                                </span>
                        </div>
                    </div>

                    <!--end::Total Profit-->
                </div>
                <div class="col-md-12 col-lg-6 col-xl-3">
                    <?php
                    $today = $this->expensesModel->expenseTotal('week');
                    $yesterday = $this->expensesModel->expenseTotal('lastweek');
                    $todayChange = $today - $yesterday;
                    $todayChangePer = $yesterday > 0 ? round($todayChange / $yesterday * 100) : 100;
                    $todayClass = $todayChangePer > 0 ? 'danger' : 'success';
                    $todayShowArrow = $todayChangePer > 0 ? '<i class="fa fa-angle-up font-danger" style="color: #9f191f; font-size: 14px; font-weight: 700"></i>' : '<i class="fa fa-angle-down font-success" style="color: #3a945b; font-size: 14px; font-weight: 700"></i>';
                    ?>
                    <!--begin::Total Profit-->
                    <div class="m-widget24">
                        <div class="m-widget24__item">
                            <h4 class="m-widget24__title">
                                Weekly Expenses
                            </h4><br>
                            <span class="m-widget24__desc">
                                    All Expenses Value
                                </span>
                            <span class="m-widget24__stats m--font-<?php echo $todayClass; ?>">
                                    <?php echo moneyUnit($today); ?>
                                </span>
                            <div class="m--space-10"></div>
                            <div class="progress m-progress--sm">
                                <div class="progress-bar m--bg-<?php echo $todayClass; ?>" role="progressbar"
                                     style="width: <?php echo abs($todayChangePer); ?>%;" aria-valuenow="50"
                                     aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                            <span class="m-widget24__change">
                                    Change
                                </span>
                            <span class="m-widget24__number">
                                    <?php echo '<b>' . abs($todayChangePer) . '% ' . moneyUnit(abs($todayChange)) . $todayShowArrow . '</b>'; ?>
                                </span>
                        </div>
                    </div>

                    <!--end::Total Profit-->
                </div>
                <div class="col-md-12 col-lg-6 col-xl-3">
                    <?php
                    $today = $this->expensesModel->expenseTotal('month');
                    $yesterday = $this->expensesModel->expenseTotal('lastmonth');
                    $todayChange = $today - $yesterday;
                    $todayChangePer = $yesterday > 0 ? round($todayChange / $yesterday * 100) : 100;
                    $todayClass = $todayChangePer > 0 ? 'danger' : 'success';
                    $todayShowArrow = $todayChangePer > 0 ? '<i class="fa fa-angle-up font-danger" style="color: #9f191f; font-size: 14px; font-weight: 700"></i>' : '<i class="fa fa-angle-down font-success" style="color: #3a945b; font-size: 14px; font-weight: 700"></i>';
                    ?>
                    <!--begin::Total Profit-->
                    <div class="m-widget24">
                        <div class="m-widget24__item">
                            <h4 class="m-widget24__title">
                                Monthly Expenses
                            </h4><br>
                            <span class="m-widget24__desc">
                                    All Expenses Value
                                </span>
                            <span class="m-widget24__stats m--font-<?php echo $todayClass; ?>">
                                    <?php echo moneyUnit($today); ?>
                                </span>
                            <div class="m--space-10"></div>
                            <div class="progress m-progress--sm">
                                <div class="progress-bar m--bg-<?php echo $todayClass; ?>" role="progressbar"
                                     style="width: <?php echo abs($todayChangePer); ?>%;" aria-valuenow="50"
                                     aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                            <span class="m-widget24__change">
                                    Change
                                </span>
                            <span class="m-widget24__number">
                                    <?php echo '<b>' . abs($todayChangePer) . '% ' . moneyUnit(abs($todayChange)) . $todayShowArrow . '</b>'; ?>
                                </span>
                        </div>
                    </div>

                    <!--end::Total Profit-->
                </div>
                <div class="col-md-12 col-lg-6 col-xl-3">
                    <?php
                    $today = $this->expensesModel->expenseTotal('year');
                    $yesterday = $this->expensesModel->expenseTotal('lastyear');
                    $todayChange = $today - $yesterday;
                    $todayChangePer = $yesterday > 0 ? round($todayChange / $yesterday * 100) : 100;
                    $todayClass = $todayChangePer > 0 ? 'danger' : 'success';
                    $todayShowArrow = $todayChangePer > 0 ? '<i class="fa fa-angle-up font-danger" style="color: #9f191f; font-size: 14px; font-weight: 700"></i>' : '<i class="fa fa-angle-down font-success" style="color: #3a945b; font-size: 14px; font-weight: 700"></i>';
                    ?>
                    <!--begin::Total Profit-->
                    <div class="m-widget24">
                        <div class="m-widget24__item">
                            <h4 class="m-widget24__title">
                                Annual Expenses
                            </h4><br>
                            <span class="m-widget24__desc">
                                    All Expenses Value
                                </span>
                            <span class="m-widget24__stats m--font-<?php echo $todayClass; ?>">
                                    <?php echo moneyUnit($today); ?>
                                </span>
                            <div class="m--space-10"></div>
                            <div class="progress m-progress--sm">
                                <div class="progress-bar m--bg-<?php echo $todayClass; ?>" role="progressbar"
                                     style="width: <?php echo abs($todayChangePer); ?>%;" aria-valuenow="50"
                                     aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                            <span class="m-widget24__change">
                                    Change
                                </span>
                            <span class="m-widget24__number">
                                    <?php echo '<b>' . abs($todayChangePer) . '% ' . moneyUnit(abs($todayChange)) . $todayShowArrow . '</b>'; ?>
                                </span>
                        </div>
                    </div>

                    <!--end::Total Profit-->
                </div>
            </div>
        </div>
    </div>
    <div class="m-portlet">
        <div class="m-portlet__body">
            <?php if (!empty($this->input->get('when'))) { ?>
                <h3 style="color:#2a62bc;">
                    <small>Showing </small> <?php echo ucwords(datesWhenCustom(htmlspecialchars(strtolower(urldecode(trim($this->input->get('when'))))))['label']); ?>
                    <small>Report</small></h3>
                <hr/>
            <?php } ?>
            <!--begin: Search Form -->
            <form class="m-form m-form--fit m--margin-bottom-20">
                <div class="row m--margin-bottom-20">
                    <div class="col-lg-3 m--margin-bottom-10-tablet-and-mobile">
                        <label>RecordID:</label>
                        <input type="text" class="form-control m-input" placeholder="E.g: 4590" data-col-index="0">
                    </div>
                    <div class="col-lg-3 m--margin-bottom-10-tablet-and-mobile">
                        <label>Employee:</label>
                        <select class="form-control m-input" data-col-index="2">
                            <option value="">Select</option>
                        </select>
                    </div>
                    <div class="col-lg-3 m--margin-bottom-10-tablet-and-mobile">
                        <label>Type:</label>
                        <select class="form-control m-input" data-col-index="4">
                            <option value="">Select</option>
                        </select>
                    </div>
                    <div class="col-lg-3 m--margin-bottom-10-tablet-and-mobile">
                        <label>Category:</label>
                        <select class="form-control m-input" data-col-index="3">
                            <option value="">Select</option>
                        </select>
                    </div>
                </div>
                <div class="row m--margin-bottom-20">
                    <div class="col-lg-3 m--margin-bottom-10-tablet-and-mobile">
                        <label>Expense Date:</label>
                        <div class="input-daterange input-group" id="m_datepicker">
                            <input type="text" class="form-control m-input" name="start" placeholder="From"
                                   data-col-index="1"/>
                            <div class="input-group-append">
                                <span class="input-group-text"><i class="la la-ellipsis-h"></i></span>
                            </div>
                            <input type="text" class="form-control m-input" name="end" placeholder="To"
                                   data-col-index="1"/>
                        </div>
                    </div>
                    <div class="col-lg-3 m--margin-bottom-10-tablet-and-mobile">
                        <label>Status:</label>
                        <select class="form-control m-input" data-col-index="7">
                            <option value="">Select</option>
                        </select>
                    </div>
                    <div class="col-lg-3 m--margin-bottom-10-tablet-and-mobile">
                        <label>Actions:</label><br/>
                        <button class="btn btn-brand m-btn m-btn--icon" id="m_search">
                            <span>
                                    <i class="la la-search"></i>
                                    <span>Search</span>
                            </span>
                        </button>
                        &nbsp;&nbsp;
                        <button class="btn btn-secondary m-btn m-btn--icon" id="m_reset">
                            <span>
                                    <i class="la la-close"></i>
                                    <span>Reset</span>
                            </span>
                        </button>
                    </div>
                    <div class="col-lg-3 m--margin-bottom-10-tablet-and-mobile"><br/>
                        <a class="btn btn-success text-uppercase " href="#expenseModal" data-toggle="modal"
                           style="vertical-align: middle;">New Expense</a>
                    </div>
                </div>
            </form>

            <table class="table table-bordered table-succee table-striped" id="lm_table_partials">
                <thead>
                <tr>
                    <th>#</th>
                    <th>Date</th>
                    <th>Employee</th>
                    <th>Category</th>
                    <th>Type</th>
                    <th>Amount</th>
                    <th>Paid</th>
                    <th>Status</th>
                    <th>Payee</th>
                    <th>Description</th>
                    <th>Budget</th>
                </tr>
                </thead>
                <tfoot>
                <tr>
                    <th>#</th>
                    <th>Date</th>
                    <th>Employee</th>
                    <th>Category</th>
                    <th>Type</th>
                    <th>Amount</th>
                    <th>Paid</th>
                    <th>Status</th>
                    <th>Payee</th>
                    <th>Description</th>
                    <th>Budget</th>
                </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>
</div>
<!-- end:: Body -->
<?php include VIEWPATH . 'includes/footer.php'; ?>
<?php include VIEWPATH . 'includes/js/base_scripts.php'; ?>
<?php include __DIR__ . '/common.php'; ?>
<?php
if (!empty($_GET['when'])) {
    $when = htmlspecialchars(strtolower(urldecode(trim($_GET['when']))));
} else {
    $when = '';
}
?>
<script type="text/javascript">

    //== Class definition
    $.fn.dataTable.Api.register('column().title()', function () {
        return $(this.header()).text().trim();
    });

    var Datatable = function () {

        var initTable = function () {
            var table = $('#lm_table_partials');

            // begin first table
            table.DataTable({
                responsive: true,
                buttons: [
                    'print',
                    'copyHtml5',
                    'excelHtml5',
                    'csvHtml5',
                    'pdfHtml5',
                ],
                dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
			<'row'<'col-sm-12'tr>>
			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                searchDelay: 500,
                processing: true,
                serverSide: true,
                ajax: '<?php echo base_url($auth_role . '/managers/expenses/rerequests/datasource/' . $when);?>',
                columns: [
                    {data: 'expense_id'},
                    {data: 'expense_date'},
                    {data: 'employee'},
                    {data: 'category_title'},
                    {data: 'type_title'},
                    {data: 'expense_amount'},
                    {data: 'expense_paid'},
                    {data: 'expense_status'},
                    {data: 'expense_payee'},
                    {data: 'expense_details'},
                    {data: 'budget_title'},
                ],
                initComplete: function () {
                    this.api().columns().every(function () {
                        var column = this;

                        switch (column.title()) {
                            case 'Employee':
                                column.data().unique().sort().each(function (d, j) {
                                    $('.m-input[data-col-index="2"]').append('<option value="' + d + '">' + d + '</option>');
                                });
                                break;
                            case 'Type':
                                column.data().unique().sort().each(function (d, j) {
                                    $('.m-input[data-col-index="4"]').append('<option value="' + d + '">' + d + '</option>');
                                });
                                break;
                            case 'Category':
                                column.data().unique().sort().each(function (d, j) {
                                    $('.m-input[data-col-index="3"]').append('<option value="' + d + '">' + d + '</option>');
                                });
                                break;
                            case 'Status':
                                var status = {
                                    0: {'expense_status': 'Pending', 'class': 'm-badge--brand'},
                                    1: {'expense_status': 'Approved', 'class': ' m-badge--success'},
                                    2: {'expense_status': 'Rejected', 'class': ' m-badge--danger'},
                                };
                                column.data().unique().sort().each(function (d, j) {
                                    $('.m-input[data-col-index="7"]').append('<option value="' + d + '">' + status[d].expense_status + '</option>');
                                });
                                break;
                        }
                    });
                },
                columnDefs: [
                    {
                        targets: 0,
                        "width": "3%",
                    },
                    {
                        targets: 1,
                        "width": "7%",
                    },
                    {
                        targets: 2,
                        "width": "10%",
                        render: function (data, type, full, meta) {
                            return '<a  href="<?php echo base_url($auth_role . '/managers/expenses/employees/detailsr/');?>' + full.user_id + '">' + full.employee + '</a>';
                        },
                    },
                    {
                        targets: 3,
                        "width": "10%",
                        render: function (data, type, full, meta) {
                            return '<a  href="<?php echo base_url($auth_role . '/managers/expenses/categories/detailsr/');?>' + full.category_id + '">' + full.category_title + '</a>';
                        },
                    },
                    {
                        targets: 4,
                        "width": "10%",
                        render: function (data, type, full, meta) {
                            return '<a  href="<?php echo base_url($auth_role . '/managers/expenses/types/detailsr/');?>' + full.type_id + '">' + full.type_title + '</a>';
                        },
                    }, {
                        targets: 5,
                        "width": "5%",
                        render: function (data, type, full, meta) {
                            return numeral(full.expense_amount).format('0,0');
                        },
                    },
                    {
                        targets: 6,
                        "width": "5%",
                        render: function (data, type, full, meta) {
                            return numeral(full.expense_paid).format('0,0');
                        },
                    },
                    {
                        targets: 7,
                        "width": "5%",
                        render: function (data, type, full, meta) {
                            var status = {
                                0: {'expense_status': 'Pending', 'class': 'm-badge--warning'},
                                1: {'expense_status': 'Approved', 'class': ' m-badge--success'},
                                2: {'expense_status': 'Rejected', 'class': ' m-badge--danger'},
                            };
                            if (typeof status[data] === 'undefined') {
                                return data;
                            }
                            return '<a href="#expense-details-cancel-request" data-toggle="modal" data-key="' + full.expense_id + '"><span class="m-badge ' + status[data].class + ' m-badge--wide">' + status[data].expense_status + '</span></a>';
                        },
                    },
                    {
                        // hide columns by index number
                        targets: 8,
                        "width": "15%",

                    }, {
                        // hide columns by index number
                        targets: 9,
                        "width": "10%",
                        visible: false,
                    },

                    {
                        targets: 10,
                        "width": "10%",
                        render: function (data, type, full, meta) {
                            return '<a  href="<?php echo base_url($auth_role . '/managers/expenses/budgets/detailsr/');?>' + full.budget_id + '">' + full.budget_title + '</a>';
                        },
                    },
                ],
            });

            var filter = function () {
                var val = $.fn.dataTable.util.escapeRegex($(this).val());
                let table = $.fn.dataTable.tables({api: true});
                table.column($(this).data('col-index')).search(val ? val : '', false, false).draw();
            };

            var asdasd = function (value, index) {
                let table = $.fn.dataTable.tables({api: true});
                var val = $.fn.dataTable.util.escapeRegex(value);
                table.column(index).search(val ? val : '', false, true);
            };

            $('#m_search').on('click', function (e) {
                e.preventDefault();
                let table = $.fn.dataTable.tables({api: true});
                var params = {};
                $('.m-input').each(function () {
                    var i = $(this).data('col-index');
                    if (params[i]) {
                        params[i] += '|' + $(this).val();
                    } else {
                        params[i] = $(this).val();
                    }
                });
                $.each(params, function (i, val) {
                    // apply search params to datatable
                    table.column(i).search(val ? val : '', false, false);
                });
                table.table().draw();
            });

            $('#m_reset').on('click', function (e) {
                e.preventDefault();
                let table = $.fn.dataTable.tables({api: true});
                $('.m-input').each(function () {
                    $(this).val('');
                    table.column($(this).data('col-index')).search('', false, false);
                });
                table.table().draw();
            });

            $('#m_datepicker').datepicker({
                todayHighlight: true,
                templates: {
                    leftArrow: '<i class="la la-angle-left"></i>',
                    rightArrow: '<i class="la la-angle-right"></i>',
                },
            });
        };

        return {

            //main function to initiate the module
            init: function () {
                initTable();
            },

        };

    }();

    jQuery(document).ready(function () {
        Datatable.init();
    });
</script>
</body>
<!-- end::Body -->
</html>
