<!-- begin::Head -->
<?php include VIEWPATH.'includes/header.php';?>
<link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.5.0/css/bootstrap-datepicker.css" rel="stylesheet">
<!-- end::Head -->

<!-- begin:: Aside Menu -->
<?php include VIEWPATH.'menus/left.php';?>
<!-- end:: Aside Menu -->

<!-- begin:: Header Menu -->
<?php include VIEWPATH.'menus/top.php';?>
<!-- end:: Header Menu -->

<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

    <?php topMenuFreightForward('home');?>
    <!-- begin:: Content -->
    <div class="kt-container  kt-container--fluid  kt-grid__item kt-grid__item--fluid">

        <div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
            <div class="kt-portlet">
                <div class="kt-portlet__body  kt-portlet__body--fit">
                    <div class="row row-no-padding row-col-separator-xl">
                        <?php include('side_menu.php'); ?>
                        <div class="col-md-9">

                            <!--begin::Portlet-->
                            <div id="kt_page_portlet">
                                <div class="kt-widget24 kt-padding-b-0">
                                    <div class="kt-widget24__details">
                                        <div class="kt-widget24__info">
                                            <h4 class="kt-widget24__title">
                                                <h3 class="kt-portlet__head-title"><?php //echo ucwords($employee->firstname . ' ' . $employee->middlename . ' ' . $employee->lastname); ?>
                                                    <small id="information">Freight Information (File No - <?= $freight['fr_key']; ?>)</small>
                                                    <?php
                                                    if($freight['fr_file_status'] == 'Closed'){
                                                        echo "<a style='color: red; margin-left: 5px'><i class='fa fa-folder'></i> File Closed </a>";
                                                    }
                                                    ?>
                                                </h3>
                                            </h4>
                                        </div>
                                    </div>
                                </div>
                                <hr/>
                                <div class="kt-portlet__body" id="details">
                                    <div class="row">
                                        <div class="col">
                                            <div class="alert alert-light alert-elevate fade show" role="alert">
                                                <div class="alert-icon"><i class="flaticon-warning kt-font-info"></i></div>
                                                <div class="alert-text">
                                                    <h3>Description of documentation </h3>
                                                    <?php
                                                    $freight_desc = $this->documentsModel->find_many_by(['doc_fr_key'=>$freight['fr_key'],'doc_type'=>'Documentation', 'deleted'=>0]);
                                                    if(!empty($freight_desc))
                                                    {
                                                        foreach ($freight_desc as $desc)
                                                        {
                                                            if(!empty($desc['doc_description']))
                                                            {
                                                                ?>
                                                                <li>
                                                                    <code><?= $desc['doc_name']; ?> Description : </code>
                                                                    <?= $desc['doc_description'];?>
                                                                    <small>
                                                                        <?= "<i style='color: blue'>(".date('M d,Y', strtotime($desc['created'])).")</i>";?>
                                                                    </small>
                                                                    <small>
                                                                        <?= "<i style='color: blue'>(".!empty($desc['created_by'])? " Created by - ".profile($desc['created_by'])->firstname." ".profile($desc['created_by'])->lastname : ''.")</i>";?>
                                                                    </small>
                                                                </li>
                                                                <?php
                                                            }
                                                            else
                                                            {
                                                                ?>
                                                                <li>
                                                                    <code><?= $desc['doc_name']; ?> : </code><code>(No description)</code>
                                                                    <small>
                                                                        <?= "<i style='color: blue'>(".date('M d,Y', strtotime($desc['created'])).")</i>";?>
                                                                    </small>
                                                                    <small>
                                                                        <?= "<i style='color: blue'>(".!empty($desc['created_by'])? " Created by - ".profile($desc['created_by'])->firstname." ".profile($desc['created_by'])->lastname : ''.")</i>";?>
                                                                    </small>
                                                                </li>
                                                                <?php
                                                            }
                                                        }
                                                    }
                                                    else
                                                    {
                                                        ?>
                                                        <code>(No description)</code>
                                                        <?php
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php
                                    if(has_menu_freight()){
                                        if(has_role('freight_create_documentations')){
                                            if($freight['fr_file_status'] == 'Active'){?>
                                                <form id="docsForm" onsubmit="return false;" class="kt-form kt-form--label-right">
                                                    <div class="kt-portlet__body">
                                                        <div class="form-group row">
                                                            <div class="col-lg-12" style="margin-top: 5px">
                                                                <label class="">Attach File:</label>
                                                                <div class="m-dropzone dropzone m-dropzone--primary dz-clickable" id="kt_dropzone_1">
                                                                    <div class="dropzone-msg dz-message needsclick">
                                                                        <h3 class="dropzone-msg-title">Click here to upload documentation file..</h3>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-lg-6">
                                                                <label>Document Type (eg. Invoice, Bill of lading, etc)</label>
                                                                <input type="text" class="form-control" name="doc_name" placeholder="Enter here" required>
                                                            </div>
                                                            <input type="hidden" class="form-control" name="doc_type" value="Documentation" readonly>
                                                            <div class="col-lg-6">
                                                                <label>Description:</label>
                                                                <textarea class="form-control" name="doc_description" placeholder="Enter description"></textarea>
                                                            </div>
                                                            <input type="hidden" class="form-control" id="uploadedfiles" name="uploadedfiles" />
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-lg-6">
                                                            </div>
                                                            <div class="col-lg-6 kt-align-right">
                                                                <button type="submit" name="submit" class="btn btn-success">Submit</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </form>
                                            <?php }}} ?>
                                    <!--Begin::Section-->
                                    <div class="row">
                                        <?php
                                        $document = $this->documentsModel->find_many_by(['doc_fr_key'=>$freight['fr_key'],'doc_type'=>'Documentation']);
                                        if(!empty($document)):
                                            foreach($document as $doc):
                                                ?>
                                                <div class="col-xl-3 col-lg-6 col-md-6" id='<?php echo $doc['doc_key'];?>'>

                                                    <!--Begin::Portlet-->
                                                    <div class="kt-portlet">
                                                        <div class="kt-portlet__head kt-portlet__head--noborder">
                                                            <div class="kt-portlet__head-label">
                                                                <h3 class="kt-portlet__head-title">
                                                                </h3>
                                                            </div>
                                                            <div class="kt-portlet__head-toolbar">
                                                                <a href="#" class="btn btn-clean btn-sm btn-icon btn-icon-md" data-toggle="dropdown">
                                                                    <i class="flaticon-more-1"></i>
                                                                </a>
                                                                <?php
                                                                if(has_menu_freight()){
                                                                    if(has_role('freight_delete_documentations')){
                                                                        ?>
                                                                        <div class="dropdown-menu dropdown-menu-right">
                                                                            <ul class="kt-nav">
                                                                                <li class="kt-nav__item">
                                                                                    <a href="<?= uploadFilePath('freight_docs/').$doc['doc_file'];?>" class="kt-nav__link">
                                                                                        <i class="kt-nav__link-icon flaticon2-download"></i>
                                                                                        <span class="kt-nav__link-text">View</span>
                                                                                    </a>
                                                                                </li>
                                                                                <li class="kt-nav__item">
                                                                                    <a href="javascript:(0);" onclick="deleteDocument('<?php echo $doc['doc_key'];?>')" class="kt-nav__link">
                                                                                        <i class="kt-nav__link-icon flaticon2-trash"></i>
                                                                                        <span class="kt-nav__link-text">Delete</span>
                                                                                    </a>
                                                                                </li>
                                                                            </ul>
                                                                        </div>
                                                                    <?php }}?>
                                                            </div>
                                                        </div>
                                                        <div class="kt-portlet__body">
                                                            <!--begin::Widget -->
                                                            <div class="kt-widget__files">
                                                                <div class="kt-widget__media">
                                                                    <img class="kt-widget__img kt-hidden-" src="<?php echo base_url('resources/');?>assets/media/files/<?php echo getFileExt($doc['doc_file']);?>.svg" alt="FILE">
                                                                </div>

                                                                <a target="_blank" href="<?php echo uploadFilePath('freight_docs/').$doc['doc_file'];?>"  data-url="<?php echo uploadFilePath('freight_docs/').$doc['doc_file'];?>" class="kt-widget__desc">
                                                                    <?php echo $doc['doc_name'];?>
                                                                </a>
                                                            </div>

                                                            <!--end::Widget -->
                                                        </div>
                                                    </div>

                                                    <!--End::Portlet-->
                                                </div>
                                            <?php endforeach; endif; ?>
                                    </div>
                                    <!--End::Section-->
                                </div>                            <!--end::Portlet-->
                            </div>
                        </div>
                    </div>
                </div>
                <!-- end:: Content -->
            </div>

        </div>

    </div>
    <!-- end:: Content -->
</div>

<?php include VIEWPATH.'includes/footer.php';
//include __DIR__.'/scripts.php';
?>
<script src="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.js" type="text/javascript"></script>
<script src="<?php echo base_url('resources');?>/assets/js/pages/crud/forms/widgets/bootstrap-datetimepicker.js" type="text/javascript"></script>

<script src="https://js.pusher.com/4.4/pusher.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfobject/2.1.1/pdfobject.min.js" integrity="sha256-rYPX3dXq8Nh532EvCS2foeyTgmzbcC8u+nCk/rEtKXA=" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-timeago/1.6.3/jquery.timeago.js"></script>
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
<script src="https://printjs-4de6.kxcdn.com/print.min.js"></script>
<script src="<?php echo base_url('resources')?>/lockminds/js/lmscripts.js" type="text/javascript"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/numeral.js/2.0.6/numeral.min.js"></script>

<!--begin::Page Scripts(used by this page) -->
<div class="modal fade- modal-sticky-top-right" id="freightTaskDetails" role="dialog" aria-labelledby="" aria-hidden="true">
    <div class="modal-dialog modal-md" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="">All Task Information</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true" class="la la-remove"></span>
                </button>
            </div>
            <div class="modal-body text-back" id="printArea">

            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    function deleteDocument(docKey){
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('freight/index/deleteDocument/')?>'+ docKey,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.block("div#kt_page_portlet",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Deleting document ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblock('div#kt_page_portlet');
                        if( result.status == true){
                            notifySuccess(result.message);
                            window.location.reload();
                        }else{
                            Swal.fire("", "An error occurred! " + result.message, "warning");
                            window.location.reload();
                        }
                    },
                    error: function(xhr){
                        KTApp.unblock('div#kt_page_portlet');
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText, 'warning');
                        window.location.reload();
                        <?php }?>
                    }
                });
            }
        })
    }

    $(function () {

        $('form#docsForm').submit(function (event) {
            let form = $(this);
            let $div = $('div#details');
            let dropzone = $('input#uploadedfiles').val();
            event.preventDefault();
            let formdata = form.serialize();

            if(dropzone === ''){
                swal.fire('Warning', 'Please attach document', 'warning');
            }
            else{
                $.ajax({
                    url: '<?php echo base_url( 'freight/index/newDocumentation/' . $freight['fr_key']);?>',
                    type: 'get',
                    data: formdata,
                    beforeSend: function () {
                        KTApp.block($div, {
                            overlayColor: "#000000",
                            type: "loader",
                            state: "success",
                            message: "Processing, please wait...."
                        });
                    },
                    success: function (result) {
                        if(result.status == true){
                            KTApp.unblock($div);
                            window.location.reload();
                            Swal.fire('', 'Successfully Uploaded!', 'success');
                        }
                        else {
                            KTApp.unblock($div);
                            window.location.reload();
                            Swal.fire('', result.message, 'warning');
                        }
                    },
                    error: function (xhr) {
                        KTApp.unblock($div);
                        Swal.fire('Error', xhr.statusText, 'warning');
                    }
                });
            }
        });
    })

    //Dropzone.autoDiscover = false;
    var options = {
        url: "<?php echo base_url('freight/index/uploadfrdoc');?>",
        paramName: "file", // The name that will be used to transfer the file
        maxFiles: 1,
        maxFilesize: 5, // MB
        addRemoveLinks: true,
        success: function(file, response){
            let oldValue = $('input#uploadedfiles').val();
            if(oldValue.length > 0){
                oldValue = oldValue + 'LM-55';
            }
            let newValue =  oldValue + response.files;
            $('input#uploadedfiles').val(newValue);
        },
    };
    var freightDocs = new Dropzone("div#kt_dropzone_1",options);
</script>
<!--end::Page Scripts -->
</body>

<!-- end::Body -->
</html>