<script type="text/javascript">

    "use strict";

    //== Class definition
    $.fn.dataTable.Api.register('column().title()', function() {
        return $(this.header()).text().trim();
    });

    var Datatable = function() {

        var initTables = function()
        {
            var countries = $('#countries-list-table');
            if(countries != undefined){
                // begin countries table
                countries.DataTable({
                    "ordering": false,
                    responsive: true,
                    buttons: [
                        'print',
                        'copyHtml5',
                        'excelHtml5',
                        'csvHtml5',
                        'pdfHtml5',
                    ],
                    dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
                            <'row'<'col-sm-12'tr>>
                            <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                    searchDelay: 500,
                    processing: false,
                    serverSide: false,
                    ajax: '<?php echo base_url('freight/index/datasource_contries');?>',
                    columns: [
                        {data: 'country_id'},
                        {data: 'country_name'},
                        {data: 'country_created_on'},
                    ],
                    columnDefs: [
                        {
                            targets: 2,
                            render: function(data,type, full, meta){
                                return data;
                            }
                        },

                        {
                            targets: 3,
                            render: function(data, type, full, meta) {
                                return  '<a data-key="' + full.country_key + '" data-toggle="modal" data-backdrop="false" href="#modify-country-modal"><i class="la la-edit kt-font-success"></i> Modify</a>\n' +
                                        '<a  href="javascript:deleteCountry('+ full.country_key  +');"><i class="la la-trash kt-font-danger"></i> Delete</a>\n';
                            },
                        },
                    ],
                });

            }

            var countriesBin = $('#countries-list-bin-table');
            if(countriesBin != undefined){
                // begin countries table
                countriesBin.DataTable({
                    "ordering": true,
                    responsive: true,
                    buttons: [
                        'print',
                        'copyHtml5',
                        'excelHtml5',
                        'csvHtml5',
                        'pdfHtml5',
                    ],
                    dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
                            <'row'<'col-sm-12'tr>>
                            <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                    searchDelay: 500,
                    processing: false,
                    serverSide: false,
                    ajax: '<?php echo base_url('freight/index/datasource_contries_bin');?>',
                    columns: [
                        {data: 'country_id'},
                        {data: 'country_name'},
                        {data: 'country_created_on'},
                    ],
                    columnDefs: [
                        {
                            targets: 2,
                            render: function(data,type, full, meta){
                                return data;
                            }
                        },

                        {
                            targets: 3,
                            render: function(data, type, full, meta) {

                                return  '<a  href="javascript:restoreCountry('+ full.country_key  +');"><i class="la la-reply-all kt-font-success"></i> Restore</a>\n';


                            },
                        },
                    ],
                });

            }

            var categories = $('#categories-list-table');
            if(categories != undefined){
                // begin categories table
                categories.DataTable({
                    "ordering": false,
                    responsive: true,
                    buttons: [
                        'print',
                        'copyHtml5',
                        'excelHtml5',
                        'csvHtml5',
                        'pdfHtml5',
                    ],
                    dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
                            <'row'<'col-sm-12'tr>>
                            <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                    searchDelay: 500,
                    processing: false,
                    serverSide: false,
                    ajax: '<?php echo base_url('freight/index/datasource_categories');?>',
                    columns: [
                        {data: 'fr_category_id'},
                        {data: 'fr_category_name'},
                        {data: 'fr_category_created_on'},
                    ],
                    columnDefs: [
                        {
                            targets: 2,
                            render: function(data,type, full, meta){
                                return data;
                            }
                        },

                        {
                            targets: 3,
                            render: function(data, type, full, meta) {

                                return  '<a data-key="' + full.fr_category_key + '" data-toggle="modal" data-backdrop="false" href="#modify-category-modal"><i class="la la-edit kt-font-success"></i> Modify</a>\n' +
                                    '<a  href="javascript:deleteCategory('+ full.fr_category_key  +');"><i class="la la-trash kt-font-danger"></i> Delete</a>\n';


                            },
                        },
                    ],
                });

            }

            var categoriesBin = $('#categories-list-bin-table');
            if(categoriesBin != undefined){
                // begin categories bin table
                categoriesBin.DataTable({
                    "ordering": false,
                    responsive: true,
                    buttons: [
                        'print',
                        'copyHtml5',
                        'excelHtml5',
                        'csvHtml5',
                        'pdfHtml5',
                    ],
                    dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
                            <'row'<'col-sm-12'tr>>
                            <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                    searchDelay: 500,
                    processing: false,
                    serverSide: false,
                    ajax: '<?php echo base_url('freight/index/datasource_categories_bin');?>',
                    columns: [
                        {data: 'fr_category_id'},
                        {data: 'fr_category_name'},
                        {data: 'fr_category_created_on'},
                    ],
                    columnDefs: [
                        {
                            targets: 2,
                            render: function(data,type, full, meta){
                                return data;
                            }
                        },

                        {
                            targets: 3,
                            render: function(data, type, full, meta) {

                                return  '<a  href="javascript:restoreCategory('+ full.fr_category_key  +');"><i class="la la-reply-all kt-font-success"></i> Restore</a>\n';


                            },
                        },
                    ],
                });

            }

            var plans = $('#plans-list-table');
            if(plans != undefined){
                // begin categories table
                plans.DataTable({
                    "ordering": false,
                    responsive: true,
                    buttons: [
                        'print',
                        'copyHtml5',
                        'excelHtml5',
                        'csvHtml5',
                        'pdfHtml5',
                    ],
                    dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
                            <'row'<'col-sm-12'tr>>
                            <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                    searchDelay: 500,
                    processing: false,
                    serverSide: false,
                    ajax: '<?php echo base_url('freight/index/datasource_plans');?>',
                    columns: [
                        {data: 'fr_plan_id'},
                        {data: 'fr_plan_name'},
                        {data: 'fr_plan_created_on'},
                    ],
                    columnDefs: [
                        {
                            targets: 2,
                            render: function(data,type, full, meta){
                                return data;
                            }
                        },

                        {
                            targets: 3,
                            render: function(data, type, full, meta) {

                                return  '<a data-key="' + full.fr_plan_key + '" data-toggle="modal" data-backdrop="false" href="#modify-plan-modal"><i class="la la-edit kt-font-success"></i> Modify</a>\n' +
                                    '<a  href="javascript:deletePlan('+ full.fr_plan_key  +');"><i class="la la-trash kt-font-danger"></i> Delete</a>\n';
                            },
                        },
                    ],
                });

            }

            var plansBin = $('#plans-list-bin-table');
            if(plansBin != undefined){
                // begin categories table
                plansBin.DataTable({
                    "ordering": false,
                    responsive: true,
                    buttons: [
                        'print',
                        'copyHtml5',
                        'excelHtml5',
                        'csvHtml5',
                        'pdfHtml5',
                    ],
                    dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
                            <'row'<'col-sm-12'tr>>
                            <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                    searchDelay: 500,
                    processing: false,
                    serverSide: false,
                    ajax: '<?php echo base_url('freight/index/datasource_plans_bin');?>',
                    columns: [
                        {data: 'fr_plan_id'},
                        {data: 'fr_plan_name'},
                        {data: 'fr_plan_created_on'},
                    ],
                    columnDefs: [
                        {
                            targets: 2,
                            render: function(data,type, full, meta){
                                return data;
                            }
                        },

                        {
                            targets: 3,
                            render: function(data, type, full, meta) {

                                return  '<a  href="javascript:restorePlan('+ full.fr_plan_key  +');"><i class="la la-reply-all kt-font-success"></i> Restore</a>\n';
                            },
                        },
                    ],
                });

            }

            var freights = $('#freights-list-table');
            if(freights != undefined){
                // begin freights table
                freights.DataTable({
                    "ordering": false,
                    responsive: true,
                    buttons: [
                        'print',
                        'copyHtml5',
                        'excelHtml5',
                        'csvHtml5',
                        'pdfHtml5',
                    ],
                    dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
                            <'row'<'col-sm-12'tr>>
                            <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                    searchDelay: 500,
                    processing: false,
                    serverSide: false,
                    ajax: '<?php echo base_url('freight/index/datasource_freights');?>',
                    columns: [
                        {data: 'fr_id'},
                        {data: 'fr_importer'},
                        {data: 'fr_country_of_destination'},
                        {data: 'fr_created_on'},
                        {data: 'fr_invoice_number'},
                        {data: 'fr_status'},
                    ],
                    columnDefs: [
                        {
                            targets: 1,
                            render: function(data,type, full, meta){
                                return full.firstname + " " + full.lastname;
                            }
                        },
                        {
                            targets: 2,
                            render: function(data,type, full, meta){
                                return full.country_name;
                            }
                        },
                        {
                            targets: 5,
                            "width": "15%",
                            render: function (data, type, full, meta) {
                                var status = {
                                    "Approved": {'fr_status': 'Approved', 'class': 'kt-badge--success'},
                                    "Pending": {'fr_status': 'Pending', 'class': ' kt-badge--warning'},
                                    "Rejected": {'fr_status': 'Rejected', 'class': ' kt-badge--danger'},
                                    "Pending Reject": {'fr_status': 'Pending Rejected', 'class': ' kt-badge--dark'},
                                };
                                if (typeof status[data] === 'undefined') {
                                    return data;
                                }
                                return '<a href="#expense-details" data-toggle="modal" data-backdrop="static" data-key="' + full.fr_key+ '"><span class="kt-badge ' + status[data].class + ' kt-badge--wide kt-badge--inline kt-font-bolder">' + status[data].fr_status + '</span></a> ' +
                                    '<div class="dropdown dropdown-inline">\n' +
                                    '                            <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                                    '                                <i class="flaticon-more"></i>\n' +
                                    '                            </span>\n' +
                                    '                            <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                                    '                                <a class="dropdown-item"  href="<?php echo base_url('freight/edit/');?>' + full.fr_key + '"><i class="la la-edit kt-font-info"></i> Edit</a>\n' +
                                    '                                <a class="dropdown-item"  href="javascript:deleteFreight(' + full.fr_key+ ');"><i class="la la-trash kt-font-danger"></i> Delete</a>\n' +
                                    '                                <a class="dropdown-item" href="<?php echo base_url('freight/details/');?>' + full.fr_key + '"><i class="la la-eye kt-font-success"></i> View</a>\n' +
                                    '                                <div class="dropdown-divider"></div>' +
                                    '                                <a class="dropdown-item" href="<?php echo base_url('freight/documents/');?>' + full.fr_key + '"><i class="la la-cog kt-font-success"></i> Freight Info</a>\n' +
                                    '                            </div>\n' +
                                    '                        </div>';
                            },
                        }
                    ],
                });

            }

            var freightsBin = $('#freights-list-bin-table');
            if(freightsBin != undefined){
                // begin freights table
                freightsBin.DataTable({
                    "ordering": false,
                    responsive: true,
                    buttons: [
                        'print',
                        'copyHtml5',
                        'excelHtml5',
                        'csvHtml5',
                        'pdfHtml5',
                    ],
                    dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
                            <'row'<'col-sm-12'tr>>
                            <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                    searchDelay: 500,
                    processing: false,
                    serverSide: false,
                    ajax: '<?php echo base_url('freight/index/datasource_freights_bin');?>',
                    columns: [
                        {data: 'fr_id'},
                        {data: 'fr_importer'},
                        {data: 'fr_country_of_destination'},
                        {data: 'fr_created_on'},
                        {data: 'fr_invoice_number'},
                        {data: 'fr_status'},
                    ],
                    columnDefs: [
                        {
                            targets: 1,
                            render: function(data,type, full, meta){
                                return full.firstname + " " + full.lastname;
                            }
                        },
                        {
                            targets: 2,
                            render: function(data,type, full, meta){
                                return full.country_name;
                            }
                        },
                        {
                            targets: 5,
                            render: function(data, type, full, meta) {

                                return  '<a  href="javascript:restoreFreight('+ full.fr_key  +');"><i class="la la-reply-all kt-font-success"></i> Restore</a>\n';
                            },
                        },
                    ],
                });

            }

            var importers = $('#importers-list-table');
            if(importers != undefined){
                // begin importers table
                importers.DataTable({
                    "ordering": false,
                    responsive: true,
                    buttons: [
                        'print',
                        'copyHtml5',
                        'excelHtml5',
                        'csvHtml5',
                        'pdfHtml5',
                    ],
                    dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
                            <'row'<'col-sm-12'tr>>
                            <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                    searchDelay: 500,
                    processing: false,
                    serverSide: false,
                    ajax: '<?php echo base_url('freight/index/datasource_importers');?>',
                    columns: [
                        {data: 'users_id'},
                        {data: 'fullname'},
                        {data: 'email'},
                        {data: 'country'},
                        {data: 'phonenumber'},
                        {data: 'user_status'},
                    ],
                    columnDefs: [
                        {
                            targets: 1,
                            render: function(data,type, full, meta){
                                return full.firstname + " " + full.lastname;
                            }
                        },
                        {
                            targets: 5,
                            "width": "15%",
                            render: function (data, type, full, meta) {
                                var status = {
                                    "Active": {'user_status': 'Active', 'class': 'kt-badge--success'},
                                    "Inactive": {'user_status': 'Inactive', 'class': ' kt-badge--warning'},
                                };
                                if (typeof status[data] === 'undefined') {
                                    return data;
                                }
                                return '<a href="#expense-details" data-toggle="modal" data-backdrop="static" data-key="' + full.user_key+ '"><span class="kt-badge ' + status[data].class + ' kt-badge--wide kt-badge--inline kt-font-bolder">' + status[data].user_status + '</span></a> ' +
                                    '<div class="dropdown dropdown-inline">\n' +
                                    '     <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                                    '         <i class="flaticon-more"></i>\n' +
                                    '      </span>\n' +
                                    '      <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                                    '           <a class="dropdown-item" href="<?php echo base_url('freight/importers/details/');?>' + full.user_key + '"><i class="la la-cog kt-font-success"></i>Freight Details</a>\n' +
                                    '        </div>\n' +
                                    '</div>';
                            },
                        }
                    ],
                });

            }

            var exporters = $('#exporters-list-table');
            if(exporters != undefined){
                // begin importers table
                exporters.DataTable({
                    "ordering": false,
                    responsive: true,
                    buttons: [
                        'print',
                        'copyHtml5',
                        'excelHtml5',
                        'csvHtml5',
                        'pdfHtml5',
                    ],
                    dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
                            <'row'<'col-sm-12'tr>>
                            <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                    searchDelay: 500,
                    processing: false,
                    serverSide: false,
                    ajax: '<?php echo base_url('freight/index/datasource_exporters');?>',
                    columns: [
                        {data: 'users_id'},
                        {data: 'fullname'},
                        {data: 'email'},
                        {data: 'country'},
                        {data: 'phonenumber'},
                        {data: 'user_status'},
                    ],
                    columnDefs: [
                        {
                            targets: 1,
                            render: function(data,type, full, meta){
                                return full.firstname + " " + full.lastname;
                            }
                        },
                        {
                            targets: 5,
                            "width": "15%",
                            render: function (data, type, full, meta) {
                                var status = {
                                    "Active": {'user_status': 'Active', 'class': 'kt-badge--success'},
                                    "Inactive": {'user_status': 'Inactive', 'class': ' kt-badge--warning'},
                                };
                                if (typeof status[data] === 'undefined') {
                                    return data;
                                }
                                return '<a href="#expense-details" data-toggle="modal" data-backdrop="static" data-key="' + full.user_key + '"><span class="kt-badge ' + status[data].class + ' kt-badge--wide kt-badge--inline kt-font-bolder">' + status[data].user_status + '</span></a> ' +
                                    '<div class="dropdown dropdown-inline">\n' +
                                    '     <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                                    '         <i class="flaticon-more"></i>\n' +
                                    '      </span>\n' +
                                    '      <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                                    '           <a class="dropdown-item" href="<?php echo base_url('freight/exporters/details/');?>' + full.user_key + '"><i class="la la-cog kt-font-success"></i>Freight Details</a>\n' +
                                    '        </div>\n' +
                                    '</div>';
                            },
                        }
                    ],
                });

            }
        };

        return {

            //main function to initiate the module
            init: function() {
                initTables();
            },

        };

    }();

    jQuery(document).ready(function() {
        Datatable.init();
    });

</script>