<!-- begin::Head -->
<?php include VIEWPATH.'includes/header.php';?>
<link href="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css" />
<!-- end::Head -->
<style>
    td {word-wrap: break-word}
</style>
<!-- begin:: Aside Menu -->
<?php include VIEWPATH.'menus/left.php';?>
<!-- end:: Aside Menu -->

<!-- begin:: Header Menu -->
<?php include VIEWPATH.'menus/top.php';?>
<!-- end:: Header Menu -->

<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

    <?php topMenuFreightForward('settings');?>

    <!-- begin:: Content -->
    <div class="kt-container kt-container--fluid">
        <div class="row">
            <div class="col-12">
                <div class="bs-example">
                    <nav >
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:(0);">Freight Forwarding</a></li>
                            <li class="breadcrumb-item active"><a href="javascript:(0);">Settings</a></li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>



        <!--begin:: Widgets/Quick Stats-->
        <?php //include __DIR__.'/top_summary.php';?>
        <!--end:: Widgets/Quick Stats-->

        <div class="kt-portlet kt-portlet--tabs" data-portlet="true">
            <div class="kt-portlet__head">
                <div class="kt-portlet__head-label">
                    <h3 class="kt-portlet__head-title">
                        Countries <?php if(!empty($when = $this->input->get("when"))) echo '| <span class="kt-font-brand">'. ucfirst(datesWhen($when)['label'])."</span>";?>
                    </h3> &nbsp;&nbsp;
                    <a href="#countries" data-backdrop="false" data-toggle="modal" class="btn btn-outline-brand btn-sm">Add Country</a>
                </div>
                <div class="kt-portlet__head-toolbar">

                    <ul class="nav nav-tabs nav-tabs-bold nav-tabs-line   nav-tabs-line-right nav-tabs-line-brand" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" data-toggle="tab" href="#countries-list" role="tab" aria-selected="false">
                                Countries
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#countries-list-bin" role="tab" aria-selected="true">
                                Recycle Bin
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="kt-portlet__body kt-portlet__body--fullheight">
                <div class="tab-content">
                    <div class="tab-pane  active" id="countries-list">
                        <table class="table " id="countries-list-table">
                            <thead>
                            <tr>
                                <th>ID #</th>
                                <th>Country</th>
                                <th>Date</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                    <div class="tab-pane" id="countries-list-bin">
                        <table id="countries-list-bin-table" class="table">
                            <thead>
                            <tr>
                                <th>ID #</th>
                                <th>Country</th>
                                <th>Date</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="kt-portlet kt-portlet--tabs" data-portlet="true">
            <div class="kt-portlet__head">
                <div class="kt-portlet__head-label">
                    <h3 class="kt-portlet__head-title">
                        Goods Category <?php if(!empty($when = $this->input->get("when"))) echo '| <span class="kt-font-brand">'. ucfirst(datesWhen($when)['label'])."</span>";?>
                    </h3>
                    &nbsp;&nbsp;
                    <a href="#categories" data-backdrop="false" data-toggle="modal" class="btn btn-outline-brand btn-sm">Add Category</a>
                </div>
                <div class="kt-portlet__head-toolbar">
                    <ul class="nav nav-tabs nav-tabs-bold nav-tabs-line   nav-tabs-line-right nav-tabs-line-brand" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" data-toggle="tab" href="#categories-list" role="tab" aria-selected="false">
                                Categories
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#categories-list-bin" role="tab" aria-selected="true">
                                Recycle Bin
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="kt-portlet__body kt-portlet__body--fullheight">
                <div class="tab-content">
                    <div class="tab-pane  active" id="categories-list">
                        <table class="table " id="categories-list-table">
                            <thead>
                            <tr>
                                <th>ID #</th>
                                <th>Category Name</th>
                                <th>Date</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                    <div class="tab-pane" id="categories-list-bin">
                        <table id="categories-list-bin-table" class="table">
                            <thead>
                            <tr>
                                <th>ID #</th>
                                <th>Category Name</th>
                                <th>Date</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="kt-portlet kt-portlet--tabs" data-portlet="true">
            <div class="kt-portlet__head">
                <div class="kt-portlet__head-label">
                    <h3 class="kt-portlet__head-title">
                        Plans <?php if(!empty($when = $this->input->get("when"))) echo '| <span class="kt-font-brand">'. ucfirst(datesWhen($when)['label'])."</span>";?>
                    </h3>&nbsp;&nbsp;
                    <a href="#plans" data-backdrop="false" data-toggle="modal" class="btn btn-outline-brand btn-sm">Add Plan</a>
                </div>
                <div class="kt-portlet__head-toolbar">
                    <ul class="nav nav-tabs nav-tabs-bold nav-tabs-line   nav-tabs-line-right nav-tabs-line-brand" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" data-toggle="tab" href="#plans-list" role="tab" aria-selected="false">
                                Plans
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#plans-list-bin" role="tab" aria-selected="true">
                                Recycle Bin
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="kt-portlet__body kt-portlet__body--fullheight">
                <div class="tab-content">
                    <div class="tab-pane  active" id="plans-list">
                        <table class="table " id="plans-list-table">
                            <thead>
                            <tr>
                                <th>ID #</th>
                                <th>Plan Name</th>
                                <th>Date</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                    <div class="tab-pane" id="plans-list-bin">
                        <table id="plans-list-bin-table" class="table">
                            <thead>
                            <tr>
                                <th>ID #</th>
                                <th>Plan Name</th>
                                <th>Date</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <!-- end:: Content -->
</div>

<!-- Begin: Modify Countries Modal -->
<div class="modal fade" id="modify-country-modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <?php $attr = array( 'class' => 'kt-form','id'=>'modify-country-form');
        echo form_open('', $attr );?>
        <div class="modal-content">
            <div class="modal-header">
                <h3>Modify Country</h3>
            </div>
            <div class="modal-body">

            </div>
            <div class="modal-footer">
                <div class="kt-form__actions">
                    <div class="row">
                        <div class="col-6"><button type="button" data-dismiss="modal" class="btn btn-secondary">Cancel</button></div>
                        <div class="col-6">
                            <button type="submit" name="submit" class="btn btn-success pull-right">Update</button>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <?php echo form_close();?>
    </div>
</div>
<!-- End: Modify Countries Modal -->

<!-- Begin: Modify Categories Modal -->
<div class="modal fade" id="modify-category-modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <?php $attr = array( 'class' => 'kt-form','id'=>'modify-category-form');
        echo form_open('', $attr );?>
        <div class="modal-content">
            <div class="modal-header">
                <h3>Modify Category</h3>
            </div>
            <div class="modal-body">

            </div>
            <div class="modal-footer">
                <div class="kt-form__actions">
                    <div class="row">
                        <div class="col-6"><button type="button" data-dismiss="modal" class="btn btn-secondary">Cancel</button></div>
                        <div class="col-6">
                            <button type="submit" name="submit" class="btn btn-success pull-right">Update</button>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <?php echo form_close();?>
    </div>
</div>
<!-- End: Modify Categories Modal -->

<!-- Begin: Modify Plans Modal -->
<div class="modal fade" id="modify-plan-modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <?php $attr = array( 'class' => 'kt-form','id'=>'modify-plan-form');
        echo form_open('', $attr );?>
        <div class="modal-content">
            <div class="modal-header">
                <h3>Modify Plan</h3>
            </div>
            <div class="modal-body">

            </div>
            <div class="modal-footer">
                <div class="kt-form__actions">
                    <div class="row">
                        <div class="col-6"><button type="button" data-dismiss="modal" class="btn btn-secondary">Cancel</button></div>
                        <div class="col-6">
                            <button type="submit" name="submit" class="btn btn-success pull-right">Update</button>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <?php echo form_close();?>
    </div>
</div>
<!-- End: Modify Plans Modal -->

<!-- Begin: Add Countries Modal -->
<div class="modal fade" id="countries" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <?php $attr = array( 'class' => 'kt-form','id'=>'add-country-form');
        echo form_open('', $attr );?>
        <div class="modal-content">
            <div class="modal-header">
                <h3>Add Country</h3>
            </div>
            <div class="modal-body">
                <!--begin::Form-->
                <label style="margin: 10px">Country of Export | Trading Country | Country of Destination </label>
                <div class="kt-portlet__body">
                    <div class="form-group">
                        <input name="country" class="form-control kt-select2" id="kt_select2_3_modal" required>
                    </div>

                </div>
            </div>
            <div class="modal-footer">
                <div class="kt-form__actions">
                    <div class="row">
                        <div class="col-6"><button type="button" data-dismiss="modal" class="btn btn-secondary">Cancel</button></div>
                        <div class="col-6">
                            <button type="submit" name="submit" class="btn btn-success pull-right">Add</button>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <?php echo form_close();?>
    </div>
</div>
<!-- End: Add Countries Modal -->

<!-- Begin: Add Categories Modal -->
<div class="modal fade" id="categories" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <?php $attr = array( 'class' => 'kt-form','id'=>'add-category-form');
        echo form_open('', $attr );?>
        <div class="modal-content">
            <div class="modal-header">
                <h3>Add Category</h3>
            </div>
            <div class="modal-body">
                <div class="kt-portlet__body">
                    <div class="form-group">
                        <input name="category" class="form-control kt-select2" id="kt_select2_3_modal" required>
                    </div>

                </div>
            </div>
            <div class="modal-footer">
                <div class="kt-form__actions">
                    <div class="row">
                        <div class="col-6"><button type="button" data-dismiss="modal" class="btn btn-secondary">Cancel</button></div>
                        <div class="col-6">
                            <button type="submit" name="submit" class="btn btn-success pull-right">Add</button>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <?php echo form_close();?>
    </div>
</div>
<!-- End: Add Categories Modal -->

<!-- Begin: Add Plans Modal -->
<div class="modal fade" id="plans" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <?php $attr = array( 'class' => 'kt-form','id'=>'add-plan-form');
        echo form_open('', $attr );?>
        <div class="modal-content">
            <div class="modal-header">
                <h3>Add Plan</h3>
            </div>
            <div class="modal-body">
                <div class="kt-portlet__body">
                    <div class="form-group">
                        <input name="plan" class="form-control kt-select2" id="kt_select2_3_modal" required>
                    </div>

                </div>
            </div>
            <div class="modal-footer">
                <div class="kt-form__actions">
                    <div class="row">
                        <div class="col-6"><button type="button" data-dismiss="modal" class="btn btn-secondary">Cancel</button></div>
                        <div class="col-6">
                            <button type="submit" name="submit" class="btn btn-success pull-right">Add</button>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <?php echo form_close();?>
    </div>
</div>
<!-- End: Add Plans Modal -->

<?php
include VIEWPATH.'includes/footer.php';?>
<script src="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.js" type="text/javascript"></script>
<?php
include __DIR__.'/scripts.php';
//include __DIR__.'/common.php';
?>

<script type="text/javascript">
    // Begin : Add Countries, Categories and Plans
    $( function(){

        $("#countries").on('show.bs.modal', function (event) {
            $("form#add-country-form").resetForm();
        })

        $("form#modify-country-form").submit( function(event){
            const  form = $(this);
            event.preventDefault();
            let formData = form.serialize();
            $.ajax({
                url: "<?php echo base_url('freight/index/modify_country');?>",
                data: formData,
                type: "post",
                beforeSend: function(){
                    KTApp.block(form,{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"Modifying country ..."
                    });
                },
                success: function(result){
                    KTApp.unblock(form);
                    if( result.status == true){
                        $("#modify-country-modal").modal("hide");
                        notifySuccess(result.message);
                        var table = $.fn.dataTable.tables( { api: true } );
                        table.clear().draw();

                    }else{
                        swal.fire("","An error occurred! "+ result.message,"warning");
                    }
                },
                error: function(xhr){
                    KTApp.unblock(form);
                    <?php if(ENVIRONMENT !== 'production'){?>
                    Swal.fire('Server Error!', xhr.statusText,'danger');
                    <?php }?>
                }

            })
        });

        $("form#modify-category-form").submit( function(event){
            const  form = $(this);
            event.preventDefault();
            let formData = form.serialize();
            $.ajax({
                url: "<?php echo base_url('freight/index/modify_category');?>",
                data: formData,
                type: "post",
                beforeSend: function(){
                    KTApp.block(form,{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"Modifying category ..."
                    });
                },
                success: function(result){
                    KTApp.unblock(form);
                    if( result.status == true){
                        $("#modify-category-modal").modal("hide");
                        notifySuccess(result.message);
                        var table = $.fn.dataTable.tables( { api: true } );
                        table.clear().draw();

                    }else{
                        swal.fire("","An error occurred! "+ result.message,"warning");
                    }
                },
                error: function(xhr){
                    KTApp.unblock(form);
                    <?php if(ENVIRONMENT !== 'production'){?>
                    Swal.fire('Server Error!', xhr.statusText,'danger');
                    <?php }?>
                }

            })
        });

        $("form#modify-plan-form").submit( function(event){
            const  form = $(this);
            event.preventDefault();
            let formData = form.serialize();
            $.ajax({
                url: "<?php echo base_url('freight/index/modify_plan');?>",
                data: formData,
                type: "post",
                beforeSend: function(){
                    KTApp.block(form,{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"Modifying plan ..."
                    });
                },
                success: function(result){
                    KTApp.unblock(form);
                    if( result.status == true){
                        $("#modify-plan-modal").modal("hide");
                        notifySuccess(result.message);
                        var table = $.fn.dataTable.tables( { api: true } );
                        table.clear().draw();

                    }else{
                        swal.fire("","An error occurred! "+ result.message,"warning");
                    }
                },
                error: function(xhr){
                    KTApp.unblock(form);
                    <?php if(ENVIRONMENT !== 'production'){?>
                    Swal.fire('Server Error!', xhr.statusText,'danger');
                    <?php }?>
                }

            })
        });

        $("form#add-country-form").submit( function(event){
            const  form = $(this);
            event.preventDefault();
            let formData = form.serialize();
            $.ajax({
                url: "<?php echo base_url('freight/addcountry');?>",
                data: formData,
                type: "post",
                beforeSend: function(){
                    KTApp.block(form,{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"Creating country ..."
                    });
                },
                success: function(result){
                    KTApp.unblock(form);
                    if( result.status == true){
                        notifySuccess(result.message);
                        $("form#add-country-form").resetForm();

                        var table = $.fn.dataTable.tables( { api: true } );
                        table.clear().draw();

                    }else{
                        swal.fire("","An error occurred! "+ result.message,"warning");
                    }
                },
                error: function(xhr){
                    KTApp.unblock(form);
                    <?php if(ENVIRONMENT !== 'production'){?>
                    Swal.fire('Server Error!', xhr.statusText,'danger');
                    <?php }?>
                }

            })
        });

        $('#modify-country-modal').on('show.bs.modal', function (event) {
            var modal = $(this)
            modal.find('.modal-body').html('Please wait ...');
            var button = $(event.relatedTarget)
            var key = button.data('key')
            modal.find('.modal-body').load('<?php echo base_url('freight/index/country_details/');?>' + key);
        })

        $('#modify-category-modal').on('show.bs.modal', function (event) {
            var modal = $(this)
            modal.find('.modal-body').html('Please wait ...');
            var button = $(event.relatedTarget)
            var key = button.data('key')
            modal.find('.modal-body').load('<?php echo base_url('freight/index/category_details/');?>' + key);
        })

        $('#modify-plan-modal').on('show.bs.modal', function (event) {
            var modal = $(this)
            modal.find('.modal-body').html('Please wait ...');
            var button = $(event.relatedTarget)
            var key = button.data('key')
            modal.find('.modal-body').load('<?php echo base_url('freight/index/plan_details/');?>' + key);
        })



        $("#categories").on('show.bs.modal', function (event) {
            $("form#add-category-form").resetForm();
        })

        $("form#add-category-form").submit( function(event){
            const  form = $(this);
            event.preventDefault();
            let formData = form.serialize();
            $.ajax({
                url: "<?php echo base_url('freight/addcategory');?>",
                data: formData,
                type: "post",
                beforeSend: function(){
                    KTApp.block(form,{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"Adding category, Please wait ..."
                    });
                },
                success: function(result){
                    KTApp.unblock(form);
                    if( result.status == true){
                        notifySuccess(result.message);
                        $("form#add-category-form").resetForm();

                        var table = $.fn.dataTable.tables( { api: true } );
                        table.clear().draw();

                    }else{
                        swal.fire("","An error occurred! "+ result.message,"warning");
                    }
                },
                error: function(xhr){
                    KTApp.unblock(form);
                    <?php if(ENVIRONMENT !== 'production'){?>
                    Swal.fire('Server Error!', xhr.statusText,'danger');
                    <?php }?>
                }

            })
        });


        $("#plans").on('show.bs.modal', function (event) {
            $("form#add-plan-form").resetForm();
        })

        $("form#add-plan-form").submit( function(event){
            const  form = $(this);
            event.preventDefault();
            let formData = form.serialize();
            $.ajax({
                url: "<?php echo base_url('freight/addplan');?>",
                data: formData,
                type: "post",
                beforeSend: function(){
                    KTApp.block(form,{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"Adding plan, Please wait ..."
                    });
                },
                success: function(result){
                    KTApp.unblock(form);
                    if( result.status == true){
                        notifySuccess(result.message);
                        $("form#add-plan-form").resetForm();

                        var table = $.fn.dataTable.tables( { api: true } );
                        table.clear().draw();

                    }else{
                        swal.fire("","An error occurred! "+ result.message,"warning");
                    }
                },
                error: function(xhr){
                    KTApp.unblock(form);
                    <?php if(ENVIRONMENT !== 'production'){?>
                    Swal.fire('Server Error!', xhr.statusText,'danger');
                    <?php }?>
                }

            })
        });



    })
    // End : Add plans

    function deleteCountry(country){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('freight/index/delete_country')?>/' + country,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Deleting Country ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }

    function deleteCategory(category){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('freight/index/delete_category')?>/' + category,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Deleting Category ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }

    function deletePlan(plan){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('freight/index/delete_plan')?>/' + plan,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Deleting Plan ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }

    function restoreCountry(country){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Restore it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('freight/index/restore_country')?>/' + country,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Restoring Country ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }

    function restoreCategory(category){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Restore it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('freight/index/restore_category')?>/' + category,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Restoring Category ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }

    function restorePlan(plan){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Restore it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('freight/index/restore_plan')?>/' + plan,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Restoring Plan ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }


</script>

<!--end::Page Scripts -->
</body>

<!-- end::Body -->
</html>

