<!-- begin::Head -->
<?php include VIEWPATH.'includes/header.php';?>
<link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.5.0/css/bootstrap-datepicker.css" rel="stylesheet">
<!-- end::Head -->

<!-- begin:: Aside Menu -->
<?php include VIEWPATH.'menus/left.php';?>
<!-- end:: Aside Menu -->

<!-- begin:: Header Menu -->
<?php include VIEWPATH.'menus/top.php';?>
<!-- end:: Header Menu -->

<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

    <?php topMenuFreightForward('home');?>
    <!-- begin:: Content -->
    <div class="kt-container  kt-container--fluid  kt-grid__item kt-grid__item--fluid">

        <div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
            <div class="kt-portlet">
                <div class="kt-portlet__body  kt-portlet__body--fit">
                    <div class="row row-no-padding row-col-separator-xl">
                        <?php include('side_menu.php'); ?>
                        <div class="col-md-9">

                            <!--begin::Portlet-->
                            <div id="kt_page_portlet">
                                <div class="kt-widget24 kt-padding-b-0">
                                    <div class="kt-widget24__details">
                                        <div class="kt-widget24__info">
                                            <h4 class="kt-widget24__title">
                                                <h3 class="kt-portlet__head-title"><?php //echo ucwords($employee->firstname . ' ' . $employee->middlename . ' ' . $employee->lastname); ?>
                                                    <small id="information">Freight Information (File No - <?= $freight['fr_key']; ?>)</small>
                                                    <?php
                                                    if($freight['fr_file_status'] == 'Closed'){
                                                        echo "<a style='color: red; margin-left: 5px'><i class='fa fa-folder'></i> File Closed </a>";
                                                    }
                                                    ?>
                                                </h3>
                                            </h4>
                                        </div>
                                    </div>
                                </div>
                                <hr/>
                                <?php
                                if(has_menu_freight()){
                                    if(has_role('task_create')){
                                        if($freight['fr_file_status'] == 'Active'){?>
                                            <form id="freightTaskForm" onsubmit="return false;" class="kt-form kt-form--label-right">
                                                <div class="kt-portlet__body">
                                                    <div class="form-group row">
                                                        <input type="text" hidden class="form-control" name="freight_task_freight_key" value="<?php echo $freight['fr_key'];?>" placeholder="Enter description">
                                                        <div class="col-lg-6">
                                                            <label>Employee:</label>
                                                            <select class="form-control" name="freight_task_employee_key">
                                                                <option disabled>Select Employee</option>
                                                                <?php if(!empty($employees)):
                                                                    foreach($employees as $emp):?>
                                                                        <option value="<?php echo $emp['user_id'];?>" selected><?php echo $emp['firstname'];?> <?php echo $emp['lastname'];?></option>
                                                                    <?php endforeach; endif;?>
                                                            </select>
                                                        </div>
                                                        <div class="col-lg-3">
                                                            <label>File No:</label>
                                                            <input type="text" readonly class="form-control" name="freight_task_freight_key" placeholder="" value="<?php echo $freight['fr_key'];?>">
                                                        </div>
                                                        <div class="col-lg-3">
                                                            <label>Task Status:</label>
                                                            <input type="text" readonly class="form-control" name="user_fam_mname" placeholder="" value="Pending">
                                                        </div>
                                                    </div>
                                                    <div class="form-group row">
                                                        <input type="text" hidden class="form-control" name="freight_task_client" value="<?php echo $freight['fr_client'];?>" placeholder="Enter description">
                                                        <input type="text" hidden class="form-control" name="freight_task_client_name" value="<?php echo $freight['company_name'].' '.$freight['firstname'].' '.$freight['lastname'];?>" placeholder="Enter description">
                                                        <div class="col-lg-6">
                                                            <label>Task Start(optional):</label>
                                                            <div class="input-group date">
                                                                <input type="text" class="form-control" name="freight_task_start" placeholder="Select date and time" id="kt_datetimepicker_5" />
                                                                <div class="input-group-append">
                                                                    <span class="input-group-text">
                                                                        <i class="la la-calendar glyphicon-th"></i>
                                                                    </span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-6">
                                                            <label>Task Deadline(Optional):</label>
                                                            <div class="input-group date">
                                                                <input type="text" class="form-control" name="freight_task_deadline" placeholder="Select date and time" id="kt_datetimepicker_4" />
                                                                <div class="input-group-append">
                                                                    <span class="input-group-text">
                                                                        <i class="la la-calendar glyphicon-th"></i>
                                                                    </span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="form-group row">
                                                        <div class="col-lg-12">
                                                            <label>Task Description</label>
                                                            <textarea id="kt_summernote_1" required name="freight_task_desc" class="form-control summernote" placeholder="Descriptions"></textarea>
                                                        </div>
                                                    </div>

                                                    <div class="row">
                                                        <div class="col-lg-6">
                                                            <button type="reset" class="btn btn-secondary">Clear</button>
                                                        </div>
                                                        <div class="col-lg-6 kt-align-right">
                                                            <button type="submit" name="submit" class="btn btn-success">Save</button>
                                                        </div>
                                                    </div>

                                                </div>
                                            </form>
                                        <?php }}else{ FreightAccessControl(); }}?>
                                <div class="kt-portlet__body">
                                    <!-- <div class="kt-datatable" id="applicationTable"></div> -->
                                    <table class="table table-bordered table-hover table-checkable" id="lm_table_freight_task">
                                        <thead>
                                        <tr>
                                            <th>Responsible Personnel</th>
                                            <th>Task Description</th>
                                            <th>Status</th>
                                            <th>Payment</th>
                                            <th>Action</th>
                                        </tr>
                                        </thead>
                                    </table>
                                </div>
                                <!--end::Portlet-->
                            </div>
                        </div>
                    </div>
                </div>
                <!-- end:: Content -->
            </div>

        </div>

    </div>
    <!-- end:: Content -->
</div>

<?php include VIEWPATH.'includes/footer.php';
//include __DIR__.'/scripts.php';
?>
<div class="modal fade- modal-sticky-top-right" id="freightTaskDetails" role="dialog" aria-labelledby="" aria-hidden="true">
    <div class="modal-dialog modal-md" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="">All Task Information</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true" class="la la-remove"></span>
                </button>
            </div>
            <div class="modal-body text-back" id="printArea">

            </div>
        </div>
    </div>
</div>
<!--begin::Page Scripts(used by this page) -->
<script src="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.js" type="text/javascript"></script>
<script src="<?php echo base_url('resources');?>/assets/js/pages/crud/forms/widgets/bootstrap-datetimepicker.js" type="text/javascript"></script>
<script src="<?php echo base_url('resources');?>/assets/js/pages/crud/forms/editors/summernote.js" type="text/javascript"></script>
<script type="text/javascript">
    //== Class definition
    $.fn.dataTable.Api.register('column().title()', function() {
        return $(this.header()).text().trim();
    });

    var Datatable = function() {
        var initTable = function() {
            var events = $('#lm_table_freight_task');
            // begin first table
            events.DataTable({
                responsive: true,
                buttons: [
                    'print',
                    'copyHtml5',
                    'excelHtml5',
                    'csvHtml5',
                    'pdfHtml5',
                ],
                dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
			<'row'<'col-sm-12'tr>>
			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                searchDelay: 500,
                processing: true,
                serverSide: false,
                ajax: '<?php echo base_url('freight/index/datasourceFreightTask/'.$freight['fr_key']);?>',
                columns: [
                    {data: 'freight_task_employee_key'},
                    {data: 'freight_task_desc'},
                    {data: 'freight_task_status'},
                    {data: 'freight_task_payment'},
                    {data: 'action'},
                ],
                columnDefs: [
                    {
                        targets: 0,
                        render: function (data, type, full, meta) {
                            return '<a  href="<?php echo base_url('/hrm/employees/index/details/');?>' + full.freight_task_employee_key + '">'+full.firstname+' '+full.lastname+'</a>';
                        },
                    },
                    {
                        targets: 4,
                        "width": "20%",
                            <?php
                            if(has_menu_freight()){
                            if(has_role('task_create')){
                            if ($freight['fr_file_status'] == 'Active'){ ?>
                            render: function (data, type, full, meta) {
                                return ' <a href="javascript:deleteItem(' + full.freight_task_key + ');"  title="Delete"><i class="flaticon-delete text-danger"></i></a> | <a data-backdrop="false" title="Edit" href="javascript:updateTask(' + full.freight_task_key + ');"><i class="flaticon2-edit"></i></a>| <a data-backdrop="false" title="View" href="javascript:detailsTask(' + full.freight_task_key + ');"><i class="flaticon2-paper"></i></a>';
                            }
                            <?php }}} else{ ?>
                            function(){ return 'No Action' };
                            <?php } ?>
                    }
                ],
            });

            var filter = function() {
                var val = $.fn.dataTable.util.escapeRegex($(this).val());
                let table = $.fn.dataTable.tables( { api: true } );
                table.column($(this).data('col-index')).search(val ? val : '', false, false).draw();
            };

            var asdasd = function(value, index) {
                let table = $.fn.dataTable.tables( { api: true } );
                var val = $.fn.dataTable.util.escapeRegex(value);
                table.column(index).search(val ? val : '', false, true);
            };

            $('#m_search').on('click', function(e) {
                e.preventDefault();
                let table = $.fn.dataTable.tables( { api: true } );
                var params = {};
                $('.kt-input').each(function() {
                    var i = $(this).data('col-index');
                    if (params[i]) {
                        params[i] += '|' + $(this).val();
                    }
                    else {
                        params[i] = $(this).val();
                    }
                });
                $.each(params, function(i, val) {
                    // apply search params to datatable
                    table.column(i).search(val ? val : '', false, false);
                });
                table.table().draw();
            });

            $('#m_reset').on('click', function(e) {
                e.preventDefault();
                let table = $.fn.dataTable.tables( { api: true } );
                $('.kt-input').each(function() {
                    $(this).val('');
                    table.column($(this).data('col-index')).search('', false, false);
                });
                table.table().draw();
            });

        };

        return {
            //main function to initiate the module
            init: function() {
                initTable();
            },

        };

    }();

    jQuery(document).ready(function() {
        Datatable.init();
    });

    $('form#freightTaskForm').submit(function (event) {
        let form = $(this);
        let $div = $('div#kt_page_portlet');
        event.preventDefault();
        let formdata = form.serialize();
        $.ajax({
            url: '<?php echo base_url('freight/index/newFreightTask/')?>',
            type: 'get',
            data: formdata,
            beforeSend: function () {
                KTApp.block($div, {
                    overlayColor: "#000000",
                    type: "loader",
                    state: "success",
                    message: "Adding New Task for Freight...."
                });
            },
            success: function (r) {
                var obj = JSON.parse(r);
                if (obj.status == 'ok') {
                    window.location.reload();
                    Swal.fire('Success', obj.message, 'success');
                } else {
                    window.location.reload();
                    Swal.fire('', obj.message, 'warning');
                }
                KTApp.unblock($div);
            },
            error: function () {
                Swal.fire('', obj.message, 'success');
                KTApp.unblock($div);
            }
        });
    })

    function deleteItem(task){
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('freight/index/deleteFreightTask/task')?>/'+task,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.block("#lm_table_freight_task",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Deleting task data ..."
                        });
                    },
                    success: function(result){
                        let obj = JSON.parse(result);
                        if( obj.status == 'ok'){
                            notifySuccess(obj.message);
                            KTApp.unblock('#lm_table_freight_task');
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.ajax.reload();
                        }else{
                            Swal.fire('',obj.message,'warning');
                        }
                    },
                    error: function(xhr){
                        KTApp.unblock('#lm_table_freight_task');
                        Swal.fire('',xhr.statusText,'warning');
                    }
                });
            }
        })
    }

    function updateTask(task){
        let $modal =  $('div#freightTaskDetails');
        let $div = $modal.find('.modal-body');
        $div.html('');
        $modal.modal('show');
        $.ajax({
            url: '<?php echo base_url('freight/index/updateFreightTask/');?>' + task,
            type: 'get',
            beforeSend: function(){
                KTApp.block($div,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Loading more details ...."
                });
            },
            success: function (result){
                $div.html(result);
                KTApp.unblock($div);
            },
            error: function (xhr){
                $modal.modal('hide');
                KTApp.unblock($div);
                Swal.fire('',xhr.statusText,'warning');
            }
        })
    }

    function detailsTask(task){
        let $modal =  $('div#freightTaskDetails');
        let $div = $modal.find('.modal-body');
        $div.html('');
        $modal.modal('show');
        $.ajax({
            url: '<?php echo base_url('freight/index/detailsFreightTask/');?>' + task,
            type: 'get',
            beforeSend: function(){
                KTApp.block($div,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Loading more details ...."
                });
            },
            success: function (result){
                $div.html(result);
                KTApp.unblock($div);
            },
            error: function (xhr){
                $modal.modal('hide');
                KTApp.unblock($div);
                Swal.fire('',xhr.statusText,'warning');
            }
        })
    }
</script>
<!--end::Page Scripts -->
</body>

<!-- end::Body -->
</html>