<script type="text/javascript">

    "use strict";

    // Class definition
    var KTFormRepeaters = function() {

        // Private functions
        var items = function() {
            let items = $('#kt_repeater_items').repeater({
                initEmpty: true,
                ready: function () {
                },
                show: function () {

                    $(this).slideDown();

                    $('select.select_tax_option').select2({
                        placeholder: "Select Tax Option",
                    });

                    $('select.select_tax').select2({
                        placeholder: "Select Tax",
                    });

                    $("select.inv_item_tax" ).change(function() {

                        let url = '<?php echo base_url('taxes/index/get_total_tax');?>';

                        let handler = $( this );

                        let parent = handler.closest('.item-container');

                        let itemPrice = parent.find('input.inv_item_price');
                        let quantity = parent.find('input.inv_item_qty');
                        let beforeTax = parent.find('input.inv_item_before_tax');
                        let afterTax = parent.find('input.inv_item_after_tax');
                        let taxValue = parent.find('input.inv_item_tax_value');
                        let taxInclusive = parent.find('select.inv_item_tax_inclusive').val();

                        $.ajax({
                            url: url,
                            data: {'value':handler.val()},
                            type: 'get',
                            beforeSend: function () {
                                KTApp.blockPage({
                                    overlayColor:"#000000",
                                    type:"loader",
                                    state:"danger",
                                    message: ''
                                });
                            },
                            success: function(response){
                                // get tax details
                                parent.find('input.inv_item_tax_percent').val(response.total);
                                let tax = parseFloat(parent.find('input.inv_item_tax_percent').val());

                                taxValue.val(tax * parseFloat(itemPrice.val()) * parseFloat(quantity.val()));

                                // calculate total before Tax
                                beforeTax.val(parseFloat(itemPrice.val()) * parseFloat(quantity.val()));

                                // calculate after tax
                                if(taxInclusive != undefined){
                                    if(taxInclusive == 1){
                                        afterTax.val(parseFloat(beforeTax.val()));
                                    }else{
                                        afterTax.val(parseFloat(beforeTax.val()) + parseFloat(taxValue.val()));
                                    }
                                }else{
                                    afterTax.val(parseFloat(beforeTax.val()) + parseFloat(taxValue.val()));
                                }

                                if(parseFloat(itemPrice.val()) > 0){
                                    beforeTax.css({
                                        "border": "3px solid grey"
                                    });
                                    afterTax.css({
                                        "border": "3px solid grey"
                                    });
                                    afterTax.css({
                                        "border": "3px solid grey"
                                    });
                                    taxValue.css({
                                        "border": "3px solid grey"
                                    });
                                }else{
                                    beforeTax.css({
                                        "border": "1px solid grey"
                                    });
                                    afterTax.css({
                                        "border": "1px solid grey"
                                    });
                                    taxValue.css({
                                        "border": "1px solid grey"
                                    });
                                }
                                KTApp.unblockPage();
                                calSubTotal();
                            },
                            error: function(xhr){
                                KTApp.unblockPage();
                            }
                        });
                    });

                    $("select.inv_item_tax_inclusive" ).change(function() {
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message: ''
                        });
                        let handler = $( this );
                        let parent = handler.closest('.item-container');
                        let itemPrice = parent.find('input.inv_item_price');
                        let quantity = parent.find('input.inv_item_qty');
                        let beforeTax = parent.find('input.inv_item_before_tax');
                        let afterTax = parent.find('input.inv_item_after_tax');
                        let taxValue = parent.find('input.inv_item_tax_value');
                        let taxInclusive = handler.val();

                        // get tax details
                        let tax = parseFloat(parent.find('input.inv_item_tax_percent').val());
                        taxValue.val(tax * parseFloat(itemPrice.val()) * parseFloat(quantity.val()));

                        taxValue.val(tax * parseFloat(itemPrice.val()) * parseFloat(quantity.val()));

                        // calculate total before Tax
                        beforeTax.val(parseFloat(itemPrice.val()) * parseFloat(quantity.val()));

                        // calculate after tax
                        if(taxInclusive != undefined){
                            if(taxInclusive == 1){
                                afterTax.val(parseFloat(beforeTax.val()));
                            }else{
                                afterTax.val(parseFloat(beforeTax.val()) + parseFloat(taxValue.val()));
                            }
                        }else{
                            afterTax.val(parseFloat(beforeTax.val()) + parseFloat(taxValue.val()));
                        }

                        if(parseFloat(itemPrice.val()) > 0){
                            beforeTax.css({
                                "border": "3px solid grey"
                            });
                            afterTax.css({
                                "border": "3px solid grey"
                            });
                            afterTax.css({
                                "border": "3px solid grey"
                            });
                            taxValue.css({
                                "border": "3px solid grey"
                            });
                        }else{
                            beforeTax.css({
                                "border": "1px solid grey"
                            });
                            afterTax.css({
                                "border": "1px solid grey"
                            });
                            taxValue.css({
                                "border": "1px solid grey"
                            });
                        }
                        KTApp.unblockPage();
                        calSubTotal();
                    });

                    $("input.inv_item_price" ).keyup(function() {
                        let handler = $( this );
                        let value = parseFloat(handler.val());
                        let parent = handler.closest('.item-container');
                        let quantity = parent.find('input.inv_item_qty');
                        let beforeTax = parent.find('input.inv_item_before_tax');
                        let afterTax = parent.find('input.inv_item_after_tax');
                        let taxValue = parent.find('input.inv_item_tax_value');
                        let taxInclusive = parent.find('select.inv_item_tax_inclusive').val();

                        // get tax details
                        let tax = parseFloat(parent.find('input.inv_item_tax_percent').val());
                        taxValue.val(tax * value * parseFloat(quantity.val()));

                        // calculate total before Tax
                        beforeTax.val(value * parseFloat(quantity.val()));

                        // calculate after tax
                        if(taxInclusive != undefined){
                            if(taxInclusive == 1){
                                afterTax.val(parseFloat(beforeTax.val()));
                            }else{
                                afterTax.val(parseFloat(beforeTax.val()) + parseFloat(taxValue.val()));
                            }
                        }else{
                            afterTax.val(parseFloat(beforeTax.val()) + parseFloat(taxValue.val()));
                        }

                        if(value > 0){
                            beforeTax.css({
                                "border": "3px solid grey"
                            });
                            afterTax.css({
                                "border": "3px solid grey"
                            });
                            afterTax.css({
                                "border": "3px solid grey"
                            });
                            taxValue.css({
                                "border": "3px solid grey"
                            });
                        }else{
                            beforeTax.css({
                                "border": "1px solid grey"
                            });
                            afterTax.css({
                                "border": "1px solid grey"
                            });
                            taxValue.css({
                                "border": "1px solid grey"
                            });
                        }

                        calSubTotal();
                    });

                    $("input.inv_item_qty" ).keyup(function() {
                        let handler = $( this );
                        let parent = handler.closest('.item-container');
                        let itemPrice = parent.find('input.inv_item_price');
                        let quantity = handler;
                        let beforeTax = parent.find('input.inv_item_before_tax');
                        let afterTax = parent.find('input.inv_item_after_tax');
                        let taxValue = parent.find('input.inv_item_tax_value');
                        let taxInclusive = parent.find('select.inv_item_tax_inclusive').val();

                        // get tax details
                        let tax = parseFloat(parent.find('input.inv_item_tax_percent').val());
                        taxValue.val(tax * parseFloat(itemPrice.val()) * parseFloat(quantity.val()));

                        taxValue.val(tax * parseFloat(itemPrice.val()) * parseFloat(quantity.val()));

                        // calculate total before Tax
                        beforeTax.val(parseFloat(itemPrice.val()) * parseFloat(quantity.val()));

                        // calculate after tax
                        if(taxInclusive != undefined){
                            if(taxInclusive == 1){
                                afterTax.val(parseFloat(beforeTax.val()));
                            }else{
                                afterTax.val(parseFloat(beforeTax.val()) + parseFloat(taxValue.val()));
                            }
                        }else{
                            afterTax.val(parseFloat(beforeTax.val()) + parseFloat(taxValue.val()));
                        }

                        if(parseFloat(itemPrice.val()) > 0){
                            beforeTax.css({
                                "border": "3px solid grey"
                            });
                            afterTax.css({
                                "border": "3px solid grey"
                            });
                            afterTax.css({
                                "border": "3px solid grey"
                            });
                            taxValue.css({
                                "border": "3px solid grey"
                            });
                        }else{
                            beforeTax.css({
                                "border": "1px solid grey"
                            });
                            afterTax.css({
                                "border": "1px solid grey"
                            });
                            taxValue.css({
                                "border": "1px solid grey"
                            });
                        }
                        calSubTotal();
                    });
                },

                hide: function (deleteElement) {
                    if(confirm('Are you sure you want to delete this element?')) {
                        $(this).slideUp(deleteElement);
                        calSubTotal();
                    }
                }
            });

            <?php if(!empty($items)){?>
            if(items.setList != undefined){
                items.setList([
                    <?php  foreach ($items as $i => $item){?>
                    {
                        'inv_item_tax_inclusive' : '<?php echo 0;?>',
                        'inv_item_tax' : '<?php echo 0;?>',
                        'inv_item_tax_percent' : '<?php echo 0;?>',
                        'inv_item' : '<?php echo $item['gl_details'];?>',
                        'inv_item_details' : '<?php echo $item['gl_details'];?>',
                        'inv_item_price' : '<?php echo round(to_money($item['gl_amount']));?>',
                        'inv_item_qty' : '<?php echo 1;?>',
                        'inv_item_tax_value' : '<?php echo round(to_money(0));?>',
                        'inv_item_after_tax' : '<?php echo round(to_money($item['gl_amount']));?>',
                        'inv_item_before_tax' : '<?php echo round(to_money($item['gl_amount']));?>',
                    },
                    <?php } ?>
                ]);
            }
            <?php } ?>
        }

        return {
            // public functions
            init: function() {
                items();
            }
        };
    }();


    jQuery(document).ready(function() {

        $('select.select2').select2({placeholder: "Select option"});

        KTFormRepeaters.init();

    });

    function calSubTotal(){
        let beforeTaxTotal = 0;
        let afterTaxTotal = 0;
        let taxTotalTotal = 0;

        let items = $('input.inv_item');

        let beforeTax = $('input.inv_item_before_tax');
        let afterTax = $('input.inv_item_after_tax');
        let taxTotal = $('input.inv_item_tax_value');

        for (let i = 0; i < items.length; i++){
            beforeTaxTotal += parseFloat(beforeTax[i].value);
            afterTaxTotal += parseFloat(afterTax[i].value);
            taxTotalTotal += parseFloat(taxTotal[i].value);
        }

        $('input.inv_sub_total').val(beforeTaxTotal);
        $('input.inv_total_tax').val(taxTotalTotal);
        $('input.inv_total_after_tax').val(afterTaxTotal);

    }


</script>
