
<?php
if(!empty($_GET['when'])) {
    $when = htmlspecialchars(strtolower(urldecode(trim($_GET['when']))));
}else{
    $when ='';
}
?>
<script type="text/javascript">
    //== Class definition
    $.fn.dataTable.Api.register('column().title()', function() {
        return $(this.header()).text().trim();
    });
    var Datatable = function() {

        let unapprovedTable = function() {
            let table = $('table#lm_table_unapproved');

            // begin first table
            table.DataTable({
                responsive: true,
                "lengthMenu": [[10, 25, 50, -1], [10, 25, 50, "All"]],
                buttons: [
                    'print',
                    'copyHtml5',
                    'excelHtml5',
                    'csvHtml5',
                    'pdfHtml5',
                ],
                dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
			<'row'<'col-sm-12'tr>>
			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                searchDelay: 500,
                processing: true,
                serverSide: false,
                ajax: '<?php echo base_url('freight/request/datasourceUnapproved/'.$when);?>',
                columns: [
                    {data: 'petty_request_payee'},
                    {data: 'petty_request_date_created'},
                    {data: 'petty_request_file_number'},
                    {data: 'petty_request_purpose_expense'},
                    {data: 'petty_request_status'},
                ],
                initComplete: function () {
                    this.api().columns().every(function () {
                        var column = this;

                        switch (column.title()) {
                            case 'Budget':
                                column.data().unique().sort().each(function (d, j) {
                                    $('.m-input[data-col-index="2"]').append('<option value="' + d + '">' + d + '</option>');
                                });
                                break;
                            case 'Spent':
                                column.data().unique().sort().each(function (d, j) {
                                    $('.m-input[data-col-index="4"]').append('<option value="' + d + '">' + d + '</option>');
                                });
                                break;
                            case 'Balance':
                                column.data().unique().sort().each(function (d, j) {
                                    $('.m-input[data-col-index="3"]').append('<option value="' + d + '">' + d + '</option>');
                                });
                                break;
                            case 'Status':
                                var status = {
                                    "UnApproved": {'petty_request_status': 'UnApproved', 'class': 'kt-badge--warning'},
                                    "Approved": {'petty_request_status': 'Approved', 'class': ' kt-badge--success'},
                                    "Rejected": {'petty_request_status': 'Rejected', 'class': ' kt-badge--danger'},
                                };
                                column.data().unique().sort().each(function (d, j) {
                                    $('.m-input[data-col-index="4"]').append('<option value="' + d + '">' + status[d].petty_request_status + '</option>');
                                });
                                break;
                        }
                    });
                },

                columnDefs: [
                    {
                        targets: 0,
                        render: function (data, type, full, meta) {
                            return '<a  href="<?php echo base_url('freight/request/details/');?>' + full.petty_request_key + '">'+full.firstname+' '+full.lastname+'</a>';
                        },
                    },
                    {
                        targets: 4,
                        "width": "14%",
                        render: function (data, type, full, meta) {
                            var status = {
                                "UnApproved": {'petty_request_status': 'UnApproved', 'class': 'kt-badge--warning'},
                                "Approved": {'petty_request_status': 'Approved', 'class': ' kt-badge--success'},
                                "Rejected": {'petty_request_status': 'Rejected', 'class': ' kt-badge--danger'},
                            };
                            if (typeof status[data] === 'undefined') {
                                return data;
                            }
                            return '<a href="#budget-details" data-toggle="modal" data-backdrop="static" data-key="' + full.petty_request_key + '"><span class="kt-badge ' + status[data].class + ' kt-badge--wide kt-badge--inline">' + status[data].petty_request_status + '</span></a> ' +
                                '<div class="dropdown dropdown-inline">\n' +
                                '                            <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                                '                                <i class="flaticon-more"></i>\n' +
                                '                            </span>\n' +
                                '                            <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                                '                                <a class="dropdown-item" data-backdrop="false" data-toggle="modal" data-key="' + full.petty_request_key + '" href="#newApproveRequest"><i class="la la-plus kt-font-success"></i> Approve Request</a>\n' +
                                '                                <div class="dropdown-divider"></div>' +
                                '                                <a class="dropdown-item" class="kt-font-danger kt-font-bolder"  href="javascript:rejectRequest(' + full.petty_request_key + ');"><i class="la la-reply-all kt-font-danger kt-font-bolder"></i> Reject Request</a>\n' +
                                '                                <a class="dropdown-item" class="kt-font-danger kt-font-bolder"  href="javascript:deleteRequest(' + full.petty_request_key + ');"><i class="la la-trash kt-font-danger kt-font-bolder"></i> Delete</a>\n' +
                                '                                <a class="dropdown-item" data-key="' + full.petty_request_key + '" href="<?php echo base_url('freight/request/details/');?>' + full.petty_request_key + '"><i class="la la-cog kt-font-dark"></i> Details</a>\n' +
                                '                            </div>\n' +
                                '                        </div>';
                        },
                    }
                ],
            });

            var filter = function() {
                var val = $.fn.dataTable.util.escapeRegex($(this).val());
                let table = $.fn.dataTable.tables( { api: true } );
                table.column($(this).data('col-index')).search(val ? val : '', false, false).draw();
            };

            var asdasd = function(value, index) {
                let table = $.fn.dataTable.tables( { api: true } );
                var val = $.fn.dataTable.util.escapeRegex(value);
                table.column(index).search(val ? val : '', false, true);
            };

            $('#m_search').on('click', function(e) {
                e.preventDefault();
                let table = $.fn.dataTable.tables( { api: true } );
                var params = {};
                $('.kt-input').each(function() {
                    var i = $(this).data('col-index');
                    if (params[i]) {
                        params[i] += '|' + $(this).val();
                    }
                    else {
                        params[i] = $(this).val();
                    }
                });
                $.each(params, function(i, val) {
                    // apply search params to datatable
                    table.column(i).search(val ? val : '', false, false);
                });
                table.table().draw();
            });

            $('#m_reset').on('click', function(e) {
                e.preventDefault();
                let table = $.fn.dataTable.tables( { api: true } );
                $('.kt-input').each(function() {
                    $(this).val('');
                    table.column($(this).data('col-index')).search('', false, false);
                });
                table.table().draw();
            });

        };

        let approvedTable = function() {
            let table = $('table#lm_table_approved');

            // begin first table
            table.DataTable({
                responsive: true,
                "lengthMenu": [[10, 25, 50, -1], [10, 25, 50, "All"]],
                buttons: [
                    'print',
                    'copyHtml5',
                    'excelHtml5',
                    'csvHtml5',
                    'pdfHtml5',
                ],
                dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
			<'row'<'col-sm-12'tr>>
			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                searchDelay: 500,
                processing: true,
                serverSide: false,
                ajax: '<?php echo base_url('freight/request/datasourceApproved/'.$when);?>',
                columns: [
                    {data: 'petty_request_payee'},
                    {data: 'petty_request_date_created'},
                    {data: 'petty_request_file_number'},
                    {data: 'petty_request_purpose_expense'},
                    {data: 'petty_request_status'},
                ],

                initComplete: function () {
                    this.api().columns().every(function () {
                        var column = this;

                        switch (column.title()) {
                            case 'Budget':
                                column.data().unique().sort().each(function (d, j) {
                                    $('.m-input[data-col-index="2"]').append('<option value="' + d + '">' + d + '</option>');
                                });
                                break;
                            case 'Spent':
                                column.data().unique().sort().each(function (d, j) {
                                    $('.m-input[data-col-index="4"]').append('<option value="' + d + '">' + d + '</option>');
                                });
                                break;
                            case 'Balance':
                                column.data().unique().sort().each(function (d, j) {
                                    $('.m-input[data-col-index="3"]').append('<option value="' + d + '">' + d + '</option>');
                                });
                                break;
                            case 'Status':
                                var status = {
                                    "UnApproved": {'petty_request_status': 'UnApproved', 'class': 'kt-badge--warning'},
                                    "Approved": {'petty_request_status': 'Approved', 'class': ' kt-badge--success'},
                                    "Rejected": {'petty_request_status': 'Rejected', 'class': ' kt-badge--danger'},
                                };
                                column.data().unique().sort().each(function (d, j) {
                                    $('.m-input[data-col-index="4"]').append('<option value="' + d + '">' + status[d].petty_request_status + '</option>');
                                });
                                break;
                        }
                    });
                },

                columnDefs: [
                    {
                        targets: 0,
                        render: function (data, type, full, meta) {
                            return '<a  href="<?php echo base_url('freight/request/details/');?>' + full.petty_request_key + '">'+full.firstname+' '+full.lastname+'</a>';
                        },
                    },
                    {
                        targets: 4,
                        "width": "14%",
                        render: function (data, type, full, meta) {
                            var status = {
                                "UnApproved": {'petty_request_status': 'UnApproved', 'class': 'kt-badge--warning'},
                                "Approved": {'petty_request_status': 'Approved', 'class': ' kt-badge--success'},
                                "Rejected": {'petty_request_status': 'Rejected', 'class': ' kt-badge--danger'},
                            };
                            if (typeof status[data] === 'undefined') {
                                return data;
                            }
                            return '<a href="#budget-details" data-toggle="modal" data-backdrop="static" data-key="' + full.petty_request_key + '"><span class="kt-badge ' + status[data].class + ' kt-badge--wide kt-badge--inline">' + status[data].petty_request_status + '</span></a> ' +
                                '<div class="dropdown dropdown-inline">\n' +
                                '                            <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                                '                                <i class="flaticon-more"></i>\n' +
                                '                            </span>\n' +
                                '                            <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                                '                                <div class="dropdown-divider"></div>' +
                                '                                <a class="dropdown-item" class="kt-font-danger kt-font-bolder"  href="javascript:deleteRequest(' + full.petty_request_key + ');"><i class="la la-trash kt-font-danger kt-font-bolder"></i> Delete</a>\n' +
                                '                                <a class="dropdown-item" data-key="' + full.petty_request_key + '" href="<?php echo base_url('freight/request/details/');?>' + full.petty_request_key + '"><i class="la la-cog kt-font-dark"></i> Details</a>\n' +
                                '                            </div>\n' +
                                '                        </div>';
                        },
                    }
                ],
            });

            var filter = function() {
                var val = $.fn.dataTable.util.escapeRegex($(this).val());
                let table = $.fn.dataTable.tables( { api: true } );
                table.column($(this).data('col-index')).search(val ? val : '', false, false).draw();
            };

            var asdasd = function(value, index) {
                let table = $.fn.dataTable.tables( { api: true } );
                var val = $.fn.dataTable.util.escapeRegex(value);
                table.column(index).search(val ? val : '', false, true);
            };

            $('#m_search').on('click', function(e) {
                e.preventDefault();
                let table = $.fn.dataTable.tables( { api: true } );
                var params = {};
                $('.kt-input').each(function() {
                    var i = $(this).data('col-index');
                    if (params[i]) {
                        params[i] += '|' + $(this).val();
                    }
                    else {
                        params[i] = $(this).val();
                    }
                });
                $.each(params, function(i, val) {
                    // apply search params to datatable
                    table.column(i).search(val ? val : '', false, false);
                });
                table.table().draw();
            });

            $('#m_reset').on('click', function(e) {
                e.preventDefault();
                let table = $.fn.dataTable.tables( { api: true } );
                $('.kt-input').each(function() {
                    $(this).val('');
                    table.column($(this).data('col-index')).search('', false, false);
                });
                table.table().draw();
            });

        };

        let myTable = function() {
            let table = $('table#lm_table_myrequest');

            // begin first table
            table.DataTable({
                responsive: true,
                "lengthMenu": [[10, 25, 50, -1], [10, 25, 50, "All"]],
                buttons: [
                    'print',
                    'copyHtml5',
                    'excelHtml5',
                    'csvHtml5',
                    'pdfHtml5',
                ],
                dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
			<'row'<'col-sm-12'tr>>
			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                searchDelay: 500,
                processing: true,
                serverSide: false,
                ajax: '<?php echo base_url('freight/request/datasourceMyrequest/'.$when);?>',
                columns: [
                    {data: 'petty_request_payee'},
                    {data: 'petty_request_date_created'},
                    {data: 'petty_request_file_number'},
                    {data: 'petty_request_purpose_expense'},
                    {data: 'petty_request_status'},
                ],

                initComplete: function () {
                    this.api().columns().every(function () {
                        var column = this;

                        switch (column.title()) {
                            case 'Budget':
                                column.data().unique().sort().each(function (d, j) {
                                    $('.m-input[data-col-index="2"]').append('<option value="' + d + '">' + d + '</option>');
                                });
                                break;
                            case 'Spent':
                                column.data().unique().sort().each(function (d, j) {
                                    $('.m-input[data-col-index="4"]').append('<option value="' + d + '">' + d + '</option>');
                                });
                                break;
                            case 'Balance':
                                column.data().unique().sort().each(function (d, j) {
                                    $('.m-input[data-col-index="3"]').append('<option value="' + d + '">' + d + '</option>');
                                });
                                break;
                            case 'Status':
                                var status = {
                                    "UnApproved": {'petty_request_status': 'UnApproved', 'class': 'kt-badge--warning'},
                                    "Approved": {'petty_request_status': 'Approved', 'class': ' kt-badge--success'},
                                    "Rejected": {'petty_request_status': 'Rejected', 'class': ' kt-badge--danger'},
                                };
                                column.data().unique().sort().each(function (d, j) {
                                    $('.m-input[data-col-index="4"]').append('<option value="' + d + '">' + status[d].petty_request_status + '</option>');
                                });
                                break;
                        }
                    });
                },

                columnDefs: [
                    {
                        targets: 0,
                        render: function (data, type, full, meta) {
                            return '<a  href="<?php echo base_url('crm/customers/index/details/');?>' + full.petty_request_payee + '">'+full.firstname+' '+full.lastname+'</a>';
                        },
                    },
                    {
                        targets: 4,
                        "width": "14%",
                        render: function (data, type, full, meta) {
                            var status = {
                                "UnApproved": {'petty_request_status': 'UnApproved', 'class': 'kt-badge--warning'},
                                "Approved": {'petty_request_status': 'Approved', 'class': ' kt-badge--success'},
                                "Rejected": {'petty_request_status': 'Rejected', 'class': ' kt-badge--danger'},
                            };
                            if (typeof status[data] === 'undefined') {
                                return data;
                            }
                            return '<a href="#budget-details" data-toggle="modal" data-backdrop="static" data-key="' + full.petty_request_key + '"><span class="kt-badge ' + status[data].class + ' kt-badge--wide kt-badge--inline">' + status[data].petty_request_status + '</span></a> ' +
                                '<div class="dropdown dropdown-inline">\n' +
                                '                            <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                                '                                <i class="flaticon-more"></i>\n' +
                                '                            </span>\n' +
                                '                            <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                                '                                <div class="dropdown-divider"></div>' +
                                '                                <a class="dropdown-item" data-key="' + full.petty_request_key + '" href="<?php echo base_url('freight/request/details/');?>' + full.petty_request_key + '"><i class="la la-cog kt-font-dark"></i> Details</a>\n' +
                                '                            </div>\n' +
                                '                        </div>';
                        },
                    }
                ],
            });

            var filter = function() {
                var val = $.fn.dataTable.util.escapeRegex($(this).val());
                let table = $.fn.dataTable.tables( { api: true } );
                table.column($(this).data('col-index')).search(val ? val : '', false, false).draw();
            };

            var asdasd = function(value, index) {
                let table = $.fn.dataTable.tables( { api: true } );
                var val = $.fn.dataTable.util.escapeRegex(value);
                table.column(index).search(val ? val : '', false, true);
            };

            $('#m_search').on('click', function(e) {
                e.preventDefault();
                let table = $.fn.dataTable.tables( { api: true } );
                var params = {};
                $('.kt-input').each(function() {
                    var i = $(this).data('col-index');
                    if (params[i]) {
                        params[i] += '|' + $(this).val();
                    }
                    else {
                        params[i] = $(this).val();
                    }
                });
                $.each(params, function(i, val) {
                    // apply search params to datatable
                    table.column(i).search(val ? val : '', false, false);
                });
                table.table().draw();
            });

            $('#m_reset').on('click', function(e) {
                e.preventDefault();
                let table = $.fn.dataTable.tables( { api: true } );
                $('.kt-input').each(function() {
                    $(this).val('');
                    table.column($(this).data('col-index')).search('', false, false);
                });
                table.table().draw();
            });

        };

        return {
            //main function to initiate the module
            init: function() {
                unapprovedTable();
                approvedTable();
                myTable();
            },

        };

    }();

    jQuery(document).ready(function() {
        Datatable.init();
    });

    jQuery(document).ready(function() {
        $('select').css('width','100%');
        $('select').select2({placeholder: 'select option'});
        let height = $(window).innerHeight()  - 250;
        $('.lm_max_height').css({ height: height });
        $(window).resize(function(){
            $('.lm_max_height').css({ height: height });
        });

        $('form#newMyRequest').submit( function(event){
            let form = $( this );
            event.preventDefault();
            let formdata = form.serialize();
            $.ajax({
                url: '<?php echo base_url('freight/request/newMyPettyRequest/')?>',
                type: 'get',
                data: formdata,
                beforeSend: function(){
                    KTApp.block("form#newMyRequest",{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"success",
                        message:"Creating new Request ...."
                    });
                },
                success: function(r){
                    var obj = JSON.parse(r);
                    if(obj.status == 'ok'){
                        notifySuccess(obj.message);
                        var table = $.fn.dataTable.tables( { api: true } );
                        //table.clear().draw();
                        //window.location.reload();
                        table.ajax.reload();
                    }else{
                        Swal.fire('',obj.message,'warning');
                    }
                    KTApp.unblock('form#newMyRequest');
                    $('div#newRequest').modal('hide');
                },
                error: function(){
                    KTApp.unblock('form#newMyRequest');
                }
            });
        })

    });

    $( function(){
        $('#newApproveRequest').on('show.bs.modal', function (event) {
            var modal = $(this)
            modal.find('.modal-content').html('Loading user data ...');
            KTApp.block("#newApproveRequest .modal-content",{
                overlayColor:"#000000",
                type:"loader",
                state:"warning",
                message:"Loading request data ..."
            });
            var button = $(event.relatedTarget)
            var key = button.data('key')
            modal.find('.modal-content').load('<?php echo base_url('freight/request/approveRequest/');?>' + key );
            KTApp.unblock('#newApproveRequest .modal-content');
        })
    })

    function deleteRequest(request){
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('freight/request/deleteRequest/request')?>/'+request,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.block("#lm_table_unapproved",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Deleting Request Details Now ..."
                        });
                    },
                    success: function(result){
                        let obj = JSON.parse(result);
                        if( obj.status == 'ok'){
                            notifySuccess(obj.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.ajax.reload();
                        }else{
                            Swal.fire('',obj.message,'warning');
                        }
                        KTApp.unblock('#lm_table_unapproved');
                    },
                    error: function(xhr){
                        KTApp.unblock('#lm_table_unapproved');
                        Swal.fire('',xhr.statusText,'warning');
                    }
                });
            }
        })
    }

    function rejectRequest(request){
        Swal.fire({
            title: 'Are you sure?',
            text: "You are about to start your TASK!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Start it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "<?php echo base_url('freight/request/requestReject/');?>" + request,
                    type: "get",
                    beforeSend: function(){
                        KTApp.block("#lm_table_unapproved",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Starting Task assigned ..."
                        });
                    },
                    success: function(result){
                        let obj = JSON.parse(result);
                        if( obj.status == 'ok'){
                            $('div#id-' + request).hide();
                            notifySuccess(obj.message);
                            KTApp.unblock('#lm_table_unapproved');
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.ajax.reload();
                        }else{
                            Swal.fire('',obj.message,'warning');
                        }
                    },
                    error: function(xhr){
                        KTApp.unblock('#lm_table_unapproved');
                        Swal.fire('',xhr.statusText,'warning');
                    }

                })
            }
        })
    }

</script>