<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<div class="modal-header">
    <h5 class="modal-title" id="">Approve Petty Request Payment</h5>
    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true" class="la la-remove"></span>
    </button>
</div>
<div class="modal-body text-back" id="printArea">

<form id="newPettyRequestApproveForm" class="kt-form kt-form--fit kt-form--label-right" action="#" method="get" onsubmit="return false">

    <input class="form-control" hidden readonly name="project_time_created" type="text" value="<?php echo $request->petty_request_key;?> " />
    <div class="modal-body">
        <div class="row form-group">
            <div class="col-4">
                <label>Name Of The Payee</label>
                <input type="text" hidden name="petty_request_payee" class="form-control" value="<?php echo $request->petty_request_payee;?> "/>
                <input type="text" readonly placeholder="<?php echo $request->firstname.' '.$request->lastname;?>" class="form-control"/>
            </div>
            <div class="col-4">
                <label>File Number</label>
                <input required type="text" name="petty_request_file_number" class="form-control" value="<?php echo $request->petty_request_file_number;?>" />
            </div>
            <div class="col-4">
                <label>Mode Of Payment</label>
                <select name="petty_request_mode_payment" required class="form-control">
                    <option disabled selected>Select mode</option>
                    <option value="CASH">CASH</option>
                    <option value="BANK">BANK</option>
                </select>
            </div>
        </div>
        <div class="form-group row">
            <div class="col-md-6">
                <label >Purpose Of Expense</label>
                <textarea data-provide="markdown" readonly class="form-control" name="petty_request_purpose_expense"><?php echo $request->petty_request_purpose_expense;?></textarea>
            </div>
            <div class="col-md-6">
                <label >Details</label>
                <textarea data-provide="markdown" class="form-control" name="petty_request_details"><?php echo $request->petty_request_comment;?></textarea>
            </div>
        </div>

        <div class="row form-group">
            <div class="col-6">
                <label>Payment Amount</label>
                <input type="text" name="petty_request_payment_amount" value="<?php echo $request->petty_request_payment_amount;?>"placeholder="amount" class="form-control number" />
            </div>
<!--            <div class="col-4">-->
<!--                <label>SubTotal</label>-->
<!--                <input type="text" name="petty_request_payment_total_amount" class="form-control number" placeholder="Full amount" />-->
<!--            </div>-->
            <div class="col-6">
                <label>Consignee Name</label>
                <input type="text" readonly name="petty_request_consignee_name" placeholder="" class="form-control" value="<?php echo $request->petty_request_consignee_name;?>"/>
            </div>
        </div>
        <div class="form-group row">
            <div class="col-md-6">
                <label >Amount In Words</label>
                <textarea data-provide="markdown" class="form-control" name="petty_request_payment_amount_word" placeholder="amount in words"></textarea>
            </div>
            <div class="col-md-6">
                <label>Request Comments (optional)</label>
                <textarea data-provide="markdown" class="form-control" name="petty_request_comment" placeholder="Andika kama una maoni yoyote"><?php echo $request->petty_request_comment;?></textarea>
            </div>
        </div><hr>
        <div class="form-group row">
            <div class="col-md-12">
                <label>Choose whether this expense is office operational based or consignee based. </label>
                <select name="expense_type" id="expense_type" class="form-control" required>
                    <option value="" disabled selected>Select Option</option>
                    <option value="0">Office Expense</option>
                    <option value="1">Consignee Expense</option>
                </select>
            </div>
        </div>
        <div class="form-group row" id="accounts" style="display: none;">
            <div class="col-md-6">
                <label >Credit Account</label>
                <?php $accounts = $this->accountingModel->accounts(); ?>
                <select style="width: 100%" name="petty_request_credit_account" class="form-control">
                    <option value="" disabled selected>Select Option</option>
                    <?php if(!empty($accounts)){
                        foreach ($accounts as $debit){ ?>
                            <option value="<?php echo $debit['account_key'];?>"><?= $debit['account_name'] ?></option>
                        <?php }
                    } ?>
                </select>
            </div>
            <div class="col-md-6">
                <label>Debit Account</label>
                <?php $accounts = $this->accountingModel->accounts(); ?>
                <select style="width: 100%" name="petty_request_debit_account" class="form-control">
                    <option value="" disabled selected>Select Option</option>
                    <?php if(!empty($accounts)){
                        foreach ($accounts as $credit){ ?>
                            <option <?php if(!empty($settings) && $settings->set_revenue_account == $credit['account_key']) echo "selected";?> value="<?php echo $credit['account_key'];?>"><?= $credit['account_name'] ?></option>
                        <?php }
                    } ?>
                </select>
            </div>
        </div>
        <div class="row form-group">
            <div class="col-3">
                <label>Requested By</label>
                <input type="text" hidden  name="petty_request_by" class="form-control" value="<?php echo $request->petty_request_payee;?> "/>
                <input type="text" readonly placeholder="<?php echo $request->firstname.' '.$request->lastname;?>" class="form-control"/>
            </div>
            <div class="col-3">
                <label>Request Date</label>
                <input type="text" readonly name="petty_request_date_created" class="form-control" value="<?php echo $request->petty_request_date_created;?>" />
            </div>
            <div class="col-3" hidden>
                <label>Approved By</label>
                <input type="text" hidden name="petty_request_approved_by" class="form-control" value="<?php echo profile()->user_key;?> "/>
                <input type="text" readonly placeholder="<?php echo profile()->firstname.' '.profile()->lastname;?>" class="form-control"/>
            </div>
            <div class="col-3" hidden>
                <label>Approve Date</label>
                <input type="text" readonly name="petty_request_date_approved" placeholder="<?php echo date('Y-m-d');?>>" class="form-control" value="<?php echo date('Y-m-d');?>"/>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <button type="button" class="btn btn-info" data-dismiss="modal">Close</button>
        <button type="submit" name="submit" class="btn btn-success">Approve Request</button>
    </div>
</form>

</div>
<script type="text/javascript">
    $(function () {
        $('select').select2({
            placeholder:"Select Option"
        })

        $('select#expense_type').change(function () {
            let expense_type = $(this).val();
            //alert(expense_type)
            if (expense_type == 0){
                $('div#accounts').css('display', 'block');
            }
            else {
                $('div#accounts').css('display', 'none');
            }
        });

        $('form#newPettyRequestApproveForm').submit( function(event){
            let form = $( this );
            event.preventDefault();
            let formData = form.serialize();
            $.ajax({
                url: '<?php echo base_url('freight/request/approvePettyRequest/'.$request->petty_request_key);?>' ,
                type: 'get',
                data: formData,
                beforeSend: function(){
                    KTApp.block(form,{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"success",
                        message:"Approving Request ..."
                    });
                },
                success: function(r){
                    var obj = JSON.parse(r);
                    if(obj.status === 'ok'){
                        $('div#newApproveRequest').modal('hide');
                        notifySuccess(obj.message);
                        var table = $.fn.dataTable.tables( { api: true } );
                        table.clear().draw();
                        table.ajax.reload();
                    }else{
                        Swal.fire('',obj.message,'warning');
                    }
                    KTApp.unblock(form);
                },
                error: function(){
                    $('div#newApproveRequest').modal('hide');
                    KTApp.unblock(form);
                }
            });
        });
    })
</script>