<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<!-- Begin : Assessment Page -->
<div class="kt-portlet__body" id="details">
    <div class="row">
        <div class="col">
            <div class="alert alert-light alert-elevate fade show" role="alert">
                <div class="alert-icon"><i class="flaticon-warning kt-font-info"></i></div>
                <div class="alert-text">
                    <h3>Description of assessment </h3>
                    <?php
                    $freight_desc = $this->documentsModel->find_many_by(['doc_fr_key'=>$freight['fr_key'],'doc_type'=>'Assessment', 'deleted'=>0]);
                    if(!empty($freight_desc))
                    {
                        foreach ($freight_desc as $desc)
                        {
                            if(!empty($desc['doc_description']))
                            {
                                ?>
                                <li>
                                    <code><?= $desc['doc_name']; ?> Description : </code>
                                    <?= $desc['doc_description'];?>
                                    <small>
                                        <?= "<i style='color: blue'>(".date('M d,Y', strtotime($desc['created'])).")</i>";?>
                                    </small>
                                </li>
                                <?php
                            }
                            else
                            {
                                ?>
                                <li>
                                    <code><?= $desc['doc_name']; ?> : </code><code>(No description)</code>
                                    <small>
                                        <?= "<i style='color: blue'>(".date('M d,Y', strtotime($desc['created'])).")</i>";?>
                                    </small>
                                </li>
                                <?php
                            }
                        }
                    }
                    else
                    {
                        ?>
                        <code>(No description)</code>
                        <?php
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>
    <?php
    if(has_menu_freight()){
        if(has_role('freight_create_assessment')){
            if($freight['fr_file_status'] == 'Active'){?>
                <form id="AssessForm" onsubmit="return false;" class="kt-form kt-form--label-right">
                    <div class="kt-portlet__body">
                        <div class="form-group row">
                            <div class="col-lg-12" style="margin-top: 5px">
                                <label class="">Attach File:</label>
                                <div class="m-dropzone dropzone m-dropzone--primary dz-clickable" id="kt_assessment">
                                    <div class="dropzone-msg dz-message needsclick" >
                                        <h3 class="dropzone-msg-title">Click here to upload file..</h3>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <label>Document Type (eg. Invoice, Bill of lading, etc)</label>
                                <input type="text" class="form-control" name="doc_name" placeholder="Enter here" required>
                            </div>
                            <input type="hidden" class="form-control" name="doc_type" value="Assessment" readonly>
                            <div class="col-lg-6">
                                <label>Description:</label>
                                <textarea class="form-control" name="doc_description" placeholder="Enter description"></textarea>
                            </div>

                            <!-- <div class="col-lg-12">
                                 <div class="m-dropzone dropzone m-dropzone--primary dz-clickable"  id="crop-image">
                                     <div class="m-dropzone__msg dz-message needsclick">
                                         <h3 class="m-dropzone__msg-title">Drop files here or click to upload.</h3>
                                         <span class="m-dropzone__msg-desc">Upload 1 files</span>
                                     </div>
                                 </div>
                             </div>-->
                            <input type="hidden" class="form-control" id="uploadedfiles" name="uploadedfiles" />
                        </div>
                        <div class="row">
                            <div class="col-lg-6">
                            </div>
                            <div class="col-lg-6 kt-align-right">
                                <button type="submit" name="submit" class="btn btn-success">Submit</button>
                            </div>
                        </div>
                    </div>
                </form>
            <?php }}} ?>
    <!--Begin::Section-->
    <div class="row">
        <?php
        $freight_doc = $this->documentsModel->find_many_by(['doc_fr_key'=>$freight['fr_key'],'doc_type'=>'Assessment']);
        if(!empty($freight_doc)):
            foreach($freight_doc as $doc):
                ?>
                <div class="col-xl-3 col-lg-6 col-md-6" id='<?php echo $doc['doc_key'];?>'>

                    <!--Begin::Portlet-->
                    <div class="kt-portlet">
                        <div class="kt-portlet__head kt-portlet__head--noborder">
                            <div class="kt-portlet__head-label">
                                <h3 class="kt-portlet__head-title">
                                </h3>
                            </div>
                            <div class="kt-portlet__head-toolbar">
                                <a href="#" class="btn btn-clean btn-sm btn-icon btn-icon-md" data-toggle="dropdown">
                                    <i class="flaticon-more-1"></i>
                                </a>
                                <?php
                                if(has_menu_freight()){
                                    if(has_role('freight_delete_assessment')){
                                        ?>
                                        <div class="dropdown-menu dropdown-menu-right">
                                            <ul class="kt-nav">
                                                <li class="kt-nav__item">
                                                    <a href="<?= uploadFilePath('freight_docs/').$doc['doc_file'];?>" class="kt-nav__link">
                                                        <i class="kt-nav__link-icon flaticon2-download"></i>
                                                        <span class="kt-nav__link-text">View</span>
                                                    </a>
                                                </li>
                                                <li class="kt-nav__item">
                                                    <a href="javascript:(0);" onclick="deleteAssessment('<?php echo $doc['doc_key'];?>')" class="kt-nav__link">
                                                        <i class="kt-nav__link-icon flaticon2-trash"></i>
                                                        <span class="kt-nav__link-text">Delete</span>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                        <?php
                                    }
                                }
                                ?>
                            </div>
                        </div>
                        <div class="kt-portlet__body">
                            <!--begin::Widget -->
                            <div class="kt-widget__files">
                                <div class="kt-widget__media">
                                    <img class="kt-widget__img kt-hidden-" src="<?php echo base_url('resources/');?>assets/media/files/<?php echo getFileExt($doc['doc_file']);?>.svg" alt="FILE">
                                </div>

                                <a target="_blank" href="<?php echo uploadFilePath('freight_docs/').$doc['doc_file'];?>"  data-url="<?php echo uploadFilePath('freight_docs/').$doc['doc_file'];?>" class="kt-widget__desc">
                                    <?php echo $doc['doc_name'];?>
                                </a>
                            </div>

                            <!--end::Widget -->
                        </div>
                    </div>

                    <!--End::Portlet-->
                </div>
            <?php endforeach; endif; ?>
    </div>
    <!--End::Section-->
</div>
<script type="text/javascript">
    $(function () {

        $('form#AssessForm').submit(function (event) {
            let form = $(this);
            let $div = $('div#details');
            event.preventDefault();
            let formdata = form.serialize();
            $.ajax({
                url: '<?php echo base_url( 'freight/index/newDocumentation/' . $freight['fr_key']);?>',
                type: 'get',
                data: formdata,
                beforeSend: function () {
                    KTApp.block($div, {
                        overlayColor: "#000000",
                        type: "loader",
                        state: "success",
                        message: "Adding Document ...."
                    });
                },
                success: function () {
                    KTApp.unblock($div);
                    $div.load("<?php echo base_url('freight/index/loadAssessment/' . $freight['fr_key']);?>");
                    Swal.fire('', 'Successfully Uploaded!', 'success');

                },
                error: function (xhr) {
                    Swal.fire('', xhr.statusText, 'success');
                    KTApp.unblock($div);
                    $div.load("<?php echo base_url('freight/index/loadAssessment/' . $freight['fr_key']);?>");
                }
            });
        });
    })

    Dropzone.autoDiscover = false;
    var options = {
        url: "<?php echo base_url('freight/index/uploadfrdoc');?>",
        paramName: "file", // The name that will be used to transfer the file
        maxFiles: 1,
        maxFilesize: 5, // MB
        addRemoveLinks: true,
        success: function(file, response){
            let oldValue = $('input#uploadedfiles').val();
            if(oldValue.length > 0){
                oldValue = oldValue + 'LM-55';
            }
            let newValue =  oldValue + response.files;
            $('input#uploadedfiles').val(newValue);
        },
    };
    var freightDocs = new Dropzone("div#kt_assessment", options);

</script>
<!-- End : Assessment Page -->

<!-- Begin : Import Permit Page -->
<div class="kt-portlet__body" id="details">
    <div class="row">
        <div class="col">
            <div class="alert alert-light alert-elevate fade show" role="alert">
                <div class="alert-icon"><i class="flaticon-warning kt-font-info"></i></div>
                <div class="alert-text">
                    <h3>Description of import permit </h3>
                    <?php
                    $freight_desc = $this->documentsModel->find_many_by(['doc_fr_key'=>$freight['fr_key'],'doc_type'=>'Import Permit', 'deleted'=>0]);
                    if(!empty($freight_desc))
                    {
                        foreach ($freight_desc as $desc)
                        {
                            if(!empty($desc['doc_description']))
                            {
                                ?>
                                <li>
                                    <code><?= $desc['doc_name']; ?> : </code>
                                    <?= $desc['doc_description'];?>
                                    <small>
                                        <?= "<i style='color: blue'>(".date('M d,Y', strtotime($desc['created'])).")</i>";?>
                                    </small>
                                </li>
                                <?php
                            }
                            else
                            {
                                ?>
                                <li>
                                    <code><?= $desc['doc_name']; ?> : </code><code>(No description)</code>
                                    <small>
                                        <?= "<i style='color: blue'>(".date('M d,Y', strtotime($desc['created'])).")</i>";?>
                                    </small>
                                </li>
                                <?php
                            }
                        }
                    }
                    else
                    {
                        ?>
                        <code>(No description)</code>
                        <?php
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>
    <?php
    if(has_menu_freight()){
        if(has_role('freight_create_assessment')){
            if($freight['fr_file_status'] == 'Active'){?>
                <form id="docsForm" onsubmit="return false;" class="kt-form kt-form--label-right">
                    <div class="kt-portlet__body">
                        <div class="form-group row">
                            <div class="col-lg-12" style="margin-top: 5px">
                                <label class="">Attach File:</label>
                                <div class="m-dropzone dropzone m-dropzone--primary dz-clickable" id="kt_dropzone_1">
                                    <div class="dropzone-msg dz-message needsclick" >
                                        <h3 class="dropzone-msg-title">Click here to upload file..</h3>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <label>Document Type (eg. Invoice, Bill of lading, etc)</label>
                                <input type="text" class="form-control" name="doc_name" placeholder="Enter here" required>
                            </div>
                            <input type="hidden" class="form-control" name="doc_type" value="Import Permit" readonly>
                            <div class="col-lg-6">
                                <label>Description:</label>
                                <textarea class="form-control" name="doc_description" placeholder="Enter description"></textarea>
                            </div>

                            <!-- <div class="col-lg-12">
                                 <div class="m-dropzone dropzone m-dropzone--primary dz-clickable"  id="crop-image">
                                     <div class="m-dropzone__msg dz-message needsclick">
                                         <h3 class="m-dropzone__msg-title">Drop files here or click to upload.</h3>
                                         <span class="m-dropzone__msg-desc">Upload 1 files</span>
                                     </div>
                                 </div>
                             </div>-->
                            <input type="hidden" class="form-control" id="uploadedfiles" name="uploadedfiles" />
                        </div>
                        <div class="row">
                            <div class="col-lg-6">
                            </div>
                            <div class="col-lg-6 kt-align-right">
                                <button type="submit" name="submit" class="btn btn-success">Submit</button>
                            </div>
                        </div>
                    </div>
                </form>
            <?php }}} ?>
    <!--Begin::Section-->
    <div class="row">
        <?php
        $freight_doc = $this->documentsModel->find_many_by(['doc_fr_key'=>$freight['fr_key'],'doc_type'=>'Import Permit']);
        if(!empty($freight_doc)):
            foreach($freight_doc as $doc):
                ?>
                <div class="col-xl-3 col-lg-6 col-md-6" id='<?php echo $doc['doc_key'];?>'>

                    <!--Begin::Portlet-->
                    <div class="kt-portlet">
                        <div class="kt-portlet__head kt-portlet__head--noborder">
                            <div class="kt-portlet__head-label">
                                <h3 class="kt-portlet__head-title">
                                </h3>
                            </div>
                            <div class="kt-portlet__head-toolbar">
                                <a href="#" class="btn btn-clean btn-sm btn-icon btn-icon-md" data-toggle="dropdown">
                                    <i class="flaticon-more-1"></i>
                                </a>
                                <?php
                                if(has_menu_freight()){
                                    if(has_role('freight_delete_assessment')){
                                        ?>
                                        <div class="dropdown-menu dropdown-menu-right">
                                            <ul class="kt-nav">
                                                <li class="kt-nav__item">
                                                    <a href="<?= uploadFilePath('freight_docs/').$doc['doc_file'];?>" class="kt-nav__link">
                                                        <i class="kt-nav__link-icon flaticon2-download"></i>
                                                        <span class="kt-nav__link-text">View</span>
                                                    </a>
                                                </li>
                                                <li class="kt-nav__item">
                                                    <a href="javascript:(0);" onclick="deleteDocument('<?php echo $doc['doc_key'];?>')" class="kt-nav__link">
                                                        <i class="kt-nav__link-icon flaticon2-trash"></i>
                                                        <span class="kt-nav__link-text">Delete</span>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                        <?php
                                    }
                                }
                                ?>
                            </div>
                        </div>
                        <div class="kt-portlet__body">
                            <!--begin::Widget -->
                            <div class="kt-widget__files">
                                <div class="kt-widget__media">
                                    <img class="kt-widget__img kt-hidden-" src="<?php echo base_url('resources/');?>assets/media/files/<?php echo getFileExt($doc['doc_file']);?>.svg" alt="FILE">
                                </div>

                                <a target="_blank" href="<?php echo uploadFilePath('freight_docs/').$doc['doc_file'];?>"  data-url="<?php echo uploadFilePath('freight_docs/').$doc['doc_file'];?>" class="kt-widget__desc">
                                    <?php echo $doc['doc_name'];?>
                                </a>
                            </div>

                            <!--end::Widget -->
                        </div>
                    </div>

                    <!--End::Portlet-->
                </div>
            <?php endforeach; endif; ?>
    </div>
    <!--End::Section-->
</div>
<script type="text/javascript">
    $(function () {

        $('form#docsForm').submit(function (event) {
            let form = $(this);
            let $div = $('div#details');
            event.preventDefault();
            let formdata = form.serialize();
            $.ajax({
                url: '<?php echo base_url( 'freight/index/newDocumentation/' . $freight['fr_key']);?>',
                type: 'get',
                data: formdata,
                beforeSend: function () {
                    KTApp.block($div, {
                        overlayColor: "#000000",
                        type: "loader",
                        state: "success",
                        message: "Adding Document ...."
                    });
                },
                success: function () {
                    KTApp.unblock($div);
                    Swal.fire('', 'Successfully Uploaded!', 'success');

                },
                error: function (xhr) {
                    Swal.fire('', xhr.statusText, 'success');
                    KTApp.unblock($div);
                }
            });
        });
    })

    Dropzone.autoDiscover = false;
    var options = {
        url: "<?php echo base_url('freight/index/uploadfrdoc');?>",
        paramName: "file", // The name that will be used to transfer the file
        maxFiles: 1,
        maxFilesize: 5, // MB
        addRemoveLinks: true,
        success: function(file, response){
            let oldValue = $('input#uploadedfiles').val();
            if(oldValue.length > 0){
                oldValue = oldValue + 'LM-55';
            }
            let newValue =  oldValue + response.files;
            $('input#uploadedfiles').val(newValue);
        },
    };
    var freightDocs = new Dropzone("div#kt_dropzone_1", options);

</script>
<!-- End : Import Permit Page -->

<!-- Begin : Payment of Duty Page -->
<div class="kt-portlet__body" id="details">
    <div class="row">
        <div class="col">
            <div class="alert alert-light alert-elevate fade show" role="alert">
                <div class="alert-icon"><i class="flaticon-warning kt-font-info"></i></div>
                <div class="alert-text">
                    <h3>Description of payment of duty taxes </h3>
                    <?php
                    $freight_desc = $this->documentsModel->find_many_by(['doc_fr_key'=>$freight['fr_key'],'doc_type'=>'Payment of duty', 'deleted'=>0]);
                    if(!empty($freight_desc))
                    {
                        foreach ($freight_desc as $desc)
                        {
                            if(!empty($desc['doc_description']))
                            {
                                ?>
                                <li>
                                    <code><?= $desc['doc_name']; ?> Description : </code>
                                    <?= $desc['doc_description'];?>
                                    <small>
                                        <?= "<i style='color: blue'>(".date('M d,Y', strtotime($desc['created'])).")</i>";?>
                                    </small>
                                </li>
                                <?php
                            }
                            else
                            {
                                ?>
                                <li>
                                    <code><?= $desc['doc_name']; ?> : </code><code>(No description)</code>
                                    <small>
                                        <?= "<i style='color: blue'>(".date('M d,Y', strtotime($desc['created'])).")</i>";?>
                                    </small>
                                </li>
                                <?php
                            }
                        }
                    }
                    else
                    {
                        ?>
                        <code>(No description)</code>
                        <?php
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>
    <?php
    if(has_menu_freight()){
        if(has_role('freight_create_assessment')){
            if($freight['fr_file_status'] == 'Active'){?>
                <form id="docsForm" onsubmit="return false;" class="kt-form kt-form--label-right">
                    <div class="kt-portlet__body">
                        <div class="form-group row">
                            <div class="col-lg-12" style="margin-top: 5px">
                                <label class="">Attach File:</label>
                                <div class="m-dropzone dropzone m-dropzone--primary dz-clickable" id="kt_dropzone_1">
                                    <div class="dropzone-msg dz-message needsclick" >
                                        <h3 class="dropzone-msg-title">Click here to upload file..</h3>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <label>Document Type (eg. Invoice, Bill of lading, etc)</label>
                                <input type="text" class="form-control" name="doc_name" placeholder="Enter here" required>
                            </div>
                            <input type="hidden" class="form-control" name="doc_type" value="Payment of duty" readonly>
                            <div class="col-lg-6">
                                <label>Description:</label>
                                <textarea class="form-control" name="doc_description" placeholder="Enter description"></textarea>
                            </div>

                            <!-- <div class="col-lg-12">
                                 <div class="m-dropzone dropzone m-dropzone--primary dz-clickable"  id="crop-image">
                                     <div class="m-dropzone__msg dz-message needsclick">
                                         <h3 class="m-dropzone__msg-title">Drop files here or click to upload.</h3>
                                         <span class="m-dropzone__msg-desc">Upload 1 files</span>
                                     </div>
                                 </div>
                             </div>-->
                            <input type="hidden" class="form-control" id="uploadedfiles" name="uploadedfiles" />
                        </div>
                        <div class="row">
                            <div class="col-lg-6">
                            </div>
                            <div class="col-lg-6 kt-align-right">
                                <button type="submit" name="submit" class="btn btn-success">Submit</button>
                            </div>
                        </div>
                    </div>
                </form>
            <?php }}} ?>
    <!--Begin::Section-->
    <div class="row">
        <?php
        $freight_doc = $this->documentsModel->find_many_by(['doc_fr_key'=>$freight['fr_key'],'doc_type'=>'Payment of duty']);
        if(!empty($freight_doc)):
            foreach($freight_doc as $doc):
                ?>
                <div class="col-xl-3 col-lg-6 col-md-6" id='<?php echo $doc['doc_key'];?>'>

                    <!--Begin::Portlet-->
                    <div class="kt-portlet">
                        <div class="kt-portlet__head kt-portlet__head--noborder">
                            <div class="kt-portlet__head-label">
                                <h3 class="kt-portlet__head-title">
                                </h3>
                            </div>
                            <div class="kt-portlet__head-toolbar">
                                <a href="#" class="btn btn-clean btn-sm btn-icon btn-icon-md" data-toggle="dropdown">
                                    <i class="flaticon-more-1"></i>
                                </a>
                                <?php
                                if(has_menu_freight()){
                                    if(has_role('freight_delete_assessment')){
                                        ?>
                                        <div class="dropdown-menu dropdown-menu-right">
                                            <ul class="kt-nav">
                                                <li class="kt-nav__item">
                                                    <a href="<?= uploadFilePath('freight_docs/').$doc['doc_file'];?>" class="kt-nav__link">
                                                        <i class="kt-nav__link-icon flaticon2-download"></i>
                                                        <span class="kt-nav__link-text">View</span>
                                                    </a>
                                                </li>
                                                <li class="kt-nav__item">
                                                    <a href="javascript:(0);" onclick="deleteDocument('<?php echo $doc['doc_key'];?>')" class="kt-nav__link">
                                                        <i class="kt-nav__link-icon flaticon2-trash"></i>
                                                        <span class="kt-nav__link-text">Delete</span>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                        <?php
                                    }
                                }
                                ?>
                            </div>
                        </div>
                        <div class="kt-portlet__body">
                            <!--begin::Widget -->
                            <div class="kt-widget__files">
                                <div class="kt-widget__media">
                                    <img class="kt-widget__img kt-hidden-" src="<?php echo base_url('resources/');?>assets/media/files/<?php echo getFileExt($doc['doc_file']);?>.svg" alt="FILE">
                                </div>

                                <a target="_blank" href="<?php echo uploadFilePath('freight_docs/').$doc['doc_file'];?>"  data-url="<?php echo uploadFilePath('freight_docs/').$doc['doc_file'];?>" class="kt-widget__desc">
                                    <?php echo $doc['doc_name'];?>
                                </a>
                            </div>

                            <!--end::Widget -->
                        </div>
                    </div>

                    <!--End::Portlet-->
                </div>
            <?php endforeach; endif; ?>
    </div>
    <!--End::Section-->
</div>
<script type="text/javascript">
    $(function () {

        $('form#docsForm').submit(function (event) {
            let form = $(this);
            let $div = $('div#details');
            event.preventDefault();
            let formdata = form.serialize();
            $.ajax({
                url: '<?php echo base_url( 'freight/index/newDocumentation/' . $freight['fr_key']);?>',
                type: 'get',
                data: formdata,
                beforeSend: function () {
                    KTApp.block($div, {
                        overlayColor: "#000000",
                        type: "loader",
                        state: "success",
                        message: "Adding Document ...."
                    });
                },
                success: function () {
                    KTApp.unblock($div);
                    Swal.fire('', 'Successfully Uploaded!', 'success');

                },
                error: function (xhr) {
                    Swal.fire('', xhr.statusText, 'success');
                    KTApp.unblock($div);
                }
            });
        });
    })

    Dropzone.autoDiscover = false;
    var options = {
        url: "<?php echo base_url('freight/index/uploadfrdoc');?>",
        paramName: "file", // The name that will be used to transfer the file
        maxFiles: 1,
        maxFilesize: 5, // MB
        addRemoveLinks: true,
        success: function(file, response){
            let oldValue = $('input#uploadedfiles').val();
            if(oldValue.length > 0){
                oldValue = oldValue + 'LM-55';
            }
            let newValue =  oldValue + response.files;
            $('input#uploadedfiles').val(newValue);
        },
    };
    var freightDocs = new Dropzone("div#kt_dropzone_1", options);

</script>
<!-- End : Payment of Duty Page -->

<!-- Begin : Shipping Line Page -->
<div class="kt-portlet__body" id="details">
    <div class="row">
        <div class="col">
            <div class="alert alert-light alert-elevate fade show" role="alert">
                <div class="alert-icon"><i class="flaticon-warning kt-font-info"></i></div>
                <div class="alert-text">
                    <h3>Description of shipping line </h3>
                    <?php
                    $freight_desc = $this->documentsModel->find_many_by(['doc_fr_key'=>$freight['fr_key'],'doc_type'=>'Shipping Line', 'deleted'=>0]);
                    if(!empty($freight_desc))
                    {
                        foreach ($freight_desc as $desc)
                        {
                            if(!empty($desc['doc_description']))
                            {
                                ?>
                                <li>
                                    <code><?= $desc['doc_name']; ?> Description : </code>
                                    <?= $desc['doc_description'];?>
                                    <small>
                                        <?= "<i style='color: blue'>(".date('M d,Y', strtotime($desc['created'])).")</i>";?>
                                    </small>
                                </li>
                                <?php
                            }
                            else
                            {
                                ?>
                                <li>
                                    <code><?= $desc['doc_name']; ?> : </code><code>(No description)</code>
                                    <small>
                                        <?= "<i style='color: blue'>(".date('M d,Y', strtotime($desc['created'])).")</i>";?>
                                    </small>
                                </li>
                                <?php
                            }
                        }
                    }
                    else
                    {
                        ?>
                        <code>(No description)</code>
                        <?php
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>
    <?php
    if(has_menu_freight()){
        if(has_role('freight_create_shipping_line')){
            if($freight['fr_file_status'] == 'Active'){?>
                <form id="docsForm" onsubmit="return false;" class="kt-form kt-form--label-right">
                    <div class="kt-portlet__body">
                        <div class="form-group row">
                            <div class="col-lg-12" style="margin-top: 5px">
                                <label class="">Attach File:</label>
                                <div class="m-dropzone dropzone m-dropzone--primary dz-clickable" id="kt_dropzone_1">
                                    <div class="dropzone-msg dz-message needsclick" >
                                        <h3 class="dropzone-msg-title">Click here to upload file..</h3>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <label>Document Type (eg. Invoice, Delivery Note, etc)</label>
                                <input type="text" class="form-control" name="doc_name" placeholder="Enter here" required>
                            </div>
                            <input type="hidden" class="form-control" name="doc_type" value="Shipping Line" readonly>
                            <div class="col-lg-6">
                                <label>Description:</label>
                                <textarea class="form-control" name="doc_description" placeholder="Enter description"></textarea>
                            </div>

                            <!-- <div class="col-lg-12">
                                 <div class="m-dropzone dropzone m-dropzone--primary dz-clickable"  id="crop-image">
                                     <div class="m-dropzone__msg dz-message needsclick">
                                         <h3 class="m-dropzone__msg-title">Drop files here or click to upload.</h3>
                                         <span class="m-dropzone__msg-desc">Upload 1 files</span>
                                     </div>
                                 </div>
                             </div>-->
                            <input type="hidden" class="form-control" id="uploadedfiles" name="uploadedfiles" />
                        </div>
                        <div class="row">
                            <div class="col-lg-6">
                            </div>
                            <div class="col-lg-6 kt-align-right">
                                <button type="submit" name="submit" class="btn btn-success">Submit</button>
                            </div>
                        </div>
                    </div>
                </form>
            <?php }}} ?>
    <!--Begin::Section-->
    <div class="row">
        <?php
        $freight_doc = $this->documentsModel->find_many_by(['doc_fr_key'=>$freight['fr_key'],'doc_type'=>'Shipping Line']);
        if(!empty($freight_doc)):
            foreach($freight_doc as $doc):
                ?>
                <div class="col-xl-3 col-lg-6 col-md-6" id='<?php echo $doc['doc_key'];?>'>

                    <!--Begin::Portlet-->
                    <div class="kt-portlet">
                        <div class="kt-portlet__head kt-portlet__head--noborder">
                            <div class="kt-portlet__head-label">
                                <h3 class="kt-portlet__head-title">
                                </h3>
                            </div>
                            <div class="kt-portlet__head-toolbar">
                                <a href="#" class="btn btn-clean btn-sm btn-icon btn-icon-md" data-toggle="dropdown">
                                    <i class="flaticon-more-1"></i>
                                </a>
                                <?php
                                if(has_menu_freight()){
                                    if(has_role('freight_delete_shipping_line')){
                                        ?>
                                        <div class="dropdown-menu dropdown-menu-right">
                                            <ul class="kt-nav">
                                                <li class="kt-nav__item">
                                                    <a href="<?= uploadFilePath('freight_docs/').$doc['doc_file'];?>" class="kt-nav__link">
                                                        <i class="kt-nav__link-icon flaticon2-download"></i>
                                                        <span class="kt-nav__link-text">View</span>
                                                    </a>
                                                </li>
                                                <li class="kt-nav__item">
                                                    <a href="javascript:(0);" onclick="deleteDocument('<?php echo $doc['doc_key'];?>')" class="kt-nav__link">
                                                        <i class="kt-nav__link-icon flaticon2-trash"></i>
                                                        <span class="kt-nav__link-text">Delete</span>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                        <?php
                                    }
                                }
                                ?>
                            </div>
                        </div>
                        <div class="kt-portlet__body">
                            <!--begin::Widget -->
                            <div class="kt-widget__files">
                                <div class="kt-widget__media">
                                    <img class="kt-widget__img kt-hidden-" src="<?php echo base_url('resources/');?>assets/media/files/<?php echo getFileExt($doc['doc_file']);?>.svg" alt="FILE">
                                </div>

                                <a target="_blank" href="<?php echo uploadFilePath('freight_docs/').$doc['doc_file'];?>"  data-url="<?php echo uploadFilePath('freight_docs/').$doc['doc_file'];?>" class="kt-widget__desc">
                                    <?php echo $doc['doc_name'];?>
                                </a>
                            </div>

                            <!--end::Widget -->
                        </div>
                    </div>

                    <!--End::Portlet-->
                </div>
            <?php endforeach; endif; ?>
    </div>
    <!--End::Section-->
</div>
<script type="text/javascript">
    $(function () {

        $('form#docsForm').submit(function (event) {
            let form = $(this);
            let $div = $('div#details');
            event.preventDefault();
            let formdata = form.serialize();
            $.ajax({
                url: '<?php echo base_url( 'freight/index/newDocumentation/' . $freight['fr_key']);?>',
                type: 'get',
                data: formdata,
                beforeSend: function () {
                    KTApp.block($div, {
                        overlayColor: "#000000",
                        type: "loader",
                        state: "success",
                        message: "Adding Document ...."
                    });
                },
                success: function () {
                    KTApp.unblock($div);
                    Swal.fire('', 'Successfully Uploaded!', 'success');

                },
                error: function (xhr) {
                    Swal.fire('', xhr.statusText, 'success');
                    KTApp.unblock($div);
                }
            });
        });
    })

    Dropzone.autoDiscover = false;
    var options = {
        url: "<?php echo base_url('freight/index/uploadfrdoc');?>",
        paramName: "file", // The name that will be used to transfer the file
        maxFiles: 1,
        maxFilesize: 5, // MB
        addRemoveLinks: true,
        success: function(file, response){
            let oldValue = $('input#uploadedfiles').val();
            if(oldValue.length > 0){
                oldValue = oldValue + 'LM-55';
            }
            let newValue =  oldValue + response.files;
            $('input#uploadedfiles').val(newValue);
        },
    };
    var freightDocs = new Dropzone("div#kt_dropzone_1", options);

</script>
<!-- End : Shipping Line Page -->

<!-- Begin : Verification Physical Page -->
<div class="kt-portlet__body" id="details">
    <div class="row">
        <div class="col">
            <div class="alert alert-light alert-elevate fade show" role="alert">
                <div class="alert-icon"><i class="flaticon-warning kt-font-info"></i></div>
                <div class="alert-text">
                    <h3>Description of verification physical </h3>
                    <?php
                    $freight_desc = $this->documentsModel->find_many_by(['doc_fr_key'=>$freight['fr_key'],'doc_type'=>'Verification Physical', 'deleted'=>0]);
                    if(!empty($freight_desc))
                    {
                        foreach ($freight_desc as $desc)
                        {
                            if(!empty($desc['doc_description']))
                            {
                                ?>
                                <li>
                                    <code><?= $desc['doc_name']; ?> Description : </code>
                                    <?= $desc['doc_description'];?>
                                    <small>
                                        <?= "<i style='color: blue'>(".date('M d,Y', strtotime($desc['created'])).")</i>";?>
                                    </small>
                                </li>
                                <?php
                            }
                            else
                            {
                                ?>
                                <li>
                                    <code><?= $desc['doc_name']; ?> : </code><code>(No description)</code>
                                    <small>
                                        <?= "<i style='color: blue'>(".date('M d,Y', strtotime($desc['created'])).")</i>";?>
                                    </small>
                                </li>
                                <?php
                            }
                        }
                    }
                    else
                    {
                        ?>
                        <code>(No description)</code>
                        <?php
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>
    <?php
    if(has_menu_freight()){
        if(has_role('freight_create_delivery_note')){
            if($freight['fr_file_status'] == 'Active'){?>
                <form id="docsForm" onsubmit="return false;" class="kt-form kt-form--label-right">
                    <div class="kt-portlet__body">
                        <div class="form-group row">
                            <div class="col-lg-12" style="margin-top: 5px">
                                <label class="">Attach File:</label>
                                <div class="m-dropzone dropzone m-dropzone--primary dz-clickable" id="kt_dropzone_1">
                                    <div class="dropzone-msg dz-message needsclick" >
                                        <h3 class="dropzone-msg-title">Click here to upload file..</h3>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <label>Document Type (eg. Invoice, Delivery Note, etc)</label>
                                <input type="text" class="form-control" name="doc_name" placeholder="Enter here" required>
                            </div>
                            <input type="hidden" class="form-control" name="doc_type" value="Verification Physical" readonly>
                            <div class="col-lg-6">
                                <label>Description:</label>
                                <textarea class="form-control" name="doc_description" placeholder="Enter description"></textarea>
                            </div>

                            <!-- <div class="col-lg-12">
                                 <div class="m-dropzone dropzone m-dropzone--primary dz-clickable"  id="crop-image">
                                     <div class="m-dropzone__msg dz-message needsclick">
                                         <h3 class="m-dropzone__msg-title">Drop files here or click to upload.</h3>
                                         <span class="m-dropzone__msg-desc">Upload 1 files</span>
                                     </div>
                                 </div>
                             </div>-->
                            <input type="hidden" class="form-control" id="uploadedfiles" name="uploadedfiles" />
                        </div>
                        <div class="row">
                            <div class="col-lg-6">
                            </div>
                            <div class="col-lg-6 kt-align-right">
                                <button type="submit" name="submit" class="btn btn-success">Submit</button>
                            </div>
                        </div>
                    </div>
                </form>
            <?php }}} ?>
    <!--Begin::Section-->
    <div class="row">
        <?php
        $freight_doc = $this->documentsModel->find_many_by(['doc_fr_key'=>$freight['fr_key'],'doc_type'=>'Verification Physical']);
        if(!empty($freight_doc)):
            foreach($freight_doc as $doc):
                ?>
                <div class="col-xl-3 col-lg-6 col-md-6" id='<?php echo $doc['doc_key'];?>'>

                    <!--Begin::Portlet-->
                    <div class="kt-portlet">
                        <div class="kt-portlet__head kt-portlet__head--noborder">
                            <div class="kt-portlet__head-label">
                                <h3 class="kt-portlet__head-title">
                                </h3>
                            </div>
                            <div class="kt-portlet__head-toolbar">
                                <a href="#" class="btn btn-clean btn-sm btn-icon btn-icon-md" data-toggle="dropdown">
                                    <i class="flaticon-more-1"></i>
                                </a>
                                <?php
                                if(has_menu_freight()){
                                    if(has_role('freight_delete_delivery_note')){
                                        ?>
                                        <div class="dropdown-menu dropdown-menu-right">
                                            <ul class="kt-nav">
                                                <li class="kt-nav__item">
                                                    <a href="<?= uploadFilePath('freight_docs/').$doc['doc_file'];?>" class="kt-nav__link">
                                                        <i class="kt-nav__link-icon flaticon2-download"></i>
                                                        <span class="kt-nav__link-text">View</span>
                                                    </a>
                                                </li>
                                                <li class="kt-nav__item">
                                                    <a href="javascript:(0);" onclick="deleteDocument('<?php echo $doc['doc_key'];?>')" class="kt-nav__link">
                                                        <i class="kt-nav__link-icon flaticon2-trash"></i>
                                                        <span class="kt-nav__link-text">Delete</span>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                        <?php
                                    }
                                }
                                ?>
                            </div>
                        </div>
                        <div class="kt-portlet__body">
                            <!--begin::Widget -->
                            <div class="kt-widget__files">
                                <div class="kt-widget__media">
                                    <img class="kt-widget__img kt-hidden-" src="<?php echo base_url('resources/');?>assets/media/files/<?php echo getFileExt($doc['doc_file']);?>.svg" alt="FILE">
                                </div>

                                <a target="_blank" href="<?php echo uploadFilePath('freight_docs/').$doc['doc_file'];?>"  data-url="<?php echo uploadFilePath('freight_docs/').$doc['doc_file'];?>" class="kt-widget__desc">
                                    <?php echo $doc['doc_name'];?>
                                </a>
                            </div>

                            <!--end::Widget -->
                        </div>
                    </div>

                    <!--End::Portlet-->
                </div>
            <?php endforeach; endif; ?>
    </div>
    <!--End::Section-->
</div>
<script type="text/javascript">
    $(function () {

        $('form#docsForm').submit(function (event) {
            let form = $(this);
            let $div = $('div#details');
            event.preventDefault();
            let formdata = form.serialize();
            $.ajax({
                url: '<?php echo base_url( 'freight/index/newDocumentation/' . $freight['fr_key']);?>',
                type: 'get',
                data: formdata,
                beforeSend: function () {
                    KTApp.block($div, {
                        overlayColor: "#000000",
                        type: "loader",
                        state: "success",
                        message: "Adding Document ...."
                    });
                },
                success: function () {
                    KTApp.unblock($div);
                    Swal.fire('', 'Successfully Uploaded!', 'success');

                },
                error: function (xhr) {
                    Swal.fire('', xhr.statusText, 'success');
                    KTApp.unblock($div);
                }
            });
        });
    })

    Dropzone.autoDiscover = false;
    var options = {
        url: "<?php echo base_url('freight/index/uploadfrdoc');?>",
        paramName: "file", // The name that will be used to transfer the file
        maxFiles: 1,
        maxFilesize: 5, // MB
        addRemoveLinks: true,
        success: function(file, response){
            let oldValue = $('input#uploadedfiles').val();
            if(oldValue.length > 0){
                oldValue = oldValue + 'LM-55';
            }
            let newValue =  oldValue + response.files;
            $('input#uploadedfiles').val(newValue);
        },
    };
    var freightDocs = new Dropzone("div#kt_dropzone_1", options);

</script>
<!-- End : Verification Physical Page -->

<!-- Begin : Port Charges Page -->
<div class="kt-portlet__body" id="details">
    <div class="row">
        <div class="col">
            <div class="alert alert-light alert-elevate fade show" role="alert">
                <div class="alert-icon"><i class="flaticon-warning kt-font-info"></i></div>
                <div class="alert-text">
                    <h3>Description of port charges </h3>
                    <?php
                    $freight_desc = $this->documentsModel->find_many_by(['doc_fr_key'=>$freight['fr_key'],'doc_type'=>'Port Charges', 'deleted'=>0]);
                    if(!empty($freight_desc))
                    {
                        foreach ($freight_desc as $desc)
                        {
                            if(!empty($desc['doc_description']))
                            {
                                ?>
                                <li>
                                    <code><?= $desc['doc_name']; ?> Description : </code>
                                    <?= $desc['doc_description'];?>
                                    <small>
                                        <?= "<i style='color: blue'>(".date('M d,Y', strtotime($desc['created'])).")</i>";?>
                                    </small>
                                </li>
                                <?php
                            }
                            else
                            {
                                ?>
                                <li>
                                    <code><?= $desc['doc_name']; ?> : </code><code>(No description)</code>
                                    <small>
                                        <?= "<i style='color: blue'>(".date('M d,Y', strtotime($desc['created'])).")</i>";?>
                                    </small>
                                </li>
                                <?php
                            }
                        }
                    }
                    else
                    {
                        ?>
                        <code>(No description)</code>
                        <?php
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>
    <?php
    if(has_menu_freight()){
        if(has_role('freight_create_delivery_note')){
            if($freight['fr_file_status'] == 'Active'){?>
                <form id="docsForm" onsubmit="return false;" class="kt-form kt-form--label-right">
                    <div class="kt-portlet__body">
                        <div class="form-group row">
                            <div class="col-lg-12" style="margin-top: 5px">
                                <label class="">Attach File:</label>
                                <div class="m-dropzone dropzone m-dropzone--primary dz-clickable" id="kt_dropzone_1">
                                    <div class="dropzone-msg dz-message needsclick" >
                                        <h3 class="dropzone-msg-title">Click here to upload file..</h3>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <label>Document Type (eg. Invoice, Delivery Note, etc)</label>
                                <input type="text" class="form-control" name="doc_name" placeholder="Enter here" required>
                            </div>
                            <input type="hidden" class="form-control" name="doc_type" value="Port Charges" readonly>
                            <div class="col-lg-6">
                                <label>Description:</label>
                                <textarea class="form-control" name="doc_description" placeholder="Enter description"></textarea>
                            </div>
                            <input type="hidden" class="form-control" id="uploadedfiles" name="uploadedfiles" />
                        </div>
                        <div class="row">
                            <div class="col-lg-6">
                            </div>
                            <div class="col-lg-6 kt-align-right">
                                <button type="submit" name="submit" class="btn btn-success">Submit</button>
                            </div>
                        </div>
                    </div>
                </form>
            <?php }}} ?>
    <!--Begin::Section-->
    <div class="row">
        <?php
        $freight_doc = $this->documentsModel->find_many_by(['doc_fr_key'=>$freight['fr_key'],'doc_type'=>'Port Charges']);
        if(!empty($freight_doc)):
            foreach($freight_doc as $doc):
                ?>
                <div class="col-xl-3 col-lg-6 col-md-6" id='<?php echo $doc['doc_key'];?>'>

                    <!--Begin::Portlet-->
                    <div class="kt-portlet">
                        <div class="kt-portlet__head kt-portlet__head--noborder">
                            <div class="kt-portlet__head-label">
                                <h3 class="kt-portlet__head-title">
                                </h3>
                            </div>
                            <div class="kt-portlet__head-toolbar">
                                <a href="#" class="btn btn-clean btn-sm btn-icon btn-icon-md" data-toggle="dropdown">
                                    <i class="flaticon-more-1"></i>
                                </a>
                                <?php
                                if(has_menu_freight()){
                                    if(has_role('freight_delete_delivery_note')){
                                        ?>
                                        <div class="dropdown-menu dropdown-menu-right">
                                            <ul class="kt-nav">
                                                <li class="kt-nav__item">
                                                    <a href="<?= uploadFilePath('freight_docs/').$doc['doc_file'];?>" class="kt-nav__link">
                                                        <i class="kt-nav__link-icon flaticon2-download"></i>
                                                        <span class="kt-nav__link-text">View</span>
                                                    </a>
                                                </li>
                                                <li class="kt-nav__item">
                                                    <a href="javascript:(0);" onclick="deleteDocument('<?php echo $doc['doc_key'];?>')" class="kt-nav__link">
                                                        <i class="kt-nav__link-icon flaticon2-trash"></i>
                                                        <span class="kt-nav__link-text">Delete</span>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                        <?php
                                    }
                                }
                                ?>
                            </div>
                        </div>
                        <div class="kt-portlet__body">
                            <!--begin::Widget -->
                            <div class="kt-widget__files">
                                <div class="kt-widget__media">
                                    <img class="kt-widget__img kt-hidden-" src="<?php echo base_url('resources/');?>assets/media/files/<?php echo getFileExt($doc['doc_file']);?>.svg" alt="FILE">
                                </div>

                                <a target="_blank" href="<?php echo uploadFilePath('freight_docs/').$doc['doc_file'];?>"  data-url="<?php echo uploadFilePath('freight_docs/').$doc['doc_file'];?>" class="kt-widget__desc">
                                    <?php echo $doc['doc_name'];?>
                                </a>
                            </div>

                            <!--end::Widget -->
                        </div>
                    </div>

                    <!--End::Portlet-->
                </div>
            <?php endforeach; endif; ?>
    </div>
    <!--End::Section-->
</div>
<script type="text/javascript">
    $(function () {

        $('form#docsForm').submit(function (event) {
            let form = $(this);
            let $div = $('div#details');
            event.preventDefault();
            let formdata = form.serialize();
            $.ajax({
                url: '<?php echo base_url( 'freight/index/newDocumentation/' . $freight['fr_key']);?>',
                type: 'get',
                data: formdata,
                beforeSend: function () {
                    KTApp.block($div, {
                        overlayColor: "#000000",
                        type: "loader",
                        state: "success",
                        message: "Adding Document ...."
                    });
                },
                success: function () {
                    KTApp.unblock($div);
                    Swal.fire('', 'Successfully Uploaded!', 'success');

                },
                error: function (xhr) {
                    Swal.fire('', xhr.statusText, 'success');
                    KTApp.unblock($div);
                }
            });
        });
    })

    Dropzone.autoDiscover = false;
    var options = {
        url: "<?php echo base_url('freight/index/uploadfrdoc');?>",
        paramName: "file", // The name that will be used to transfer the file
        maxFiles: 1,
        maxFilesize: 5, // MB
        addRemoveLinks: true,
        success: function(file, response){
            let oldValue = $('input#uploadedfiles').val();
            if(oldValue.length > 0){
                oldValue = oldValue + 'LM-55';
            }
            let newValue =  oldValue + response.files;
            $('input#uploadedfiles').val(newValue);
        },
    };
    var freightDocs = new Dropzone("div#kt_dropzone_1", options);

</script>
<!-- End : Port Charges Page -->

<!-- Begin : Release container Page -->
<div class="kt-portlet__body" id="details">
    <div class="row">
        <div class="col">
            <div class="alert alert-light alert-elevate fade show" role="alert">
                <div class="alert-icon"><i class="flaticon-warning kt-font-info"></i></div>
                <div class="alert-text">
                    <h3>Description of release the container </h3>
                    <?php
                    $freight_desc = $this->documentsModel->find_many_by(['doc_fr_key'=>$freight['fr_key'],'doc_type'=>'Release Container', 'deleted'=>0]);
                    if(!empty($freight_desc))
                    {
                        foreach ($freight_desc as $desc)
                        {
                            if(!empty($desc['doc_description']))
                            {
                                ?>
                                <li>
                                    <code><?= $desc['doc_name']; ?> Description : </code>
                                    <?= $desc['doc_description'];?>
                                    <small>
                                        <?= "<i style='color: blue'>(".date('M d,Y', strtotime($desc['created'])).")</i>";?>
                                    </small>
                                </li>
                                <?php
                            }
                            else
                            {
                                ?>
                                <li>
                                    <code><?= $desc['doc_name']; ?> : </code><code>(No description)</code>
                                    <small>
                                        <?= "<i style='color: blue'>(".date('M d,Y', strtotime($desc['created'])).")</i>";?>
                                    </small>
                                </li>
                                <?php
                            }
                        }
                    }
                    else
                    {
                        ?>
                        <code>(No description)</code>
                        <?php
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>
    <?php
    if(has_menu_freight()){
        if(has_role('freight_create_delivery_note')){
            if($freight['fr_file_status'] == 'Active'){?>
                <form id="docsForm" onsubmit="return false;" class="kt-form kt-form--label-right">
                    <div class="kt-portlet__body">
                        <div class="form-group row">
                            <div class="col-lg-12" style="margin-top: 5px">
                                <label class="">Attach File:</label>
                                <div class="m-dropzone dropzone m-dropzone--primary dz-clickable" id="kt_dropzone_1">
                                    <div class="dropzone-msg dz-message needsclick" >
                                        <h3 class="dropzone-msg-title">Click here to upload file..</h3>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <label>Document Type (eg. Invoice, Delivery Note, etc)</label>
                                <input type="text" class="form-control" name="doc_name" placeholder="Enter here" required>
                            </div>
                            <input type="hidden" class="form-control" name="doc_type" value="Release Container" readonly>
                            <div class="col-lg-6">
                                <label>Description:</label>
                                <textarea class="form-control" name="doc_description" placeholder="Enter description"></textarea>
                            </div>

                            <!-- <div class="col-lg-12">
                                 <div class="m-dropzone dropzone m-dropzone--primary dz-clickable"  id="crop-image">
                                     <div class="m-dropzone__msg dz-message needsclick">
                                         <h3 class="m-dropzone__msg-title">Drop files here or click to upload.</h3>
                                         <span class="m-dropzone__msg-desc">Upload 1 files</span>
                                     </div>
                                 </div>
                             </div>-->
                            <input type="hidden" class="form-control" id="uploadedfiles" name="uploadedfiles" />
                        </div>
                        <div class="row">
                            <div class="col-lg-6">
                            </div>
                            <div class="col-lg-6 kt-align-right">
                                <button type="submit" name="submit" class="btn btn-success">Submit</button>
                            </div>
                        </div>
                    </div>
                </form>
            <?php }}} ?>
    <!--Begin::Section-->
    <div class="row">
        <?php
        $freight_doc = $this->documentsModel->find_many_by(['doc_fr_key'=>$freight['fr_key'],'doc_type'=>'Release Container']);
        if(!empty($freight_doc)):
            foreach($freight_doc as $doc):
                ?>
                <div class="col-xl-3 col-lg-6 col-md-6" id='<?php echo $doc['doc_key'];?>'>

                    <!--Begin::Portlet-->
                    <div class="kt-portlet">
                        <div class="kt-portlet__head kt-portlet__head--noborder">
                            <div class="kt-portlet__head-label">
                                <h3 class="kt-portlet__head-title">
                                </h3>
                            </div>
                            <div class="kt-portlet__head-toolbar">
                                <a href="#" class="btn btn-clean btn-sm btn-icon btn-icon-md" data-toggle="dropdown">
                                    <i class="flaticon-more-1"></i>
                                </a>

                                <?php
                                if(has_menu_freight()){
                                    if(has_role('freight_delete_delivery_note')){
                                        ?>
                                        <div class="dropdown-menu dropdown-menu-right">
                                            <ul class="kt-nav">
                                                <li class="kt-nav__item">
                                                    <a href="<?= uploadFilePath('freight_docs/').$doc['doc_file'];?>" class="kt-nav__link">
                                                        <i class="kt-nav__link-icon flaticon2-download"></i>
                                                        <span class="kt-nav__link-text">View</span>
                                                    </a>
                                                </li>
                                                <li class="kt-nav__item">
                                                    <a href="javascript:(0);" onclick="deleteDocument('<?php echo $doc['doc_key'];?>')" class="kt-nav__link">
                                                        <i class="kt-nav__link-icon flaticon2-trash"></i>
                                                        <span class="kt-nav__link-text">Delete</span>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                        <?php
                                    }
                                }
                                ?>
                            </div>
                        </div>
                        <div class="kt-portlet__body">
                            <!--begin::Widget -->
                            <div class="kt-widget__files">
                                <div class="kt-widget__media">
                                    <img class="kt-widget__img kt-hidden-" src="<?php echo base_url('resources/');?>assets/media/files/<?php echo getFileExt($doc['doc_file']);?>.svg" alt="FILE">
                                </div>

                                <a target="_blank" href="<?php echo uploadFilePath('freight_docs/').$doc['doc_file'];?>"  data-url="<?php echo uploadFilePath('freight_docs/').$doc['doc_file'];?>" class="kt-widget__desc">
                                    <?php echo $doc['doc_name'];?>
                                </a>
                            </div>

                            <!--end::Widget -->
                        </div>
                    </div>

                    <!--End::Portlet-->
                </div>
            <?php endforeach; endif; ?>
    </div>
    <!--End::Section-->
</div>
<script type="text/javascript">
    $(function () {

        $('form#docsForm').submit(function (event) {
            let form = $(this);
            let $div = $('div#details');
            event.preventDefault();
            let formdata = form.serialize();
            $.ajax({
                url: '<?php echo base_url( 'freight/index/newDocumentation/' . $freight['fr_key']);?>',
                type: 'get',
                data: formdata,
                beforeSend: function () {
                    KTApp.block($div, {
                        overlayColor: "#000000",
                        type: "loader",
                        state: "success",
                        message: "Adding Document ...."
                    });
                },
                success: function () {
                    KTApp.unblock($div);
                    Swal.fire('', 'Successfully Uploaded!', 'success');

                },
                error: function (xhr) {
                    Swal.fire('', xhr.statusText, 'success');
                    KTApp.unblock($div);
                }
            });
        });
    })

    Dropzone.autoDiscover = false;
    var options = {
        url: "<?php echo base_url('freight/index/uploadfrdoc');?>",
        paramName: "file", // The name that will be used to transfer the file
        maxFiles: 1,
        maxFilesize: 5, // MB
        addRemoveLinks: true,
        success: function(file, response){
            let oldValue = $('input#uploadedfiles').val();
            if(oldValue.length > 0){
                oldValue = oldValue + 'LM-55';
            }
            let newValue =  oldValue + response.files;
            $('input#uploadedfiles').val(newValue);
        },
    };
    var freightDocs = new Dropzone("div#kt_dropzone_1", options);

</script>
<!-- End : Release container Page -->

<!-- Begin : Delivery Note Page -->
<?php
$freight_key = $this->freightsModel->find_by(['fr_key'=>$freight['fr_key']]);
$consignee = $freight_key['fr_client'];
$shipper = $freight_key['fr_importer'];
if(!empty($shipper)) {
    $sender = profile($shipper)->company_name;
}
if(!empty($consignee)) {
    $company = profile($consignee)->company_name;
    $client = profile($consignee)->firstname . ' ' . profile($consignee)->middlename . ' ' . profile($consignee)->lastname;
}
?>
<link href="<?= base_url('resources/')?>assets/css/pages/invoices/invoice-2.css" rel="stylesheet" type="text/css" />
<div class="kt-portlet__body" id="details">
    <div class="row">
        <div class="col">
            <div class="alert alert-light alert-elevate fade show" role="alert">
                <div class="alert-text">
                    <h3>Delivery Note |
                        <?php
                        $delivery = $this->deliveryNoteModel->find_many_by(['delivery_note_fr_key'=>$freight['fr_key'], 'delivery_note_deleted'=>0]);
                        if(empty($delivery)){
                        if($freight_key['fr_file_status'] == 'Active'){
                        ?>
                        <a href="#delivery-note" data-backdrop="false" data-toggle="modal"
                           class="btn btn-outline-brand btn-sm" style="margin-left: 5px">Create Delivery Note</a></h3>
                    <?php
                    }}else{
                        if($freight_key['fr_file_status'] == 'Active'){
                            ?>
                            <a href="#modify-delivery-note" data-backdrop="false" data-toggle="modal"
                               class="btn btn-outline-brand btn-sm" style="margin-left: 5px">Modify Delivery Note</a></h3>
                        <?php }}?>
                </div>
            </div>
        </div>
    </div>

    <!--old form here // form is found in delivery_note1 file. -->
    <!--old form here-->

    <?php
    if(!empty($delivery)){
        //var_dump($delivery);
        foreach ($delivery as $note){
            ?>
            <div class="kt-portlet" id="printableArea">
                <div class="kt-portlet__body kt-portlet__body--fit">
                    <div class="kt-invoice-2">
                        <div class="kt-invoice__head">
                            <div class="kt-invoice__container">
                                <h3 style="color: #0a6aa1">DELIVERY NOTE</h3>
                                <div class="kt-invoice__brand" style="float: right;">
                                    <div href="#" class="kt-invoice__logo">
                                        <a href="#"><img style="width: 100px; height: 90px" src="<?php echo base_url('resources/')?>assets/images/rurutz-logo.PNG"></a>
                                        <!--<span class="kt-invoice__desc">
                                            <span>Cecilia Chapman, 711-2880 Nulla St, Mankato</span>
                                            <span>Mississippi 96522</span>
                                        </span>-->
                                    </div>
                                </div>
                                <div class="kt-invoice__items">
                                    <div class="kt-invoice__item">
                                        <span class="kt-invoice__subtitle" style="color: rebeccapurple;font-weight: bold">DATE</span>
                                        <span class="kt-invoice__text"><?= $note['delivery_note_created']; ?></span>
                                    </div>
                                    <div class="kt-invoice__item">
                                        <span class="kt-invoice__subtitle" style="color: rebeccapurple;font-weight: bold">WAY BILL NUMBER</span>
                                        <span class="kt-invoice__text"><?= $note['delivery_note_bill_no']; ?></span>
                                    </div>
                                </div>
                                <div class="kt-invoice__items">
                                    <div class="kt-invoice__item">
                                        <span class="kt-invoice__subtitle" style="color: rebeccapurple;font-weight: bold">SENDER</span>
                                        <span class="kt-invoice__text">
                                        Name : <?php
                                            if (!empty($sender)) {
                                                echo $sender;
                                            }
                                            else{
                                                echo "N/A";
                                            }
                                            ?><br>
                                        Location : <?= $note['delivery_note_sender_location']; ?>
                                    </span>
                                    </div>
                                    <div class="kt-invoice__item">
                                        <span class="kt-invoice__subtitle" style="color: rebeccapurple;font-weight: bold">CONSIGNEE</span>
                                        <span class="kt-invoice__text">
                                        Name : <?php
                                            if (!empty($company)) {
                                                echo $company;
                                            }
                                            else{
                                                echo $client;
                                            }
                                            ?><br>
                                        Location : <?= $note['delivery_note_consignee_location']; ?>
                                    </span>
                                    </div>
                                </div>
                                <div class="kt-invoice__items">
                                    <div class="kt-invoice__item">
                                        <span class="kt-invoice__subtitle" style="color: rebeccapurple;font-weight: bold">DRIVER DETAILS</span>
                                        <span class="kt-invoice__text">
                                        Driver Name : <?= $note['delivery_note_driver_name']; ?> <br>
                                        Phone Number : <?= $note['delivery_note_driver_phone']; ?> <br>
                                        License Number : <?= $note['delivery_note_driver_license']; ?> <br>
                                    </span>
                                    </div>
                                    <div class="kt-invoice__item">
                                        <span class="kt-invoice__subtitle" style="color: rebeccapurple;font-weight: bold">TRANSPORTER DETAILS</span>
                                        <span class="kt-invoice__text">
                                        Truck Number : <?= $note['delivery_note_truck_no']; ?> <br>
                                        Truck Owner : <?= $note['delivery_note_truck_owner']; ?> <br>
                                        Trailer Number : <?= $note['delivery_note_trailer_no']; ?> <br>
                                        Trailer Owner : <?= $note['delivery_note_trailer_owner']; ?> <br>
                                        Transport Mode : <?= $freight_key['fr_plan_name']; ?> <br>
                                    </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="kt-invoice__body">
                            <div class="kt-invoice__container">
                                <div class="table-responsive">
                                    <table class="table">
                                        <thead>
                                        <tr>
                                            <th>NO</th>
                                            <th>ITEM</th>
                                            <th>PACKAGING</th>
                                            <th>WEIGHT</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td><?= 1; ?></td>
                                            <td><?= $freight_key['fr_cargo_details']; ?></td>
                                            <td><?= $freight_key['fr_category_name']; ?></td>
                                            <td><?= $freight_key['fr_gross_weight']; ?></td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="kt-invoice__footer">
                            <div class="kt-invoice__container">
                                <div class="table-responsive">
                                    <table class="table">
                                        <thead>
                                        <tr>
                                            <th>Comments / observations (Condition of goods on reception: missing /damaged, etc)
                                            </th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td><?= $note['delivery_note_comment']; ?></td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="kt-invoice__actions">
                <div class="kt-invoice__container">
                    <!--<button type="button" class="btn btn-label-brand btn-bold" onclick="window.print();">Download Invoice</button>-->
                    <button type="button" class="btn btn-brand btn-bold" onclick="printDiv('printableArea');">Print Delivery Note</button>
                </div>
            </div>
        <?php }} ?>

    <!--Begin::Section-->
    <div class="row">
        <?php
        $freight_doc = $this->documentsModel->find_many_by(['doc_fr_key'=>$freight['fr_key'],'doc_type'=>'Delivery Note']);
        if(!empty($freight_doc)):
            foreach($freight_doc as $doc):
                ?>
                <div class="col-xl-3 col-lg-6 col-md-6" id='<?php echo $doc['doc_key'];?>'>

                    <!--Begin::Portlet-->
                    <div class="kt-portlet">
                        <div class="kt-portlet__head kt-portlet__head--noborder">
                            <div class="kt-portlet__head-label">
                                <h3 class="kt-portlet__head-title">
                                </h3>
                            </div>
                            <div class="kt-portlet__head-toolbar">
                                <a href="#" class="btn btn-clean btn-sm btn-icon btn-icon-md" data-toggle="dropdown">
                                    <i class="flaticon-more-1"></i>
                                </a>
                                <div class="dropdown-menu dropdown-menu-right">
                                    <ul class="kt-nav">
                                        <li class="kt-nav__item">
                                            <a href="<?= uploadFilePath('freight_docs/').$doc['doc_file'];?>" class="kt-nav__link">
                                                <i class="kt-nav__link-icon flaticon2-download"></i>
                                                <span class="kt-nav__link-text">Download</span>
                                            </a>
                                        </li>
                                        <li class="kt-nav__item">
                                            <a href="javascript:(0);" onclick="deleteDocument('<?php echo $doc['doc_key'];?>')" class="kt-nav__link">
                                                <i class="kt-nav__link-icon flaticon2-trash"></i>
                                                <span class="kt-nav__link-text">Delete</span>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="kt-portlet__body">
                            <!--begin::Widget -->
                            <div class="kt-widget__files">
                                <div class="kt-widget__media">
                                    <img class="kt-widget__img kt-hidden-" src="<?php echo base_url('resources/');?>assets/media/files/<?php echo getFileExt($doc['doc_file']);?>.svg" alt="FILE">
                                </div>

                                <a target="_blank" href="<?php echo uploadFilePath('freight_docs/').$doc['doc_file'];?>"  data-url="<?php echo uploadFilePath('freight_docs/').$doc['doc_file'];?>" class="kt-widget__desc">
                                    <?php echo $doc['doc_name'];?>
                                </a>
                            </div>

                            <!--end::Widget -->
                        </div>
                    </div>

                    <!--End::Portlet-->
                </div>
            <?php endforeach; endif; ?>
    </div>
    <!--End::Section-->
</div>
<!-- Begin: create delivery note Modal -->
<div class="modal fade" id="delivery-note" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <?php $attr = array( 'class' => 'kt-form','id'=>'delivery-note-form');
        echo form_open('', $attr );?>
        <div class="modal-content">
            <div class="modal-header">
                <h3>Create Delivery Note</h3>
                <div style="float: right"><button type="button" data-dismiss="modal" class="btn btn-secondary">Close</button></div>
            </div>
            <!--<div class="row">
                <div class="col">
                    <div class="alert alert-light alert-elevate fade show" role="alert">
                        <div class="alert-icon"><i class="flaticon-warning kt-font-danger"></i></div>
                        <div class="alert-text">
                            <code><b>Warning :</b> <br> This is the final stage of this freight history. Once approved this stage, the entire history on this freight will no longer created or updated</code>
                        </div>
                    </div>
                </div>
            </div>-->
            <div class="modal-body">
                <div class="kt-portlet__body">
                    <input type="hidden" name="delivery_note_fr_key" value="<?= $freight['fr_key']?>">
                    <div class="form-group row">
                        <div class="col-md-4">
                            <label class="col-form-label">Delivery Note / Way Bill No</label>
                            <input class="form-control" type="text" name="delivery_note_bill_no" required>
                        </div>
                        <div class="col-md-4">
                            <label class="col-form-label">Truck Number</label>
                            <input class="form-control" type="text" name="delivery_note_truck_no" required>
                        </div>
                        <div class="col-md-4">
                            <label class="col-form-label">Trailer Details</label>
                            <input type="text" name="delivery_note_trailer_no" class="form-control" required>
                        </div>
                        <!--<div class="col-md-6">
                            <label class="col-form-label">Transport Mode</label>
                            <input type="text" name="fr_stage_date" class="form-control" required>
                        </div>-->
                    </div>
                    <div class="form-group row">
                        <div class="col-md-4">
                            <label class="col-form-label">Driver Name</label>
                            <input class="form-control" type="text" name="delivery_note_driver_name" required>
                        </div>
                        <div class="col-md-4">
                            <label class="col-form-label">Driver Contacts (phone)</label>
                            <input type="text" name="delivery_note_driver_phone" class="form-control" required>
                        </div>
                        <div class="col-md-4">
                            <label class="col-form-label">Driver License Number</label>
                            <input type="text" name="delivery_note_driver_license" class="form-control" required>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-md-6">
                            <label class="col-form-label">Truck Owner</label>
                            <input type="text" name="delivery_note_truck_owner" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label class="col-form-label">Trailer Owner</label>
                            <input type="text" name="delivery_note_trailer_owner" class="form-control" required>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-md-6">
                            <label class="col-form-label">Sender Location</label>
                            <input type="text" name="delivery_note_sender_location" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label class="col-form-label">Consignee Location</label>
                            <input type="text" name="delivery_note_consignee_location" class="form-control" required>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-md-12">
                            <label class="col-form-label">Comments / observations (Condition of goods on reception: missing /damaged, etc)</label>
                            <textarea class="form-control summernote" name="delivery_note_comment" required></textarea>
                        </div>
                    </div>
                    <!--<div class="form-group row">
                        <div class="col-md-6">
                            <label class="col-form-label">Sender</label>
                            <input class="form-control" type="text" value="
                            </?php/**
                            if (!empty($sender)) {
                                echo $sender;
                            }
                            else{
                                echo "N/A";
                            } **/
                            ?>" name="fr_invoice_date" readonly>
                            <label class="col-form-label">Sender Location</label>
                            <input class="form-control" type="text" name="fr_invoice_date" required>
                        </div>
                        <div class="col-md-6">
                            <label class="col-form-label">Consignee</label>
                            <input type="text" name="fr_stage_date" class="form-control" value="
                            </?php/**
                            if (!empty($company)) {
                                echo $company;
                            }
                            else{
                                echo $client;
                            }**/
                            ?>
                            " readonly>
                            <label class="col-form-label">Consignee Location</label>
                            <input type="text" name="fr_stage_date" class="form-control" required>
                        </div>
                    </div>-->
                    <!--<div class="form-group row">
                        <div class="col-lg-12" style="margin-top: 5px">
                            <label class="">Attach File:</label>
                            <div class="m-dropzone dropzone m-dropzone--primary dz-clickable" id="kt_dropzone_note">
                                <div class="dropzone-msg dz-message needsclick" >
                                    <h3 class="dropzone-msg-title">Click here to upload file..</h3>
                                </div>
                            </div>
                        </div>
                        <input type="hidden" class="form-control" id="uploadedfiles" name="uploadedfiles" />
                    </div>-->
                </div>
            </div>
            <div class="modal-footer">
                <div class="kt-form__actions">
                    <div class="row">
                        <div class="col-6"><button type="button" data-dismiss="modal" class="btn btn-secondary">Cancel</button></div>
                        <div class="col-6">
                            <button type="submit" name="submit" class="btn btn-success pull-right">Save</button>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <?php echo form_close();?>
    </div>
</div>
<!-- End: create delivery note Modal -->
<!-- Begin: modify delivery note Modal -->
<div class="modal fade" id="modify-delivery-note" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <?php $attr = array( 'class' => 'kt-form','id'=>'modify-delivery-note-form');
        echo form_open('', $attr );?>
        <div class="modal-content">
            <div class="modal-header">
                <h3>Modify Delivery Note</h3>
                <div style="float: right"><button type="button" data-dismiss="modal" class="btn btn-secondary">Close</button></div>
            </div>
            <!--<div class="row">
                <div class="col">
                    <div class="alert alert-light alert-elevate fade show" role="alert">
                        <div class="alert-icon"><i class="flaticon-warning kt-font-danger"></i></div>
                        <div class="alert-text">
                            <code><b>Warning :</b> <br> This is the final stage of this freight history. Once approved this stage, the entire history on this freight will no longer created or updated</code>
                        </div>
                    </div>
                </div>
            </div>-->
            <?php
            if(!empty($delivery)){
                //var_dump($delivery);
                foreach ($delivery as $note){
                    ?>
                    <div class="modal-body">
                        <div class="kt-portlet__body">
                            <input type="hidden" name="delivery_note_fr_key" value="<?= $freight['fr_key']?>">
                            <input type="hidden" name="delivery_note_key" value="<?= $note['delivery_note_key']?>">
                            <div class="form-group row">
                                <div class="col-md-4">
                                    <label class="col-form-label">Delivery Note / Way Bill No</label>
                                    <input class="form-control" type="text" name="delivery_note_bill_no" value="<?= $note['delivery_note_bill_no'];?>" required>
                                </div>
                                <div class="col-md-4">
                                    <label class="col-form-label">Truck Number</label>
                                    <input class="form-control" type="text" name="delivery_note_truck_no" value="<?= $note['delivery_note_truck_no'];?>" required>
                                </div>
                                <div class="col-md-4">
                                    <label class="col-form-label">Trailer Number</label>
                                    <input type="text" name="delivery_note_trailer_no" class="form-control" value="<?= $note['delivery_note_trailer_no'];?>" required>
                                </div>
                                <!--<div class="col-md-6">
                                    <label class="col-form-label">Transport Mode</label>
                                    <input type="text" name="fr_stage_date" class="form-control" required>
                                </div>-->
                            </div>
                            <div class="form-group row">
                                <div class="col-md-4">
                                    <label class="col-form-label">Driver Name</label>
                                    <input class="form-control" type="text" name="delivery_note_driver_name" value="<?= $note['delivery_note_driver_name'];?>" required>
                                </div>
                                <div class="col-md-4">
                                    <label class="col-form-label">Driver Contacts (phone)</label>
                                    <input type="text" name="delivery_note_driver_phone" class="form-control" value="<?= $note['delivery_note_driver_phone'];?>" required>
                                </div>
                                <div class="col-md-4">
                                    <label class="col-form-label">Driver License Number</label>
                                    <input type="text" name="delivery_note_driver_license" class="form-control" value="<?= $note['delivery_note_driver_license'];?>" required>
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-md-6">
                                    <label class="col-form-label">Truck Owner</label>
                                    <input type="text" name="delivery_note_truck_owner" class="form-control" value="<?= $note['delivery_note_truck_owner'];?>" required>
                                </div>
                                <div class="col-md-6">
                                    <label class="col-form-label">Trailer Owner</label>
                                    <input type="text" name="delivery_note_trailer_owner" class="form-control" value="<?= $note['delivery_note_trailer_owner'];?>" required>
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-md-6">
                                    <label class="col-form-label">Sender Location</label>
                                    <input type="text" name="delivery_note_sender_location" class="form-control" value="<?= $note['delivery_note_sender_location'];?>" required>
                                </div>
                                <div class="col-md-6">
                                    <label class="col-form-label">Consignee Location</label>
                                    <input type="text" name="delivery_note_consignee_location" class="form-control" value="<?= $note['delivery_note_consignee_location'];?>" required>
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-md-12">
                                    <label class="col-form-label">Comments / observations (Condition of goods on reception: missing /damaged, etc)</label>
                                    <textarea class="form-control summernote" name="delivery_note_comment" required><?= $note['delivery_note_comment'];?></textarea>
                                </div>
                            </div>
                            <!--<div class="form-group row">
                                <div class="col-md-6">
                                    <label class="col-form-label">Sender</label>
                                    <input class="form-control" type="text" value="
                                    " name="fr_invoice_date" readonly>
                                    <label class="col-form-label">Sender Location</label>
                                    <input class="form-control" type="text" name="fr_invoice_date" required>
                                </div>
                                <div class="col-md-6">
                                    <label class="col-form-label">Consignee</label>
                                    <input type="text" name="fr_stage_date" class="form-control" value="

                                    " readonly>
                                    <label class="col-form-label">Consignee Location</label>
                                    <input type="text" name="fr_stage_date" class="form-control" required>
                                </div>
                            </div>-->
                            <!--<div class="form-group row">
                                <div class="col-lg-12" style="margin-top: 5px">
                                    <label class="">Attach File:</label>
                                    <div class="m-dropzone dropzone m-dropzone--primary dz-clickable" id="kt_dropzone_note1">
                                        <div class="dropzone-msg dz-message needsclick" >
                                            <h3 class="dropzone-msg-title">Click here to upload file..</h3>
                                        </div>
                                    </div>
                                </div>
                                <input type="hidden" class="form-control" id="uploadedfiles" name="uploadedfiles" />
                            </div>-->
                        </div>
                    </div>
                <?php }}?>
            <div class="modal-footer">
                <div class="kt-form__actions">
                    <div class="row">
                        <div class="col-6"><button type="button" data-dismiss="modal" class="btn btn-secondary">Cancel</button></div>
                        <div class="col-6">
                            <button type="submit" name="submit" class="btn btn-success pull-right">Save</button>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <?php echo form_close();?>
    </div>
</div>
<!-- End: modify delivery note Modal -->
<script src="<?php echo base_url('resources')?>/assets/js/pages/crud/forms/editors/summernote.js" type="text/javascript"></script>
<!--<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>-->
<script type="text/javascript">
    $(function () {

        $('form#delivery-note-form').submit(function (event) {
            let form = $(this);
            let $div = $('div#details');
            event.preventDefault();
            let formdata = form.serialize();
            //alert(formdata);
            $.ajax({
                url: '<?php echo base_url( 'freight/index/create_delivery_note');?>',
                type: 'post',
                data: formdata,
                beforeSend: function () {
                    KTApp.blockPage({
                        overlayColor: "#000000",
                        type: "loader",
                        state: "success",
                        message: "Creating Delivery Note...."
                    });
                },
                success: function () {
                    KTApp.unblockPage();
                    Swal.fire('', 'Delivery Note Successfully Created!', 'success');
                    $("#delivery-note").modal("hide");
                    $div.load("<?php echo base_url('freight/index/loadDeliveryNote/' . $freight['fr_key']);?>");
                },
                error: function (xhr) {
                    Swal.fire('', xhr.statusText, 'warning');
                    KTApp.unblockPage();
                    $("#delivery-note").modal("hide");
                }
            });
        });
    })
    $(function () {

        $('form#modify-delivery-note-form').submit(function (event) {
            let form = $(this);
            let $div = $('div#details');
            event.preventDefault();
            let formdata = form.serialize();
            //alert(formdata);
            $.ajax({
                url: '<?php echo base_url( 'freight/index/modify_delivery_note');?>',
                type: 'post',
                data: formdata,
                beforeSend: function () {
                    KTApp.blockPage({
                        overlayColor: "#000000",
                        type: "loader",
                        state: "success",
                        message: "Modifying Delivery Note...."
                    });
                },
                success: function () {
                    KTApp.unblockPage();
                    Swal.fire('', 'Delivery Note Successfully Modified!', 'success');
                    $("#modify-delivery-note").modal("hide");
                    $div.load("<?php echo base_url('freight/index/loadDeliveryNote/' . $freight['fr_key']);?>");
                },
                error: function (xhr) {
                    Swal.fire('', xhr.statusText, 'warning');
                    KTApp.unblockPage();
                    $("#modify-delivery-note").modal("hide");
                }
            });
        });
    })
</script>
<!-- End : Delivery Note Page -->

<!-- Begin : Delivery at Consignee Page -->
<div class="kt-portlet__body" id="details">
    <div class="row">
        <div class="col">
            <div class="alert alert-light alert-elevate fade show" role="alert">
                <div class="alert-icon"><i class="flaticon-warning kt-font-info"></i></div>
                <div class="alert-text">
                    <h3>Description of delivery at consignee </h3>
                    <?php
                    $freight_desc = $this->documentsModel->find_many_by(['doc_fr_key'=>$freight['fr_key'],'doc_type'=>'Delivery at Consignee', 'deleted'=>0]);
                    if(!empty($freight_desc))
                    {
                        foreach ($freight_desc as $desc)
                        {
                            if(!empty($desc['doc_description']))
                            {
                                ?>
                                <li>
                                    <code><?= $desc['doc_name']; ?> Description : </code>
                                    <?= $desc['doc_description'];?>
                                    <small>
                                        <?= "<i style='color: blue'>(".date('M d,Y', strtotime($desc['created'])).")</i>";?>
                                    </small>
                                </li>
                                <?php
                            }
                            else
                            {
                                ?>
                                <li>
                                    <code><?= $desc['doc_name']; ?> : </code><code>(No description)</code>
                                    <small>
                                        <?= "<i style='color: blue'>(".date('M d,Y', strtotime($desc['created'])).")</i>";?>
                                    </small>
                                </li>
                                <?php
                            }
                        }
                    }
                    else
                    {
                        ?>
                        <code>(No description)</code>
                        <?php
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>
    <?php
    if(has_menu_freight()){
        if(has_role('freight_create_delivery_note')){
            if($freight['fr_file_status'] == 'Active'){?>
                <form id="docsForm" onsubmit="return false;" class="kt-form kt-form--label-right">
                    <div class="kt-portlet__body">
                        <div class="form-group row">
                            <div class="col-lg-12" style="margin-top: 5px">
                                <label class="">Attach File:</label>
                                <div class="m-dropzone dropzone m-dropzone--primary dz-clickable" id="kt_dropzone_1">
                                    <div class="dropzone-msg dz-message needsclick" >
                                        <h3 class="dropzone-msg-title">Click here to upload file..</h3>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <label>Document Type (eg. Invoice, Consignee Photos, etc)</label>
                                <input type="text" class="form-control" name="doc_name" placeholder="Enter here" required>
                            </div>
                            <input type="hidden" class="form-control" name="doc_type" value="Delivery at Consignee" readonly>
                            <div class="col-lg-6">
                                <label>Description:</label>
                                <textarea class="form-control" name="doc_description" placeholder="Enter description"></textarea>
                            </div>

                            <!-- <div class="col-lg-12">
                                 <div class="m-dropzone dropzone m-dropzone--primary dz-clickable"  id="crop-image">
                                     <div class="m-dropzone__msg dz-message needsclick">
                                         <h3 class="m-dropzone__msg-title">Drop files here or click to upload.</h3>
                                         <span class="m-dropzone__msg-desc">Upload 1 files</span>
                                     </div>
                                 </div>
                             </div>-->
                            <input type="hidden" class="form-control" id="uploadedfiles" name="uploadedfiles" />
                        </div>
                        <div class="row">
                            <div class="col-lg-6">
                            </div>
                            <div class="col-lg-6 kt-align-right">
                                <button type="submit" name="submit" class="btn btn-success">Submit</button>
                            </div>
                        </div>
                    </div>
                </form>
            <?php }}} ?>
    <!--Begin::Section-->
    <div class="row">
        <?php
        $freight_doc = $this->documentsModel->find_many_by(['doc_fr_key'=>$freight['fr_key'],'doc_type'=>'Delivery at Consignee']);
        if(!empty($freight_doc)):
            foreach($freight_doc as $doc):
                ?>
                <div class="col-xl-3 col-lg-6 col-md-6" id='<?php echo $doc['doc_key'];?>'>

                    <!--Begin::Portlet-->
                    <div class="kt-portlet">
                        <div class="kt-portlet__head kt-portlet__head--noborder">
                            <div class="kt-portlet__head-label">
                                <h3 class="kt-portlet__head-title">
                                </h3>
                            </div>
                            <div class="kt-portlet__head-toolbar">
                                <a href="#" class="btn btn-clean btn-sm btn-icon btn-icon-md" data-toggle="dropdown">
                                    <i class="flaticon-more-1"></i>
                                </a>
                                <?php
                                if(has_menu_freight()){
                                    if(has_role('freight_delete_delivery_note')){
                                        ?>
                                        <div class="dropdown-menu dropdown-menu-right">
                                            <ul class="kt-nav">
                                                <li class="kt-nav__item">
                                                    <a href="<?= uploadFilePath('freight_docs/').$doc['doc_file'];?>" class="kt-nav__link">
                                                        <i class="kt-nav__link-icon flaticon2-download"></i>
                                                        <span class="kt-nav__link-text">View</span>
                                                    </a>
                                                </li>
                                                <li class="kt-nav__item">
                                                    <a href="javascript:(0);" onclick="deleteDocument('<?php echo $doc['doc_key'];?>')" class="kt-nav__link">
                                                        <i class="kt-nav__link-icon flaticon2-trash"></i>
                                                        <span class="kt-nav__link-text">Delete</span>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                        <?php
                                    }
                                }
                                ?>
                            </div>
                        </div>
                        <div class="kt-portlet__body">
                            <!--begin::Widget -->
                            <div class="kt-widget__files">
                                <div class="kt-widget__media">
                                    <img class="kt-widget__img kt-hidden-" src="<?php echo base_url('resources/');?>assets/media/files/<?php echo getFileExt($doc['doc_file']);?>.svg" alt="FILE">
                                </div>

                                <a target="_blank" href="<?php echo uploadFilePath('freight_docs/').$doc['doc_file'];?>"  data-url="<?php echo uploadFilePath('freight_docs/').$doc['doc_file'];?>" class="kt-widget__desc">
                                    <?php echo $doc['doc_name'];?>
                                </a>
                            </div>

                            <!--end::Widget -->
                        </div>
                    </div>

                    <!--End::Portlet-->
                </div>
            <?php endforeach; endif; ?>
    </div>
    <!--End::Section-->
</div>
<script type="text/javascript">
    $(function () {

        $('form#docsForm').submit(function (event) {
            let form = $(this);
            let $div = $('div#details');
            event.preventDefault();
            let formdata = form.serialize();
            $.ajax({
                url: '<?php echo base_url( 'freight/index/newDocumentation/' . $freight['fr_key']);?>',
                type: 'get',
                data: formdata,
                beforeSend: function () {
                    KTApp.block($div, {
                        overlayColor: "#000000",
                        type: "loader",
                        state: "success",
                        message: "Adding Document ...."
                    });
                },
                success: function () {
                    KTApp.unblock($div);
                    Swal.fire('', 'Successfully Uploaded!', 'success');

                },
                error: function (xhr) {
                    Swal.fire('', xhr.statusText, 'success');
                    KTApp.unblock($div);
                }
            });
        });
    })

    Dropzone.autoDiscover = false;
    var options = {
        url: "<?php echo base_url('freight/index/uploadfrdoc');?>",
        paramName: "file", // The name that will be used to transfer the file
        maxFiles: 1,
        maxFilesize: 5, // MB
        addRemoveLinks: true,
        success: function(file, response){
            let oldValue = $('input#uploadedfiles').val();
            if(oldValue.length > 0){
                oldValue = oldValue + 'LM-55';
            }
            let newValue =  oldValue + response.files;
            $('input#uploadedfiles').val(newValue);
        },
    };
    var freightDocs = new Dropzone("div#kt_dropzone_1", options);

</script>
<!-- End : Delivery at Consignee Page -->

<!-- Begin : Received Interchange Page -->
<div class="kt-portlet__body" id="details">
    <div class="row">
        <div class="col">
            <div class="alert alert-light alert-elevate fade show" role="alert">
                <div class="alert-icon"><i class="flaticon-warning kt-font-info"></i></div>
                <div class="alert-text">
                    <h3>Description of received interchange from driver ref No. </h3>
                    <?php
                    $freight_desc = $this->documentsModel->find_many_by(['doc_fr_key'=>$freight['fr_key'],'doc_type'=>'Received Interchange', 'deleted'=>0]);
                    if(!empty($freight_desc))
                    {
                        foreach ($freight_desc as $desc)
                        {
                            if(!empty($desc['doc_description']))
                            {
                                ?>
                                <li>
                                    <code><?= $desc['doc_name']; ?> Description : </code>
                                    <?= $desc['doc_description'];?>
                                    <small>
                                        <?= "<i style='color: blue'>(".date('M d,Y', strtotime($desc['created'])).")</i>";?>
                                    </small>
                                </li>
                                <?php
                            }
                            else
                            {
                                ?>
                                <li>
                                    <code><?= $desc['doc_name']; ?> : </code><code>(No description)</code>
                                    <small>
                                        <?= "<i style='color: blue'>(".date('M d,Y', strtotime($desc['created'])).")</i>";?>
                                    </small>
                                </li>
                                <?php
                            }
                        }
                    }
                    else
                    {
                        ?>
                        <code>(No description)</code>
                        <?php
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>
    <?php
    if(has_menu_freight()){
        if(has_role('freight_create_delivery_note')){
            if($freight['fr_file_status'] == 'Active'){?>
                <form id="docsForm" onsubmit="return false;" class="kt-form kt-form--label-right">
                    <div class="kt-portlet__body">
                        <div class="form-group row">
                            <div class="col-lg-12" style="margin-top: 5px">
                                <label class="">Attach File:</label>
                                <div class="m-dropzone dropzone m-dropzone--primary dz-clickable" id="kt_dropzone_1">
                                    <div class="dropzone-msg dz-message needsclick" >
                                        <h3 class="dropzone-msg-title">Click here to upload file..</h3>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <label>Document Type (eg. Invoice, Delivery Note, etc)</label>
                                <input type="text" class="form-control" name="doc_name" placeholder="Enter here" required>
                            </div>
                            <input type="hidden" class="form-control" name="doc_type" value="Received Interchange" readonly>
                            <div class="col-lg-6">
                                <label>Description:</label>
                                <textarea class="form-control" name="doc_description" placeholder="Enter description"></textarea>
                            </div>
                            <!-- <div class="col-lg-12">
                                 <div class="m-dropzone dropzone m-dropzone--primary dz-clickable"  id="crop-image">
                                     <div class="m-dropzone__msg dz-message needsclick">
                                         <h3 class="m-dropzone__msg-title">Drop files here or click to upload.</h3>
                                         <span class="m-dropzone__msg-desc">Upload 1 files</span>
                                     </div>
                                 </div>
                             </div>-->
                            <input type="hidden" class="form-control" id="uploadedfiles" name="uploadedfiles" />
                        </div>
                        <div class="row">
                            <div class="col-lg-6">
                            </div>
                            <div class="col-lg-6 kt-align-right">
                                <button type="submit" name="submit" class="btn btn-success">Submit</button>
                            </div>
                        </div>
                    </div>
                </form>
            <?php }}} ?>
    <!--Begin::Section-->
    <div class="row">
        <?php
        $freight_doc = $this->documentsModel->find_many_by(['doc_fr_key'=>$freight['fr_key'],'doc_type'=>'Received Interchange']);
        if(!empty($freight_doc)):
            foreach($freight_doc as $doc):
                ?>
                <div class="col-xl-3 col-lg-6 col-md-6" id='<?php echo $doc['doc_key'];?>'>

                    <!--Begin::Portlet-->
                    <div class="kt-portlet">
                        <div class="kt-portlet__head kt-portlet__head--noborder">
                            <div class="kt-portlet__head-label">
                                <h3 class="kt-portlet__head-title">
                                </h3>
                            </div>
                            <div class="kt-portlet__head-toolbar">
                                <a href="#" class="btn btn-clean btn-sm btn-icon btn-icon-md" data-toggle="dropdown">
                                    <i class="flaticon-more-1"></i>
                                </a>
                                <?php
                                if(has_menu_freight()){
                                    if(has_role('freight_delete_delivery_note')){
                                        ?>
                                        <div class="dropdown-menu dropdown-menu-right">
                                            <ul class="kt-nav">
                                                <li class="kt-nav__item">
                                                    <a href="<?= uploadFilePath('freight_docs/').$doc['doc_file'];?>" class="kt-nav__link">
                                                        <i class="kt-nav__link-icon flaticon2-download"></i>
                                                        <span class="kt-nav__link-text">View</span>
                                                    </a>
                                                </li>
                                                <li class="kt-nav__item">
                                                    <a href="javascript:(0);" onclick="deleteDocument('<?php echo $doc['doc_key'];?>')" class="kt-nav__link">
                                                        <i class="kt-nav__link-icon flaticon2-trash"></i>
                                                        <span class="kt-nav__link-text">Delete</span>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                        <?php
                                    }
                                }
                                ?>
                            </div>
                        </div>
                        <div class="kt-portlet__body">
                            <!--begin::Widget -->
                            <div class="kt-widget__files">
                                <div class="kt-widget__media">
                                    <img class="kt-widget__img kt-hidden-" src="<?php echo base_url('resources/');?>assets/media/files/<?php echo getFileExt($doc['doc_file']);?>.svg" alt="FILE">
                                </div>

                                <a target="_blank" href="<?php echo uploadFilePath('freight_docs/').$doc['doc_file'];?>"  data-url="<?php echo uploadFilePath('freight_docs/').$doc['doc_file'];?>" class="kt-widget__desc">
                                    <?php echo $doc['doc_name'];?>
                                </a>
                            </div>

                            <!--end::Widget -->
                        </div>
                    </div>

                    <!--End::Portlet-->
                </div>
            <?php endforeach; endif; ?>
    </div>
    <!--End::Section-->
</div>
<script type="text/javascript">
    $(function () {

        $('form#docsForm').submit(function (event) {
            let form = $(this);
            let $div = $('div#details');
            event.preventDefault();
            let formdata = form.serialize();
            $.ajax({
                url: '<?php echo base_url( 'freight/index/newDocumentation/' . $freight['fr_key']);?>',
                type: 'get',
                data: formdata,
                beforeSend: function () {
                    KTApp.block($div, {
                        overlayColor: "#000000",
                        type: "loader",
                        state: "success",
                        message: "Adding Document ...."
                    });
                },
                success: function () {
                    KTApp.unblock($div);
                    Swal.fire('', 'Successfully Uploaded!', 'success');

                },
                error: function (xhr) {
                    Swal.fire('', xhr.statusText, 'success');
                    KTApp.unblock($div);
                }
            });
        });
    })

    Dropzone.autoDiscover = false;
    var options = {
        url: "<?php echo base_url('freight/index/uploadfrdoc');?>",
        paramName: "file", // The name that will be used to transfer the file
        maxFiles: 1,
        maxFilesize: 5, // MB
        addRemoveLinks: true,
        success: function(file, response){
            let oldValue = $('input#uploadedfiles').val();
            if(oldValue.length > 0){
                oldValue = oldValue + 'LM-55';
            }
            let newValue =  oldValue + response.files;
            $('input#uploadedfiles').val(newValue);
        },
    };
    var freightDocs = new Dropzone("div#kt_dropzone_1", options);

</script>
<!-- End : Received Interchange Page -->

<!-- Begin : Freight Task Page -->
<div class="kt-portlet kt-portlet--head-md kt-portlet--responsive-mobile" id="kt_page_portlet">
    <?php
    if(has_menu_freight()){
        if(has_role('task_create')){
            if($freight['fr_file_status'] == 'Active'){?>
                <form id="freightTaskForm" onsubmit="return false;" class="kt-form kt-form--label-right">
                    <div class="kt-portlet__body">
                        <div class="form-group row">
                            <input type="text" hidden class="form-control" name="freight_task_freight_key" value="<?php echo $freight['fr_key'];?>" placeholder="Enter description">
                            <div class="col-lg-6">
                                <label>Employee:</label>
                                <select class="form-control" name="freight_task_employee_key">
                                    <option disabled>Select Employee</option>
                                    <?php if(!empty($employees)):
                                        foreach($employees as $emp):?>
                                            <option value="<?php echo $emp['user_id'];?>" selected><?php echo $emp['firstname'];?> <?php echo $emp['lastname'];?></option>
                                        <?php endforeach; endif;?>
                                </select>
                            </div>
                            <div class="col-lg-3">
                                <label>File No:</label>
                                <input type="text" readonly class="form-control" name="freight_task_freight_key" placeholder="" value="<?php echo $freight['fr_key'];?>">
                            </div>
                            <div class="col-lg-3">
                                <label>Task Status:</label>
                                <input type="text" readonly class="form-control" name="user_fam_mname" placeholder="" value="Pending">
                            </div>
                        </div>
                        <div class="form-group row">
                            <input type="text" hidden class="form-control" name="freight_task_client" value="<?php echo $freight['fr_client'];?>" placeholder="Enter description">
                            <input type="text" hidden class="form-control" name="freight_task_client_name" value="<?php echo $freight['company_name'].' '.$freight['firstname'].' '.$freight['lastname'];?>" placeholder="Enter description">
                            <div class="col-lg-6">
                                <label>Task Start(optional):</label>
                                <div class="input-group date">
                                    <input type="text" class="form-control" name="freight_task_start" placeholder="Select date and time" id="kt_datetimepicker_5" />
                                    <div class="input-group-append">
                            <span class="input-group-text">
                                <i class="la la-calendar glyphicon-th"></i>
                            </span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <label>Task Deadline(Optional):</label>
                                <div class="input-group date">
                                    <input type="text" class="form-control" name="freight_task_deadline" placeholder="Select date and time" id="kt_datetimepicker_4" />
                                    <div class="input-group-append">
                            <span class="input-group-text">
                                <i class="la la-calendar glyphicon-th"></i>
                            </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-lg-12">
                                <label>Task Description</label>
                                <textarea id="kt_summernote_1" required name="freight_task_desc" class="form-control summernote" placeholder="Descriptions"></textarea>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-lg-6">
                                <button type="reset" class="btn btn-secondary">Clear</button>
                            </div>
                            <div class="col-lg-6 kt-align-right">
                                <button type="submit" name="submit" class="btn btn-success">Save</button>
                            </div>
                        </div>

                    </div>
                </form>
            <?php }}}?>

    <div class="kt-portlet__body">
        <!-- <div class="kt-datatable" id="applicationTable"></div> -->
        <table class="table table-bordered table-hover table-checkable" id="lm_table_freight_task">
            <thead>
            <tr>
                <th>Responsible Personnel</th>
                <th>Task Description</th>
                <th>Status</th>
                <th>Payment</th>
                <th>Action</th>
            </tr>
            </thead>
        </table>
    </div>
</div>
<script src="<?php echo base_url('resources');?>/assets/js/pages/crud/forms/widgets/bootstrap-datetimepicker.js" type="text/javascript"></script>
<script src="<?php echo base_url('resources');?>/assets/js/pages/crud/forms/editors/summernote.js" type="text/javascript"></script>
<script type="text/javascript">
    //== Class definition
    $.fn.dataTable.Api.register('column().title()', function() {
        return $(this.header()).text().trim();
    });

    var Datatable = function() {
        var initTable = function() {
            var events = $('#lm_table_freight_task');
            // begin first table
            events.DataTable({
                responsive: true,
                buttons: [
                    'print',
                    'copyHtml5',
                    'excelHtml5',
                    'csvHtml5',
                    'pdfHtml5',
                ],
                dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
			<'row'<'col-sm-12'tr>>
			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                searchDelay: 500,
                processing: true,
                serverSide: false,
                ajax: '<?php echo base_url('freight/index/datasourceFreightTask/'.$freight['fr_key']);?>',
                columns: [
                    {data: 'freight_task_employee_key'},
                    {data: 'freight_task_desc'},
                    {data: 'freight_task_status'},
                    {data: 'freight_task_payment'},
                    {data: 'action'},
                ],
                columnDefs: [
                    {
                        targets: 0,
                        render: function (data, type, full, meta) {
                            return '<a  href="<?php echo base_url('/hrm/employees/index/details/');?>' + full.freight_task_employee_key + '">'+full.firstname+' '+full.lastname+'</a>';
                        },
                    },
                    {
                        targets: 4,
                        "width": "20%",
                        render: function(data, type, full, meta){
                            return ' <a href="javascript:deleteItem(' + full.freight_task_key + ');"><i class="flaticon-delete text-danger"></i></a> | <a data-backdrop="false" href="javascript:updateTask(' + full.freight_task_key + ');"><i class="flaticon2-edit"></i>Update</a>| <a data-backdrop="false" href="javascript:detailsTask(' + full.freight_task_key + ');"><i class="flaticon2-paper"></i>More</a>';
                        }
                    }

                ],
            });

            var filter = function() {
                var val = $.fn.dataTable.util.escapeRegex($(this).val());
                let table = $.fn.dataTable.tables( { api: true } );
                table.column($(this).data('col-index')).search(val ? val : '', false, false).draw();
            };

            var asdasd = function(value, index) {
                let table = $.fn.dataTable.tables( { api: true } );
                var val = $.fn.dataTable.util.escapeRegex(value);
                table.column(index).search(val ? val : '', false, true);
            };

            $('#m_search').on('click', function(e) {
                e.preventDefault();
                let table = $.fn.dataTable.tables( { api: true } );
                var params = {};
                $('.kt-input').each(function() {
                    var i = $(this).data('col-index');
                    if (params[i]) {
                        params[i] += '|' + $(this).val();
                    }
                    else {
                        params[i] = $(this).val();
                    }
                });
                $.each(params, function(i, val) {
                    // apply search params to datatable
                    table.column(i).search(val ? val : '', false, false);
                });
                table.table().draw();
            });

            $('#m_reset').on('click', function(e) {
                e.preventDefault();
                let table = $.fn.dataTable.tables( { api: true } );
                $('.kt-input').each(function() {
                    $(this).val('');
                    table.column($(this).data('col-index')).search('', false, false);
                });
                table.table().draw();
            });

        };

        return {
            //main function to initiate the module
            init: function() {
                initTable();
            },

        };

    }();

    jQuery(document).ready(function() {
        Datatable.init();
    });

    $('form#freightTaskForm').submit(function (event) {
        let form = $(this);
        let $div = $('div#details');
        event.preventDefault();
        let formdata = form.serialize();
        $.ajax({
            url: '<?php echo base_url('freight/index/newFreightTask/')?>',
            type: 'get',
            data: formdata,
            beforeSend: function () {
                KTApp.block($div, {
                    overlayColor: "#000000",
                    type: "loader",
                    state: "success",
                    message: "Adding New Task for Freight...."
                });
            },
            success: function (r) {
                var obj = JSON.parse(r);
                if (obj.status == 'ok') {
                    $div.load("<?php echo base_url('freight/index/loadTaskFreight/' . $freight['fr_key']);?>");
                    Swal.fire('', obj.message, 'success');
                } else {
                    Swal.fire('', obj.message, 'warning');
                }
                KTApp.unblock($div);
            },
            error: function () {
                Swal.fire('', obj.message, 'success');
                KTApp.unblock($div);
            }
        });
    })

    function deleteItem(task){
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('freight/index/deleteFreightTask/task')?>/'+task,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.block("#lm_table_freight_task",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Deleting task data ..."
                        });
                    },
                    success: function(result){
                        let obj = JSON.parse(result);
                        if( obj.status == 'ok'){
                            notifySuccess(obj.message);
                            KTApp.unblock('#lm_table_freight_task');
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            Swal.fire('',obj.message,'warning');
                        }
                    },
                    error: function(xhr){
                        KTApp.unblock('#lm_table_freight_task');
                        Swal.fire('',xhr.statusText,'warning');
                    }
                });
            }
        })
    }

    function updateTask(task){
        let $modal =  $('div#freightTaskDetails');
        let $div = $modal.find('.modal-body');
        $div.html('');
        $modal.modal('show');
        $.ajax({
            url: '<?php echo base_url('freight/index/updateFreightTask/');?>' + task,
            type: 'get',
            beforeSend: function(){
                KTApp.block($div,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Loading more details ...."
                });
            },
            success: function (result){
                $div.html(result);
                KTApp.unblock($div);
            },
            error: function (xhr){
                $modal.modal('hide');
                KTApp.unblock($div);
                Swal.fire('',xhr.statusText,'warning');
            }
        })
    }

    function detailsTask(task){
        let $modal =  $('div#freightTaskDetails');
        let $div = $modal.find('.modal-body');
        $div.html('');
        $modal.modal('show');
        $.ajax({
            url: '<?php echo base_url('freight/index/detailsFreightTask/');?>' + task,
            type: 'get',
            beforeSend: function(){
                KTApp.block($div,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Loading more details ...."
                });
            },
            success: function (result){
                $div.html(result);
                KTApp.unblock($div);
            },
            error: function (xhr){
                $modal.modal('hide');
                KTApp.unblock($div);
                Swal.fire('',xhr.statusText,'warning');
            }
        })
    }
</script>
<!-- End : Freight Task Page -->





