<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<form id="modifyAttendanceForm" class="kt-form kt-form--fit kt-form--label-right" action="#" method="get" onsubmit="return false">
    <div class="modal-body">
        <div class="row form-group">
            <div class="col-6">
                <label>Employee Name</label>
                <input hidden type="text" name="att_user_id" value="<?php echo $attendance->att_user_id;?>" placeholder="" class="form-control"/>
                <input type="text" value="<?php echo $attendance->firstname;?> <?php echo $attendance->lastname;?>" placeholder="" class="form-control" readonly="readonly"/>
            </div>
            <div class="col-6">
                <label>Device Clock In</label>
                <input type="text" name="att_time_in_device" value="<?php echo $attendance->att_time_in_device;?>" placeholder="" class="form-control" readonly="readonly"/>
            </div>
        </div>
        <div class="row form-group">
            <div class="col-4">
                <label>Clock In</label>
                <input type="text" name="att_time_in" value="<?php echo $attendance->att_time_in;?>" placeholder="" class="form-control" readonly="readonly"/>
            </div>
            <div class="col-4">
                <label> Clock Out</label>
                <input class="form-control" value="<?php echo date("H:i:s");?>" name="att_time_out" id="kt_timepicker_2" readonly placeholder="Select time Out" type="text"/>
            </div>
            <div class="col-4">
                <label>Select Device</label>
                <select class="form-control kt-select2" id="kt_select2_1_modal" name="att_time_out_device">
                    <option>Select Device</option>
                    <?php if(!empty($device)):
                        foreach($device as $dev):?>
                            <option value="<?php echo $dev['device_number'];?>"><?php echo $dev['device_number'];?> - <?php echo $dev['device_name'];?></option>
                        <?php endforeach; endif;?>
                </select>
            </div>
        </div>

    </div>
    <div class="modal-footer">
        <button type="button" class="btn btn-info" data-dismiss="modal">Close</button>
        <button type="submit" name="submit" class="btn btn-success">Clock Out</button>
    </div>
</form>

<script type="text/javascript">
    $('form#modifyAttendanceForm').submit( function(event){
        let form = $( this );
        event.preventDefault();
        let formdata = form.serialize();
        $.ajax({
            url: '<?php echo base_url('hrm/attendance/index/updateAttendance/'.$attendance->att_key);?>' ,
            type: 'get',
            data: formdata,
            beforeSend: function(){
                KTApp.block(form,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Clocking Out Employee ..."
                });
            },
            success: function(r){
                var obj = JSON.parse(r);
                if(obj.status == 'ok'){
                    $('div#attendanceDetails').modal('hide');
                    notifySuccess(obj.message);
                    var table = $.fn.dataTable.tables( { api: true } );
                    table.clear().draw();
                }else{
                    Swal.fire('',obj.message,'warning');
                }
                KTApp.unblock(form);
            },
            error: function(){
                $('div#attendanceDetails').modal('hide');
                KTApp.unblock(form);
            }
        });
    })
</script>