<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<form id="modifyDeviceForm" class="kt-form kt-form--fit kt-form--label-right" action="#" method="get" onsubmit="return false">
    <div class="modal-body">
        <div class="row form-group">
            <div class="col-6">
                <label>Device Name</label>
                <input type="text" name="device_name" value="<?php echo $device->device_name;?>" placeholder="" class="form-control"/>
            </div>
            <div class="col-6">
                <label>Device Number</label>
                <input type="text" name="device_number" value="<?php echo $device->device_number;?>" placeholder="" class="form-control"/>
            </div>
        </div>

        <div class="row form-group">
            <div class="col-6">
                <label>Device Status</label>
                <select class="form-control kt-select2" id="kt_select2_1_modal" name="device_status">
                    <option disabled="">Select Device Status</option>
                    <option <?php if($device->device_status == 'Online') echo 'selected';?>>Online</option>
                    <option <?php if($device->device_status == 'Offline') echo 'selected';?>>Offline</option>
                </select>
            </div>
            <div class="col-6">
                <label>Device Mode</label>
                <select class="form-control kt-select2" id="kt_select2_1_modal" name="device_mode">
                    <option disabled="">Select Device Mode</option>
                    <option <?php if($device->device_mode == 'Active') echo 'selected';?>>Active</option>
                    <option <?php if($device->device_mode == 'Inactive') echo 'selected';?>>Inactive</option>
                </select>
            </div>
        </div>

        <div class="form-group m-form__group row">
            <label >Device Description</label>
            <div class="col-md-12">
                <textarea data-provide="markdown" class="form-control" value="<?php echo $device->device_desc;?>" name="device_desc"><?php echo $device->device_desc;?></textarea>
            </div>
        </div>

    </div>
    <div class="modal-footer">
        <button type="button" class="btn btn-info" data-dismiss="modal">Close</button>
        <button type="submit" name="submit" class="btn btn-success">Submit</button>
    </div>
</form>

<script type="text/javascript">
    $('form#modifyDeviceForm').submit( function(event){
        let form = $( this );
        event.preventDefault();
        let formdata = form.serialize();
        $.ajax({
            url: '<?php echo base_url('hrm/attendance/index/updateDevice/'.$device->device_key);?>' ,
            type: 'get',
            data: formdata,
            beforeSend: function(){
                KTApp.block(form,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Updating Fingerprint Device ..."
                });
            },
            success: function(r){
                var obj = JSON.parse(r);
                if(obj.status == 'ok'){
                    $('div#deviceDetails').modal('hide');
                    notifySuccess(obj.message);
                    var table = $.fn.dataTable.tables( { api: true } );
                    table.clear().draw();
                }else{
                    Swal.fire('',obj.message,'warning');
                }
                KTApp.unblock(form);
            },
            error: function(){
                $('div#deviceDetails').modal('hide');
                KTApp.unblock(form);
            }
        });
    })
</script>