<script type="text/javascript">

    var LMDatatableGroups= function() {
        var initTable = function() {
            // begin first table
            var table = $('#lm_table_att').DataTable({
                responsive: true,
                // Pagination settings
                dom: `<'row'<'col-sm-12'tr>>
    			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                // read more: https://datatables.net/examples/basic_init/dom.html

                lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],

                pageLength: 10,
                language: {
                    'lengthMenu': 'Display _MENU_',
                    buttons: {
                        selectAll: "Select all",
                        selectNone: "Select none"
                    },
                    "emptyTable": "No record found",
                },
                searchDelay: 500,
                processing: true,
                serverSide: true,
                select:true,
                "ajax":"<?php echo base_url('/hrm/attendance/index/datasourceAttendances');?>",
                dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
    			<'row'<'col-sm-12'tr>>
    			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                buttons: [
                    {
                        text: 'Delete Seleted',
                        action: function ( e, dt, node, config ) {
                            deleteSelected( table);
                        }
                    },
                    'selectAll',
                    'selectNone',
                    'excelHtml5',
                    'pdfHtml5',
                ],
                columns: [
                    {data: 'att_user_id'},
                    {data: 'att_date'},
                    {data: 'att_time_in'},
                    {data: 'att_time_out'},
                    {data: 'action'},
                ],
                columnDefs: [
                    {
                        targets: 0,
                        render: function(data, type, full, meta){
                            return '<a  href="<?php echo base_url('administration/employees/details/');?>' + full.user_id + '"> ' + full.firstname + ' ' + full.lastname + '</a> ';
                        }
                    },
                    {
                        targets: 4,
                        render: function(data, type, full, meta){
                            return '<a href="javascript:details(' + full.att_key + ');"><i class="flaticon-eye text-success"></i></a> | <a href="javascript:modify(' + full.att_key + ');"><i class="flaticon-edit text-warning"></i></a> | <a href="javascript:deleteItem(' + full.att_key + ');"><i class="flaticon-delete text-danger"></i></a>';
                        }
                    }
                ],
            });
        };

        return {
            //main function to initiate the module
            init: function() {
                initTable();
            },

        };

    }();

    jQuery(document).ready(function() {
        $('select').css('width','100%');
        $('select').select2({placeholder: 'select option'});
        let height = $(window).innerHeight()  - 250;
        $('.lm_max_height').css({ height: height });
        $(window).resize(function(){
            $('.lm_max_height').css({ height: height });
        });
        LMDatatableGroups.init();
        $('form#newAttendanceForm').submit( function(event){
            let form = $( this );
            event.preventDefault();
            let formdata = form.serialize();
            $.ajax({
                url: '<?php echo base_url('hrm/attendance/index/newAttendance/')?>',
                type: 'get',
                data: formdata,
                beforeSend: function(){
                    KTApp.block("form#newAttendanceForm",{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"success",
                        message:"Creating new Attendance ...."
                    });
                },
                success: function(r){
                    var obj = JSON.parse(r);
                    if(obj.status == 'ok'){
                        notifySuccess(obj.message);
                        var table = $.fn.dataTable.tables( { api: true } );
                        table.clear().draw();
                        window.location.reload();
                    }else{
                        Swal.fire('',obj.message,'warning');
                    }
                    KTApp.unblock('form#newAttendanceForm');
                    $('div#newAttendance').modal('hide');
                },
                error: function(){
                    KTApp.unblock('form#newAttendanceForm');
                }
            });
        })

    });

    Dropzone.autoDiscover = false;
    var options = {
        url: "<?php echo base_url('hrm/attendance/index/uploadtemplate');?>",
        paramName: "file", // The name that will be used to transfer the file
        maxFiles: 10,
        maxFilesize: 3, // MB
        success: function(file, response){
            let oldValue = $('input#uploadedfiles').val();
            if(oldValue.length > 0){
                oldValue = oldValue + 'LM-55';
            }
            let newValue =  oldValue + response.files;
            $('input#uploadedfiles').val(newValue);
        },
    };
    var expsenseDocs = new Dropzone("div#crop-image",options);

    function clockOut(attend){
        let $modal =  $('div#attendanceDetails');
        let $div = $modal.find('.modal-body');
        $div.html('');
        $modal.modal('show');
        $.ajax({
            url: '<?php echo base_url('hrm/attendance/index/clockOut/');?>' + attend,
            type: 'get',
            beforeSend: function(){
                KTApp.block($div,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Loading Attendance details ...."
                });
            },
            success: function (result){
                $div.html(result);
                KTApp.unblock($div);
            },
            error: function (xhr){
                $modal.modal('hide');
                KTApp.unblock($div);
                Swal.fire('',xhr.statusText,'warning');
            }
        })
    }

    function clockIn(attend){
        let $modal =  $('div#attendanceDetails');
        let $div = $modal.find('.modal-body');
        $div.html('');
        $modal.modal('show');
        $.ajax({
            url: '<?php echo base_url('hrm/attendance/index/clockIn/');?>' + attend,
            type: 'get',
            beforeSend: function(){
                KTApp.block($div,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Loading Attendance details ...."
                });
            },
            success: function (result){
                $div.html(result);
                KTApp.unblock($div);
            },
            error: function (xhr){
                $modal.modal('hide');
                KTApp.unblock($div);
                Swal.fire('',xhr.statusText,'warning');
            }
        })
    }

    function deleteAttend(attend){
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('hrm/leave/index/deleteAttend/attend')?>/'+attend,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.block("#lm_table_att",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Deleting Attendance ..."
                        });
                    },
                    success: function(result){
                        let obj = JSON.parse(result);
                        if( obj.status == 'ok'){
                            notifySuccess(obj.message);
                            KTApp.unblock('#lm_table_att');
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            Swal.fire('',obj.message,'warning');
                        }
                    },
                    error: function(xhr){
                        KTApp.unblock('#lm_table_att');
                        Swal.fire('',xhr.statusText,'warning');
                    }
                });
            }
        })
    }

    function details(attend){
        let $modal =  $('div#attendDetails');
        let $div = $modal.find('.modal-body');
        $div.html('');
        $modal.modal('show');
        $.ajax({
            url: '<?php echo base_url('/hrm/leave/index/detailsLeave/');?>' + leave,
            type: 'get',
            beforeSend: function(){
                KTApp.block($div,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Loading attendance details ...."
                });
            },
            success: function (result){
                $div.html(result);
                KTApp.unblock($div);
            },
            error: function (xhr){
                $modal.modal('hide');
                KTApp.unblock($div);
                Swal.fire('',xhr.statusText,'warning');
            }
        })
    }

    function modify(attend){
        let $modal =  $('div#attendDetails');
        let $div = $modal.find('.modal-body');
        $div.html('');
        $modal.modal('show');
        $.ajax({
            url: '<?php echo base_url('hrm/leave/index/modifyLeave/');?>' + leave,
            type: 'get',
            beforeSend: function(){
                KTApp.block($div,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Loading attendance details ...."
                });
            },
            success: function (result){
                $div.html(result);
                KTApp.unblock($div);
            },
            error: function (xhr){
                $modal.modal('hide');
                KTApp.unblock($div);
                Swal.fire('',xhr.statusText,'warning');
            }
        })
    }

    function deleteSelected(table){
        if(table.rows('.selected').data().length<1)
            return;
        var data= [];
        $.each(table.rows('.selected').data(), function() {
            data.push(this["group_key"]);
        });
        Swal.fire({
            title: 'Are you sure?',
            text: "You are going to DELETE " + table.rows('.selected').data().length + " groups",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Delete them!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('/customers/category/deleteselected/');?>',
                    type: 'get',
                    data: {'data':data},
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Please wait ..."
                        });
                    },
                    success: function(result){
                        let obj = JSON.parse(result);
                        if( obj.status == 'ok'){
                            notifySuccess(obj.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            Swal.fire('',obj.message,'warning');
                        }
                        KTApp.unblockPage();
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        Swal.fire('',xhr.statusText,'warning');
                    }
                });
            }
        })
    }

</script>