<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<form id="modifyAttendanceinForm" class="kt-form kt-form--fit kt-form--label-right" action="#" method="get" onsubmit="return false">
    <div class="modal-body">
        <div class="row form-group">
            <div class="col-4">
                <label>Employee Name</label>
                <input hidden type="text" name="att_user_id" value="<?php echo $attendance->att_user_id;?>" placeholder="" class="form-control"/>
                <input type="text" value="<?php echo $attendance->firstname;?> <?php echo $attendance->lastname;?>" placeholder="" class="form-control" readonly="readonly"/>
            </div>
            <div class="col-4">
                <label>Select Device</label>
                <select class="form-control kt-select2" id="kt_select2_1_modal" name="att_time_in_device">
                    <option>Select Device</option>
                    <?php if(!empty($device)):
                        foreach($device as $dev):?>
                            <option value="<?php echo $dev['device_number'];?>"><?php echo $dev['device_number'];?> - <?php echo $dev['device_name'];?></option>
                        <?php endforeach; endif;?>
                </select>
            </div>
            <div class="col-4">
                <label>Clock In</label>
                <input type="text" name="att_time_in" value="<?php echo date("H:i:s");?>" placeholder="" class="form-control" readonly="readonly"/>
            </div>
        </div>

    </div>
    <div class="modal-footer">
        <button type="button" class="btn btn-info" data-dismiss="modal">Close</button>
        <button type="submit" name="submit" class="btn btn-success">Clock In</button>
    </div>
</form>
<script type="text/javascript">
    $('form#modifyAttendanceinForm').submit( function(event){
        let form = $( this );
        event.preventDefault();
        let formdata = form.serialize();
        $.ajax({
            url: '<?php echo base_url('hrm/attendance/index/inAttendance/')?>',
            type: 'get',
            data: formdata,
            beforeSend: function(){
                KTApp.block(form,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Clocking in Employee ..."
                });
            },
            success: function(r){
                var obj = JSON.parse(r);
                if(obj.status == 'ok'){
                    $('div#attendanceDetails').modal('hide');
                    notifySuccess(obj.message);
                    var table = $.fn.dataTable.tables( { api: true } );
                    table.clear().draw();
                }else{
                    Swal.fire('',obj.message,'warning');
                }
                KTApp.unblock(form);
            },
            error: function(){
                $('div#attendanceDetails').modal('hide');
                KTApp.unblock(form);
            }
        });
    })
</script>