<script type="text/javascript">

  jQuery(document).ready(function() {
      $('select').css('width','100%');
      $('select').select2({placeholder: 'select option'});
      let height = $(window).innerHeight()  - 250;
      $('.lm_max_height').css({ height: height });
      $(window).resize(function(){
          $('.lm_max_height').css({ height: height });
      });
      //LMDatatableGroups.init();
      $('form#newDeviceForm').submit( function(event){
          let form = $( this );
          event.preventDefault();
          let formdata = form.serialize();
          $.ajax({
              url: '<?php echo base_url('hrm/attendance/index/newDevice/')?>',
              type: 'get',
              data: formdata,
              beforeSend: function(){
                  KTApp.block("form#newDeviceForm",{
                      overlayColor:"#000000",
                      type:"loader",
                      state:"success",
                      message:"Creating new Device ...."
                  });
              },
              success: function(r){
                  var obj = JSON.parse(r);
                  if(obj.status == 'ok'){
                      notifySuccess(obj.message);
                      var table = $.fn.dataTable.tables( { api: true } );
                      table.clear().draw();
                      window.location.reload();
                  }else{
                      Swal.fire('',obj.message,'warning');
                  }
                  KTApp.unblock('form#newDeviceForm');
                  $('div#newDevice').modal('hide');
              },
              error: function(){
                  KTApp.unblock('form#newDeviceForm');
              }
          });
      })

  });

  Dropzone.autoDiscover = false;
  var options = {
      url: "<?php echo base_url('hrm/attendance/index/uploadexpensedocsd');?>",
      paramName: "file", // The name that will be used to transfer the file
      maxFiles: 10,
      maxFilesize: 3, // MB
      success: function(file, response){
          let oldValue = $('input#uploadedfiles').val();
          if(oldValue.length > 0){
              oldValue = oldValue + 'LM-55';
          }
          let newValue =  oldValue + response.files;
          $('input#uploadedfiles').val(newValue);
      },
  };
  var expsenseDocs = new Dropzone("div#crop-image",options);

  function deleteDevice(device){
      Swal.fire({
          title: 'Are you sure?',
          text: "You won't be able to revert this!",
          type: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Yes, delete it!'
      }).then((result) => {
          if (result.value) {
              $.ajax({
                  url: '<?php echo base_url('hrm/attendance/index/deleteDevice/device')?>/'+device,
                  type: 'get',
                  beforeSend: function(){
                      KTApp.block("#lm_table_att",{
                          overlayColor:"#000000",
                          type:"loader",
                          state:"danger",
                          message:"Deleting Device ..."
                      });
                  },
                  success: function(result){
                      let obj = JSON.parse(result);
                      if( obj.status == 'ok'){
                          $('div#id-' + device).hide();
                          notifySuccess(obj.message);
                          //KTApp.unblock('#lm_table_att');
                          //var table = $.fn.dataTable.tables( { api: true } );
                          //table.clear().draw();
                      }else{
                          Swal.fire('',obj.message,'warning');
                      }
                  },
                  error: function(xhr){
                      //KTApp.unblock('#lm_table_att');
                      Swal.fire('',xhr.statusText,'warning');
                  }
              });
          }
      })
  }

  function modifyDevice(device){
      let $modal =  $('div#deviceDetails');
      let $div = $modal.find('.modal-body');
      $div.html('');
      $modal.modal('show');
      $.ajax({
          url: '<?php echo base_url('hrm/attendance/index/modifyDevice/');?>' + device,
          type: 'get',
          beforeSend: function(){
              KTApp.block($div,{
                  overlayColor:"#000000",
                  type:"loader",
                  state:"success",
                  message:"Loading Device details ...."
              });
          },
          success: function (result){
              $div.html(result);
              KTApp.unblock($div);
          },
          error: function (xhr){
              $modal.modal('hide');
              KTApp.unblock($div);
              Swal.fire('',xhr.statusText,'warning');
          }
      })
  }

  function setActives(device){
      Swal.fire({
          title: 'Are you sure?',
          text: "You are about to ACTIVATE a Device!",
          type: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Yes, Activate it!'
      }).then((result) => {
          if (result.value) {
              $.ajax({
                  url: "<?php echo base_url('hrm/attendance/index/activateDevice/');?>" + device,
                  type: "get",
                  beforeSend: function(){
                      KTApp.block("#lm_table_task",{
                          overlayColor:"#000000",
                          type:"loader",
                          state:"danger",
                          message:"Starting a Device assigned ..."
                      });
                  },
                  success: function(result){
                      let obj = JSON.parse(result);
                      if( obj.status == 'ok'){
                          notifySuccess(obj.message);
                          KTApp.unblock('#lm_table_task');
                          var table = $.fn.dataTable.tables( { api: true } );
                          table.clear().draw();
                      }else{
                          Swal.fire('',obj.message,'warning');
                      }
                  },
                  error: function(xhr){
                      KTApp.unblock('#lm_table_task');
                      Swal.fire('',xhr.statusText,'warning');
                  }

              })
          }
      })
  }

  function setInactives(device){
      Swal.fire({
          title: 'Are you sure?',
          text: "You are about to DEACTIVATE a Device!",
          type: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Yes, Deactivate it!'
      }).then((result) => {
          if (result.value) {
              $.ajax({
                  url: "<?php echo base_url('hrm/attendance/index/deactivateDevice/');?>" + device,
                  type: "get",
                  beforeSend: function(){
                      KTApp.block("#lm_table_task",{
                          overlayColor:"#000000",
                          type:"loader",
                          state:"danger",
                          message:"Deactivating Device assigned ..."
                      });
                  },
                  success: function(result){
                      let obj = JSON.parse(result);
                      if( obj.status == 'ok'){
                          notifySuccess(obj.message);
                          KTApp.unblock('#lm_table_task');
                          var table = $.fn.dataTable.tables( { api: true } );
                          table.clear().draw();
                      }else{
                          Swal.fire('',obj.message,'warning');
                      }
                  },
                  error: function(xhr){
                      KTApp.unblock('#lm_table_task');
                      Swal.fire('',xhr.statusText,'warning');
                  }

              })
          }
      })
  }

  function setOnline(device){
      Swal.fire({
          title: 'Are you sure?',
          text: "You are about to START your Device!",
          type: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Yes, Start it!'
      }).then((result) => {
          if (result.value) {
              $.ajax({
                  url: "<?php echo base_url('hrm/attendance/index/onlineDevice/');?>" + device,
                  type: "get",
                  beforeSend: function(){
                      KTApp.block("#lm_table_task",{
                          overlayColor:"#000000",
                          type:"loader",
                          state:"danger",
                          message:"Starting device assigned ..."
                      });
                  },
                  success: function(result){
                      let obj = JSON.parse(result);
                      if( obj.status == 'ok'){
                          notifySuccess(obj.message);
                          KTApp.unblock('#lm_table_task');
                          var table = $.fn.dataTable.tables( { api: true } );
                          table.clear().draw();
                      }else{
                          Swal.fire('',obj.message,'warning');
                      }
                  },
                  error: function(xhr){
                      KTApp.unblock('#lm_table_task');
                      Swal.fire('',xhr.statusText,'warning');
                  }

              })
          }
      })
  }

  function setOffline(device){
      Swal.fire({
          title: 'Are you sure?',
          text: "You are about to SWITCH OFF a Device!",
          type: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Yes, SWITCH OFF!'
      }).then((result) => {
          if (result.value) {
              $.ajax({
                  url: "<?php echo base_url('hrm/attendance/index/offlineDevice/');?>" + device,
                  type: "get",
                  beforeSend: function(){
                      KTApp.block("#lm_table_task",{
                          overlayColor:"#000000",
                          type:"loader",
                          state:"danger",
                          message:"Switching off device ..."
                      });
                  },
                  success: function(result){
                      let obj = JSON.parse(result);
                      if( obj.status == 'ok'){
                          notifySuccess(obj.message);
                          KTApp.unblock('#lm_table_task');
                          var table = $.fn.dataTable.tables( { api: true } );
                          table.clear().draw();
                      }else{
                          Swal.fire('',obj.message,'warning');
                      }
                  },
                  error: function(xhr){
                      KTApp.unblock('#lm_table_task');
                      Swal.fire('',xhr.statusText,'warning');
                  }

              })
          }
      })
  }

</script>