<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<div class="kt-portlet kt-portlet--head-md kt-portlet--responsive-mobile" id="kt_page_portlet">
    <form id="experienceForm" onsubmit="return false;" class="kt-form kt-form--label-right">
        <div class="kt-todo__header">
            <h3 class="kt-todo__title"><?php echo $employee->firstname;?> <?php echo $employee->lastname; ?> <span class="pull-right">Work Experience</span></h3>
        </div>
        <div class="kt-portlet__body">
            <div class="form-group row">
                <input type="text" hidden class="form-control" name="user_exp_user_key" value="<?php echo $employee->user_key;?>" placeholder="Enter description">
                <div class="col-lg-6">
                    <label>Company Name:</label>
                    <input type="text" class="form-control" name="user_exp_company" placeholder="example company">
                </div>
                <div class="col-lg-6">
                    <label>Title:</label>
                    <input type="text" class="form-control" name="user_exp_title" placeholder="eg.. ceo">
                </div>

            </div>
            <div class="form-group row">
                <div class="col-lg-4">
                    <label>From:</label>
                    <input type="date" class="form-control" name="user_exp_from" placeholder="from">
                </div>
                <div class="col-lg-4">
                    <label>To:</label>
                    <input type="date" class="form-control" name="user_exp_to" placeholder="to">
                </div>

            </div>

            <div class="row">
                <div class="col-lg-6">
                    <button type="reset" class="btn btn-secondary">Clear</button>
                </div>
                <div class="col-lg-6 kt-align-right">
                    <button type="submit" name="submit" class="btn btn-success">Save</button>
                </div>
            </div>
        </div>
    </form>

    <div class="kt-portlet__body">
        <!-- <div class="kt-datatable" id="applicationTable"></div> -->
        <table class="table table-bordered table-hover table-checkable" id="lm_table_experience">
            <thead>
            <tr>
                <th>Company</th>
                <th>From</th>
                <th>To</th>
                <th>Title</th>
                <th>Action</th>
            </tr>
            </thead>
        </table>
    </div>
</div>

<script type="text/javascript">
    //== Class definition
    $.fn.dataTable.Api.register('column().title()', function() {
        return $(this.header()).text().trim();
    });

    var Datatable = function() {
        var initTable = function() {
            var events = $('#lm_table_experience');
            // begin first table
            events.DataTable({
                responsive: true,
                buttons: [
                    'print',
                    'copyHtml5',
                    'excelHtml5',
                    'csvHtml5',
                    'pdfHtml5',
                ],
                dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
			<'row'<'col-sm-12'tr>>
			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                searchDelay: 500,
                processing: true,
                serverSide: false,
                ajax: '<?php echo base_url('hrm/employees/index/datasourceExperience/'.$employee->user_key);?>',
                columns: [
                    {data: 'user_exp_company'},
                    {data: 'user_exp_from'},
                    {data: 'user_exp_to'},
                    {data: 'user_exp_title'},
                    {data: 'action'},
                ],
                initComplete: function() {
                    this.api().columns().every(function() {
                        var column = this;

                        switch (column.title()) {
                            case 'Status':
                                column.data().unique().sort().each(function(d, j) {
                                    $('.kt-input[data-col-index="6"]').append('<option value="' + d + '">' + d + '</option>');
                                });
                                break;
                            case 'Region':
                                column.data().unique().sort().each(function(d, j) {
                                    $('.kt-input[data-col-index="4"]').append('<option value="' + d + '">' + d + '</option>');
                                });
                                break;
                            case 'District':
                                column.data().unique().sort().each(function(d, j) {
                                    $('.kt-input[data-col-index="5"]').append('<option value="' + d + '">' + d + '</option>');
                                });
                                break;
                        }
                    });
                },
                columnDefs: [
                    {
                        targets: 0,
                        render: function(data, type, full, meta) {
                            return (data);
                        }
                    },
                    {
                        targets: 1,
                        render: function(data, type, full, meta) {
                            return (data);
                        }
                    },
                    {
                        targets: 4,
                        render: function(data, type, full, meta){
                            return ' <a href="javascript:deleteItem(' + full.user_exp_key + ');"><i class="flaticon-delete text-danger"></i></a>';
                        }
                    }

                ],
            });

            var filter = function() {
                var val = $.fn.dataTable.util.escapeRegex($(this).val());
                let table = $.fn.dataTable.tables( { api: true } );
                table.column($(this).data('col-index')).search(val ? val : '', false, false).draw();
            };

            var asdasd = function(value, index) {
                let table = $.fn.dataTable.tables( { api: true } );
                var val = $.fn.dataTable.util.escapeRegex(value);
                table.column(index).search(val ? val : '', false, true);
            };

            $('#m_search').on('click', function(e) {
                e.preventDefault();
                let table = $.fn.dataTable.tables( { api: true } );
                var params = {};
                $('.kt-input').each(function() {
                    var i = $(this).data('col-index');
                    if (params[i]) {
                        params[i] += '|' + $(this).val();
                    }
                    else {
                        params[i] = $(this).val();
                    }
                });
                $.each(params, function(i, val) {
                    // apply search params to datatable
                    table.column(i).search(val ? val : '', false, false);
                });
                table.table().draw();
            });

            $('#m_reset').on('click', function(e) {
                e.preventDefault();
                let table = $.fn.dataTable.tables( { api: true } );
                $('.kt-input').each(function() {
                    $(this).val('');
                    table.column($(this).data('col-index')).search('', false, false);
                });
                table.table().draw();
            });

        };

        return {
            //main function to initiate the module
            init: function() {
                initTable();
            },

        };

    }();

    jQuery(document).ready(function() {
        Datatable.init();
    });

    $('form#experienceForm').submit(function (event) {
        let form = $(this);
        let $div = $('div#kt_page_portlet');
        event.preventDefault();
        let formdata = form.serialize();
        $.ajax({
            url: '<?php echo base_url('hrm/employees/index/newExperience/')?>',
            type: 'get',
            data: formdata,
            beforeSend: function () {
                KTApp.block($div, {
                    overlayColor: "#000000",
                    type: "loader",
                    state: "success",
                    message: "Updating Employee Experience ...."
                });
            },
            success: function (r) {
                var obj = JSON.parse(r);
                if (obj.status == 'ok') {
                    $div.load("<?php echo base_url('hrm/employees/index/loadInformationExperience/' . $employee->user_key);?>");
                    Swal.fire('', obj.message, 'success');
                } else {
                    Swal.fire('', obj.message, 'warning');
                }
                KTApp.unblock($div);
            },
            error: function () {
                Swal.fire('', obj.message, 'success');
                KTApp.unblock($div);
            }
        });
    })

    function deleteItem(experience){
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('hrm/employees/index/deleteExperience/experience')?>/'+experience,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.block("#lm_table_experience",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Deleting Experience data ..."
                        });
                    },
                    success: function(result){
                        let obj = JSON.parse(result);
                        if( obj.status == 'ok'){
                            notifySuccess(obj.message);
                            KTApp.unblock('#lm_table_experience');
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            Swal.fire('',obj.message,'warning');
                        }
                    },
                    error: function(xhr){
                        KTApp.unblock('#lm_table_experience');
                        Swal.fire('',xhr.statusText,'warning');
                    }
                });
            }
        })
    }
</script>