<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<div class="kt-portlet kt-portlet--head-md kt-portlet--responsive-mobile" id="kt_page_portlet">
    <form id="familyForm" onsubmit="return false;" class="kt-form kt-form--label-right">
    <div class="kt-todo__header">
        <h3 class="kt-todo__title"><?php echo $employee->firstname;?> <?php echo $employee->lastname; ?> <span class="pull-right">Family History</span></h3>
    </div>
    <div class="kt-portlet__body">
        <div class="form-group row">
            <input type="text" hidden class="form-control" name="user_fam_user_key" value="<?php echo $employee->user_key;?>" placeholder="Enter description">
            <div class="col-lg-4">
                <label>Firstname:</label>
                <input type="text" class="form-control" name="user_fam_fname" placeholder="firstname">
            </div>
            <div class="col-lg-4">
                <label>Middlename:</label>
                <input type="text" class="form-control" name="user_fam_mname" placeholder="middlename">
            </div>
            <div class="col-lg-4">
                <label>Lastname:</label>
                <input type="text" class="form-control" name="user_fam_lname" placeholder="lastname">
            </div>
        </div>
        <div class="form-group row">
            <div class="col-lg-4">
                <label>DOB:</label>
                <input type="date" class="form-control" id="user_fam_dob" name="user_fam_dob" placeholder="date">
            </div>
            <div class="col-lg-4">
                <label>Relation:</label>
                <select class="form-control kt-select2" id="kt_select2_3_modal" name="user_fam_relation">
                    <option>Select Relation</option>
                    <option value="Child">Child</option>
                    <option value="Next of Kin">Next of Kin</option>
                    <option value="Father">Father</option>
                    <option value="Mother">Mother</option>
                    <option value="Brother">Brother</option>
                    <option value="Sister">Sister</option>
                    <option value="Uncle">Uncle</option>
                    <option value="Aunt">Aunt</option>
                </select>
            </div>
            <div class="col-lg-4">
                <label>Gender:</label>
                <select class="form-control kt-select2" id="kt_select2_3_modal" name="user_fam_gender">
                    <option>Select Gender</option>
                    <option value="Male">Male</option>
                    <option value="Female">Female</option>
                </select>
            </div>
        </div>
        <div class="form-group row">
            <input type="text" hidden class="form-control" name="user_fam_user_key" value="<?php echo $employee->user_key;?>" placeholder="Enter description">
            <div class="col-lg-6">
                <label>Email:</label>
                <input type="email" class="form-control" name="user_fam_email" placeholder="email">
            </div>
            <div class="col-lg-6">
                <label>Phonenumber:</label>
                <input type="text" class="form-control" name="user_fam_phone" placeholder="number">
            </div>
        </div>
        <div class="row">
            <div class="col-lg-6">
                <button type="reset" class="btn btn-secondary">Clear</button>
            </div>
            <div class="col-lg-6 kt-align-right">
                <button type="submit" name="submit" class="btn btn-success">Save</button>
            </div>
        </div>

    </div>
</form>

    <div class="kt-portlet__body">
        <!-- <div class="kt-datatable" id="applicationTable"></div> -->
        <table class="table table-bordered table-hover table-checkable" id="lm_table_family">
            <thead>
            <tr>
                <th>Firstname</th>
                <th>Lastname</th>
                <th>Gender</th>
                <th>Relation</th>
                <th>Contact</th>
                <th>Action</th>
            </tr>
            </thead>
        </table>
    </div>
</div>

<script type="text/javascript">
    //== Class definition
    $.fn.dataTable.Api.register('column().title()', function() {
        return $(this.header()).text().trim();
    });

    var Datatable = function() {
        var initTable = function() {
            var events = $('#lm_table_family');
            // begin first table
            events.DataTable({
                responsive: true,
                buttons: [
                    'print',
                    'copyHtml5',
                    'excelHtml5',
                    'csvHtml5',
                    'pdfHtml5',
                ],
                dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
			<'row'<'col-sm-12'tr>>
			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                searchDelay: 500,
                processing: true,
                serverSide: false,
                ajax: '<?php echo base_url('hrm/employees/index/datasourceFamily/'.$employee->user_key);?>',
                columns: [
                    {data: 'user_fam_fname'},
                    {data: 'user_fam_lname'},
                    {data: 'user_fam_gender'},
                    {data: 'user_fam_relation'},
                    {data: 'user_fam_phone'},
                    {data: 'action'},
                ],
                initComplete: function() {
                    this.api().columns().every(function() {
                        var column = this;

                        switch (column.title()) {
                            case 'Status':
                                column.data().unique().sort().each(function(d, j) {
                                    $('.kt-input[data-col-index="6"]').append('<option value="' + d + '">' + d + '</option>');
                                });
                                break;
                            case 'Region':
                                column.data().unique().sort().each(function(d, j) {
                                    $('.kt-input[data-col-index="4"]').append('<option value="' + d + '">' + d + '</option>');
                                });
                                break;
                            case 'District':
                                column.data().unique().sort().each(function(d, j) {
                                    $('.kt-input[data-col-index="5"]').append('<option value="' + d + '">' + d + '</option>');
                                });
                                break;
                        }
                    });
                },
                columnDefs: [
                    {
                        targets: 0,
                        render: function(data, type, full, meta) {
                            return (data);
                        }
                    },
                    {
                        targets: 1,
                        render: function(data, type, full, meta) {
                            return (data);
                        }
                    },
                    {
                        targets: 5,
                        render: function(data, type, full, meta){
                            return ' <a href="javascript:deleteItem(' + full.user_fam_key + ');"><i class="flaticon-delete text-danger"></i></a> | <a data-backdrop="false" href="javascript:detailsFamily(' + full.user_fam_key + ');"><i class="flaticon2-paper"></i>More</a>';
                        }
                    }

                ],
            });

            var filter = function() {
                var val = $.fn.dataTable.util.escapeRegex($(this).val());
                let table = $.fn.dataTable.tables( { api: true } );
                table.column($(this).data('col-index')).search(val ? val : '', false, false).draw();
            };

            var asdasd = function(value, index) {
                let table = $.fn.dataTable.tables( { api: true } );
                var val = $.fn.dataTable.util.escapeRegex(value);
                table.column(index).search(val ? val : '', false, true);
            };

            $('#m_search').on('click', function(e) {
                e.preventDefault();
                let table = $.fn.dataTable.tables( { api: true } );
                var params = {};
                $('.kt-input').each(function() {
                    var i = $(this).data('col-index');
                    if (params[i]) {
                        params[i] += '|' + $(this).val();
                    }
                    else {
                        params[i] = $(this).val();
                    }
                });
                $.each(params, function(i, val) {
                    // apply search params to datatable
                    table.column(i).search(val ? val : '', false, false);
                });
                table.table().draw();
            });

            $('#m_reset').on('click', function(e) {
                e.preventDefault();
                let table = $.fn.dataTable.tables( { api: true } );
                $('.kt-input').each(function() {
                    $(this).val('');
                    table.column($(this).data('col-index')).search('', false, false);
                });
                table.table().draw();
            });

        };

        return {
            //main function to initiate the module
            init: function() {
                initTable();
            },

        };

    }();

    jQuery(document).ready(function() {
        Datatable.init();
    });

    $('form#familyForm').submit(function (event) {
        let form = $(this);
        let $div = $('div#kt_page_portlet');
        event.preventDefault();
        let formdata = form.serialize();
        $.ajax({
            url: '<?php echo base_url('hrm/employees/index/newFamily/')?>',
            type: 'get',
            data: formdata,
            beforeSend: function () {
                KTApp.block($div, {
                    overlayColor: "#000000",
                    type: "loader",
                    state: "success",
                    message: "Updating Employee family ...."
                });
            },
            success: function (r) {
                var obj = JSON.parse(r);
                if (obj.status == 'ok') {
                    $div.load("<?php echo base_url('hrm/employees/index/loadInformationFamily/' . $employee->user_key);?>");
                    Swal.fire('', obj.message, 'success');
                } else {
                    Swal.fire('', obj.message, 'warning');
                }
                KTApp.unblock($div);
            },
            error: function () {
                Swal.fire('', obj.message, 'success');
                KTApp.unblock($div);
            }
        });
    })

    function deleteItem(family){
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('hrm/employees/index/deleteFamily/family')?>/'+family,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.block("#lm_table_family",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Deleting Education data ..."
                        });
                    },
                    success: function(result){
                        let obj = JSON.parse(result);
                        if( obj.status == 'ok'){
                            notifySuccess(obj.message);
                            KTApp.unblock('#lm_table_family');
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            Swal.fire('',obj.message,'warning');
                        }
                    },
                    error: function(xhr){
                        KTApp.unblock('#lm_table_family');
                        Swal.fire('',xhr.statusText,'warning');
                    }
                });
            }
        })
    }

    function detailsFamily(family){
        let $modal =  $('div#familyDetails');
        let $div = $modal.find('.modal-body');
        $div.html('');
        $modal.modal('show');
        $.ajax({
            url: '<?php echo base_url('hrm/employees/index/detailsFamily/');?>' + family,
            type: 'get',
            beforeSend: function(){
                KTApp.block($div,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Loading more details ...."
                });
            },
            success: function (result){
                $div.html(result);
                KTApp.unblock($div);
            },
            error: function (xhr){
                $modal.modal('hide');
                KTApp.unblock($div);
                Swal.fire('',xhr.statusText,'warning');
            }
        })
    }
</script>

