<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<form id="modifyRequestForm" class="kt-form" action="#" method="get" onsubmit="return false">
    <div class="form-group row">
        <div class="col-12">
            <input type="text" value="<?php echo $leave->firstname;?> <?php echo $leave->lastname;?>" class="form-control" readonly="readonly">
        </div>
    </div>
    <div class="form-group row">
        <label>Leave Selected</label>
        <div class="col-12">
            <select class="form-control" name="leave_request_leave_key">
                <option value=""></option>
                <?php if($leaves){
                    foreach ($leaves as $key => $leav) {?>
                        <option value="<?php echo $leav['hrm_leave_schemes_titles_key'];?>"><?php echo $leav['hrm_leave_schemes_titles_title'];?></option>
                    <?php }
                } ?>
            </select>
        </div>
    </div>
    <div class="form-group row">
        <label>From</label>
        <div class="col-12">
            <input type="date" name="leave_request_from" value="<?php echo $leave->leave_request_from;?>" class="form-control" placeholder="">
        </div>
    </div>
    <div class="form-group row">
        <label>To</label>
        <div class="col-12">
            <input type="date" name="leave_request_to" value="<?php echo $leave->leave_request_to;?>" class="form-control" placeholder="">
        </div>
    </div>
    <div class="form-group row">
        <label>Reason</label>
        <div class="col-12">
            <textarea class="form-control" name="leave_request_desc" rows="5" cols="80" readonly="readonly"><?php echo $leave->leave_request_desc;?></textarea>
        </div>
    </div>

    <div class="form-group row">
        <label>Request Status</label>
        <div class="col-12">
            <select class="form-control" name="leave_request_status">
               <option value="Approved">Approve</option>
              <option value="Not Approved">Decline Request</option>
            </select>
        </div>
    </div>

  </div>

  <div class="form-group row">
    <label class="col-8 col-form-label"></label>
    <div class="col-4">
      <button type="submit" class="btn btn-sm btn-block btn-warning" name="button"><b>Update Request</b></button>
    </div>
  </div>
</form>
<script type="text/javascript">
$('form#modifyRequestForm').submit( function(event){
  let form = $( this );
  event.preventDefault();
  let formdata = form.serialize();
  $.ajax({
   url: '<?php echo base_url('/hrm/leave/index/updateRequest/'.$leave->leave_request_key);?>' ,
    type: 'get',
    data: formdata,
    beforeSend: function(){
        KTApp.block(form,{
                overlayColor:"#000000",
                type:"loader",
                state:"success",
                message:"Updating Leave request ..."
            });
      },
     success: function(r){
          var obj = JSON.parse(r);
          if(obj.status == 'ok'){
            $('div#leaveDetails').modal('hide');
            notifySuccess(obj.message);
            var table = $.fn.dataTable.tables( { api: true } );
            table.clear().draw();
            }else{
                Swal.fire('',obj.message,'warning');
            }
            KTApp.unblock(form);
         },
      error: function(){
          $('div#leaveDetails').modal('hide');
          KTApp.unblock(form);
          }
  });
})
</script>