<!-- begin::Body -->
<?php include VIEWPATH . '/employee/includes/header.styles.php'; ?>
<div class="kt-portlet__body">
    <div class="row">
        <div class="col-7">
            <h5>Roles for <b><?php echo $category->category_name; ?></b></h5></div>
        <div class="col-5">
            <div class="dropdown pull-right">
                <a href="#" class="btn btn-label-brand btn-bold btn-sm dropdown-toggle" data-toggle="dropdown" aria-expanded="false">
                    Got Role
                </a>
                <div class="dropdown-menu dropdown-menu-sm" aria-labelledby="dropdownMenuButton" x-placement="bottom-start" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(0px, 28px, 0px);">

                    <!--begin::Nav-->
                    <ul class="kt-nav">
                        <?php if (!empty($groups = roles_groups())) {
                            foreach ($groups as $key => $group) {?>
                                <li class="kt-nav__item">
                                    <a href="#role-<?= ucfirst($group['role_group'])?>" class="kt-nav__link">
                                        <span class="kt-nav__link-text"><?= $group['role_group']?></span>
                                    </a>
                                </li>
                            <?php } } ?>
                    </ul>

                    <!--end::Nav-->
                </div>
            </div>
        </div>
    </div>
    <div class="kt-separator kt-separator--space-sm  kt-separator--border-dashed"></div>
    <div class="kt-section">
        <?php if (!empty($groups = roles_groups())) {
            foreach ($groups as $key => $group) {
                if ($key > 0) {
                    echo '<br/>';
                } ?>
                <div id="role-<?php echo ucfirst(strtolower($group['role_group'])); ?>"></div>
                <div  class="kt-section__<?php echo $group['role_class'];?>"><?php echo ucfirst(strtolower($group['role_group'])); ?>:</div>
                <div class="kt-section__content kt-section__content--solid">
                    <div class="row " style="background:transparent;">
                        <?php if (!empty($roles)) {
                            $i = 1;
                            foreach ($roles as $key => $role) {
                                if (strtolower($role['role_group']) == strtolower($group['role_group'])) {
                                    ?>
                                    <div class="col-md-4">
                                        <div title="<?php echo $role['role_details']; ?>" class="row form-group kt-bg-light-<?php echo $role['role_class']; ?>" style="border-radius: 6px; margin-right: 5px;">
                                            <label class="col-9" style="vertical-align: bottom; padding-top: 10px;"><span  ><?php echo $role['role_name']; ?></span></label>
                                            <div class="col-2" style="vertical-align: bottom; padding-top: 4px;">
                                              <span class="kt-switch kt-switch--sm kt-switch--icon kt-switch kt-switch--outline kt-switch--icon kt-switch--<?php echo $role['role_class']; ?>">
                                                <label>
                                                  <input type="checkbox"
                                                         data-url="<?php echo base_url('/hrm/employees/roles/titleAction/' . $category->category_id . '/' . urlencode($role['role_action'])); ?>"
                                                         class="user-role-check-box" <?php if (isTitleAction($category->category_id, $role['role_action'])) echo 'checked="checked"'; ?>>
                                                  <span></span>
                                                </label>
                                              </span>
                                            </div>
                                        </div>
                                    </div>
                                    <?php $i++;
                                }
                            }
                        } ?>
                    </div>
                </div>
            <?php }
        } ?>
    </div>

</div>
<!--end::Global App Bundle -->
<script type="text/javascript">
    $('.user-role-check-box').change(function (e) {

        let $input = $(this);

        e.preventDefault();

        let $url = $input.data('url');
        $.ajax({
            url: $url,
            type: 'get',
            beforeSend: function(){
                KTApp.blockPage({
                    overlayColor:"#000000",
                    type:"loader",
                    state:"danger",
                    message:"Please wait ..."
                });
            },
            success: function (result) {
                KTApp.unblockPage();
                if ($input.prop('checked')) {
                    if (result.status == true) {
                        notifySuccess(result.message);
                        $input.prop('checked', true);
                    } else {
                        notifyWarning(result.message);
                        $input.prop('checked', false);
                    }
                } else {
                    if (result.status == true) {
                        notifySuccess(result.message);
                        $input.prop('checked', false);
                    } else {
                        notifyWarning(result.message);
                        $input.prop('checked', true);
                    }
                }
            },
            error: function () {
                KTApp.unblockPage();
                result = false;
            }
        });
    });
</script>
</body>

<!-- end::Body -->
</html>
