<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<form id="modifyTitleForm" class="kt-form" action="#" method="get" onsubmit="return false">
    <div class="form-group row">
        <div class="col-12">
            <input type="text" name="title_name" value="<?php echo $title->title_name; ?>" class="form-control"
                   placeholder="Title name">
        </div>
    </div>
    <div class="form-group row">
        <div class="col-12">
            <textarea class="form-control" name="title_details" rows="4" cols="80"
                      placeholder="Title details"><?php echo $title->title_details; ?></textarea>
        </div>
    </div>
    <div class="form-group row">
        <label class="col-8 col-form-label"></label>
        <div class="col-4">
            <button type="submit" class="btn btn-sm btn-block btn-warning" name="button"><b>Save Changes</b></button>
        </div>
    </div>
</form>
<script type="text/javascript">
    $('form#modifyTitleForm').submit(function (event) {
        let form = $(this);
        event.preventDefault();
        let formdata = form.serialize();
        $.ajax({
            url: '<?php echo base_url('employee/administration/employees/titles/update/' . $title->title_key);?>',
            type: 'get',
            data: formdata,
            beforeSend: function () {
                KTApp.block(form, {
                    overlayColor: "#000000",
                    type: "loader",
                    state: "success",
                    message: "Updating Title ..."
                });
            },
            success: function (r) {
                var obj = JSON.parse(r);
                if (obj.status == 'ok') {
                    $('.kt-datatable').KTDatatable('reload');
                    $('div#titleDetails').modal('hide');
                    Swal.fire('', obj.message, 'success');
                } else {
                    Swal.fire('', obj.message, 'warning');
                }
                KTApp.unblock(form);
            },
            error: function () {
                $('div#titleDetails').modal('hide');
                KTApp.unblock(form);
            }
        });
    })
</script>
