<script type="text/javascript">

  var LMDatatableGroups= function() {
    	var initTable = function() {
    		// begin first table
    		var table = $('#titles').DataTable({
    			responsive: true,
    			// Pagination settings
    			dom: `<'row'<'col-sm-12'tr>>
    			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
    			// read more: https://datatables.net/examples/basic_init/dom.html

    			lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
    			pageLength: 10,
    			language: {
    				'lengthMenu': 'Display _MENU_',
            buttons: {
                selectAll: "Select all",
                selectNone: "Select none"
            },
            "emptyTable": "No record found",
    			},
    			searchDelay: 500,
    			processing: true,
    			serverSide: true,
    			select:true,
            "ajax":"<?php echo base_url('/hrm/employees/titles/datasource');?>",
    			dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
    			<'row'<'col-sm-12'tr>>
    			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
    			buttons: [
            {
              text: 'Delete Seleted',
              action: function ( e, dt, node, config ) {
                  deleteSelected( table);
                }
            },
            'selectAll',
            'selectNone',
    				'excelHtml5',
    				'pdfHtml5',
    			],
          columns: [
              {data: 'category_name'},
              {data: 'category_details'},
              {data: 'actions'},
          ],
          columnDefs: [
            {
              targets: 0,
                "width": "30%",
              render: function(data, type, full, meta){
                return ucfirst(data);
              }
            },
              {
                  targets: 2,
                  "width": "10%",
                  render: function(data, type, full, meta){
                      return'<a href="javascript:modifyTitle(' + full.category_key + ');" data-backdrop="false"><i class="flaticon-edit text-warning"></i></a> | ' +
                          '<a href="javascript:deleteTitle(' + full.category_key + ');" data-backdrop="false"><i class="flaticon-delete text-danger"></i></a>';
                  }
              }
          ],
    		});
    	};

    	return {
    		//main function to initiate the module
    		init: function() {
    			initTable();
    		},

    	};

    }();

  jQuery(document).ready(function() {
    $('select').css('width','100%');
    $('select').select2({placeholder: 'select option'});
    let height = $(window).innerHeight()  - 250;
    $('.lm_max_height').css({ height: height });
    $(window).resize(function(){
      $('.lm_max_height').css({ height: height });
    });
  	LMDatatableGroups.init();
    $('form#newTitleForm').submit( function(event){
      let form = $( this );
      event.preventDefault();
      let formdata = form.serialize();
      $.ajax({
          url: '<?php echo base_url('hrm/employees/titles/newTitle/')?>',
        type: 'get',
        data: formdata,
        beforeSend: function(){
            KTApp.block("form#newTitleForm",{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Creating new Title ...."
                });
          },
         success: function(r){
              var obj = JSON.parse(r);
              if(obj.status == 'ok'){
                notifySuccess(obj.message);
                var table = $.fn.dataTable.tables( { api: true } );
                table.clear().draw();
                }else{
                    Swal.fire('',obj.message,'warning');
                }
                KTApp.unblock('form#newTitleForm');
                $('div#newTitle').modal('hide');
             },
          error: function(){
              KTApp.unblock('form#newTitleForm');
              }
      });
    })

  });

  function deleteTitle(title){
    Swal.fire({
      title: 'Are you sure?',
      text: "You won't be able to revert this!",
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      confirmButtonText: 'Yes, delete it!'
    }).then((result) => {
      if (result.value) {
        $.ajax({
            url: '<?php echo base_url('hrm/employees/titles/delete/title')?>/' + title,
            type: 'get',
            beforeSend: function(){
                KTApp.block("#titles",{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"Deleting titles ..."
                    });
              },
             success: function(result){
                 let obj = JSON.parse(result);
                     if( obj.status == 'ok'){
                       notifySuccess(obj.message);
                       KTApp.unblock('#titles');
                       var table = $.fn.dataTable.tables( { api: true } );
                       table.clear().draw();
                      }else{
                        Swal.fire('',obj.message,'warning');
                      }
                 },
              error: function(xhr){
                  KTApp.unblock('#titles');
                  Swal.fire('',xhr.statusText,'warning');
                  }
        });
      }
    })
  }

  function TitleDetails(title){
    let $modal =  $('div#titleDetails');
    let $div = $modal.find('.modal-body');
    $div.html('');
    $modal.modal('show');
    $.ajax({
        url: '<?php echo base_url('hrm/employees/titles/details/');?>' + title,
      type: 'get',
      beforeSend: function(){
      KTApp.block($div,{
              overlayColor:"#000000",
              type:"loader",
              state:"success",
              message:"Loading Title details ...."
          });
      },
      success: function (result){
        $div.html(result);
        KTApp.unblock($div);
      },
      error: function (xhr){
        $modal.modal('hide');
        KTApp.unblock($div);
        Swal.fire('',xhr.statusText,'warning');
      }
    })
  }

  function modifyTitle(title){
    let $modal =  $('div#titleDetails');
    let $div = $modal.find('.modal-body');
    $div.html('');
    $modal.modal('show');
    $.ajax({
        url: '<?php echo base_url('hrm/employees/titles/modify/');?>' + title,
      type: 'get',
      beforeSend: function(){
      KTApp.block($div,{
              overlayColor:"#000000",
              type:"loader",
              state:"success",
              message:"Loading title details ...."
          });
      },
      success: function (result){
        $div.html(result);
        KTApp.unblock($div);
      },
      error: function (xhr){
        $modal.modal('hide');
        KTApp.unblock($div);
        Swal.fire('',xhr.statusText,'warning');
      }
    })
  }

  function deleteSelected(table){
    if(table.rows('.selected').data().length<1)
    return;
    var data= [];
   $.each(table.rows('.selected').data(), function() {
     data.push(this["category_key"]);
   });
    Swal.fire({
      title: 'Are you sure?',
      text: "You are going to DELETE " + table.rows('.selected').data().length + " category",
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      confirmButtonText: 'Yes, Delete them!'
    }).then((result) => {
      if (result.value) {
        $.ajax({
            url: '<?php echo base_url('/customers/category/deleteselected/');?>',
            type: 'get',
            data: {'data':data},
            beforeSend: function(){
                KTApp.blockPage({
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"Please wait ..."
                    });
              },
             success: function(result){
                   let obj = JSON.parse(result);
                     if( obj.status == 'ok'){
                        notifySuccess(obj.message);
                        var table = $.fn.dataTable.tables( { api: true } );
                        table.clear().draw();
                      }else{
                        Swal.fire('',obj.message,'warning');
                      }
                   KTApp.unblockPage();
                 },
             error: function(xhr){
                KTApp.unblockPage();
                Swal.fire('',xhr.statusText,'warning');
                }
        });
      }
    })
  }

</script>