<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<form id="modifyWorkdaySchemeForm" class="kt-form" action="#" method="get" onsubmit="return false">
        <div class="form-group row">
            <div class="col-12">
                <label>Scheme WorkDay</label>
                <input type="text" hidden name="hrm_workdays_scheme_days_workdays_schemes_key" value="<?php echo $workday->hrm_workdays_scheme_days_workdays_schemes_key;?>" class="form-control">
                <input type="text" class="form-control" placeholder="<?php echo $workday->hrm_workdays_scheme_title;?>">
            </div>
        </div>

    <div class="form-group row">
        <div class="col-12">
            <label>Select Day</label>
            <select class="form-control" name="hrm_workdays_schemes_days_day">
                <option value="" disabled>Select Day</option>
                <option <?php if($workday->hrm_workdays_schemes_days_day == 'Monday') echo 'selected';?>>Monday</option>
                <option <?php if($workday->hrm_workdays_schemes_days_day == 'Tuesday') echo 'selected';?>>Tuesday</option>
                <option <?php if($workday->hrm_workdays_schemes_days_day == 'Wednesday') echo 'selected';?>>Wednesday</option>
                <option <?php if($workday->hrm_workdays_schemes_days_day == 'Thursday') echo 'selected';?>>Thursday</option>
                <option <?php if($workday->hrm_workdays_schemes_days_day == 'Friday') echo 'selected';?>>Friday</option>
                <option <?php if($workday->hrm_workdays_schemes_days_day == 'Saturday') echo 'selected';?>>Saturday</option>
                <option <?php if($workday->hrm_workdays_schemes_days_day == 'Sunday') echo 'selected';?>>Sunday</option>
            </select>
        </div>
    </div>

    <div class="form-group row">
        <div class="col-12">
            <input type="text" name="hrm_workdays_schemes_days_start" value="<?php echo $workday->hrm_workdays_schemes_days_start;?>" class="form-control" placeholder="Start Time">
        </div>
    </div>

    <div class="form-group row">
        <div class="col-12">
            <input type="text" name="hrm_workdays_schemes_days_end" value="<?php echo $workday->hrm_workdays_schemes_days_end;?>" class="form-control" placeholder="End Time">
        </div>
    </div>

    <div class="form-group row">
        <div class="col-12">
            <input type="text" name="hrm_workdays_schemes_days_hours"
                   placeholder="<?php
                   $time1 =   strtotime($workday->hrm_workdays_schemes_days_end);
                   $time2 = strtotime($workday->hrm_workdays_schemes_days_start);
                   $difference = round(abs($time2 - $time1) / 3600,2);
                   echo $difference;
                   ?> Hours in Total"
                   class="form-control" value="">
        </div>
    </div>

    <div class="form-group row">
        <div class="col-12">
            <label>Select Status</label>
            <select class="form-control" name="hrm_workdays_schemes_days_status">
                <option value="">Select Status</option>
                <option <?php if($workday->hrm_workdays_schemes_days_status == 'Full Day') echo 'selected';?>>Full Day</option>
                <option <?php if($workday->hrm_workdays_schemes_days_status == 'Half Day') echo 'selected';?>>Half Day</option>
                <option <?php if($workday->hrm_workdays_schemes_days_status == 'Off') echo 'selected';?>>Off</option>
            </select>
        </div>
    </div>
    <div class="form-group row">
        <label class="col-8 col-form-label"></label>
        <div class="col-4">
            <button type="submit" class="btn btn-sm btn-block btn-warning" name="button"><b>Save Changes</b></button>
        </div>
    </div>
</form>
<script type="text/javascript">
    $('form#modifyWorkdaySchemeForm').submit( function(event){
        let form = $( this );
        event.preventDefault();
        let formdata = form.serialize();
        $.ajax({
            url: '<?php echo base_url('/hrm/workday/index/updateWorkdayScheme/'.$workday->hrm_workdays_schemes_days_key);?>' ,
            type: 'get',
            data: formdata,
            beforeSend: function(){
                KTApp.block(form,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Updating day ..."
                });
            },
            success: function(r){
                var obj = JSON.parse(r);
                if(obj.status == 'ok'){
                    $('div#workdayDetails').modal('hide');
                    notifySuccess(obj.message);
                    var table = $.fn.dataTable.tables( { api: true } );
                    table.clear().draw();
                }else{
                    Swal.fire('',obj.message,'warning');
                }
                KTApp.unblock(form);
            },
            error: function(){
                $('div#workdayDetails').modal('hide');
                KTApp.unblock(form);
            }
        });
    })
</script>