<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<form id="addWorkdaySchemeDays" class="kt-form" action="#" method="get" onsubmit="return false">
    <h5><?php echo $workday->hrm_workdays_scheme_title;?></h5>
    <div class="form-group row">
        <div class="col-12">
            <input hidden type="text" name="hrm_workdays_scheme_days_workdays_schemes_key" value="<?php echo $workday->hrm_workdays_scheme_key;?>" class="form-control" placeholder="Leave name">
        </div>
    </div>
    <div class="form-group row">
        <div class="col-12">
            <label>Select Day</label>
            <select class="form-control" name="hrm_workdays_schemes_days_day">
                <option value="">Select Day</option>
                <option value="Monday">Monday</option>
                <option value="Tuesday">Tuesday</option>
                <option value="Wednesday">Wednesday</option>
                <option value="Thursday">Thursday</option>
                <option value="Friday">Friday</option>
                <option value="Saturday">Saturday</option>
                <option value="Sunday">Sunday</option>
            </select>
        </div>
    </div>
    <div class="form-group row">
        <div class="col-12">
            <label>Select Status</label>
            <select class="form-control" name="hrm_workdays_schemes_days_status">
                <option value="">Select Status</option>
                <option value="Full Day">Full Day</option>
                <option value="Half Day">Half Day</option>
                <option value="Off">Off</option>
            </select>
        </div>
    </div>
    <div class="form-group row">
        <div class="col-12">
            <input type="text" id="kt_timepicker_1" name="hrm_workdays_schemes_days_start" value="" class="form-control" placeholder="time start">
        </div>
    </div>

    <div class="form-group row">
        <div class="col-12">
            <input type="text" id="kt_datepicker_1_modal" name="hrm_workdays_schemes_days_end" value="" class="form-control" placeholder="Time end">
        </div>
    </div>
    <div class="form-group row">
        <label class="col-8 col-form-label"></label>
        <div class="col-4">
            <button type="submit" class="btn btn-sm btn-block btn-warning" name="button"><b>Save Data</b></button>
        </div>
    </div>
</form>

<script type="text/javascript">
    $('form#addWorkdaySchemeDays').submit( function(event){
        let form = $( this );
        event.preventDefault();
        let formdata = form.serialize();
        $.ajax({
            url: '<?php echo base_url('hrm/workday/index/createWorkdaySchemeDay/')?>',
            type: 'get',
            data: formdata,
            beforeSend: function(){
                KTApp.block(form,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Adding Workday data ..."
                });
            },
            success: function(r){
                var obj = JSON.parse(r);
                if(obj.status == 'ok'){
                    $('div#kt_datepicker_modal').modal('hide');
                    notifySuccess(obj.message);
                    var table = $.fn.dataTable.tables( { api: true } );
                    table.clear().draw();
                }else{
                    Swal.fire('',obj.message,'warning');
                }
                KTApp.unblock(form);
            },
            error: function(){
                $('div#kt_datepicker_modal').modal('hide');
                KTApp.unblock(form);
            }
        });
    })
</script>