<script type="text/javascript">

    "use strict";

    // Class definition
    var KTFormRepeaters = function() {

        // Private functions
        var items = function() {
            let items = $('#kt_repeater_items').repeater({
                initEmpty: true,
                ready: function () {
                    $('select').select2({
                        placeholder: "Select an option...",
                    });
                },
                show: function () {
                    $(this).slideDown();
                    $('select').select2({
                        placeholder: "Select an option...",
                    });
                },

                hide: function (deleteElement) {
                    if(confirm('Are you sure you want to delete this element?')) {
                        $(this).slideUp(deleteElement);
                        alert($(this).closest('input','.inv_item_qty'));
                        setTimeout(calSubTotal(), 5000);
                    }
                }
            });
            <?php if(!empty($items)){?>
            if(items.setList != undefined){
                items.setList([
                    <?php  foreach ($items as $i => $item){?>
                    {
                        'inv_item' : '<?php echo $item['inv_data_item'];?>',
                        'inv_item_details' : '<?php echo $item['inv_data_item_details'];?>',
                        'inv_item_price' : '<?php echo to_money($item['inv_data_item_price']);?>',
                        'inv_item_qty' : '<?php echo $item['inv_data_item_qty'];?>',
                        'inv_item_total' : '<?php echo to_money($item['inv_data_item_total']);?>',
                    },
                    <?php } ?>
                ]);
            }
            <?php } ?>
        }


        var services = function() {
            $('#kt_repeater_products').repeater({
                initEmpty: true,

                show: function () {
                    calSubTotal();
                    $(this).slideDown();
                },

                hide: function (deleteElement) {
                    calSubTotal();
                    $(this).slideUp(deleteElement);
                }
            });
        }

        var products = function() {
            $('#kt_repeater_services').repeater({
                initEmpty: true,
                show: function () {
                    calSubTotal();
                    $(this).slideDown();
                },

                hide: function (deleteElement) {
                    $(this).slideUp(deleteElement);

                }
            });
        }

        return {
            // public functions
            init: function() {
                services();
                products();
                items();
            }
        };
    }();

    var KTSummernoteDemo = function () {
        // Private functions
        var demos = function () {
            $('textarea').summernote({
                height: 150
            });
        }

        return {
            // public functions
            init: function() {
                demos();
            }
        };
    }();

    jQuery(document).ready(function() {

        $('select').select2({placeholder: "Select option"});

        $('#tax-option-checkbox').change(function (e) {
            calSubTotal();
        });

        $("select#taxes").change( function(e){
            $.ajax({
                url: '<?php echo base_url('taxes/index/get_total_taxes');?>',
                type: 'get',
                data: {'values': $(this).val()},
                beforeSend: function(){
                    KTApp.blockPage({
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"Please wait ..."
                    });
                },
                success: function(response){
                    KTApp.unblockPage();
                    $("input#total-tax").val(response.total);
                    calSubTotal();
                },
                error: function(){
                    KTApp.unblockPage();
                }
            });
        })

        KTFormRepeaters.init();
        KTSummernoteDemo.init();

    });

    function calSubTotal(){

        let items = $('input.inv_item');
        let itemPrices = $('input.inv_item_price');
        let itemQty = $('input.inv_item_qty');
        let itemTotal = 0;
        let totalItem =  $('input.inv_item_total');
        for (let i = 0; i < items.length; i++){
            itemTotal += itemPrices[i].value * itemQty[i].value;
            totalItem[i].value = itemPrices[i].value * itemQty[i].value;
        }


        let services = $('input.service');
        let servicesPrices = $('input.service_price');
        let servicesQty = $('input.service_qty');
        let serviceTotal = 0;
        let totalService = $('input.service_total');
        for (let i = 0; i < servicesPrices.length; i++){
            serviceTotal += servicesPrices[i].value * servicesQty[i].value;
            totalService[i].value = servicesPrices[i].value * servicesQty[i].value;
        }

        let products = $('input.product');
        let productsPrices = $('input.product_price');
        let productsQty = $('input.product_qty');
        let productTotal = 0;
        let totalProduct = $('input.product_total');
        for (let i = 0; i < productsPrices.length; i++){
            productTotal += productsPrices[i].value * productsQty[i].value;
            totalProduct[i].value = productsPrices[i].value * productsQty[i].value;
        }


        let unTaxed = parseFloat($("input#un_taxed").val());
        let customValue = parseFloat($("input#custom_amount").val());
        let sub_total = customValue + serviceTotal + productTotal + itemTotal;

        let totalTax = parseFloat($("input#total-tax-class").val()) + parseFloat($("input#total-tax").val());
        let tax_value = sub_total * totalTax;
        let $input = $("#tax-option-checkbox");
        if($input.prop('checked')){
            $('input#sub_total').val(sub_total +  unTaxed);
            $('input#tax_value').val(tax_value);
            $('input#after_tax').val(sub_total);
            $('input#grand_total').val(sub_total + unTaxed);
        }else{
            $('input#sub_total').val(sub_total +  unTaxed);
            $('input#tax_value').val(tax_value);
            $('input#after_tax').val(tax_value + sub_total);
            $('input#grand_total').val(sub_total + tax_value + unTaxed);
        }

    }

    function create_invoice() {
        let form = $('form#new-invoice-form');
        let formData = form.serialize();
        Swal.fire("",formData);
        //return;
        $.ajax({
            url: '<?php echo base_url('invoices/index/createinvoice/');?>',
            type: 'get',
            data: formData,
            beforeSend: function () {
                KTApp.block(form, {
                    overlayColor: "#000000",
                    type: "loader",
                    state: "success",
                    message: "Creating Invoice, Please wait ..."
                });
            },
            success: function (result) {
                KTApp.unblock(form);
                if (result.status == true) {
                    $('#new-invoice').modal("hide");
                    Swal.fire('', result.product, 'success');
                    let table = $.fn.dataTable.tables({api: true});
                    table.clear().draw();
                } else {
                    Swal.fire('', result.message, 'warning');
                }
            },
            error: function (xhr) {
                KTApp.unblock(form);
                Swal.fire('', xhr.statusText, 'warning');
            }
        })
    }

</script>
