<!-- begin::Head -->
<?php include VIEWPATH.'includes/header.php';?>
<link href="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css" />
<!-- end::Head -->
<style>
    td {word-wrap: break-word}
</style>
<!-- begin:: Aside Menu -->
<?php include VIEWPATH.'menus/left.php';?>
<!-- end:: Aside Menu -->

<!-- begin:: Header Menu -->
<?php include VIEWPATH.'menus/top.php';?> 
<!-- end:: Header Menu -->

<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

    <?php topMenuInvoices('transactions');?>

    <!-- begin:: Content -->
        <div class="kt-container kt-container--fluid">
            <div class="row">
                <div class="col-12">
                    <div class="bs-example">
                        <nav >
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="javascript:(0);">Invoices</a></li>
                                <li class="breadcrumb-item active"><a href="javascript:(0);">Transactions</a></li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>

            
           <!--begin:: Widgets/Quick Stats-->
                    <?php include __DIR__.'/top_summary_transactions.php';?>
            <!--end:: Widgets/Quick Stats-->

            <div class="kt-portlet kt-portlet--tabs" data-portlet="true" id="kt_portlet_invoices">
                <div class="kt-portlet__head">
                    <div class="kt-portlet__head-label">
                        <h3 class="kt-portlet__head-title">
                            Transactions <?php if(!empty($when = $this->input->get("when"))) echo '| <span class="kt-font-brand">'. ucfirst(datesWhen($when)['label'])."</span>";?>
                        </h3>
                    </div>
                    <div class="kt-portlet__head-toolbar">
                        <ul class="nav nav-tabs nav-tabs-bold nav-tabs-line   nav-tabs-line-right nav-tabs-line-brand" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active" data-toggle="tab" href="#transactions-list" role="tab" aria-selected="false">
                                    Transactions
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" data-toggle="tab" href="#transactions-list-bin" role="tab" aria-selected="true">
                                    Recycle Bin
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="kt-portlet__body kt-portlet__body--fullheight">
                    <div class="tab-content">
                        <div class="tab-pane  active" id="transactions-list">
                            <table id="bms_table_transactions" class="table">
                                <thead>
                                <tr>
                                    <th>Ref #.</th>
                                    <th>Invoice #:</th>
                                    <th>Payer</th>
                                    <th>Payment Date</th>
                                    <th>Amount</th>
                                    <th>Post Status</th>
                                    <th>Action</th>
                                </tr>
                                </thead>
                            </table>
                        </div>
                        <div class="tab-pane" id="transactions-list-bin">
                            <table id="bms_table_transactions-bin" class="table">
                                <thead>
                                <tr>
                                    <th>Ref #.</th>
                                    <th>Invoice #:</th>
                                    <th>Payer</th>
                                    <th>Payment Date</th>
                                    <th>Amount</th>
                                    <th>Post Status</th>
                                    <th>Action</th>
                                </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    <!-- end:: Content -->
</div>

<?php
    include VIEWPATH.'includes/footer.php';?>
    <script src="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.js" type="text/javascript"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/numeral.js/2.0.6/numeral.min.js"></script>
   <?php include 'scripts.php';
?>

<?php
if (!empty($_GET['when'])) {
    $when = '?when='.htmlspecialchars(strtolower(urldecode(trim($_GET['when']))));
} else {
    $when = '';
}
?>

<script type="text/javascript">

    "use strict";

    var LMDatatableTransactions = function() {

        var initTableTransactions = function() {
            // begin first table
            let table = $('#bms_table_transactions');
            if(table != undefined) {
                table.DataTable({
                    "order": [[ 3, "desc" ]],
                    responsive: true,
                    serverSide: true,
                    ajax: '<?php echo base_url('invoices/sourcetransactions'.$when);?>',
                    columns: [
                        {data: 'inv_pay_reference'},
                        {data: 'inv_id'},
                        {data: 'firstname'},
                        {data: 'inv_pay_date'},
                        {data: 'inv_pay_amount'},
                        {data: 'inv_pay_post_status'},
                    ],
                    // Pagination settings
                    dom: `<'row'<'col-sm-12'tr>>
    			    <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                    lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
                    pageLength: 10,
                    language: {
                        'lengthMenu': 'Display _MENU_',
                        buttons: {
                            selectAll: "Select all",
                            selectNone: "Select none"
                        },
                        "emptyTable": "No record found",
                    },
                    searchDelay: 500,
                    buttons: [
                        {
                            text: 'Delete Selected',
                            action: function (e, dt, node, config) {
                                deleteSelected(table);
                            }
                        },
                        'selectAll',
                        'selectNone',
                        'excelHtml5',
                        'pdfHtml5',
                    ],
                    columnDefs: [
                        {
                            targets: 2,
                            "width": "15%",
                            render: function (data, type, full, meta) {
                                return '<a  href="javascript:(0);">' + full.firstname + ' ' + full.lastname +'</a> ';
                            },
                        },
                        {
                            targets: 4,
                            "width": "15%",
                            render: function (data, type, full, meta) {
                                var number = numeral(to_money(full.inv_pay_amount));
                                return '<a  href="javascript:(0);">' + number.format('0,0') +'</a> ';
                            },
                        },
                        {
                            targets: 5,
                            render: function (data, type, full, meta) {
                                var status = {
                                    "UNPOSTED": {'inv_pay_post_status': 'UNPOSTED', 'class': 'kt-font-danger'},
                                    "POSTED": {'inv_pay_post_status': 'POSTED', 'class': ' kt-font-success'},
                                    "PENDING": {'inv_pay_post_status': 'PENDING', 'class': ' kt-font-warning'},
                                    "REJECTED": {'inv_pay_post_status': 'REJECTED', 'class': ' kt-font-danger'},
                                };
                                if (typeof status[data] === 'undefined') {
                                    return data;
                                }
                                return '<span class="' + status[data].class + ' kt-font-bolder">' + status[data].inv_pay_post_status + '</span>';
                            },
                        },
                        {
                            targets: 6,
                            "width": "18%",
                            render: function (data, type, full, meta) {

                                if(full.inv_pay_post_status == "UNPOSTED" || full.inv_pay_post_status == "REJECTED"){
                                    return '<a href="<?php echo base_url('invoices/details/');?>'+ full.inv_key + '" > Invoice Details</a> &nbsp' +
                                        '<div class="dropdown dropdown-inline">\n' +
                                        ' <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                                        '<i class="flaticon-more-v2"></i>\n' +
                                        '</span>\n' +
                                        ' <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                                        '<a class="dropdown-item"  href="javascript:postPayment(' + full.inv_pay_key + ');"><i class="la la-plus kt-font-danger"></i> Post Payment</a>\n' +
                                        '<a class="dropdown-item"  href="<?php echo base_url('invoices/modify/');?>' + full.inv_key + '"><i class="la la-edit kt-font-warning"></i> Modify Invoice</a>\n' +
                                        '<a class="dropdown-item"  href="<?php echo base_url('invoices/payments/');?>' + full.inv_key + '"><i class="la la-money kt-font-info"></i> Payments</a>\n' +
                                        '<a class="dropdown-item"  href="javascript:deletePayment(' + full.inv_pay_key + ');"><i class="la la-trash kt-font-danger"></i> Delete Payment</a>\n' +
                                        ' </div>\n' +
                                        ' </div>';
                                }else{
                                    return '<a href="<?php echo base_url('invoices/details/');?>'+ full.inv_key + '" > Invoice Details</a> &nbsp' +
                                        '<div class="dropdown dropdown-inline">\n' +
                                        ' <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                                        '<i class="flaticon-more-v2"></i>\n' +
                                        '</span>\n' +
                                        ' <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                                        '<a class="dropdown-item"  href="<?php echo base_url('invoices/payments/');?>' + full.inv_key + '"><i class="la la-money kt-font-info"></i> Payments</a>\n' +
                                        ' </div>\n' +
                                        ' </div>';
                                }


                            },
                        },
                    ]
                });
            }
        };

        var initTableTransactionsBin = function() {
            // begin first table
            let table = $('#bms_table_transactions-bin');
            if(table != undefined) {
                table.DataTable({
                    responsive: true,
                    serverSide: true,
                    ajax: '<?php echo base_url('invoices/sourcetransactionsbin'.$when);?>',
                    columns: [
                        {data: 'inv_pay_reference'},
                        {data: 'inv_id'},
                        {data: 'firstname'},
                        {data: 'inv_pay_date'},
                        {data: 'inv_pay_amount'},
                        {data: 'inv_pay_post_status'},
                    ],
                    // Pagination settings
                    dom: `<'row'<'col-sm-12'tr>>
    			    <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                    lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
                    pageLength: 10,
                    language: {
                        'lengthMenu': 'Display _MENU_',
                        buttons: {
                            selectAll: "Select all",
                            selectNone: "Select none"
                        },
                        "emptyTable": "No record found",
                    },
                    searchDelay: 500,
                    buttons: [
                        {
                            text: 'Delete Selected',
                            action: function (e, dt, node, config) {
                                deleteSelected(table);
                            }
                        },
                        'selectAll',
                        'selectNone',
                        'excelHtml5',
                        'pdfHtml5',
                    ],
                    columnDefs: [
                        {
                            targets: 2,
                            "width": "15%",
                            render: function (data, type, full, meta) {
                                return '<a  href="javascript:(0);">' + full.firstname + ' ' + full.lastname +'</a> ';
                            },
                        },
                        {
                            targets: 4,
                            "width": "15%",
                            render: function (data, type, full, meta) {
                                var number = numeral(to_money(full.inv_pay_amount));
                                return '<a  href="javascript:(0);">' + number.format('0,0') +'</a> ';
                            },
                        },
                        {
                            targets: 5,
                            render: function (data, type, full, meta) {
                                var status = {
                                    "UNPOSTED": {'inv_pay_post_status': 'UNPOSTED', 'class': 'kt-font-danger'},
                                    "POSTED": {'inv_pay_post_status': 'POSTED', 'class': ' kt-font-success'},
                                    "PENDING": {'inv_pay_post_status': 'PENDING', 'class': ' kt-font-warning'},
                                    "REJECTED": {'inv_pay_post_status': 'REJECTED', 'class': ' kt-font-danger'},
                                };
                                if (typeof status[data] === 'undefined') {
                                    return data;
                                }
                                return '<span class="' + status[data].class + ' kt-font-bolder">' + status[data].inv_pay_post_status + '</span>';
                            },
                        },
                        {
                            targets: 6,
                            "width": "18%",
                            render: function (data, type, full, meta) {
                                if (full.inv_pay_post_status == "UNPOSTED") {
                                    return '<a href="<?php echo base_url('invoices/details/');?>' + full.inv_key + '" > Invoice Details</a> &nbsp' +
                                        '<div class="dropdown dropdown-inline">\n' +
                                        ' <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                                        '<i class="flaticon-more-v2"></i>\n' +
                                        '</span>\n' +
                                        ' <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                                        '<a class="dropdown-item"  href="javascript:restorePayment(' + full.inv_pay_key + ');"><i class="la la-reply kt-font-success"></i> Restore</a>\n' +
                                        // '<a class="dropdown-item"  href="javascript:deletePaymentForever(' + full.inv_pay_key + ');"><i class="la la-trash kt-font-danger"></i> Delete Permanently</a>\n' +
                                        ' </div>\n' +
                                        ' </div>';
                                }else{
                                    return  '<a href="<?php echo base_url('invoices/details/');?>' + full.inv_key + '" > Invoice Details</a>';
                                }
                            },
                        },
                    ]
                });
            }
        }

        return {
            //main function to initiate the module
            init: function() {
                initTableTransactions();
                initTableTransactionsBin();
            },

        };

    }();

    jQuery(document).ready(function() {

        LMDatatableTransactions.init();
    });


    function deletePayment(inv){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('invoices/deletepayment')?>/' + inv,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Deleting Payment ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.ajax.reload();
                        }else{
                            swal.fire("",result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }

    function postPayment(inv){
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, Post it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('invoices/postpayment')?>/' + inv,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Posting payment ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.ajax.reload();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }

    function deletePaymentForever(inv){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('invoices/deletepaymentforever')?>/' + inv,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Deleting Invoice ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.ajax.reload();
                        }else{
                            swal.fire("",result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }

    function restorePayment(inv){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#449c11',
            cancelButtonColor: '#d64a21',
            confirmButtonText: 'Yes, Restore it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('invoices/restorepayment')?>/' + inv,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Restoring payment ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.ajax.reload();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }


</script>

<!--end::Page Scripts -->
</body>

<!-- end::Body -->
</html>
