<!-- begin::Head -->
<?php include VIEWPATH.'includes/header.php';?>
<link href="<?php echo base_url('resources')?>/assets/css/pages/inbox/inbox.css" rel="stylesheet" type="text/css" />
<!-- end::Head -->
<style>
    td {word-wrap: break-word}

    td {word-wrap: break-word}
    #invoice{
        padding: 30px;
    }

    .invoice {
        position: relative;
        background-color: #FFF;
        min-height: 680px;
        padding: 15px
    }

    .invoice header {
        padding: 10px 0;
        margin-bottom: 20px;
        border-bottom: 1px solid #3989c6
    }

    .invoice .company-details {
        text-align: right
    }

    .invoice .company-details .name {
        margin-top: 0;
        margin-bottom: 0
    }

    .invoice .contacts {
        margin-bottom: 20px
    }

    .invoice .invoice-to {
        text-align: left
    }

    .invoice .invoice-to .to {
        margin-top: 0;
        margin-bottom: 0
    }

    .invoice .invoice-details {
        text-align: right
    }

    .invoice .invoice-details .invoice-id {
        margin-top: 0;
        color: #3989c6
    }

    .invoice main {
        padding-bottom: 50px
    }

    .invoice main .thanks {
        margin-top: -100px;
        font-size: 2em;
        margin-bottom: 50px
    }

    .invoice main .notices {
        padding-left: 6px;
        border-left: 6px solid #3989c6
    }

    .invoice main .notices .notice {
        font-size: 1.2em
    }

    .invoice table {
        width: 100%;
        border-collapse: collapse;
        border-spacing: 0;
        margin-bottom: 20px
    }

    .invoice table td,.invoice table th {
        padding: 15px;
        background: #eee;
        border-bottom: 1px solid #fff
    }

    .invoice table th {
        white-space: nowrap;
        font-weight: 400;
        font-size: 16px
    }

    .invoice table td h3 {
        margin: 0;
        font-weight: 400;
        color: #3989c6;
        font-size: 1.2em
    }

    .invoice table .qty,.invoice table .total,.invoice table .unit {
        text-align: right;
        font-size: 1.2em
    }

    .invoice table .no {
        color: #fff;
        font-size: 1.6em;
        background: #3989c6
    }

    .invoice table .unit {
        background: #ddd
    }

    .invoice table .total {
        background: #3989c6;
        color: #fff
    }

    .invoice table tbody tr:last-child td {
        border: none
    }

    .invoice table tfoot td {
        background: 0 0;
        border-bottom: none;
        white-space: nowrap;
        text-align: right;
        padding: 10px 20px;
        font-size: 1.2em;
        border-top: 1px solid #aaa
    }

    .invoice table tfoot tr:first-child td {
        border-top: none
    }

    .invoice table tfoot tr:last-child td {
        color: #3989c6;
        font-size: 1.4em;
        border-top: 1px solid #3989c6
    }

    .invoice table tfoot tr td:first-child {
        border: none
    }

    .invoice footer {
        width: 100%;
        text-align: center;
        color: #777;
        border-top: 1px solid #aaa;
        padding: 8px 0
    }

    @media print {
        body * {
            visibility: hidden;
        }

        .invoice, .invoice * {
            visibility: visible;
        }
    }
</style>
<!-- begin:: Aside Menu -->
<?php include VIEWPATH.'menus/left.php';?>
<!-- end:: Aside Menu -->

<!-- begin:: Header Menu -->
<?php include VIEWPATH.'menus/top.php';?> 
<!-- end:: Header Menu -->

<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

    <?php topToolbar();?>

    <!-- begin:: Content -->
    <div class="kt-container kt-container--fluid">
        <div class="row">
            <div class="col-12">
                <div class="bs-example">
                    <nav >
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:(0);">Payments</a></li>
                            <li class="breadcrumb-item"><a href="javascript:(0);">Requests</a></li>
                            <li class="breadcrumb-item active"><a href="javascript:(0);">Details</a></li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
            <div class="kt-portlet" >
<!--                onsubmit="create_invoice(); return false;"-->
                <div class="kt-portlet__body kt-portlet__body--fullheight" id="list-content">
                    <!--Author      : @arboshiki-->
                    <div >

                        <div class="invoice overflow-auto" id="invoice">
                            <div >
                                <div class="toolbar hidden-print">
                                    <div class="text-right">
                                        <?php if( has_role("Edit_Payment") & strtolower($request['request_status']) == 'pending'){?> <a href="<?php echo base_url('payments/modify/'.$request['request_key']);?>" class="btn btn-info"><i class="la la-edit"></i> Modify</a><?php } ?>
                                        <a href="<?php echo base_url('payments/details/'.$request['request_key']);?>" class="btn btn-info"><i class="la la-edit"></i> Back</a>
                                        <button id="printInvoice" class="btn btn-info"><i class="fa fa-print"></i> Print</button>
                                        <?php $paid = 0;
                                        if (!empty($payments)){
                                            foreach ($payments as $payment) {
                                                $paid += $payment['request_pay_amount'];
                                            }}
                                        if($request['request_balance'] > 0){?>
                                            <?php if( has_role("Pay_Payment")){?> <a href="#add-payment" data-toggle="modal" data-backdrop="false" class="btn btn-info"><i class="la la-money"></i> Add Payments</a><?php } ?>
                                        <?php } ?>
                                        <?php if( has_role("Pay_Payment")){?> <a href="javascript:clearPayments(<?= $request['request_key']?>);"  class="btn btn-danger"><i class="la la-trash-o"></i>  Clear Payments</a><?php } ?>
                                    </div>
                                    <hr>
                                </div>
                                <main>
                                    <table class="table  table-light--info table-striped">
                                        <thead class="text-muted">
                                        <tr class="text-muted">
                                            <th colspan="7">PAYMENTS</th>
                                        </tr>
                                        <tr class="text-muted">
                                            <th>Date</th>
                                            <th>Payment Method</th>
                                            <th>Reference</th>
                                            <th>Amount</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                            <?php  $paid = 0; if(!empty($payments)){
                                                foreach ($payments as $payment){?>
                                                    <tr>
                                                        <td><?php echo date('d-M-Y',strtotime($payment['request_pay_date']));?></td>
                                                        <td><?php echo $payment['method_name'];?></td>
                                                        <td><?php echo $payment['request_pay_reference'];?></td>
                                                        <td><?php echo number_format(to_money($payment['request_pay_amount']));?></td>
                                                    </tr>
                                                <?php }
                                            } ?>
                                        </tbody>
                                    </table>

                                    <table class="table" border="0" cellspacing="0" cellpadding="0">
                                        <tfoot>
                                        <tr>
                                            <td colspan="2"></td>
                                            <td colspan="2">Request Amount</td>
                                            <td><?= number_format(round(to_money($request['request_amount'])));?></td>
                                        </tr>
                                        <tr>
                                            <td colspan="2"></td>
                                            <td colspan="2">Request Paid</td>
                                            <td><?= number_format(round(to_money($request['request_paid'])));?></td>
                                        </tr>
                                        <tr>
                                            <td colspan="2"></td>
                                            <td colspan="2">Request Balance</td>
                                            <td><?= number_format(round(to_money($request['request_amount'] - $request['request_paid'])));?></td>
                                        </tr>
                                        </tfoot>
                                    </table>
                                </main>
                            </div>
                            <!--DO NOT DELETE THIS div. IT is responsible for showing footer always at the bottom-->
                            <div></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <!-- end:: Content -->
</div>

<div class="modal" id="add-payment" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog  modal-md" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h3 >Add Payment</h3>
            </div>
            <div class="modal-body" style="min-height: 100px;">
                <form id="add-payment-form" class="kt-form col-12" onsubmit="add_payment(); return false;">
                    <input name="request_pay_request" type="hidden"  class="form-control col-12" value="<?php echo $request['request_key'];?>" required />
                    <div class="form-group row">
                        <label>Payment Method</label>
                        <select name="request_pay_method" required style="width: 100%;" class="form-control col-12">
                            <option selected value="">Select Option</option>
                            <?php if(!empty($payments = paymentMethods())){
                                foreach ($payments as $payment){?>
                                    <option value="<?php echo $payment['method_key'];?>"><?php echo $payment['method_name'];?></option>
                               <?php }
                            } ?>
                        </select>
                    </div>
                    <div class="form-group row">
                            <label>Payment Reference</label>
                            <input name="request_pay_reference"  class="form-control col-12" placeholder="Reference" required />
                    </div>
                    <div class="form-group row">
                            <label>Payment Amount</label>
                            <input name="request_pay_amount"  class="form-control col-12 number" placeholder="Amount" required />
                    </div>
                    <div class="form-group row">
                        <label>Description</label>
                        <textarea  name="request_pay_details"  class="form-control col-12" placeholder="Description" required ></textarea>
                    </div>
                    <div class="form-group row">
                        <div class="col-6">
                            <button class="btn pull-left btn-dark" data-dismiss="modal">Cancel</button>
                        </div>
                        <div class="col-6">
                            <button class="btn pull-right btn-success" type="submit">Add Payment</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>


<?php include VIEWPATH.'includes/footer.php';?>
<!--begin::Page Vendors(used by this page) -->
<script src="<?= base_url('resources/')?>/assets/plugins/custom/tinymce/tinymce.bundle.js" type="text/javascript"></script>
<script src="<?php echo base_url('resources')?>/assets/js/pages/crud/forms/editors/summernote.js" type="text/javascript"></script>
<script>
    $('#printInvoice').click(function(){
        Popup($('#invoice').outerHTML);
        function Popup(data)
        {
            window.print();
            return true;
        }
    });
</script>
<script>

    "use strict";
    // Class definition


    // Initialization
    jQuery(document).ready(function() {
        KTTinymce.init();
    });

    $("select").select2({placeholder: "Select Option"});
    $('#add-payment').on('show.bs.modal', function (event) {
        let modal = $(this);
        const form = modal.find('form');
        form.resetForm();
    })

    function add_payment() {
        let form = $('form#add-payment-form');
        let formData = form.serialize();
        $.ajax({
            url: '<?php echo base_url('payments/addpayment');?>',
            type: 'post',
            data: formData,
            beforeSend: function () {
                KTApp.block(form, {
                    overlayColor: "#000000",
                    type: "loader",
                    state: "success",
                    message: "Adding Payment, Please wait ..."
                });
            },
            success: function (result) {
                KTApp.unblock(form);
                if (result.status == true) {
                    $('#add-payment').modal("hide");
                    Swal.fire('', result.message, 'success');
                    window.location.reload();
                } else {
                    Swal.fire('', result.message, 'warning');
                }
            },
            error: function (xhr) {
                KTApp.unblock(form);
                Swal.fire('', xhr.statusText, 'warning');
            }
        })
    }
    function clearPayments(inv){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Clear All!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('payments/clearpayments')?>/' + inv,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Clearing Payments ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            window.location.reload();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }

</script>


<!--end::Page Scripts -->
</body>
<!-- end::Body -->
</html>

