
<script type="text/javascript">

    "use strict";

    // Class definition
    var KTFormRepeaters = function() {

        // Private functions
        var items = function() {
            let items = $('#kt_repeater_items').repeater({
                initEmpty: true,
                ready: function () {},
                show: function () {

                    $(this).slideDown();

                    $("input.request_item_price" ).keyup(function() {
                        let handler = $( this );
                        let value = parseFloat(handler.val());
                        let parent = handler.closest('.item-container');
                        let quantity = parent.find('input.request_item_qty');
                        parent.find('input.request_item_sub_total').val(value * quantity.val());
                        calSubTotal();
                    });

                    $("input.request_item_qty" ).keyup(function() {
                        let handler = $( this );
                        let value = parseFloat(handler.val());
                        let parent = handler.closest('.item-container');
                        let itemPrice = parent.find('input.request_item_price');
                        parent.find('input.request_item_sub_total').val(value * itemPrice.val());
                        calSubTotal();
                    });

                },

                hide: function (deleteElement) {
                    if(confirm('Are you sure you want to delete this element?')) {
                        $(this).slideUp(deleteElement);
                        calSubTotal();
                    }
                }
            });

            <?php if(!empty($items)){?>
            if(items.setList != undefined){
                items.setList([
                    <?php  foreach ($items as $i => $item){?>
                    {
                        'request_reason': '<?php echo $item['request_data_item_reason'];?>',
                        'request_item_currency': '<?php echo $item['request_data_item_currency'];?>',
                        'request_other_reason': '<?php echo $item['request_data_item_other_reason'];?>',
                        'request_item_price': '<?php echo round(to_money($item['request_data_item_price']));?>',
                        'request_item_qty': '<?php echo $item['request_data_item_qty'];?>',
                        'request_item_sub_total': '<?php echo round(to_money($item['request_data_item_sub_total']));?>',
                    },
                    <?php } ?>
                ]);
            }
            <?php } ?>
        }

        return {
            // public functions
            init: function() {
                items();
            }
        };
    }();


    jQuery(document).ready(function() {

        $('select.select').select2({placeholder: "Select Option"});

        KTFormRepeaters.init();

        $('form#new-request-form').submit( function(e){
            e.preventDefault();
            var formData = new FormData($(this)[0]);
            $.ajax({
                url: '<?= base_url('payments/create')?>',
                type: 'post',
                data: formData,
                async: false,
                cache: false,
                contentType: false,
                enctype: 'multipart/form-data',
                processData: false,
                beforeSend: function(){
                    KTApp.blockPage({
                        overlayColor:"#000000",
                        type:"loader",
                        state:"warning",
                        message:"Please wait ..."
                    })
                },
                success: function(response){
                    KTApp.unblockPage();
                    if(response.status == true){
                        $('div#new-request').modal('hide');
                        Swal.fire('Server Response',response.message);
                        let table = $.fn.dataTable.tables( { api: true } );
                        if(table != undefined){
                            table.clear().draw();
                        }

                    }else{
                        Swal.fire('Server Response',response.message);
                    }
                },
                error: function(xhr){
                    KTApp.unblockPage();
                    Swal.fire('',xhr.statusText,'warning');
                }
            });
        });

    });

    $( function(){
        $('select#client_request').change( function(){
            KTApp.blockPage({
                overlayColor:"#000000",
                type:"loader",
                state:"warning",
                message:"Please wait ..."
            })
            let value = $( this ).val();
            $('div#client_projects').load('<?= base_url('payments/get_client_projects')?>/'+value, function(responseTxt, statusTxt, xhr){
                KTApp.unblockPage();
                if(statusTxt == "error")
                    alert("Error: " + xhr.status + ": " + xhr.statusText);
            });
        })
    });

    function calSubTotal(){

        let total = 0;
        let items = $('select.request_reason');
        let subTotal = $('input.request_item_sub_total');

        for (let i = 0; i < items.length; i++){
            total += parseFloat(subTotal[i].value);
        }

        $('input.grand_total').val(total);

    }

</script>