<!-- begin::Head -->
<?php include VIEWPATH.'includes/header.php';?>
<link href="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css" />
<!-- end::Head -->
<style>
    td {word-wrap: break-word}
</style>
<!-- begin:: Aside Menu -->
<?php include VIEWPATH.'menus/left.php';?>
<!-- end:: Aside Menu -->

<!-- begin:: Header Menu -->
<?php include VIEWPATH.'menus/top.php';?>
<!-- end:: Header Menu -->

<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

    <?php topToolBarPayrolls('allowances');?>

    <!-- begin:: Content -->
    <div class="kt-container kt-container--fluid">
        <div class="row">
            <div class="col-12">
                <div class="bs-example">
                    <nav >
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:(0);">Payrolls</a></li>
                            <li class="breadcrumb-item active"><a href="javascript:(0);">Allowances</a></li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>

        <div class="kt-portlet">
            <div class="kt-portlet__head kt-portlet__head--md" style="">
                <div class="kt-portlet__head-label">
                    <h3 class="kt-portlet__head-title">Allowances</h3>
                </div>
                <div class="kt-portlet__head-toolbar">
                    <a href="#newAllowance" data-backdrop="false" data-keyboard="false" data-toggle="modal" class="btn btn-label-brand kt-margin-r-10">
                        <span class="kt-hidden-mobile">New Allowance</span>
                    </a>
                </div>
            </div>
            <div class="kt-portlet__body">
                <table class="table table-striped">
                    <thead>
                    <tr>
                        <th>Allowance</th>
                        <th>Description</th>
                        <th>Type</th>
                        <th>Value</th>
                        <th>Action</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php if(!empty($allowances)){
                        foreach ($allowances as $allowance){?>
                            <tr>
                                <td><?= $allowance['pr_allowance_name']?></td>
                                <td><?= $allowance['pr_allowance_details']?></td>
                                <td><?= $allowance['pr_allowance_type']?></td>
                                <?php if($allowance['pr_allowance_type'] == 'fixed'){?>
                                    <td><?= number_format(to_money($allowance['pr_allowance_value']))?></td>
                                <?php }else{?>
                                    <td><?= $allowance['pr_allowance_value']?></td>
                                <?php } ?>
                                <td><a data-key="<?= $allowance['pr_allowance_key']?>" data-toggle="modal" data-backdrop="false" href="#allowanceDetails"><span class="kt-badge kt-badge--success kt-badge--inline kt-badge--pill kt-badge--rounded">view</span></a> &nbsp; <a data-key="<?= $allowance['pr_allowance_key']?>" data-toggle="modal" data-keyboard="false" data-backdrop="false" href="#allowanceModify"><span class="kt-badge kt-badge--warning kt-badge--inline kt-badge--pill kt-badge--rounded">modify</span></a> &nbsp;<a  href="javascript:deleteallowance(<?= $allowance['pr_allowance_key']?>)"><span class="kt-badge kt-badge--danger kt-badge--inline kt-badge--pill kt-badge--rounded">delete</span></a> </td>
                            </tr>
                        <?php }
                    } ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- end:: Content -->
</div>

<div class="modal fade" id="allowanceDetails" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-md" role="document">
        <div class="modal-content" style="border:0px;">
            <div class="modal-header bg-dark">
                <h5 class="modal-title text-white" id="exampleModalLongTitle">Allowance Details</h5>
                <a data-dismiss="modal" href="javascript:(0);" modal-dismiss="modal" class="pull-right modal-title text-white">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon">
                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                            <rect id="bound" x="0" y="0" width="24" height="24"/>
                            <path d="M7.62302337,5.30262097 C8.08508802,5.000107 8.70490146,5.12944838 9.00741543,5.59151303 C9.3099294,6.05357769 9.18058801,6.67339112 8.71852336,6.97590509 C7.03468892,8.07831239 6,9.95030239 6,12 C6,15.3137085 8.6862915,18 12,18 C15.3137085,18 18,15.3137085 18,12 C18,9.99549229 17.0108275,8.15969002 15.3875704,7.04698597 C14.9320347,6.73472706 14.8158858,6.11230651 15.1281448,5.65677076 C15.4404037,5.20123501 16.0628242,5.08508618 16.51836,5.39734508 C18.6800181,6.87911023 20,9.32886071 20,12 C20,16.418278 16.418278,20 12,20 C7.581722,20 4,16.418278 4,12 C4,9.26852332 5.38056879,6.77075716 7.62302337,5.30262097 Z" id="Oval-25" fill="#000000" fill-rule="nonzero"/>
                            <rect id="Rectangle" fill="#000000" opacity="0.3" x="11" y="3" width="2" height="10" rx="1"/>
                        </g>
                    </svg></a>
            </div>
            <div class="modal-body text-back" id="printArea">

            </div>
            <div class="modal-footer bg-dark">
                <small> &copy <?php echo date('Y') ;?> <?= config_item('solution_name') ?> | Payroll Allowance Details</small>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="allowanceModify" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-md" role="document">
        <div class="modal-content" style="border:0px;">
            <div class="modal-header bg-dark">
                <h5 class="modal-title text-white" id="exampleModalLongTitle">Allowance Details</h5>
                <a data-dismiss="modal" href="javascript:(0);" modal-dismiss="modal" class="pull-right modal-title text-white">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon">
                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                            <rect id="bound" x="0" y="0" width="24" height="24"/>
                            <path d="M7.62302337,5.30262097 C8.08508802,5.000107 8.70490146,5.12944838 9.00741543,5.59151303 C9.3099294,6.05357769 9.18058801,6.67339112 8.71852336,6.97590509 C7.03468892,8.07831239 6,9.95030239 6,12 C6,15.3137085 8.6862915,18 12,18 C15.3137085,18 18,15.3137085 18,12 C18,9.99549229 17.0108275,8.15969002 15.3875704,7.04698597 C14.9320347,6.73472706 14.8158858,6.11230651 15.1281448,5.65677076 C15.4404037,5.20123501 16.0628242,5.08508618 16.51836,5.39734508 C18.6800181,6.87911023 20,9.32886071 20,12 C20,16.418278 16.418278,20 12,20 C7.581722,20 4,16.418278 4,12 C4,9.26852332 5.38056879,6.77075716 7.62302337,5.30262097 Z" id="Oval-25" fill="#000000" fill-rule="nonzero"/>
                            <rect id="Rectangle" fill="#000000" opacity="0.3" x="11" y="3" width="2" height="10" rx="1"/>
                        </g>
                    </svg></a>
            </div>
            <div class="modal-body text-back" id="printArea">

            </div>
            <div class="modal-footer bg-dark">
                <small> &copy <?php echo date('Y') ;?> <?= config_item('solution_name') ?> | Payroll Allowance Modification</small>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="newAllowance" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterAllowance" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-md" role="document">
        <div class="modal-content" style="border:0px;">
            <div class="modal-header bg-dark">
                <h5 class="modal-title text-white" id="exampleModalLongAllowance">New Allowance</h5>
                <a data-dismiss="modal" href="javascript:(0);" modal-dismiss="modal" class="pull-right modal-title text-white">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon">
                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                            <rect id="bound" x="0" y="0" width="24" height="24"/>
                            <path d="M7.62302337,5.30262097 C8.08508802,5.000107 8.70490146,5.12944838 9.00741543,5.59151303 C9.3099294,6.05357769 9.18058801,6.67339112 8.71852336,6.97590509 C7.03468892,8.07831239 6,9.95030239 6,12 C6,15.3137085 8.6862915,18 12,18 C15.3137085,18 18,15.3137085 18,12 C18,9.99549229 17.0108275,8.15969002 15.3875704,7.04698597 C14.9320347,6.73472706 14.8158858,6.11230651 15.1281448,5.65677076 C15.4404037,5.20123501 16.0628242,5.08508618 16.51836,5.39734508 C18.6800181,6.87911023 20,9.32886071 20,12 C20,16.418278 16.418278,20 12,20 C7.581722,20 4,16.418278 4,12 C4,9.26852332 5.38056879,6.77075716 7.62302337,5.30262097 Z" id="Oval-25" fill="#000000" fill-rule="nonzero"/>
                            <rect id="Rectangle" fill="#000000" opacity="0.3" x="11" y="3" width="2" height="10" rx="1"/>
                        </g>
                    </svg></a>
            </div>
            <div class="modal-body text-back">
                <form id="newAllowanceForm" class="kt-form" action="#" method="get" onsubmit="return false">
                    <div class="form-group row">
                        <div class="col-12">
                            <input required type="text" maxlength="30" name="allowance_name" class="form-control" placeholder="Allowance Name">
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-12">
                            <select id="allowance-debit-account" style="width: 100%;" required class="form-control" name="allowance_debit_account">
                                <option value="">Debit Account</option>
                                <?php if($accounts = accounts()){
                                    foreach ($accounts as $account){?>
                                        <option value="<?= $account['account_key']?>"><?= $account['account_name']?></option>
                                    <?php }
                                } ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-12">
                            <select id="allowance-credit-account" style="width: 100%;" required class="form-control" name="allowance_credit_account">
                                <option value="">Debit Account</option>
                                <?php if($accounts = accounts()){
                                    foreach ($accounts as $account){?>
                                        <option value="<?= $account['account_key']?>"><?= $account['account_name']?></option>
                                    <?php }
                                } ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-12">
                            <select id="allowance-type" style="width: 100%;" required class="form-control" name="allowance_type">
                                <option value="">Allowance Type</option>
                                <option value="percentage">Percentage</option>
                                <option value="fixed">Fixed Amount</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-12">
                            <input required type="decimal" maxlength="30" name="allowance_value" class="form-control" placeholder="Allowance Value">
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-12">
                            <textarea class="form-control" name="allowance_details" rows="3" cols="80" placeholder="Allowance details"></textarea>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-9 col-form-label"></label>
                        <div class="col-3">
                            <button type="submit" class="btn btn-sm btn-block btn-warning" name="button"><b>Register</b></button>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer bg-dark">
                <small> &copy <?php echo date('Y') ;?> <?= config_item('solution_name') ?> | Register new Allowance</small>
            </div>
        </div>
    </div>
</div>

<?php
include VIEWPATH.'includes/footer.php';?>
<script src="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.js" type="text/javascript"></script>
<?php include 'scripts.php';
?>


<!--end::Page Scripts -->
</body>

<!-- end::Body -->
</html>
