<script>

    "use strict";
    // Class definition


    jQuery(document).ready(function() {
        $('select#allowance-type').select2({placeholder: "Select Allowance Type"});
        $('select#allowance-debit-account').select2({placeholder: "Select Debit Account"});
        $('select#allowance-credit-account').select2({placeholder: "Select Credit Account"});

        $('form#newAllowanceForm').submit( function(event){
            let form = $( this );
            event.preventDefault();
            let formdata = form.serialize();
            $.ajax({
                url: '<?php echo base_url('payrolls/allowances/newallowance/')?>',
                type: 'post',
                data: formdata,
                beforeSend: function(){
                    KTApp.blockPage({
                        overlayColor:"#000000",
                        type:"loader",
                        state:"success",
                        message:"Creating new Allowance ..."
                    });
                },
                success: function(result){
                    KTApp.unblockPage();
                    if(result.status == true){
                        $('div#newAllowance').modal('hide');
                        notifySuccess(result.message);
                        window.location.reload();
                    }else{
                        notifyWarning(result.message);
                    }

                },
                error: function(){
                    KTApp.unblockPage();
                }
            });
        })
    });

    function deleteallowance(allowance){
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('payrolls/allowances/delete/allowance')?>/'+allowance,
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Deleting Allowance ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if(result.status == true){
                            notifySuccess(result.message);
                            window.location.reload();
                        }else{
                            notifyWarning(result.message);
                        }

                    },
                    error: function(){
                        KTApp.unblockPage();
                    }
                });
            }
        })
    }

    $('#allowanceModify').on('show.bs.modal', function (event) {
        var modal = $(this)
        modal.find('.modal-body').html('Loading details ...');
        var button = $(event.relatedTarget)
        var key = button.data('key')
        modal.find('.modal-body').load('<?php echo base_url('payrolls/allowances/allowanceModify/');?>' + key);
    })

    $('#allowanceDetails').on('show.bs.modal', function (event) {
        var modal = $(this)
        modal.find('.modal-body').html('Loading details ...');
        var button = $(event.relatedTarget)
        var key = button.data('key')
        modal.find('.modal-body').load('<?php echo base_url('payrolls/allowances/allowanceDetails/');?>' + key);
    })
</script>