<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<form class="kt-form" id="modifyDeductionForm" action="#" onsubmit="return false;">
    <div class="form-group row">
        <div class="col-12">
            <input required value="<?= $deduction->deduction_name?>" type="text" maxlength="30" name="deduction_name" class="form-control" placeholder="Deduction Name">
        </div>
    </div>
    <div cl
    <div class="form-group row">
        <div class="col-12">
            <select id="deduction-debit-account" style="width: 100%;" required class="form-control" name="deduction_debit_account">
                <option value="">Debit Account</option>
                <?php if($accounts = accounts()){
                    foreach ($accounts as $account){?>
                        <option <?php if(strtolower($deduction->deduction_debit_account) == $account['account_key']) echo 'selected';?> value="<?= $account['account_key']?>"><?= $account['account_name']?></option>
                    <?php }
                } ?>
            </select>
        </div>
    </div>
    <div class="form-group row">
        <div class="col-12">
            <select id="deduction-credit-account" style="width: 100%;" required class="form-control" name="deduction_credit_account">
                <option value="">Debit Account</option>
                <?php if($accounts = accounts()){
                    foreach ($accounts as $account){?>
                        <option <?php if(strtolower($deduction->deduction_credit_account) == $account['account_key']) echo 'selected';?> value="<?= $account['account_key']?>"><?= $account['account_name']?></option>
                    <?php }
                } ?>
            </select>
        </div>
    </div>
    <div class="form-group row">
        <div class="col-12">
            <select id="deduction-type" style="width: 100%;" required class="form-control" name="deduction_type">
                <option value="">Deduction Type</option>
                <option <?php if(strtolower($deduction->deduction_type) == 'percentage') echo 'selected';?> value="percentage">Percentage</option>
                <option <?php if(strtolower($deduction->deduction_type) == 'fixed') echo 'selected';?> value="fixed">Fixed Amount</option>
            </select>
        </div>
    </div>
    <?php if($deduction->deduction_type == 'fixed'){?>
        <div class="form-group row">
            <div class="col-12">
                <input required type="decimal" value="<?= number_format(to_money($deduction->deduction_value))?>" maxlength="30" name="deduction_value" class="form-control" placeholder="Deduction Value">
            </div>
        </div>
    <?php }else{?>
        <div class="form-group row">
            <div class="col-12">
                <input required type="decimal" value="<?= $deduction->deduction_value?>" maxlength="30" name="deduction_value" class="form-control" placeholder="Deduction Value">
            </div>
        </div>
    <?php } ?>
    <div class="form-group row">
        <div class="col-12">
            <textarea class="form-control" name="deduction_details" rows="3" cols="80" placeholder="Deduction details"><?= $deduction->deduction_details?></textarea>
        </div>
    </div>
    <div class="form-group row">
        <label class="col-9 col-form-label"></label>
        <div class="col-3">
            <button type="submit" class="btn btn-sm btn-block btn-warning" name="button"><b>Update</b></button>
        </div>
    </div>
</form>

<script type="text/javascript">
    $('select#deduction-type').select2({placeholder: "Select Deduction Type"});
    $('select#deduction-debit-account').select2({placeholder: "Select Debit Account"});
    $('select#deduction-credit-account').select2({placeholder: "Select Credit Account"});
    jQuery(document).ready(function() {
        $('form#modifyDeductionForm').submit( function(event){
            let form = $( this );
            event.preventDefault();
            let formdata = form.serialize();
            $.ajax({
                url: '<?php echo base_url('payrolls/deductions/updatededuction/'.$deduction->deduction_key);?>' ,
                type: 'post',
                data: formdata,
                beforeSend: function(){
                    KTApp.blockPage({
                        overlayColor:"#000000",
                        type:"loader",
                        state:"success",
                        message:"Updating Deduction ..."
                    });
                },
                success: function(result){
                    KTApp.unblockPage();
                    if(result.status == true){
                        $('div#deductionModify').modal('hide');
                        notifySuccess(result.message);
                        window.location.reload();
                    }else{
                        notifyWarning(result.message);
                    }

                },
                error: function(){
                    KTApp.unblockPage();
                }
            });
        })
    });

</script>
