
<?php
if (!empty($_GET['when'])) {
    $when = '?when='.htmlspecialchars(strtolower(urldecode(trim($_GET['when']))));
} else {
    $when = '';
}
?>

<script>

    jQuery(document).ready(function() {
        
        $('#internalDept').on('show.bs.modal', function (event) {
            var modal = $(this)
            modal.find('.modal-body').html('Loading details ...');
            var button = $(event.relatedTarget)
            var key = button.data('key')
            modal.find('.modal-body').load('<?php echo base_url('hrm/employees/index/loadInformationinternaldepts');?>/' + key);
        })

        $('#salarySlip').on('show.bs.modal', function (event) {
            var modal = $(this)
            modal.find('.modal-body').html('Loading details ...');
            var button = $(event.relatedTarget)
            var key = button.data('key')
            modal.find('.modal-body').load('<?php echo base_url('payrolls/index/slips/');?>' + key);
        })
    });

    function payrollDetails(payroll){
        let $modal =  $('div#payrollDetails');
        let $div = $modal.find('.modal-body').html('Loading, please wait ...');
        $div.html('');
        $modal.modal('show');
        $.ajax({
            url: '<?php echo base_url('payrolls/index/payrolldetails/');?>' + payroll,
            type: 'get',
            beforeSend: function(){
                KTApp.block($div,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Loading payroll details ...."
                });
            },
            success: function (result){
                $div.html(result);
                KTApp.unblock($div);
            },
            error: function (xhr){
                $modal.modal('hide');
                KTApp.unblock($div);
                Swal.fire('',xhr.statusText,'warning');
            }
        })
    }

    function employeeDetails(payroll){
        let $modal =  $('div#employeeDetails');
        let $div = $modal.find('.modal-body').html('Loading, please wait ...');
        $div.html('');
        $modal.modal('show');
        $.ajax({
            url: '<?php echo base_url('payrolls/index/payrolldetails/');?>' + payroll,
            type: 'get',
            beforeSend: function(){
                KTApp.block($div,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Loading payroll details ...."
                });
            },
            success: function (result){
                $div.html(result);
                KTApp.unblock($div);
            },
            error: function (xhr){
                $modal.modal('hide');
                KTApp.unblock($div);
                Swal.fire('',xhr.statusText,'warning');
            }
        })
    }

    function deletepayroll(payroll){
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('payrolls/index/delete/payroll')?>/'+payroll,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.block(".kt-datatable",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Deleting payroll ..."
                        });
                    },
                    success: function(result){
                        let obj = JSON.parse(result);
                        if( obj.status == 'ok'){
                            //window.location.href = '<?php echo current_url();?>';
                            Swal.fire('',obj.message,'success');
                            $('.kt-datatable').KTDatatable('reload');
                        }else{
                            Swal.fire('',obj.message,'warning');
                        }
                        KTApp.unblock('.kt-datatable');  KTApp.unblock('.kt-datatable');
                    },
                    error: function(xhr){
                        KTApp.unblock('.kt-datatable');
                        Swal.fire('',xhr.statusText,'warning');
                    }
                });
            }
        })
    }

    document.querySelector("#print").addEventListener("click", function() {
        printJS({ printable: 'printArea', type: 'html', header: '<?php echo config_item('application_name');?> - payroll Details',css:'<?php echo base_url('resources')?>/assets/demo/default/base/style.bundle.css','style':'link{text-decoration:none;}'});
    });
</script>