<!-- begin::Head -->
<?php include VIEWPATH.'includes/header.php';?>
<link href="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css" />
<!-- end::Head -->
<style>
    td {word-wrap: break-word}
</style>
<!-- begin:: Aside Menu -->
<?php include VIEWPATH.'menus/left.php';?>
<!-- end:: Aside Menu -->

<!-- begin:: Header Menu -->
<?php include VIEWPATH.'menus/top.php';?>
<!-- end:: Header Menu -->

<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

    <?php topToolBarPayrolls('payrolls');?>

    <!-- begin:: Content -->
    <div class="kt-container kt-container--fluid">
        <div class="row">
            <div class="col-12">
                <div class="bs-example">
                    <nav >
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:(0);">Payrllos</a></li>
                            <li class="breadcrumb-item active"><a href="javascript:(0);">Salary Slips</a></li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>


        <!--begin:: Widgets/Quick Stats-->
        <?php //include __DIR__.'/top_summary.php';?>
        <!--end:: Widgets/Quick Stats-->

        <div class="kt-portlet kt-portlet--tabs" data-portlet="true">
            <div class="kt-portlet__head">
                <div class="kt-portlet__head-label">
                    <h3 class="kt-portlet__head-title">
                        <?= $employee->firstname.' '.$employee->lastname?> - PAYROLL DETAILS
                        <?php if(!empty($when = $this->input->get("when"))) echo '| <span class="kt-font-brand">'. ucfirst(datesWhen($when)['label'])."</span>";?>
                    </h3>
                </div>
                <div class="kt-portlet__head-toolbar">
                    <ul class="nav nav-tabs nav-tabs-bold nav-tabs-line   nav-tabs-line-right nav-tabs-line-brand" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" data-toggle="tab" href="#employee-payroll-list" role="tab" aria-selected="false">
                                Payrolls
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#employee-payroll-list-bin" role="tab" aria-selected="true">
                                Recycle Bin
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="kt-portlet__body kt-portlet__body--fullheight">
                <div class="tab-content">
                    <div class="tab-pane  active" id="employee-payroll-list">
                        <table class="table " id="employee-payroll-list-table">
                            <thead>
                            <tr>
                                <th>ID #</th>
                                <th>Date</th>
                                <th>Basic Pay</th>
                                <th>Gross</th>
                                <th>Deductions</th>
                                <th>Allowances</th>
                                <th>Net Pay</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                    <div class="tab-pane" id="employee-payroll-list-bin">
                        <table id="employee-payroll-list-bin-table" class="table">
                            <thead>
                            <tr>
                                <th>ID #</th>
                                <th>Date</th>
                                <th>Basic Pay</th>
                                <th>Gross</th>
                                <th>Deductions</th>
                                <th>Allowances</th>
                                <th>Net Pay</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- end:: Content -->
</div>
<div class="modal fade" id="salarySlip" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content" style="border:0px;">
            <div class="modal-header bg-dark">
                <h5 class="modal-title text-white" id="exampleModalLongTitle">Pay Slip</h5>
                <a data-dismiss="modal" href="javascript:(0);" modal-dismiss="modal" class="pull-right modal-title text-white">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon">
                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                            <rect id="bound" x="0" y="0" width="24" height="24"/>
                            <path d="M7.62302337,5.30262097 C8.08508802,5.000107 8.70490146,5.12944838 9.00741543,5.59151303 C9.3099294,6.05357769 9.18058801,6.67339112 8.71852336,6.97590509 C7.03468892,8.07831239 6,9.95030239 6,12 C6,15.3137085 8.6862915,18 12,18 C15.3137085,18 18,15.3137085 18,12 C18,9.99549229 17.0108275,8.15969002 15.3875704,7.04698597 C14.9320347,6.73472706 14.8158858,6.11230651 15.1281448,5.65677076 C15.4404037,5.20123501 16.0628242,5.08508618 16.51836,5.39734508 C18.6800181,6.87911023 20,9.32886071 20,12 C20,16.418278 16.418278,20 12,20 C7.581722,20 4,16.418278 4,12 C4,9.26852332 5.38056879,6.77075716 7.62302337,5.30262097 Z" id="Oval-25" fill="#000000" fill-rule="nonzero"/>
                            <rect id="Rectangle" fill="#000000" opacity="0.3" x="11" y="3" width="2" height="10" rx="1"/>
                        </g>
                    </svg></a>
            </div>
            <div class="modal-body text-back" id="printArea">

            </div>
            <div class="modal-footer bg-dark">
                <small> &copy <?php echo date('Y') ;?> <?= config_item('application_name') ?> | Salary Slips</small>
            </div>
        </div>
    </div>
</div>
<?php
include VIEWPATH.'includes/footer.php';?>
<script src="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.js" type="text/javascript"></script>
<?php
//include __DIR__.'/scripts.php';
//include __DIR__.'/common.php';
?>
<?php
if (!empty($_GET['when'])) {
    $when = '?when='.htmlspecialchars(strtolower(urldecode(trim($_GET['when']))));
} else {
    $when = '';
}
?>
<script type="text/javascript">
    jQuery(document).ready(function() {

        $('#salarySlip').on('show.bs.modal', function (event) {
            var modal = $(this)
            modal.find('.modal-body').html('Loading details ...');
            var button = $(event.relatedTarget);
            var key = button.data('key');
            //alert(key);
            modal.find('.modal-body').load('<?php echo base_url('payrolls/index/slip/');?>' + key);
        })
    });

    function deletePayroll(fr){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('payrolls/index/delete_payroll')?>/' + fr,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Deleting Freight ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.ajax.reload();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }
    function restorePayroll(fr){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Restore it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('payrolls/index/restore_payroll')?>/' + fr,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Restoring Freight ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.ajax.reload();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }

    var employeePayrolls = $('#employee-payroll-list-table');
    if(employeePayrolls != undefined){
        // begin freights table
        employeePayrolls.DataTable({
            "ordering": false,
            responsive: true,
            buttons: [
                {
                    extend : 'print',
                    exportOptions : {
                        columns : [1,2,3,4,5,6]
                    }
                },
                {
                    extend : 'copyHtml5',
                    exportOptions : {
                        columns : [1,2,3,4,5,6]
                    }
                },
                {
                    extend : 'excelHtml5',
                    exportOptions : {
                        columns : [1,2,3,4,5,6]
                    }
                },
                {
                    extend : 'csvHtml5',
                    exportOptions : {
                        columns : [1,2,3,4,5,6]
                    }
                },
                {
                    extend : 'pdfHtml5',
                    exportOptions : {
                        columns : [1,2,3,4,5,6]
                    }
                },
            ],
            dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
                            <'row'<'col-sm-12'tr>>
                            <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
            searchDelay: 500,
            processing: false,
            serverSide: false,
            ajax: '<?php echo base_url('payrolls/index/datasource_employee_payrolls/'.$employee->user_key.$when);?>',
            columns: [
                {data: 'payroll_id'},
                {data: 'payroll_timestamp'},
                {data: 'payroll_basic_salary'},
                {data: 'payroll_gross_salary'},
                {data: 'emp_deduction_value'},
                {data: 'allowance_value'},
                {data: 'payroll_net_salary'},
                {data: 'payroll_taxable_salary'},
            ],
            columnDefs: [
                {
                    targets: 1,
                    render: function(data,type, full, meta){
                        return '<a  href="javascript:(0);">' + moment(data).format("DD-MM-YYYY") +'</a> ';
                    }
                },
                {
                    targets: 2,
                    render: function(data,type, full, meta){
                        return '<a  href="javascript:(0);">' + KTUtil.numberString(to_money(full.payroll_basic_salary)) +'</a> ';
                    }
                },
                {
                    targets: 3,
                    render: function(data,type, full, meta){
                        return '<a  href="javascript:(0);">' + KTUtil.numberString(to_money(full.payroll_gross_salary)) +'</a> ';
                    }
                },
                {
                    targets: 4,
                    render: function(data,type, full, meta){
                        return '<a  href="javascript:(0);">' + KTUtil.numberString(to_money(full.emp_deduction_value)) +'</a> ';
                    }
                },
                {
                    targets: 5,
                    render: function(data,type, full, meta){
                        return '<a  href="javascript:(0);">' + KTUtil.numberString(to_money(full.allowance_value)) +'</a> ';
                    }
                },
                {
                    targets: 6,
                    render: function(data,type, full, meta){
                        return '<a  href="javascript:(0);">' + KTUtil.numberString(to_money(full.payroll_net_salary)) +'</a> ';
                    }
                },
                {
                    targets: 7,
                    "width": "15%",
                    render: function (data, type, full, meta) {
                                return '<div class="dropdown dropdown-inline">\n' +
                                    '      <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                                    '          <i class="flaticon-more"></i>\n' +
                                    '      </span>\n' +
                                    '      <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                                    '           <a class="dropdown-item" data-backdrop="false" data-toggle="modal" data-keyboard="false" data-key="'+ full.payroll_id +'" href="#salarySlip"><i class="la la-eye kt-font-success"></i> View Details</a>\n' +
                                    '           <a class="dropdown-item"  href="javascript:deletePayroll(' + full.payroll_id + ');"><i class="la la-trash kt-font-danger"></i> Delete</a>\n' +
                                    '       </div>\n' +
                                    '   </div>';
                        }
                    },
            ],
        });

    }

    var employeePayrollsBin = $('#employee-payroll-list-bin-table');
    if(employeePayrollsBin != undefined){
        // begin freights table
        employeePayrollsBin.DataTable({
            "ordering": false,
            responsive: true,
            buttons: [
                'print',
                'copyHtml5',
                'excelHtml5',
                'csvHtml5',
                'pdfHtml5',
            ],
            dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
                            <'row'<'col-sm-12'tr>>
                            <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
            searchDelay: 500,
            processing: false,
            serverSide: false,
            ajax: '<?php echo base_url('freight/index/datasource_importer_freights_bin/'.$employee->user_key.$when);?>',
            columns: [
                {data: 'payroll_id'},
                {data: 'payroll_timestamp'},
                {data: 'payroll_basic_salary'},
                {data: 'payroll_gross_salary'},
                {data: 'emp_deduction_value'},
                {data: 'allowance_value'},
                {data: 'payroll_net_salary'},
                {data: 'payroll_taxable_salary'},
            ],
            columnDefs: [
                {
                    targets: 7,
                    "width": "15%",
                    render: function (data, type, full, meta) {
                        return  '<a  href="javascript:restorePayroll('+ full.payroll_id  +');"><i class="la la-reply-all kt-font-success"></i> Restore</a>\n';
                    },
                }
            ],
        });

    }
</script>

<!--end::Page Scripts -->
</body>

<!-- end::Body -->
</html>

