<!-- begin::Head -->
<?php include VIEWPATH.'includes/header.php';?>
<link href="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css" />
<!-- end::Head -->
<style>
    td {word-wrap: break-word}
</style>
<!-- begin:: Aside Menu -->
<?php include VIEWPATH.'menus/left.php';?>
<!-- end:: Aside Menu -->

<!-- begin:: Header Menu -->
<?php include VIEWPATH.'menus/top.php';?> 
<!-- end:: Header Menu -->

<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

    <?php topMenuQuotations('quotations');?>

    <!-- begin:: Content -->
        <div class="kt-container kt-container--fluid">
            <div class="row">
                <div class="col-12">
                    <div class="bs-example">
                        <nav >
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="javascript:(0);">Quotations</a></li>
                                <li class="breadcrumb-item active"><a href="javascript:(0);">List of Quotations</a></li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>

            
           <!--begin:: Widgets/Quick Stats-->
                    <?php include __DIR__.'/top_summary.php';?>
            <!--end:: Widgets/Quick Stats-->

            <div class="kt-portlet kt-portlet--tabs" data-portlet="true">
                <div class="kt-portlet__head">
                    <div class="kt-portlet__head-label">
                        <h3 class="kt-portlet__head-title">
                            List of Quotations <?php if(!empty($when = $this->input->get("when"))) echo '| <span class="kt-font-brand">'. ucfirst(datesWhen($when)['label'])."</span>";?>
                        </h3>
                    </div>
                    <div class="kt-portlet__head-toolbar">
                        <ul class="nav nav-tabs nav-tabs-bold nav-tabs-line   nav-tabs-line-right nav-tabs-line-brand" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active" data-toggle="tab" href="#quotations-list" role="tab" aria-selected="false">
                                    Quotations
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" data-toggle="tab" href="#quotations-list-bin" role="tab" aria-selected="true">
                                    Recycle Bin
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="kt-portlet__body kt-portlet__body--fullheight">
                    <div class="tab-content">
                        <div class="tab-pane  active" id="quotations-list">
                            <table id="bms_table_quotations" class="table">
                                <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Client</th>
                                    <th>Issue Date</th>
                                    <th>Amount</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                                </thead>
                            </table>
                        </div>
                        <div class="tab-pane" id="quotations-list-bin">
                            <table id="bms_table_quotations_bin" class="table">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Client</th>
                                        <th>Issue Date</th>
                                        <th>Amount</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    <!-- end:: Content -->
</div>

<?php
    include VIEWPATH.'includes/footer.php';?>
    <script src="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.js" type="text/javascript"></script>
   <?php include 'scripts.php';
?>

<?php
if (!empty($_GET['when'])) {
    $when = '?when='.htmlspecialchars(strtolower(urldecode(trim($_GET['when']))));
} else {
    $when = '';
}
?>

<script type="text/javascript">

    var LMDatatableQuotations = function() {

        var initQuotations = function() {
            // begin first table
            let table = $('#bms_table_quotations');
            if(table != undefined) {
                table.DataTable({
                    responsive: true,
                    serverSide: true,
                    ajax: '<?php echo base_url('quotations/sourcequotations/'.$hash.$when);?>',
                    columns: [
                        {data: 'quot_id'},
                        {data: 'firstname'},
                        {data: 'quot_issued_date'},
                        {data: 'quot_total'},
                        {data: 'quot_status'},
                    ],
                    // Pagination settings
                    dom: `<'row'<'col-sm-12'tr>>
    			    <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                    lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
                    pageLength: 10,
                    language: {
                        'lengthMenu': 'Display _MENU_',
                        buttons: {
                            selectAll: "Select all",
                            selectNone: "Select none"
                        },
                        "emptyTable": "No record found",
                    },
                    searchDelay: 500,
                    buttons: [
                        {
                            text: 'Delete Selected',
                            action: function (e, dt, node, config) {
                                deleteSelected(table);
                            }
                        },
                        'selectAll',
                        'selectNone',
                        'excelHtml5',
                        'pdfHtml5',
                    ],
                    columnDefs: [
                        {
                            targets: 1,
                            "width": "15%",
                            render: function (data, type, full, meta) {
                                if(full.company_name != null){
                                    return '<a href="javascript:(0)">'+ full.company_name + '</a>';
                                }
                                else {
                                    return '<a href="javascript:(0)">'+ full.firstname +' '+ full.lastname + '</a>';
                                }
                            },
                        },
                        {
                            targets: 3,
                            "width": "15%",
                            render: function (data, type, full, meta) {
                                return '<a  href="javascript:(0);">' + KTUtil.numberString(to_money(full.quot_total_after_tax)) +'</a> ';
                            },
                        },
                        {
                            targets: 4,
                            render: function (data, type, full, meta) {
                                var status = {
                                    "SENT": {'quot_status': 'SENT', 'class': 'kt-font-success'},
                                    "DRAFT": {'quot_status': 'DRAFT', 'class': ' kt-font-brand'},
                                    "PAID": {'quot_status': 'PAID', 'class': ' kt-font-success'},
                                    "PENDING": {'quot_status': 'PENDING', 'class': ' kt-font-danger'},
                                    "PARTIAL": {'quot_status': 'PARTIAL', 'class': ' kt-font-warning'},
                                    "INVOICE": {'quot_status': 'INVOICE', 'class': 'kt-font-success'},
                                };
                                if (typeof status[data] === 'undefined') {
                                    return data;
                                }
                                return '<a href="<?php echo base_url('quotations/details/');?>' + full.quot_key + '"><span class="' + status[data].class + ' kt-font-bolder">' + status[data].quot_status + '</span></a>';
                            },
                        },
                        { 
                            targets: 5,
                            "width": "18%",
                            render: function (data, type, full, meta) {
                                if(full.quot_status == "INVOICE"){
                                    return '<a href="<?php echo base_url('quotations/details/');?>'+ full.quot_key + '" > View Details</a> &nbsp' +
                                        '<div class="dropdown dropdown-inline">\n' +
                                        ' <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                                        '<i class="flaticon-more-v2"></i>\n' +
                                        '</span>\n' +
                                        ' <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                                        //'<a class="dropdown-item"  href="<?php //echo base_url('quotations/modify/');?>//' + full.quot_key + '"><i class="la la-edit kt-font-warning"></i> Modify</a>\n' +
                                        '<a class="dropdown-item"  href="javascript:deleteQuotation(' + full.quot_key + ');"><i class="la la-trash kt-font-danger"></i> Delete</a>\n' +
                                        ' </div>\n' +
                                        ' </div>';
                                }else{
                                    return '<a href="<?php echo base_url('quotations/details/');?>'+ full.quot_key + '" > View Details</a> &nbsp' +
                                        '<div class="dropdown dropdown-inline">\n' +
                                        ' <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                                        '<i class="flaticon-more-v2"></i>\n' +
                                        '</span>\n' +
                                        ' <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                                        '<a class="dropdown-item"  href="<?php echo base_url('quotations/modify/');?>' + full.quot_key + '"><i class="la la-edit kt-font-warning"></i> Modify</a>\n' +
                                        '<a class="dropdown-item"  href="<?php echo base_url('quotations/toinvoice/');?>'+ full.quot_key + '"><i class="la la-forward kt-font-success"></i> Convert to Invoice</a>\n' +
                                        '<a class="dropdown-item"  href="javascript:deleteQuotation(' + full.quot_key + ');"><i class="la la-trash kt-font-danger"></i> Delete</a>\n' +
                                        ' </div>\n' +
                                        ' </div>';
                                }

                            },
                        },
                    ]
                });
            }
        };

        var initRecycle = function() {
            // begin first table
            let table = $('#bms_table_quotations_bin');
            if(table != undefined) {
                table.DataTable({
                    responsive: true,
                    serverSide: true,
                    ajax: '<?php echo base_url('quotations/sourcequotationsbin/'.$hash.$when);?>',
                    columns: [
                        {data: 'quot_id'},
                        {data: 'firstname'},
                        {data: 'quot_issued_date'},
                        {data: 'quot_total'},
                        {data: 'quot_status'},
                    ],
                    // Pagination settings
                    dom: `<'row'<'col-sm-12'tr>>
    			    <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                    lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
                    pageLength: 10,
                    language: {
                        'lengthMenu': 'Display _MENU_',
                        buttons: {
                            selectAll: "Select all",
                            selectNone: "Select none"
                        },
                        "emptyTable": "No record found",
                    },
                    searchDelay: 500,
                    buttons: [
                        {
                            text: 'Delete Selected',
                            action: function (e, dt, node, config) {
                                deleteSelected(table);
                            }
                        },
                        'selectAll',
                        'selectNone',
                        'excelHtml5',
                        'pdfHtml5',
                    ],
                    columnDefs: [
                        {
                            targets: 1,
                            "width": "15%",
                            render: function (data, type, full, meta) {
                                return '<a  href="javascript:(0);">' + full.firstname + ' ' + full.lastname +'</a> ';
                            },
                        },
                        {
                            targets: 3,
                            "width": "15%",
                            render: function (data, type, full, meta) {
                                return '<a  href="javascript:(0);">' + KTUtil.numberString(to_money(full.quot_total_after_tax)) +'</a> ';
                            },
                        },
                        {
                            targets: 4,
                            render: function (data, type, full, meta) {
                                var status = {
                                    "SENT": {'quot_status': 'SENT', 'class': 'kt-font-success'},
                                    "DRAFT": {'quot_status': 'DRAFT', 'class': ' kt-font-brand'},
                                    "PAID": {'quot_status': 'PAID', 'class': ' kt-font-success'},
                                    "PENDING": {'quot_status': 'PENDING', 'class': ' kt-font-danger'},
                                    "PARTIAL": {'quot_status': 'PARTIAL', 'class': ' kt-font-warning'},
                                    "INVOICE": {'quot_status': 'INVOICE', 'class': 'kt-font-success'},
                                };
                                if (typeof status[data] === 'undefined') {
                                    return data;
                                }
                                return '<a href="<?php echo base_url('quotations/details/');?>' + full.quot_key + '"><span class="' + status[data].class + ' kt-font-bolder">' + status[data].quot_status + '</span></a>';
                            },
                        },
                        {
                            targets: 5,
                            "width": "18%",
                            render: function (data, type, full, meta) {
                                return '<a href="<?php echo base_url('quotations/details/');?>'+ full.quot_key + '" > View Details</a> &nbsp' +
                                    '<div class="dropdown dropdown-inline">\n' +
                                    ' <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                                    '<i class="flaticon-more-v2"></i>\n' +
                                    '</span>\n' +
                                    ' <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                                    '<a class="dropdown-item"  href="javascript:restoreQuotation(' + full.quot_key + ');"><i class="la la-reply kt-font-success"></i> Restore</a>\n' +
                                    // '<a class="dropdown-item"  href="javascript:deleteForever(' + full.quot_key + ');"><i class="la la-trash kt-font-danger"></i> Delete Permanently</a>\n' +
                                    ' </div>\n' +
                                    ' </div>';
                            },
                        },
                    ]
                });
            }
        };

        return {
            //main function to initiate the module
            init: function() {
                initQuotations();
                initRecycle();
            },

        };

    }();

    jQuery(document).ready(function() {

        LMDatatableQuotations.init();

    });


    function deleteQuotation(inv){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('quotations/deleteinv')?>/' + inv,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Deleting Quotation ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }

    function restoreQuotation(inv){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Restore it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('quotations/restoreinv')?>/' + inv,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Restoring Quotation ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }

    function deleteForever(inv){
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('quotations/deleteinvforever')?>/' + inv,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Deleting Quotation ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }


</script>

<!--end::Page Scripts -->
</body>

<!-- end::Body -->
</html>
