<!-- begin::Head -->
<?php include VIEWPATH.'includes/header.php';?>
<link href="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css" />
<!-- end::Head -->
<style>
    td {word-wrap: break-word}
</style>
<!-- begin:: Aside Menu -->
<?php include VIEWPATH.'menus/left.php';?>
<!-- end:: Aside Menu -->

<!-- begin:: Header Menu -->
<?php include VIEWPATH.'menus/top.php';?>
<!-- end:: Header Menu -->

<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

    <?php topMenuGeneralLedger('gl');?>

    <!-- begin:: Content -->
    <div class="kt-container kt-container--fluid">
        <div class="row">
            <div class="col-12">
                <div class="bs-example">
                    <nav >
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:(0);">Reports</a></li>
                            <li class="breadcrumb-item"><a href="javascript:(0);">Accounting</a></li>
                            <li class="breadcrumb-item active"><a href="javascript:(0);">General Ledger</a></li>
                        </ol>
                    </nav> 
                </div>
            </div>
        </div>

        <div class="kt-portlet ">
            <div class="kt-portlet__head">
                <div class="kt-portlet__head-label">
                    <h3 class="kt-portlet__head-title text-uppercase">
                        General Ledger
                    </h3>
                </div>
            </div>
            <div class="kt-portlet__body">
                <!--begin::Accordion-->
                <div class="accordion accordion-light accordion-toggle-plus" id="accordionExample3">
                    <? if(!empty($accounts)){
                        foreach ($accounts as $key => $account){
                            if($transactions = $this->generalLedgerModel->find_many_by(['gl_account'=>$account['account_key']])){ ?>
                                <div class="card">
                                    <div class="card-header" id="<?= 'level-'.$key;?>">
                                        <div class="card-title collapsed" data-toggle="collapse" data-target="#<?= 'collapse-'.$key;?>" aria-expanded="false" aria-controls="<?= 'collapse-'.$key;?>">
                                            <span class="text-uppercase"><?= $account['account_name'] ?> <span class="kt-badge kt-badge--inline kt-badge--success">Balance = <?= number_format(to_money(accountBalance($account['account_key'])))?></span> </span>
                                        </div>
                                    </div>
                                    <div id="<?= 'collapse-'.$key;?>" class="collapse" aria-labelledby="<?= 'level-'.$key;?>" data-parent="#accordionExample3" style="">
                                        <div class="card-body">
                                            <a href="<?= base_url('accounting/account/history/'.$account['account_key']);?>">View All Transactions</a>
                                            <table class="table">
                                                <thead>
                                                <tr>
                                                    <th>Date</th>
                                                    <th>Reference</th>
                                                    <th>Transaction Type</th>
                                                    <th>Action Type</th>
                                                    <th>Description</th>
                                                    <th>Amount</th>
                                                    <th>Balance</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php
                                                if(!empty($transactions)){
                                                    foreach ($transactions as $transaction){
                                                        $account = $this->accountingModel->account($transaction['gl_account']);
                                                        $type = 'account_to_'.strtolower($transaction['gl_type'])?>
                                                        <tr>
                                                            <td><?= date('Y-M-d',strtotime($transaction['gl_date'])) ?></td>
                                                            <td><?= $transaction['gl_reference'] ?></td>
                                                            <td><?= strtoupper($transaction['gl_type']) ?></td>
                                                            <td><?= $transaction['gl_debit'] ? "Debit" : 'Credit' ?></td>
                                                            <td><?= $transaction['gl_details'] ?></td>
                                                            <td><?= number_format(to_money($transaction['gl_amount'])) ?></td>
                                                            <td><?= number_format(to_money($transaction['gl_balance'])) ?></td>
                                                        </tr>
                                                    <?php }
                                                   }
                                                 ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                           <?php }
                        } }?>
                </div>
                <!--end::Accordion-->
            </div>
        </div>
    </div>

    <!-- end:: Content -->
</div>

<?php
include VIEWPATH.'includes/footer.php';?>
<!--end::Page Scripts -->
</body>

<!-- end::Body -->
</html>
