<!-- begin::Body -->
<style media="screen">
    table {
        width: 100%;
    }

    td {
        font-size: 14px;
        padding: 10px;
        margin: 5px;
    }

    th {
        font-size: 14px;
        padding: 10px;
        margin: 5px;
    }
</style>
<?php include VIEWPATH . '/' . $auth_role . '/includes/header.styles.php'; ?>
<!-- begin:: Page -->
<div class="kt-grid kt-grid--hor kt-grid--root">
    <div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--ver kt-page">
        <!-- begin:: Aside -->
        <?php include VIEWPATH . '/' . $auth_role . '/menus/left.php'; ?>
        <!-- end:: Aside -->
        <div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor kt-wrapper" id="kt_wrapper">
            <!-- begin:: Header -->
            <?php include VIEWPATH . '/' . $auth_role . '/menus/top.php'; ?>
            <!-- end:: Header -->
            <div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor">
                <?php topToolBarBalancesheet('home'); ?>
                <!-- begin:: Content -->
                <div class="kt-container kt-container--fluid">
                    <div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
                        <div class="kt-portlet__body">
                            <div class="alert alert-outline-brand fade show" role="alert">
                                <div class="alert-text">
                                    <h5 class="alert-heading">
                                        Balance Sheet <br/>
                                        <small>Select the Date of the Balance Sheet</small>
                                    </h5>
                                    <hr>

                                    <form class="kt-form">
                                        <?php echo form_open(base_url($auth_role . '/accounting/reports/incomestatement'), ['class' => 'kt-form', 'method' => 'post']); ?>
                                        <div class="form-group row">
                                            <div class="col-3">
                                                <label>Start Date</label>
                                                <input class="form-control" type="date" name="start_date" value="<?php
                                                if (!empty($start_date)) {
                                                    echo date('Y-m-d', strtotime($start_date));
                                                } ?>">
                                            </div>
                                            <div class="col-3">
                                                <label>End Date</label>
                                                <input class="form-control" type="date" name="end_date" value="<?php
                                                if (!empty($end_date)) {
                                                    echo date('Y-m-d', strtotime($end_date));
                                                } else {
                                                    echo date('Y-m-d');
                                                } ?>">
                                            </div>
                                            <div class="col-3">
                                                <label>&nbsp</label>
                                                <button type="submit" class="form-control btn btn-info">Submit</button>
                                            </div>
                                            <div class="col-2">
                                                <label>&nbsp</label>
                                                <button type="reset" class="form-control btn-warning">Reset</button>
                                            </div>
                                        </div>
                                        <?php echo form_close(); ?>
                                </div>
                            </div>
                        </div>
                        <?php
                        $dates = array('start_date' => NULL, 'end_date' => NULL);

                        if (!empty($start_date)) {
                            $dates['start_date'] = date('Y-m-d', strtotime($start_date));
                        }

                        if (!empty($end_date)) {
                            $dates['end_date'] = date('Y-m-d', strtotime($end_date));
                        } else {
                            $dates['end_date'] = date('Y-m-d');
                        }

                        if (empty($end_date) && empty($start_date)) {
                            $timeRange = 'As of ' . date('l, d-M-Y');
                        } else {
                            if (!empty($start_date) && empty($end_date)) {
                                $timeRange = 'As of ' . date('l, d-M-Y', strtotime($start_date));
                            }
                            if (!empty($end_date) && empty($start_date)) {
                                $timeRange = 'As of ' . date('l, d-M-Y', strtotime($end_date));
                            }
                            if (!empty($end_date) && !empty($start_date)) {
                                $timeRange = 'From ' . date('d-M-Y', strtotime($start_date)) . ' to ' . date('d-M-Y', strtotime($end_date));
                            }
                        }
                        ?>
                        <div id="details" class="row">
                            <div class="col-12">
                                <div class="alert alert-brand fade show" role="alert">
                                    <div class="alert-text">
                                        <h5 class="alert-heading">
                                            Balance Sheet <br/>
                                            <small><?php echo $timeRange ?></small>
                                        </h5>
                                        <hr/>

                                        <?php echo runningBranch()->branch_name; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="row  row-col-separator-xl">
                                    <div class="col-6">
                                        <?php
                                        $grossTotalCurrentAsset = 0;
                                        $grossTotalFixedAsset = 0;
                                        ?>
                                        <div class="alert-text">
                                            <table class=" table-bordered ">
                                                <thead>
                                                <tr class="bg-dark text-white">
                                                    <th colspan="5">ASSETS</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <tr>
                                                    <th colspan="5">CURRENT ASSETS</th>
                                                </tr>
                                                <!-- Current assets -->
                                                <?php if (!empty($currentAssets = $this->accountingModel->accountsByType(1684898))) {
                                                    foreach ($currentAssets as $ca) {
                                                        ?>
                                                        <tr>
                                                            <td colspan="4"><?php echo $ca['account_name']; ?></td>
                                                            <td><?php $grossTotalCurrentAsset += to_money(accountBalance($ca['account_id'], $dates));
                                                                echo number_format(to_money(accountBalance($ca['account_id'], $dates))); ?></td>
                                                        </tr>
                                                    <?php }
                                                } ?>
                                                <!-- Accounts Receivable -->
                                                <?php if (!empty($accountsReceivable = $this->accountingModel->accountsByType(1327152790))) {
                                                    foreach ($accountsReceivable as $arb) {
                                                        ?>
                                                        <tr>
                                                            <td colspan="4"><?php echo $arb['account_name']; ?></td>
                                                            <td><?php $grossTotalCurrentAsset += to_money(accountBalance($arb['account_id'], $dates));
                                                                echo number_format(to_money(accountBalance($arb['account_id'], $dates))); ?></td>
                                                        </tr>
                                                    <?php }
                                                } ?>

                                                <!-- Accounts Receivable -->
                                                <?php if (!empty($accountsReceivable = $this->accountingModel->accountsByType(922545))) {
                                                    foreach ($accountsReceivable as $ar) {
                                                        ?>
                                                        <tr>
                                                            <td colspan="4"><?php echo $ar['account_name']; ?></td>
                                                            <td><?php $grossTotalCurrentAsset += to_money(accountBalance($ar['account_id'], $dates));
                                                                echo number_format(to_money(accountBalance($ar['account_id'], $dates))); ?></td>
                                                        </tr>
                                                    <?php }
                                                } ?>

                                                <tr>
                                                    <td colspan="4">Corporate Tax</td>
                                                    <td><?php //echo number_format(to_money($this->financialReportsModel->bsLoanOutstandingTotal()));?></td>
                                                </tr>
                                                <tr>
                                                    <td colspan="4">Cash & Cash Equivalent</td>
                                                    <td><?php //echo number_format(to_money($this->financialReportsModel->bsLoanOutstandingTotal()));?></td>
                                                </tr>
                                                <tr>
                                                    <th colspan="4" class="text-uppercase">Total Current Assets</th>
                                                    <td><?php echo number_format($grossTotalCurrentAsset); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                            <hr/>
                                            <table class="table-bordered">
                                                <tbody>
                                                <tr class="">
                                                    <th colspan="5">FIXED ASSETS</th>
                                                </tr>

                                                <!-- Fixed assets -->
                                                <?php if (!empty($fixedAssets = $this->accountingModel->accountsByType(3215489))) {
                                                    foreach ($fixedAssets as $fx) {
                                                        ?>
                                                        <tr>
                                                            <td colspan="4"><?php echo $fx['account_name']; ?></td>
                                                            <td><?php $grossTotalFixedAsset += to_money(accountBalance($fx['account_id'], $dates));
                                                                echo number_format(to_money(accountBalance($fx['account_id'], $dates))); ?></td>
                                                        </tr>
                                                    <?php }
                                                } ?>
                                                <tr>
                                                    <th colspan="4" class="text-uppercase">Total Fixed Assets</th>
                                                    <td><?php echo number_format($grossTotalFixedAsset); ?></td>
                                                </tr>
                                                </tbody>
                                            </table>
                                            <hr/>
                                            </table>
                                            <table class=" table-bordered  table-success">
                                                <tbody>
                                                <tr class="bg-dark text-white">
                                                    <th colspan="5" class="text-uppercase ">Total Assets</th>
                                                    <th><?php echo number_format($grossTotalFixedAsset + $grossTotalCurrentAsset); ?></th>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="alert-text">
                                            <table class=" table-bordered">
                                                <thead>
                                                <tr class="bg-dark text-white">
                                                    <th colspan="5">LIABILITY AND EQUITY</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <tr>
                                                    <th colspan="5" class="text-uppercase">Current Liabilities</th>
                                                </tr>
                                                <!-- Current Liabilities -->
                                                <?php
                                                $grossTotalCurrentLiabilities = 0;
                                                if (!empty($currentLiabilities = $this->accountingModel->accountsByType(754556566))) {
                                                    foreach ($currentLiabilities as $cl) {
                                                        ?>
                                                        <tr>
                                                            <td colspan="4"><?php echo $cl['account_name']; ?></td>
                                                            <td><?php $grossTotalCurrentLiabilities += to_money(accountBalance($cl['account_id'], $dates));
                                                                echo number_format(to_money(accountBalance($cl['account_id'], $dates))); ?></td>
                                                        </tr>
                                                    <?php }
                                                } ?>
                                                <tr>
                                                    <th colspan="4">TOTAL CURRENT LIABILITIES</th>
                                                    <th>0</th>
                                                </tr>
                                                </tbody>
                                            </table>
                                            <hr/>
                                            <table class="table-bordered">
                                                <tbody>
                                                <tr>
                                                    <th colspan="5" class="text-uppercase">Non Current Liabilities</th>
                                                </tr>
                                                <!-- Current Liabilities -->
                                                <?php if (!empty($nonCurrentLiabilities = $this->accountingModel->accountsByType(3415468))) {
                                                    foreach ($nonCurrentLiabilities as $ncl) {
                                                        ?>
                                                        <tr>
                                                            <td colspan="4"><?php echo $ncl['account_name']; ?></td>
                                                            <td></td>
                                                        </tr>
                                                    <?php }
                                                } ?>
                                                <tr>
                                                    <th colspan="4">TOTAL NON CURRENT LIABILITIES</th>
                                                    <th>0</th>
                                                </tr>
                                                </tbody>
                                            </table>
                                            <table class=" table-bordered  table-success">
                                                <tbody>
                                                <tr class="bg-dark text-white">
                                                    <th colspan="5" class="text-uppercase ">Total Liabilities</th>
                                                    <th><?php //echo number_format(to_money($this->financialReportsModel->bsTotalCurrenctassets()));?></th>
                                                </tr>
                                                </tbody>
                                            </table>
                                            <hr/>
                                            <table class=" table-bordered ">
                                                <tbody>
                                                <tr>
                                                    <th colspan="5">EQUITY</th>
                                                </tr>
                                                <tr>
                                                    <td colspan="4">Loan Fund Capital</td>
                                                    <td><?php //echo number_format(to_money($this->financialReportsModel->bsTotalCurrenctassets()));?></td>
                                                </tr>
                                                <tr>
                                                    <td colspan="4">Retained Net Surplus/Deficity (prior years)</td>
                                                    <td>0</td>
                                                </tr>
                                                <tr>
                                                    <td colspan="4">Net Surplus/Deficity (current years)</td>
                                                    <td>0</td>
                                                </tr>
                                                <tr class="bg-dark text-white">
                                                    <th colspan="4">TOTAL EQUITY</th>
                                                    <th><?php //echo number_format(to_money($this->financialReportsModel->bsTotalCurrenctassets()));?></th>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- end:: Content -->


            <!-- begin:: Footer -->
            <?php bottom(); ?>
            <!-- end:: Footer -->
        </div>
    </div>
</div>
<!-- end:: Page -->

<!-- begin::Quick Panel -->
<?php
include VIEWPATH . '/' . $auth_role . '/menus/right.php';
include VIEWPATH . '/' . $auth_role . '/includes/footer.php';
include VIEWPATH . '/' . $auth_role . '/includes/footer.scripts.php';
include VIEWPATH . '/' . $auth_role . '/reports/financial/script.php';
?>

<!--end::Global App Bundle -->

<script>
    jQuery(document).ready(function () {
        $("a.changeView").click(function () {
            'user strict'
            let el = $(this);
            let count = el.data('count');
            let $div = el.data('div');
            let isEven = function (someNumber) {
                return (someNumber % 2 === 0) ? true : false;
            };
            if (isEven(count) === false) {
                el.data("count", 2);
                $("div#" + $div).css('display', 'none');
            } else if (isEven(count) === true) {
                $("div#" + $div).css('display', 'block');
            }
        });
    });
</script>

</body>
<!-- end::Body -->
</html>
