<script type="text/javascript">

    "use strict";
    // Class definition
    var KTFormRepeaters = function() {

        var tasks = function() {
            $('#kt_repeater_task').repeater({
                initEmpty: true,
                show: function () {
                    calSubTotal();
                    $(this).slideDown();
                },

                hide: function (deleteElement) {
                    calSubTotal();
                    $(this).slideUp(deleteElement);
                }
            });
        }

        return {
            // public functions
            init: function() {
                tasks();
            }
        };
    }();

    jQuery(document).ready(function() {

        KTFormRepeaters.init();

    });

    function calSubTotal(){

        let task = $('input.task');
        let servicesPrices = $('input.service_price');
        let servicesQty = $('input.service_qty');
        let serviceTotal = 0;
        let totalService = $('input.service_total');
        for (let i = 0; i < servicesPrices.length; i++){
            serviceTotal += servicesPrices[i].value * servicesQty[i].value;
            totalService[i].value = servicesPrices[i].value * servicesQty[i].value;
        }

    }

    function create_task() {
        let form = $('form#new-task-form');
        let formData = form.serialize();
        Swal.fire("",formData);
        //return;
        $.ajax({
            url: '<?php echo base_url('task/index/createtask/');?>',
            type: 'get',
            data: formData,
            beforeSend: function () {
                KTApp.block(form, {
                    overlayColor: "#000000",
                    type: "loader",
                    state: "success",
                    message: "Creating Task, Please wait ..."
                });
            },
            success: function (result) {
                KTApp.unblock(form);
                if (result.status == true) {
                    $('#new-task').modal("hide");
                    Swal.fire('', result.product, 'success');
                    let table = $.fn.dataTable.tables({api: true});
                    table.clear().draw();
                } else {
                    Swal.fire('', result.message, 'warning');
                }
            },
            error: function (xhr) {
                KTApp.unblock(form);
                Swal.fire('', xhr.statusText, 'warning');
            }
        })
    }

  jQuery(document).ready(function() {
    $('select').css('width','100%');
    $('select').select2({placeholder: 'select option'});
    let height = $(window).innerHeight()  - 250;
    $('.lm_max_height').css({ height: height });
    $(window).resize(function(){
      $('.lm_max_height').css({ height: height });
    });

    $('form#newTask').submit( function(event){
      let form = $( this );
      event.preventDefault();
      let formdata = form.serialize();
      $.ajax({
          url: '<?php echo base_url('task/index/newTask/')?>',
        type: 'get',
        data: formdata,
        beforeSend: function(){
            KTApp.block("form#newTask",{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Creating new Task ...."
                });
          },
         success: function(r){
              var obj = JSON.parse(r);
              if(obj.status == 'ok'){
                notifySuccess(obj.message);
                //var table = $.fn.dataTable.tables( { api: true } );
                //table.clear().draw();
                  //window.location.reload();
                }else{
                    Swal.fire('',obj.message,'warning');
                }
                KTApp.unblock('form#newTask');
                $('div#kt_select2_modal').modal('hide');
             },
          error: function(){
              KTApp.unblock('form#newTask');
              }
      });
    })

    $('form#newNote').submit( function(event){
          let form = $( this );
          event.preventDefault();
          let formdata = form.serialize();
          $.ajax({
              url: '<?php echo base_url('task/index/newNote/')?>',
              type: 'get',
              data: formdata,
              beforeSend: function(){
                  KTApp.block("form#newNote",{
                      overlayColor:"#000000",
                      type:"loader",
                      state:"success",
                      message:"Creating new Personal Note ...."
                  });
              },
              success: function(r){
                  var obj = JSON.parse(r);
                  if(obj.status == 'ok'){
                      notifySuccess(obj.message);
                      //var table = $.fn.dataTable.tables( { api: true } );
                      //table.clear().draw();
                      //window.location.reload();
                  }else{
                      Swal.fire('',obj.message,'warning');
                  }
                  KTApp.unblock('form#newNote');
                  $('div#kt_private_modal').modal('hide');
              },
              error: function(){
                  KTApp.unblock('form#newNote');
              }
          });
      })

    $('form#newSubTaskAdmin').submit( function(event){
          let form = $( this );
          event.preventDefault();
          let formdata = form.serialize();
          $.ajax({
              url: '<?php echo base_url('task/index/newSubTask/')?>',
              type: 'get',
              data: formdata,
              beforeSend: function(){
                  KTApp.block("form#newSubTaskAdmin",{
                      overlayColor:"#000000",
                      type:"loader",
                      state:"success",
                      message:"Creating a task to certain Employee ...."
                  });
              },
              success: function(r){
                  var obj = JSON.parse(r);
                  if(obj.status == 'ok'){
                      notifySuccess(obj.message);
                      window.location.reload();
                  }else{
                      Swal.fire('',obj.message,'warning');
                  }
                  KTApp.unblock('form#newSubTaskAdmin');
                  $('div#newSubTask').modal('hide');
              },
              error: function(){
                  KTApp.unblock('form#newSubTaskAdmin');
              }
          });
      })

  });

  jQuery(document).ready(function() {
      $('select').css('width','100%');
      $('select').select2({placeholder: 'select option'});
      let height = $(window).innerHeight()  - 250;
      $('.lm_max_height').css({ height: height });
      $(window).resize(function(){
          $('.lm_max_height').css({ height: height });
      });

      $('form#newProject').submit( function(event){
          let form = $( this );
          event.preventDefault();
          let formdata = form.serialize();
          $.ajax({
              url: '<?php echo base_url('task/projects/newProject/')?>',
              type: 'get',
              data: formdata,
              beforeSend: function(){
                  KTApp.block("form#newProject",{
                      overlayColor:"#000000",
                      type:"loader",
                      state:"success",
                      message:"Creating new Project ...."
                  });
              },
              success: function(r){
                  var obj = JSON.parse(r);
                  if(obj.status == 'ok'){
                      notifySuccess(obj.message);
                      //var table = $.fn.dataTable.tables( { api: true } );
                      //table.clear().draw();
                      //window.location.reload();
                  }else{
                      Swal.fire('',obj.message,'warning');
                  }
                  KTApp.unblock('form#newProject');
                  $('div#newProject').modal('hide');
              },
              error: function(){
                  KTApp.unblock('form#newProject');
              }
          });
      })

  });

  Dropzone.autoDiscover = false;
  var options = {
      url: "<?php echo base_url('task/projects/uploadexpensedocs');?>",
      paramName: "file", // The name that will be used to transfer the file
      maxFiles: 10,
      maxFilesize: 3, // MB
      success: function(file, response){
          let oldValue = $('input#uploadedfiles').val();
          if(oldValue.length > 0){
              oldValue = oldValue + 'LM-55';
          }
          let newValue =  oldValue + response.files;
          $('input#uploadedfiles').val(newValue);
      },
  };
  var expsenseDocs = new Dropzone("div#crop-image",options);

  function deleteTask(task){
      Swal.fire({
          title: 'Are you sure?',
          text: "You won't be able to revert this!",
          type: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Yes, delete it!'
      }).then((result) => {
          if (result.value) {
              $.ajax({
                  url: '<?php echo base_url('task/index/deleteTasks/task')?>/'+task,
                  type: 'get',
                  beforeSend: function(){
                      KTApp.block("#lm_table_task",{
                          overlayColor:"#000000",
                          type:"loader",
                          state:"danger",
                          message:"Deleting Task ..."
                      });
                  },
                  success: function(result){
                      let obj = JSON.parse(result);
                      if( obj.status == 'ok'){
                          $('div#id-' + task).hide();
                          notifySuccess(obj.message);
                          var table = $.fn.dataTable.tables( { api: true } );
                          table.clear().draw();
                      }else{
                          Swal.fire('',obj.message,'warning');
                      }
                      KTApp.unblock('#lm_table_task');
                  },
                  error: function(xhr){
                      KTApp.unblock('#lm_table_task');
                      Swal.fire('',xhr.statusText,'warning');
                  }
              });
          }
      })
  }

   function deleteTasks(task){
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('task/index/deleteTasks/task')?>/'+task,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.block("#lm_table_task",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Deleting Task ..."
                        });
                    },
                    success: function(result){
                        let obj = JSON.parse(result);
                        if( obj.status == 'ok'){
                            $('div#id-' + task).hide();
                            notifySuccess(obj.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            Swal.fire('',obj.message,'warning');
                        }
                        KTApp.unblock('#lm_table_task');
                    },
                    error: function(xhr){
                        KTApp.unblock('#lm_table_task');
                        Swal.fire('',xhr.statusText,'warning');
                    }
                });
            }
        })
    }

  function loadTaskDetails(key){
      let $div =  $('div#details');
      $.ajax({
          url: '<?php echo base_url('task/index/taskDetails/');?>' + key + '/',
          type: 'get',
          beforeSend: function(){
              KTApp.block($div,{
                  overlayColor:"#000000",
                  type:"loader",
                  state:"danger",
                  message:"Loading task information ..."
              });
          },
          success: function (result){
              $div.html(result);
              KTApp.unblock($div);
          },
          error: function (xhr){
              KTApp.unblock($div);
              Swal.fire('',xhr.statusText,'warning');
          }
      });
  }

  function details(task){
    let $modal =  $('div#leaveDetails');
    let $div = $modal.find('.modal-body');
    $div.html('');
    $modal.modal('show');
    $.ajax({
      url: '<?php echo base_url('/hrm/leave/index/detailsLeave/');?>' + task,
      type: 'get',
      beforeSend: function(){
      KTApp.block($div,{
              overlayColor:"#000000",
              type:"loader",
              state:"success",
              message:"Loading leave details ...."
          });
      },
      success: function (result){
        $div.html(result);
        KTApp.unblock($div);
      },
      error: function (xhr){
        $modal.modal('hide');
        KTApp.unblock($div);
        Swal.fire('',xhr.statusText,'warning');
      }
    })
  }

  function editTask(task){
    let $modal =  $('div#taskDetails');
    let $div = $modal.find('.modal-body');
    $div.html('');
    $modal.modal('show');
    $.ajax({
        url: '<?php echo base_url('task/index/modifyTask/');?>' + task,
      type: 'get',
      beforeSend: function(){
      KTApp.block($div,{
              overlayColor:"#000000",
              type:"loader",
              state:"success",
              message:"Loading task details ...."
          });
      },
      success: function (result){
        $div.html(result);
        KTApp.unblock($div);
      },
      error: function (xhr){
        $modal.modal('hide');
        KTApp.unblock($div);
        Swal.fire('',xhr.statusText,'warning');
      }
    })
  }

  function startTask(task){
      Swal.fire({
          title: 'Are you sure?',
          text: "You are about to start your TASK!",
          type: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Yes, Start it!'
      }).then((result) => {
          if (result.value) {
              $.ajax({
                  url: "<?php echo base_url('task/index/startEmployeeTask/');?>" + task,
                  type: "get",
                  beforeSend: function(){
                      KTApp.block("#lm_table_task",{
                          overlayColor:"#000000",
                          type:"loader",
                          state:"danger",
                          message:"Starting Task assigned ..."
                      });
                  },
                  success: function(result){
                      let obj = JSON.parse(result);
                      if( obj.status == 'ok'){
                          $('div#id-' + task).hide();
                          notifySuccess(obj.message);
                          KTApp.unblock('#lm_table_task');
                          var table = $.fn.dataTable.tables( { api: true } );
                          table.clear().draw();
                      }else{
                          Swal.fire('',obj.message,'warning');
                      }
                  },
                  error: function(xhr){
                      KTApp.unblock('#lm_table_task');
                      Swal.fire('',xhr.statusText,'warning');
                  }

              })
          }
      })
  }

  function startFreightTask(task){
        Swal.fire({
            title: 'Are you sure?',
            text: "You are about to start your TASK!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Start it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "<?php echo base_url('task/index/startEmployeeFreightTask/');?>" + task,
                    type: "get",
                    beforeSend: function(){
                        KTApp.block("#lm_table_task",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Starting Task assigned ..."
                        });
                    },
                    success: function(result){
                        let obj = JSON.parse(result);
                        if( obj.status == 'ok'){
                            $('div#id-' + task).hide();
                            notifySuccess(obj.message);
                            KTApp.unblock('#lm_table_task');
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            Swal.fire('',obj.message,'warning');
                        }
                    },
                    error: function(xhr){
                        KTApp.unblock('#lm_table_task');
                        Swal.fire('',xhr.statusText,'warning');
                    }

                })
            }
        })
    }

  function pauseTask(task){
      Swal.fire({
          title: 'Are you sure?',
          text: "You are about to pause your TASK!",
          type: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Yes, pause it!'
      }).then((result) => {
          if (result.value) {
              $.ajax({
                  url: "<?php echo base_url('task/index/pauseTask/');?>" + task,
                  type: "get",
                  beforeSend: function(){
                      KTApp.block("#lm_table_task",{
                          overlayColor:"#000000",
                          type:"loader",
                          state:"danger",
                          message:"Approving Request ..."
                      });
                  },
                  success: function(result){
                      let obj = JSON.parse(result);
                      if( obj.status == 'ok'){
                          notifySuccess(obj.message);
                          KTApp.unblock('#lm_table_task');
                          var table = $.fn.dataTable.tables( { api: true } );
                          table.clear().draw();
                      }else{
                          Swal.fire('',obj.message,'warning');
                      }
                  },
                  error: function(xhr){
                      KTApp.unblock('#lm_table_task');
                      Swal.fire('',xhr.statusText,'warning');
                  }

              })
          }
      })
  }

  function finishTask(task){
        Swal.fire({
            title: 'Are you sure?',
            text: "You are about to End this TASK!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Finish it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "<?php echo base_url('task/index/finishTask/');?>" + task,
                    type: "get",
                    beforeSend: function(){
                        KTApp.block("#lm_table_task",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Approving Request ..."
                        });
                    },
                    success: function(result){
                        let obj = JSON.parse(result);
                        if( obj.status == 'ok'){
                            $('div#id-' + task).hide();
                            notifySuccess(obj.message);
                            KTApp.unblock('#lm_table_task');
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            Swal.fire('',obj.message,'warning');
                        }
                    },
                    error: function(xhr){
                        KTApp.unblock('#lm_table_task');
                        Swal.fire('',xhr.statusText,'warning');
                    }

                })
            }
        })
    }

  function finishFreightTask(task){
        Swal.fire({
            title: 'Are you sure?',
            text: "You are about to End this TASK!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Finish it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "<?php echo base_url('task/index/finishFreightTask/');?>" + task,
                    type: "get",
                    beforeSend: function(){
                        KTApp.block("#lm_table_task",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Approving Request ..."
                        });
                    },
                    success: function(result){
                        let obj = JSON.parse(result);
                        if( obj.status == 'ok'){
                            $('div#id-' + task).hide();
                            notifySuccess(obj.message);
                            KTApp.unblock('#lm_table_task');
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            Swal.fire('',obj.message,'warning');
                        }
                    },
                    error: function(xhr){
                        KTApp.unblock('#lm_table_task');
                        Swal.fire('',xhr.statusText,'warning');
                    }

                })
            }
        })
    }

  function deleteSelected(table){
    if(table.rows('.selected').data().length<1)
    return;
    var data= [];
   $.each(table.rows('.selected').data(), function() {
     data.push(this["group_key"]);
   });
    Swal.fire({
      title: 'Are you sure?',
      text: "You are going to DELETE " + table.rows('.selected').data().length + " groups",
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      confirmButtonText: 'Yes, Delete them!'
    }).then((result) => {
      if (result.value) {
        $.ajax({
            url: '<?php echo base_url('/customers/category/deleteselected/');?>',
            type: 'get',
            data: {'data':data},
            beforeSend: function(){
                KTApp.blockPage({
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"Please wait ..."
                    });
              },
             success: function(result){
                   let obj = JSON.parse(result);
                     if( obj.status == 'ok'){
                        notifySuccess(obj.message);
                        var table = $.fn.dataTable.tables( { api: true } );
                        table.clear().draw();
                      }else{
                        Swal.fire('',obj.message,'warning');
                      }
                   KTApp.unblockPage();
                 },
             error: function(xhr){
                KTApp.unblockPage();
                Swal.fire('',xhr.statusText,'warning');
                }
        });
      }
    })
  }

  function viewTask(task){
      let $modal =  $('div#myTask');
      let $div = $modal.find('.modal-body');
      $div.html('');
      $modal.modal('show');
      $.ajax({
          url: '<?php echo base_url('task/index/viewMyTask/');?>' + task,
          type: 'get',
          beforeSend: function(){
              KTApp.block($div,{
                  overlayColor:"#000000",
                  type:"loader",
                  state:"success",
                  message:"Loading my task ...."
              });
          },
          success: function (result){
              $div.html(result);
              KTApp.unblock($div);
          },
          error: function (xhr){
              $modal.modal('hide');
              KTApp.unblock($div);
              Swal.fire('',xhr.statusText,'warning');
          }
      })
  }

  //-------------EMPLOYEE--------------//
  function setPending(task){
        Swal.fire({
            title: 'Are you sure?',
            text: "You are about to set Pending your TASK!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, SET PENDING it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "<?php echo base_url('task/index/setTaskPending/');?>" + task,
                    type: "get",
                    beforeSend: function(){
                        KTApp.block("#lm_table_task",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Starting Task assigned ..."
                        });
                    },
                    success: function(result){
                        let obj = JSON.parse(result);
                        if( obj.status == 'ok'){
                            $('div#id-' + task).hide();
                            notifySuccess(obj.message);
                            KTApp.unblock('#lm_table_task');
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            Swal.fire('',obj.message,'warning');
                        }
                    },
                    error: function(xhr){
                        KTApp.unblock('#lm_table_task');
                        Swal.fire('',xhr.statusText,'warning');
                    }

                })
            }
        })
    }

  function loadTaskPending(){
        let $div =  $('div#detailsTask');
        $.ajax({
            url: '<?php echo base_url('task/index/taskPending/');?>',
            type: 'get',
            beforeSend: function(){
                KTApp.block($div,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"danger",
                    message:"Loading your pending task ..."
                });
            },
            success: function (result){
                $div.html(result);
                KTApp.unblock($div);
            },
            error: function (xhr){
                KTApp.unblock($div);
                Swal.fire('',xhr.statusText,'warning');
            }
        });
    }

  function loadTaskOngoing(){
        let $div =  $('div#detailsTask');
        $.ajax({
            url: '<?php echo base_url('task/index/taskOngoing/');?>',
            type: 'get',
            beforeSend: function(){
                KTApp.block($div,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"danger",
                    message:"Loading your pending task ..."
                });
            },
            success: function (result){
                $div.html(result);
                KTApp.unblock($div);
            },
            error: function (xhr){
                KTApp.unblock($div);
                Swal.fire('',xhr.statusText,'warning');
            }
        });
    }

  function loadTaskCompleted(){
        let $div =  $('div#detailsTask');
        $.ajax({
            url: '<?php echo base_url('task/index/taskCompleted/');?>',
            type: 'get',
            beforeSend: function(){
                KTApp.block($div,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"danger",
                    message:"Loading your complete task ..."
                });
            },
            success: function (result){
                $div.html(result);
                KTApp.unblock($div);
            },
            error: function (xhr){
                KTApp.unblock($div);
                Swal.fire('',xhr.statusText,'warning');
            }
        });
    }

  function loadPrivateTask(){
        let $div =  $('div#detailsTask');
        $.ajax({
            url: '<?php echo base_url('task/index/privateTask/');?>',
            type: 'get',
            beforeSend: function(){
                KTApp.block($div,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"danger",
                    message:"Loading your private task ..."
                });
            },
            success: function (result){
                $div.html(result);
                KTApp.unblock($div);
            },
            error: function (xhr){
                KTApp.unblock($div);
                Swal.fire('',xhr.statusText,'warning');
            }
        });
    }

  function editPercentage(task){
        let $modal =  $('div#taskPercentage');
        let $div = $modal.find('.modal-body');
        $div.html('');
        $modal.modal('show');
        $.ajax({
            url: '<?php echo base_url('task/index/modifyTaskEmployee/');?>' + task,
            type: 'get',
            beforeSend: function(){
                KTApp.block($div,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Loading task details ...."
                });
            },
            success: function (result){
                $div.html(result);
                KTApp.unblock($div);
            },
            error: function (xhr){
                $modal.modal('hide');
                KTApp.unblock($div);
                Swal.fire('',xhr.statusText,'warning');
            }
        })
    }

  function editFreightPercentage(task){
        let $modal =  $('div#taskPercentage');
        let $div = $modal.find('.modal-body');
        $div.html('');
        $modal.modal('show');
        $.ajax({
            url: '<?php echo base_url('task/index/modifyTaskFreightEmployee/');?>' + task,
            type: 'get',
            beforeSend: function(){
                KTApp.block($div,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Loading task details ...."
                });
            },
            success: function (result){
                $div.html(result);
                KTApp.unblock($div);
            },
            error: function (xhr){
                $modal.modal('hide');
                KTApp.unblock($div);
                Swal.fire('',xhr.statusText,'warning');
            }
        })
    }

  function finishEmployeeTask(task){
        Swal.fire({
            title: 'Are you sure?',
            text: "You are about to End this TASK!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Finish it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "<?php echo base_url('task/index/finishEmployeeTask/');?>" + task,
                    type: "get",
                    beforeSend: function(){
                        KTApp.block("#lm_table_task",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Approving Request ..."
                        });
                    },
                    success: function(result){
                        let obj = JSON.parse(result);
                        if( obj.status == 'ok'){
                            $('div#id-' + task).hide();
                            notifySuccess(obj.message);
                            KTApp.unblock('#lm_table_task');
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            Swal.fire('',obj.message,'warning');
                        }
                    },
                    error: function(xhr){
                        KTApp.unblock('#lm_table_task');
                        Swal.fire('',xhr.statusText,'warning');
                    }

                })
            }
        })
    }

  function finishFreightEmployeeTask(task){
        Swal.fire({
            title: 'Are you sure?',
            text: "You are about to End this TASK!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Finish it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "<?php echo base_url('task/index/finishFreightEmployeeTask/');?>" + task,
                    type: "get",
                    beforeSend: function(){
                        KTApp.block("#lm_table_task",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Approving Request ..."
                        });
                    },
                    success: function(result){
                        let obj = JSON.parse(result);
                        if( obj.status == 'ok'){
                            $('div#id-' + task).hide();
                            notifySuccess(obj.message);
                            KTApp.unblock('#lm_table_task');
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            Swal.fire('',obj.message,'warning');
                        }
                    },
                    error: function(xhr){
                        KTApp.unblock('#lm_table_task');
                        Swal.fire('',xhr.statusText,'warning');
                    }

                })
            }
        })
    }

  function deleteNote(note){
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('task/index/deleteNote/note')?>/'+note,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.block("#lm_table_task",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Deleting Private Task ..."
                        });
                    },
                    success: function(result){
                        let obj = JSON.parse(result);
                        if( obj.status == 'ok'){
                            $('div#id-' + note).hide();
                            notifySuccess(obj.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            Swal.fire('',obj.message,'warning');
                        }
                        KTApp.unblock('#lm_table_task');
                    },
                    error: function(xhr){
                        KTApp.unblock('#lm_table_task');
                        Swal.fire('',xhr.statusText,'warning');
                    }
                });
            }
        })
    }

 //-------------Subtask Admin-------//

  function finishTaskAdmin(task){
        Swal.fire({
            title: 'Are you sure?',
            text: "You are about to End this TASK!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Finish it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "<?php echo base_url('task/index/finishTaskAdmin/');?>" + task,
                    type: "get",
                    beforeSend: function(){
                        KTApp.block("#lm_table_task",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Approving Request ..."
                        });
                    },
                    success: function(result){
                        let obj = JSON.parse(result);
                        if( obj.status == 'ok'){
                            $('div#id-' + task).hide();
                            notifySuccess(obj.message);
                            KTApp.unblock('#lm_table_task');
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            Swal.fire('',obj.message,'warning');
                        }
                    },
                    error: function(xhr){
                        KTApp.unblock('#lm_table_task');
                        Swal.fire('',xhr.statusText,'warning');
                    }

                })
            }
        })
    }

  function editSubTask(task){
        let $modal =  $('div#subtaskDetails');
        let $div = $modal.find('.modal-body');
        $div.html('');
        $modal.modal('show');
        $.ajax({
            url: '<?php echo base_url('task/index/modifySubTaskAdmin/');?>' + task,
            type: 'get',
            beforeSend: function(){
                KTApp.block($div,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Loading task details ...."
                });
            },
            success: function (result){
                $div.html(result);
                KTApp.unblock($div);
            },
            error: function (xhr){
                $modal.modal('hide');
                KTApp.unblock($div);
                Swal.fire('',xhr.statusText,'warning');
            }
        })
    }

  function setPendingAdmin(task){
        Swal.fire({
            title: 'Are you sure?',
            text: "You are about to set Pending your TASK!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, SET PENDING it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "<?php echo base_url('task/index/setTaskPending/');?>" + task,
                    type: "get",
                    beforeSend: function(){
                        KTApp.block("#lm_table_task",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Starting Task assigned ..."
                        });
                    },
                    success: function(result){
                        let obj = JSON.parse(result);
                        if( obj.status == 'ok'){
                            notifySuccess(obj.message);
                            KTApp.unblock('#lm_table_task');
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            Swal.fire('',obj.message,'warning');
                        }
                    },
                    error: function(xhr){
                        KTApp.unblock('#lm_table_task');
                        Swal.fire('',xhr.statusText,'warning');
                    }

                })
            }
        })
    }

  function setFreightEmployeePending(task){
        Swal.fire({
            title: 'Are you sure?',
            text: "You are about to set Pending your TASK!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, SET PENDING it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "<?php echo base_url('task/index/setFreightTaskPending/');?>" + task,
                    type: "get",
                    beforeSend: function(){
                        KTApp.block("#lm_table_task",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Setting Task pending ..."
                        });
                    },
                    success: function(result){
                        let obj = JSON.parse(result);
                        if( obj.status == 'ok'){
                            $('div#id-' + task).hide();
                            notifySuccess(obj.message);
                            KTApp.unblock('#lm_table_task');
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            Swal.fire('',obj.message,'warning');
                        }
                    },
                    error: function(xhr){
                        KTApp.unblock('#lm_table_task');
                        Swal.fire('',xhr.statusText,'warning');
                    }

                })
            }
        })
    }


</script>