<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<form id="modifyTaskEmployeeForm" class="kt-form kt-form--fit kt-form--label-right" action="#" method="get" onsubmit="return false">
    <h3>Employee: <?php echo $task->firstname;?> <?php echo $task->lastname;?></h3>
    <div class="modal-body">
        <div class="row form-group">
            <div class="col-6">
                <label>Project</label>
                <input type="text" readonly name="task_det_project_key" placeholder="<?php echo $task->project_title;?>" VALUE="<?php echo $task->project_title;?>" class="form-control"/>
            </div>
            <div class="col-6">
                <label>Task Deadline</label>
                <input type="text" readonly name="task_det_task_deadline" placeholder="" value="<?php echo $task->task_det_task_deadline;?>" class="form-control"/>
            </div>
        </div>
        <div class="row form-group">
            <div class="col-6">
                <label>Task Mode</label>
                <input type="text" readonly name="task_det_task_mode" placeholder="<?php echo $task->task_det_task_mode;?>" class="form-control"/>
            </div>
            <div class="col-6">
                <label>Task Description</label>
                <input type="text" name="task_det_task_desc" placeholder="" value="<?php echo $task->task_det_task_desc;?>" class="form-control"/>
            </div>
        </div>
        <div class="row form-group">
            <div class="col-12">
                <label>Task Percentage</label>
                <input type="number" min="1" max="100" maxlength="2" name="task_det_task_percent" onkeypress="return isNumeric(event)" oninput="maxLengthCheck(this)" placeholder="Maximum 99.." value="<?php echo $task->task_det_task_percent;?>" class="form-control"/>
            </div>

        </div>

    </div>
    <div class="modal-footer">
        <button type="button" class="btn btn-info" data-dismiss="modal">Close</button>
        <button type="submit" name="submit" class="btn btn-success">Submit</button>
    </div>
</form>

<script type="text/javascript">

    function maxLengthCheck(object) {
        if (object.value.length > object.maxLength)
            object.value = object.value.slice(0, object.maxLength)
    }

    function isNumeric (evt) {
        var theEvent = evt || window.event;
        var key = theEvent.keyCode || theEvent.which;
        key = String.fromCharCode (key);
        var regex = /[0-9]|\./;
        if ( !regex.test(key) ) {
            theEvent.returnValue = false;
            if(theEvent.preventDefault) theEvent.preventDefault();
        }
    }

    $('form#modifyTaskEmployeeForm').submit( function(event){
        let form = $( this );
        event.preventDefault();
        let formdata = form.serialize();
        $.ajax({
            url: '<?php echo base_url('task/index/updateEmployeeTask/'.$task->task_det_key);?>' ,
            type: 'get',
            data: formdata,
            beforeSend: function(){
                KTApp.block(form,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Updating Task ..."
                });
            },
            success: function(r){
                var obj = JSON.parse(r);
                if(obj.status == 'ok'){
                    $('div#subtaskDetails').modal('hide');
                    notifySuccess(obj.message);
                    var table = $.fn.dataTable.tables( { api: true } );
                    table.clear().draw();
                    window.location.reload()
                }else{
                    Swal.fire('',obj.message,'warning');
                }
                KTApp.unblock(form);
            },
            error: function(){
                $('div#subtaskDetails').modal('hide');
                KTApp.unblock(form);
            }
        });
    })
</script>