<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<form id="modifyTaskFreightEmployeeForm" class="kt-form kt-form--fit kt-form--label-right" action="#" method="get" onsubmit="return false">
    <div class="modal-body">
        <div class="row form-group">
            <div class="col-6">
                <label>Task Start</label>
                <input type="text" readonly name="freight_task_start" placeholder="<?php echo $task->freight_task_start;?>" VALUE="<?php echo $task->freight_task_start;?>" class="form-control"/>
            </div>
            <div class="col-6">
                <label>Task Deadline</label>
                <input type="text" readonly name="freight_task_deadline" placeholder="" value="<?php echo $task->freight_task_deadline;?>" class="form-control"/>
            </div>
        </div>
        <div class="row form-group">
            <div class="col-6">
                <label>File No:</label>
                <input type="text" readonly name="freight_task_freight_key" placeholder="<?php echo $task->freight_task_freight_key;?>" class="form-control"/>
            </div>
            <div class="col-6">
                <label>Task Description</label>
                <input type="text" readonly name="freight_task_desc" placeholder="" value="<?php echo $task->freight_task_desc;?>" class="form-control"/>
            </div>
        </div>
        <div class="row form-group">
            <div class="col-12">
                <label>Task Percentage</label>
                <input type="number" min="1" max="100" maxlength="2" name="freight_task_percent" onkeypress="return isNumeric(event)" oninput="maxLengthCheck(this)" placeholder="Maximum 99.." value="<?php echo $task->freight_task_percent;?>" class="form-control"/>
            </div>

        </div>

    </div>
    <div class="modal-footer">
        <button type="button" class="btn btn-info" data-dismiss="modal">Close</button>
        <button type="submit" name="submit" class="btn btn-success">Submit</button>
    </div>
</form>

<script type="text/javascript">

    function maxLengthCheck(object) {
        if (object.value.length > object.maxLength)
            object.value = object.value.slice(0, object.maxLength)
    }

    function isNumeric (evt) {
        var theEvent = evt || window.event;
        var key = theEvent.keyCode || theEvent.which;
        key = String.fromCharCode (key);
        var regex = /[0-9]|\./;
        if ( !regex.test(key) ) {
            theEvent.returnValue = false;
            if(theEvent.preventDefault) theEvent.preventDefault();
        }
    }

    $('form#modifyTaskFreightEmployeeForm').submit( function(event){
        let form = $( this );
        event.preventDefault();
        let formdata = form.serialize();
        $.ajax({
            url: '<?php echo base_url('task/index/updateFreightEmployeeTask/'.$task->freight_task_key);?>' ,
            type: 'get',
            data: formdata,
            beforeSend: function(){
                KTApp.block(form,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Updating Task ..."
                });
            },
            success: function(r){
                var obj = JSON.parse(r);
                if(obj.status == 'ok'){
                    $('div#taskPercentage').modal('hide');
                    notifySuccess(obj.message);
                    var table = $.fn.dataTable.tables( { api: true } );
                    table.clear().draw();
                }else{
                    Swal.fire('',obj.message,'warning');
                }
                KTApp.unblock(form);
            },
            error: function(){
                $('div#taskPercentage').modal('hide');
                KTApp.unblock(form);
            }
        });
    })
</script>