<div class="modal" id="new-tax-class" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog  modal-mg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h3 >Create Tax Class</h3>
            </div>
            <div class="modal-body" style="min-height: 100px;">
                <form id="new-tax-class-form" class="kt-form col-12" onsubmit="create_tax_class(); return false;">
                    <div class="form-group row">
                        <label>Class Name</label>
                        <input name="tax_class_title"  class="form-control col-12" placeholder="Class name" required />
                    </div>
                    <div class="form-group row">
                        <label>Class Description</label>
                        <textarea  name="tax_class_details" class="form-control col-12" placeholder="Class description" ></textarea>
                    </div>
                    <div class="form-group row">
                        <label>Class Status</label>
                        <select name="tax_class_status" required style="width: 100%;" class="form-control col-12">
                            <option selected value="">Select Option</option>
                            <option value="Active">Active</option>
                            <option value="Inactive">Inactive</option>
                        </select>
                    </div>
                    <div class="form-group row">
                        <div class="col-6">
                            <button class="btn btn-pill pull-left btn-dark" data-dismiss="modal">Cancel</button>
                        </div>
                        <div class="col-6">
                            <button class="btn btn-pill pull-right btn-success" type="submit">Create Class</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="modal" id="new-tax" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog  modal-mg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h3 >Create Tax</h3>
            </div>
            <div class="modal-body" style="min-height: 100px;">
                <form id="new-tax-form" class="kt-form col-12" onsubmit="create_tax(); return false;">
                    <div class="form-group row">
                        <label>Tax Class</label>
                        <select name="tax_class" required style="width: 100%;" class="form-control col-12">
                            <option selected value="">Select Option</option>
                            <?php $classes = $this->taxesModel->taxClasses();
                            if(!empty($classes)){
                                foreach ($classes as $class){ ?>
                                    <option value="<?php echo $class['tax_class_key'];?>"><?php echo $class['tax_class_title'];?></option>
                              <?php  }
                            } ?>
                        </select>
                    </div>
                    <div class="form-group row">
                        <label>Tax Name</label>
                        <input name="tax_title" class="form-control col-12" placeholder="Tax Name" required />
                    </div>
                    <div class="form-group row">
                        <label>Tax Type</label>
                        <select name="tax_type"  required style="width: 100%;" class="form-control col-12">
                            <option selected value="">Select Option</option>
                            <option value="Percentage">Percentage</option>
                            <option value="Fixed">Fixed</option>
                        </select>
                    </div>
                    <div class="form-group row">
                        <label>Tax Value</label>
                        <input name="tax_type_value" class="form-control col-12" placeholder="Tax Value" required />
                    </div>
                    <div class="form-group row">
                        <label>Tax Status</label>
                        <select name="tax_status" required style="width: 100%;" class="form-control col-12">
                            <option selected value="">Select Option</option>
                            <option value="Active">Active</option>
                            <option value="Inactive">Inactive</option>
                        </select>
                    </div>
                    <div class="form-group row">
                        <div class="col-6">
                            <button class="btn btn-pill pull-left btn-dark" data-dismiss="modal">Cancel</button>
                        </div>
                        <div class="col-6">
                            <button class="btn btn-pill pull-right btn-success" type="submit">Create Tax</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="modal" id="tax-class-details" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-body" style="min-height: 100px;"> </div>
        </div>
    </div>
</div>

<div class="modal" id="tax-details" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-body" style="min-height: 100px;"> </div>
        </div>
    </div>
</div>

<script type="text/javascript">

  "use strict";

  var LMDatatableTaxes = function() {

        var initTable = function() {
            // begin first table
            let table = $('#lm_table_taxes');
            if(table != undefined) {
                table.DataTable({
                    responsive: true,
                    serverSide: true,
                    ajax: '<?php echo base_url('taxes/index/datasourcetaxes');?>',
                    columns: [
                        {data: 'tax_title'},
                        {data: 'tax_class_title'},
                        {data: 'tax_type'},
                        {data: 'tax_type_value'}, 
                        {data: 'tax_status'},
                    ],
                    // Pagination settings
                    dom: `<'row'<'col-sm-12'tr>>
    			    <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                    lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
                    pageLength: 10,
                    language: {
                        'lengthMenu': 'Display _MENU_',
                        buttons: {
                            selectAll: "Select all",
                            selectNone: "Select none"
                        },
                        "emptyTable": "No record found",
                    },
                    searchDelay: 500,
                    buttons: [
                        {
                            text: 'Delete Selected',
                            action: function (e, dt, node, config) {
                                deleteSelected(table);
                            }
                        },
                        'selectAll',
                        'selectNone',
                        'excelHtml5',
                        'pdfHtml5',
                    ],
                    columnDefs: [
                        {
                            targets: 0,
                            "width": "15%",
                            render: function (data, type, full, meta) {
                                return '<a data-backdrop="false" data-toggle="modal" data-key="' + full.tax_key + '" href="#tax-details" >' + full.tax_title + '</a> ';
                            },
                        },
                        {
                            targets: 1,
                            "width": "15%",
                            render: function (data, type, full, meta) {
                                return '<a data-backdrop="false" data-toggle="modal" data-key="'+ full.tax_class_key +'" href="#tax-class-details" >' + full.tax_class_title + '</a> ';
                            },
                        },
                        {
                            targets: 5,
                            "width": "18%",
                            render: function (data, type, full, meta) {
                                return '<a data-backdrop="false" data-toggle="modal" data-key="' + full.tax_key + '" href="#tax-details" > View Details</a> &nbsp' +
                                    '<div class="dropdown dropdown-inline">\n' +
                                    ' <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                                    '<i class="flaticon-more-v2"></i>\n' +
                                    '</span>\n' +
                                    ' <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                                    '<a class="dropdown-item"  href="javascript:setTaxStatusActive(' + full.tax_key + ');"><i class="la la-toggle-off kt-font-success"></i> Set Active</a>\n' +
                                    '<a class="dropdown-item"  href="javascript:setTaxStatusInactive(' + full.tax_key + ');"><i class="la la-toggle-off kt-font-warning"></i> Set Inactive</a>\n' +
                                    '<a class="dropdown-item"  href="javascript:deleteTax(' + full.tax_key + ');"><i class="la la-trash kt-font-danger"></i> Delete</a>\n' +
                                    ' </div>\n' +
                                    ' </div>';
                            },
                        },
                    ]
                });
            }
        };

        return {
            //main function to initiate the module
            init: function() {
                initTable();
            },

        };

    }();

  var LMDatatableClasses = function() {

      var initTable = function() {
          // begin first table
          let table = $('#lm_table_classes');
          if(table != undefined) {
              table.DataTable({
                  responsive: true,
                  serverSide: true,
                  ajax: '<?php echo base_url('taxes/index/datasourcetaxclasses');?>',
                  columns: [
                      {data: 'tax_class_title'},
                      {data: 'tax_class_details'},
                      {data: 'tax_class_status'},
                  ],
                  // Pagination settings
                  dom: `<'row'<'col-sm-12'tr>>
    			    <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                  lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
                  pageLength: 10,
                  language: {
                      'lengthMenu': 'Display _MENU_',
                      buttons: {
                          selectAll: "Select all",
                          selectNone: "Select none"
                      },
                      "emptyTable": "No record found",
                  },
                  searchDelay: 500,
                  buttons: [
                      {
                          text: 'Delete Selected',
                          action: function (e, dt, node, config) {
                              deleteSelected(table);
                          }
                      },
                      'selectAll',
                      'selectNone',
                      'excelHtml5',
                      'pdfHtml5',
                  ],
                  columnDefs: [
                      {
                          targets: 0,
                          "width": "15%",
                          render: function (data, type, full, meta) {
                              return '<a data-backdrop="false" data-toggle="modal" data-key="' + full.tax_class_key + '" href="#tax-class-details" >' + full.tax_class_title + '</a> ';
                          },
                      },
                      {
                          targets: 3,
                          "width": "18%",
                          render: function (data, type, full, meta) {
                           return '<a data-backdrop="false" data-toggle="modal" data-key="' + full.tax_class_key + '" href="#tax-class-details" > View Details</a> &nbsp' +
                                  '<div class="dropdown dropdown-inline">\n' +
                                  ' <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                                  '<i class="flaticon-more-v2"></i>\n' +
                                  '</span>\n' +
                                  ' <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                                  '<a class="dropdown-item"  href="javascript:setClassStatusActive(' + full.tax_class_key + ');"><i class="la la-toggle-off kt-font-success"></i> Set Active</a>\n' +
                                  '<a class="dropdown-item"  href="javascript:setClassStatusInactive(' + full.tax_class_key + ');"><i class="la la-toggle-off kt-font-warning"></i> Set Inactive</a>\n' +
                                  '<a class="dropdown-item"  href="javascript:deleteClass(' + full.tax_class_key + ');"><i class="la la-trash kt-font-danger"></i> Delete</a>\n' +
                                  ' </div>\n' +
                                  ' </div>';
                          },
                      },
                  ]
              });
          }
      };

      return {
          //main function to initiate the module
          init: function() {
              initTable();
          },

      };

  }();

  jQuery(document).ready(function() {

      $('#new-tax-class').on('show.bs.modal', function (event) {
          let modal = $(this);
          const form = modal.find('form');
          form.resetForm();
      })

      $('#new-tax').on('show.bs.modal', function (event) {
          let modal = $(this);
          const form = modal.find('form');
          form.resetForm();
      })

      $("select").select2({placeholder: "Select option"});
      
      $('div#tax-details').on('show.bs.modal', function (event) {
          let modal = $(this);
          const body = modal.find('.modal-body');
          var button = $(event.relatedTarget)
          var record = button.data('key');
          addSpinner(body);
          body.load('<?php echo base_url('taxes/index/taxdetails/');?>' + record, function( response, status, xhr ) {
              if ( status == "error" ) {
                  <?php if(ENVIRONMENT !== 'production'){?>
                  swal.fire("","An error occurred "+response,"warning");
                  <?php }else{?>
                  swal.fire("","An error occurred","warning");
                  <?php }?>
                  modal.modal('toggle');
                  modal.hide();
              }
          });
      })
      
      $('#tax-class-details').on('show.bs.modal', function (event) {
          let modal = $(this);
          const body = modal.find('.modal-body');
          var button = $(event.relatedTarget);
          var record = button.data('key');
          addSpinner(body); 
          body.load('<?php echo base_url('taxes/index/taxclassdetails/');?>' + record, function( response, status, xhr ) {
              if ( status == "error" ) {
                  <?php if(ENVIRONMENT !== 'production'){?>
                  swal.fire("","An error occurred "+response,"warning");
                  <?php }else{?>
                  swal.fire("","An error occurred","warning");
                  <?php }?>
                  modal.modal('toggle');
                  modal.hide();
              }
          });
      })
      
      LMDatatableTaxes.init();
      LMDatatableClasses.init();

  });

  Pusher.logToConsole = true;

  var pusher = new Pusher('<?php echo $this->pusher->pusherSettings()->pusher_key;?>', {
      cluster: '<?php echo $this->pusher->pusherSettings()->pusher_cluster;?>',
      forceTLS: true
  });

  var lmEvents = pusher.subscribe('<?php echo runningBusiness()->business_key;?>');

  lmEvents.bind('<?php echo runningBranch()->branch_key;?>-tax_class_registered', function(data) {
      let table = $.fn.dataTable.tables( { api: true } );
      table.clear().draw();
  });

  lmEvents.bind('<?php echo runningBranch()->branch_key;?>-tax-class_updated', function(data) {
      let table = $.fn.dataTable.tables( { api: true } );
      table.clear().draw();
  });

  lmEvents.bind('<?php echo runningBranch()->branch_key;?>-tax_registered', function(data) {
      let table = $.fn.dataTable.tables( { api: true } );
      table.clear().draw();
  });

  lmEvents.bind('<?php echo runningBranch()->branch_key;?>-tax_updated', function(data) {
      let table = $.fn.dataTable.tables( { api: true } );
      table.clear().draw();
  });

  function create_tax() {
        let form = $('form#new-tax-form');
        let formData = form.serialize();
        $.ajax({
            url: '<?php echo base_url('taxes/index/createtax/');?>',
            type: 'get',
            data: formData,
            beforeSend: function () {
                KTApp.block(form, {
                    overlayColor: "#000000",
                    type: "loader",
                    state: "success",
                    message: "Creating Tax, Please wait ..."
                });
            },
            success: function (result) {
                KTApp.unblock(form);
                if (result.status == true) {
                    $('#new-tax').modal("hide");
                    Swal.fire('', result.message, 'success');
                    let table = $.fn.dataTable.tables({api: true});
                    table.clear().draw();
                } else {
                    Swal.fire('', result.message, 'warning');
                }
            },
            error: function (xhr) {
                KTApp.unblock(form);
                Swal.fire('', xhr.statusText, 'warning');
            }
        })
    }

  function create_tax_class() {
        let form = $('form#new-tax-class-form');
        let formData = form.serialize();
        $.ajax({
            url: '<?php echo base_url('taxes/index/createtaxclass/');?>',
            type: 'get',
            data: formData,
            beforeSend: function () {
                KTApp.block(form, {
                    overlayColor: "#000000",
                    type: "loader",
                    state: "success",
                    message: "Creating Tax Class, Please wait ..."
                });
            },
            success: function (result) {
                KTApp.unblock(form);
                if (result.status == true) {
                    $('#new-tax-class').modal("hide");
                    Swal.fire('', result.message, 'success');
                    let table = $.fn.dataTable.tables({api: true});
                    table.clear().draw();
                } else {
                    Swal.fire('', result.message, 'warning');
                }
            },
            error: function (xhr) {
                KTApp.unblock(form);
                Swal.fire('', xhr.statusText, 'warning');
            }
        })
    }

  function deleteClass(classi){
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('taxes/index/deleteclass')?>/' + classi,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Deleting Class ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                            Swal.fire('Server Error!', xhr.statusText,'danger');
                        <?php }?>
                    }
                });
            }
        })
    }

  function deleteTax(tax){
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('taxes/index/deletetax')?>/' + tax,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Deleting Tax ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                            Swal.fire('Server Error!', xhr.statusText,'danger');
                        <?php }?>
                    }
                });
            }
        })
    }

  function update_tax() {
        let form = $('form#update-tax-form');
        let formData = form.serialize();
        $.ajax({
            url: '<?php echo base_url('taxes/index/updatetax/');?>',
            type: 'get',
            data: formData,
            beforeSend: function () {
                KTApp.block(form, {
                    overlayColor: "#000000",
                    type: "loader",
                    state: "success",
                    message: "Updating Tax Class, Please wait ..."
                });
            },
            success: function (result) {
                KTApp.unblock(form);
                if (result.status == true) {
                    $('#tax-details').modal("hide");
                    Swal.fire('', result.message, 'success');
                    let table = $.fn.dataTable.tables({api: true});
                    table.clear().draw();
                } else {
                    Swal.fire('', result.message, 'warning');
                }
            },
            error: function (xhr) {
                KTApp.unblock(form);
                Swal.fire('', xhr.statusText, 'warning');
            }
        })
    }

  function update_tax_class() {
        let form = $('form#update-tax-class-form');
        let formData = form.serialize();
        $.ajax({
            url: '<?php echo base_url('taxes/index/updatetaxclass/');?>',
            type: 'get',
            data: formData,
            beforeSend: function () {
                KTApp.block(form, {
                    overlayColor: "#000000",
                    type: "loader",
                    state: "success",
                    message: "Updating Tax Class, Please wait ..."
                });
            },
            success: function (result) {
                KTApp.unblock(form);
                if (result.status == true) {
                    $('#tax-class-details').modal("hide");
                    Swal.fire('', result.message, 'success');
                    let table = $.fn.dataTable.tables({api: true});
                    table.clear().draw();
                } else {
                    Swal.fire('', result.message, 'warning');
                }
            },
            error: function (xhr) {
                KTApp.unblock(form);
                Swal.fire('', xhr.statusText, 'warning');
            }
        })
    }
    
</script>
